/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.johnson.event;

import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Event {
    private EventType key;
    private String desc;
    private String exception;
    private EventLevel level;
    private String date;
    private int progress = -1;
    private final Map attributes;

    private static String getFormattedDate() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
    }

    public Event(EventType key, String desc) {
        this.key = key;
        this.desc = desc;
        this.date = Event.getFormattedDate();
        this.attributes = new HashMap();
    }

    public Event(EventType key, String desc, String exception) {
        this.key = key;
        this.desc = desc;
        this.exception = exception;
        this.date = Event.getFormattedDate();
        this.attributes = new HashMap();
    }

    public Event(EventType key, String desc, EventLevel level) {
        this.key = key;
        this.desc = desc;
        this.level = level;
        this.date = Event.getFormattedDate();
        this.attributes = new HashMap();
    }

    public Event(EventType key, String desc, String exception, EventLevel level) {
        this.key = key;
        this.desc = desc;
        this.exception = exception;
        this.level = level;
        this.date = Event.getFormattedDate();
        this.attributes = new HashMap();
    }

    public EventType getKey() {
        return this.key;
    }

    public void setKey(EventType name) {
        this.key = name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getException() {
        return this.exception;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public EventLevel getLevel() {
        return this.level;
    }

    public void setLevel(EventLevel level) {
        this.level = level;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public boolean hasProgress() {
        return this.progress != -1;
    }

    public void addAttribute(Object key, Object value) {
        this.attributes.put(key, value);
    }

    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public Map getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event event = (Event)o;
        if (this.date != null ? !this.date.equals(event.date) : event.date != null) {
            return false;
        }
        if (this.desc != null ? !this.desc.equals(event.desc) : event.desc != null) {
            return false;
        }
        if (this.exception != null ? !this.exception.equals(event.exception) : event.exception != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(event.key) : event.key != null) {
            return false;
        }
        return !(this.level != null ? !this.level.equals(event.level) : event.level != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 29 * result + (this.desc != null ? this.desc.hashCode() : 0);
        result = 29 * result + (this.exception != null ? this.exception.hashCode() : 0);
        result = 29 * result + (this.level != null ? this.level.hashCode() : 0);
        result = 29 * result + (this.date != null ? this.date.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Level = " + (this.getLevel() == null ? "" : this.getLevel() + " ") + ", Key = " + (this.getKey() == null ? "" : this.getKey() + " ") + ", Desc = " + (this.getDesc() == null ? "" : this.getDesc() + " ") + ", Exception = " + (this.getException() == null ? "" : this.getException() + " ");
    }
}

