/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.ofbiz.association;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.ofbiz.association.AssociationManager;
import com.atlassian.core.user.UserUtils;
import com.opensymphony.user.EntityNotFoundException;
import com.opensymphony.user.User;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericPK;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilMisc;

public class DefaultAssociationManager
implements AssociationManager {
    private static final Category log = Category.getInstance((Class)DefaultAssociationManager.class);
    private final GenericDelegator delegator = CoreFactory.getGenericDelegator();

    public GenericValue createAssociation(GenericValue source, GenericValue sink, String associationType) throws GenericEntityException {
        GenericValue existingAssocation = this.getAssociation(source, sink, associationType);
        if (existingAssocation == null) {
            GenericValue v = this.delegator.makeValue("NodeAssociation", UtilMisc.toMap((String)"associationType", (Object)associationType, (String)"sourceNodeId", (Object)source.getLong("id"), (String)"sourceNodeEntity", (Object)source.getEntityName(), (String)"sinkNodeId", (Object)sink.getLong("id"), (String)"sinkNodeEntity", (Object)sink.getEntityName()));
            v.create();
            return v;
        }
        return existingAssocation;
    }

    public GenericValue createAssociation(User user, GenericValue sink, String associationType) throws GenericEntityException {
        GenericValue v = this.delegator.makeValue("UserAssociation", UtilMisc.toMap((String)"associationType", (Object)associationType, (String)"sourceName", (Object)user.getName(), (String)"sinkNodeId", (Object)sink.getLong("id"), (String)"sinkNodeEntity", (Object)sink.getEntityName()));
        v.create();
        v.refresh();
        return v;
    }

    public void removeAssociation(User user, GenericValue sink, String associationType) throws GenericEntityException {
        GenericDelegator delegator = this.delegator;
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("sinkNodeId", sink.getLong("id"));
        fields.put("sinkNodeEntity", sink.getEntityName());
        fields.put("sourceName", user.getName());
        fields.put("associationType", associationType);
        delegator.removeByPrimaryKey(delegator.makePK("UserAssociation", fields));
    }

    public void removeAssociation(GenericValue source, GenericValue sink, String associationType) throws GenericEntityException {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("sinkNodeId", sink.getLong("id"));
        fields.put("sinkNodeEntity", sink.getEntityName());
        fields.put("sourceNodeId", source.getLong("id"));
        fields.put("sourceNodeEntity", source.getEntityName());
        fields.put("associationType", associationType);
        this.delegator.removeByPrimaryKey(this.delegator.makePK("NodeAssociation", fields));
    }

    public void removeAssociationsFromSource(GenericValue source) throws GenericEntityException {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("sourceNodeId", source.getLong("id"));
        fields.put("sourceNodeEntity", source.getEntityName());
        this.delegator.removeByAnd("NodeAssociation", fields);
    }

    public void removeAssociationsFromSink(GenericValue sink) throws GenericEntityException {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("sinkNodeId", sink.getLong("id"));
        fields.put("sinkNodeEntity", sink.getEntityName());
        this.delegator.removeByAnd("NodeAssociation", fields);
    }

    public void removeUserAssociationsFromSink(GenericValue sink) throws GenericEntityException {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("sinkNodeId", sink.getLong("id"));
        fields.put("sinkNodeEntity", sink.getEntityName());
        this.delegator.removeByAnd("UserAssociation", fields);
    }

    public void removeUserAssociationsFromUser(User user) throws GenericEntityException {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("sourceName", user.getName());
        this.delegator.removeByAnd("UserAssociation", fields);
    }

    public void swapAssociation(String sourceEntityName, String associationType, GenericValue fromSink, GenericValue toSink) throws GenericEntityException {
        List sources = this.getSourceFromSink(fromSink, sourceEntityName, associationType, false);
        this.swapAssociation(sources, associationType, fromSink, toSink);
    }

    public void swapAssociation(List entities, String associationType, GenericValue fromSink, GenericValue toSink) throws GenericEntityException {
        Iterator iterator = entities.iterator();
        while (iterator.hasNext()) {
            GenericValue entity = (GenericValue)iterator.next();
            CoreFactory.getAssociationManager().createAssociation(entity, toSink, associationType);
            this.removeAssociation(entity, fromSink, associationType);
        }
    }

    private List getAssociations(String associationName, Map fields, boolean useCache, boolean useSequence) throws GenericEntityException {
        List result = null;
        result = useCache ? this.delegator.findByAndCache(associationName, fields) : this.delegator.findByAnd(associationName, fields);
        if (useSequence) {
            result = EntityUtil.orderBy((List)result, (List)UtilMisc.toList((Object)"sequence"));
        }
        return result;
    }

    public GenericValue getAssociation(GenericValue source, GenericValue sink, String associationType) throws GenericEntityException {
        return EntityUtil.getOnly((List)this.delegator.findByAnd("NodeAssociation", UtilMisc.toMap((String)"associationType", (Object)associationType, (String)"sourceNodeId", (Object)source.getLong("id"), (String)"sourceNodeEntity", (Object)source.getEntityName(), (String)"sinkNodeId", (Object)sink.getLong("id"), (String)"sinkNodeEntity", (Object)sink.getEntityName())));
    }

    public GenericValue getAssociation(User user, GenericValue sink, String associationType) throws GenericEntityException {
        if (user == null) {
            return null;
        }
        return EntityUtil.getOnly((List)this.delegator.findByAnd("UserAssociation", UtilMisc.toMap((String)"associationType", (Object)associationType, (String)"sourceName", (Object)user.getName(), (String)"sinkNodeId", (Object)sink.getLong("id"), (String)"sinkNodeEntity", (Object)sink.getEntityName())));
    }

    public List getSinkFromSource(GenericValue source, String sinkName, String associationType, boolean useCache) throws GenericEntityException {
        return this.getSinkFromSource(source, sinkName, associationType, useCache, false);
    }

    public List getSinkFromSource(GenericValue source, String sinkName, String associationType, boolean useCache, boolean useSequence) throws GenericEntityException {
        if (source == null) {
            throw new IllegalArgumentException("Source GenericValue can not be null.");
        }
        List result = this.getSinkIdsFromSource(source, sinkName, associationType, useCache, useSequence);
        ArrayList<GenericValue> outList = new ArrayList<GenericValue>(result.size());
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            GenericValue value = (GenericValue)iterator.next();
            GenericValue byPrimaryKey = useCache ? this.delegator.findByPrimaryKeyCache(sinkName, UtilMisc.toMap((String)"id", (Object)value.getLong("sinkNodeId"))) : this.delegator.findByPrimaryKey(sinkName, UtilMisc.toMap((String)"id", (Object)value.getLong("sinkNodeId")));
            if (byPrimaryKey == null) continue;
            outList.add(byPrimaryKey);
        }
        if (result.size() > 0) {
            return outList;
        }
        return Collections.EMPTY_LIST;
    }

    private List getSinkIdsFromSource(GenericValue source, String sinkName, String associationType, boolean useCache, boolean useSequence) throws GenericEntityException {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("sourceNodeId", source.getLong("id"));
        fields.put("sourceNodeEntity", source.getEntityName());
        fields.put("associationType", associationType);
        fields.put("sinkNodeEntity", sinkName);
        List result = this.getAssociations("NodeAssociation", fields, useCache, useSequence);
        return result;
    }

    public List getSourceFromSink(GenericValue sink, String sourceName, String associationType, boolean useCache) throws GenericEntityException {
        return this.getSourceFromSink(sink, sourceName, associationType, useCache, false);
    }

    public List getSourceFromSink(GenericValue sink, String sourceName, String associationType, boolean useCache, boolean useSequence) throws GenericEntityException {
        if (sink == null) {
            throw new IllegalArgumentException("Sink GenericValue can not be null.");
        }
        List result = this.getSourceIdsFromSink(sink, associationType, sourceName, useCache, useSequence);
        ArrayList<GenericValue> outList = new ArrayList<GenericValue>(result.size());
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            GenericValue value = (GenericValue)iterator.next();
            GenericPK pk = this.delegator.makePK(sourceName, UtilMisc.toMap((String)"id", (Object)value.getLong("sourceNodeId")));
            GenericValue byPrimaryKey = useCache ? this.delegator.findByPrimaryKeyCache(pk) : this.delegator.findByPrimaryKey(pk);
            if (byPrimaryKey == null) continue;
            outList.add(byPrimaryKey);
        }
        if (result.size() > 0) {
            return outList;
        }
        return Collections.EMPTY_LIST;
    }

    private List getSourceIdsFromSink(GenericValue sink, String associationType, String sourceName, boolean useCache, boolean useSequence) throws GenericEntityException {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("sinkNodeId", sink.getLong("id"));
        fields.put("sinkNodeEntity", sink.getEntityName());
        fields.put("associationType", associationType);
        fields.put("sourceNodeEntity", sourceName);
        List result = this.getAssociations("NodeAssociation", fields, useCache, useSequence);
        return result;
    }

    public List getSinkFromUser(User source, String sinkName, String associationType, boolean useCache) throws GenericEntityException {
        return this.getSinkFromUser(source, sinkName, associationType, useCache, false);
    }

    public List getSinkFromUser(User source, String sinkName, String associationType, boolean useCache, boolean useSequence) throws GenericEntityException {
        if (source == null) {
            throw new IllegalArgumentException("User can not be null.");
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("sourceName", source.getName());
        fields.put("associationType", associationType);
        fields.put("sinkNodeEntity", sinkName);
        List result = this.getAssociations("UserAssociation", fields, useCache, useSequence);
        ArrayList<GenericValue> outList = new ArrayList<GenericValue>(result.size());
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            GenericValue value = (GenericValue)iterator.next();
            GenericPK pk = this.delegator.makePK(sinkName, UtilMisc.toMap((String)"id", (Object)value.getLong("sinkNodeId")));
            GenericValue byPrimaryKey = useCache ? this.delegator.findByPrimaryKeyCache(pk) : this.delegator.findByPrimaryKey(pk);
            if (byPrimaryKey == null) continue;
            outList.add(byPrimaryKey);
        }
        if (result.size() > 0) {
            return outList;
        }
        return Collections.EMPTY_LIST;
    }

    public List getUserFromSink(GenericValue sink, String associationType, boolean useCache) throws GenericEntityException, EntityNotFoundException {
        return this.getUserFromSink(sink, associationType, useCache, false);
    }

    public List getUserFromSink(GenericValue sink, String associationType, boolean useCache, boolean useSequence) throws GenericEntityException, EntityNotFoundException {
        if (sink == null) {
            throw new IllegalArgumentException("Sink GenericValue can not be null.");
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("sinkNodeId", sink.getLong("id"));
        fields.put("sinkNodeEntity", sink.getEntityName());
        fields.put("associationType", associationType);
        List result = this.getAssociations("UserAssociation", fields, useCache, useSequence);
        ArrayList<User> outList = new ArrayList<User>(result.size());
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            GenericValue value = (GenericValue)iterator.next();
            try {
                User user = UserUtils.getUser((String)value.getString("sourceName"));
                if (user == null) continue;
                outList.add(user);
            }
            catch (EntityNotFoundException e) {
                log.error((Object)("Cannot find user with username '" + value.getString("sourceName") + "'."), (Throwable)e);
            }
        }
        if (result.size() > 0) {
            return outList;
        }
        return Collections.EMPTY_LIST;
    }

    public List getSinkIdsFromSource(GenericValue source, String sinkEntity, String associationType) throws GenericEntityException {
        List sinks = this.getSinkIdsFromSource(source, sinkEntity, associationType, false, false);
        if (sinks != null && !sinks.isEmpty()) {
            ArrayList<Long> sinkIds = new ArrayList<Long>();
            Iterator iterator = sinks.iterator();
            while (iterator.hasNext()) {
                GenericValue sink = (GenericValue)iterator.next();
                sinkIds.add(sink.getLong("sinkNodeId"));
            }
            return sinkIds;
        }
        return Collections.EMPTY_LIST;
    }

    public List getSourceIdsFromSink(GenericValue sink, String sourceEntity, String associationType) throws GenericEntityException {
        List sources = this.getSourceIdsFromSink(sink, associationType, sourceEntity, false, false);
        if (sources != null && !sources.isEmpty()) {
            ArrayList<Long> sourceIds = new ArrayList<Long>();
            Iterator iterator = sources.iterator();
            while (iterator.hasNext()) {
                GenericValue source = (GenericValue)iterator.next();
                sourceIds.add(source.getLong("sourceNodeId"));
            }
            return sourceIds;
        }
        return Collections.EMPTY_LIST;
    }
}

