/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.ofbiz.osuser;

import com.atlassian.core.ofbiz.util.CoreTransactionUtil;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.user.EntityNotFoundException;
import com.opensymphony.user.User;
import com.opensymphony.user.UserManager;
import com.opensymphony.user.provider.ofbiz.OFBizCredentialsProvider;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Category;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericTransactionException;
import org.ofbiz.core.util.UtilMisc;

public class CoreOFBizCredentialsProvider
extends OFBizCredentialsProvider {
    private static final Category log = Category.getInstance((Class)CoreOFBizCredentialsProvider.class);

    public boolean remove(String name) {
        boolean began = false;
        try {
            began = CoreTransactionUtil.begin();
            log.debug((Object)("trying to remove properties for: " + name));
            User user = UserManager.getInstance().getUser(name);
            PropertySet props = user.getPropertySet();
            Iterator keyIter = props.getKeys().iterator();
            while (keyIter.hasNext()) {
                props.remove((String)keyIter.next());
            }
            user.getProfileProvider().flushCaches();
            log.debug((Object)("trying to remove groups for: " + name));
            List userGroups = user.getGroups();
            if (userGroups != null) {
                Iterator iterator = userGroups.iterator();
                while (iterator.hasNext()) {
                    user.getAccessProvider().removeFromGroup(name, (String)iterator.next());
                }
            }
            user.getAccessProvider().flushCaches();
            log.debug((Object)("trying to remove user: " + name));
            this.clearUserCache(name);
            this.clearAllCache();
            this.getDelegator().removeByAnd(this.userEntity, UtilMisc.toMap((String)"name", (Object)name));
            CoreTransactionUtil.commit(began);
            return true;
        }
        catch (GenericEntityException e) {
            log.error((Object)("Could not remove user: " + name), (Throwable)e);
            try {
                CoreTransactionUtil.rollback(began);
            }
            catch (GenericTransactionException e1) {
                log.error((Object)("Could not remove user: " + name), (Throwable)e1);
                return false;
            }
            return false;
        }
        catch (EntityNotFoundException e) {
            log.error((Object)("Could not remove user: " + name), (Throwable)e);
            try {
                CoreTransactionUtil.rollback(began);
            }
            catch (GenericTransactionException e1) {
                log.error((Object)("Could not remove user: " + name), (Throwable)e1);
                return false;
            }
            return false;
        }
    }
}

