/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.paddle.search;

import com.atlassian.paddle.filter.LiteralFilter;
import com.atlassian.paddle.search.AbstractSearch;
import com.atlassian.paddle.search.properties.GroupSearchProperties;
import com.atlassian.paddle.search.properties.MembershipSearchProperties;
import net.sf.ldaptemplate.support.filter.AndFilter;
import net.sf.ldaptemplate.support.filter.EqualsFilter;
import net.sf.ldaptemplate.support.filter.Filter;

public class GroupsForUserSearch
extends AbstractSearch {
    private final String userDn;
    private final MembershipSearchProperties membershipSearchProperties;
    private final GroupSearchProperties groupSearchProperties;

    public GroupsForUserSearch(String userDn, GroupSearchProperties groupSearchProperties, MembershipSearchProperties membershipSearchProperties) {
        this.userDn = userDn;
        this.membershipSearchProperties = membershipSearchProperties;
        this.groupSearchProperties = groupSearchProperties;
    }

    public String getBaseDn() {
        return this.groupSearchProperties.getBaseDn();
    }

    public String getFilter() {
        AndFilter andFilter = new AndFilter();
        andFilter.and((Filter)new LiteralFilter(this.groupSearchProperties.getFilter()));
        andFilter.and((Filter)new EqualsFilter(this.membershipSearchProperties.getMembershipAttribute(), this.userDn));
        return andFilter.toString();
    }

    protected String[] getAttributesToReturn() {
        return new String[]{this.groupSearchProperties.getGroupNameAttribute(), this.membershipSearchProperties.getMembershipAttribute()};
    }
}

