/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.loaders.SinglePluginLoader;
import com.atlassian.plugin.util.ClassLoaderUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultModuleDescriptorFactory
implements ModuleDescriptorFactory {
    private static Log log = LogFactory.getLog((Class)DefaultModuleDescriptorFactory.class);
    private Map moduleDescriptorClasses;
    private List permittedModuleKeys = Collections.EMPTY_LIST;

    public DefaultModuleDescriptorFactory() {
        this.moduleDescriptorClasses = new HashMap();
    }

    public Class getModuleDescriptorClass(String type) {
        return (Class)this.moduleDescriptorClasses.get(type);
    }

    public ModuleDescriptor getModuleDescriptor(String type) throws PluginParseException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (this.shouldSkipModuleOfType(type)) {
            return null;
        }
        Class moduleDescriptorClazz = this.getModuleDescriptorClass(type);
        if (moduleDescriptorClazz == null) {
            throw new PluginParseException("Cannot find ModuleDescriptor class for plugin of type '" + type + "'.");
        }
        return (ModuleDescriptor)ClassLoaderUtils.loadClass(moduleDescriptorClazz.getName(), SinglePluginLoader.class).newInstance();
    }

    protected boolean shouldSkipModuleOfType(String type) {
        return this.permittedModuleKeys != null && !this.permittedModuleKeys.isEmpty() && !this.permittedModuleKeys.contains(type);
    }

    public void setModuleDescriptors(Map moduleDescriptorClassNames) {
        Iterator it = moduleDescriptorClassNames.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Class descriptorClass = this.getClassFromEntry(entry);
            if (descriptorClass == null) continue;
            this.addModuleDescriptor((String)entry.getKey(), descriptorClass);
        }
    }

    private Class getClassFromEntry(Map.Entry entry) {
        if (this.shouldSkipModuleOfType((String)entry.getKey())) {
            return null;
        }
        Class descriptorClass = null;
        try {
            descriptorClass = ClassLoaderUtils.loadClass((String)entry.getValue(), this.getClass());
            if (!ModuleDescriptor.class.isAssignableFrom(descriptorClass)) {
                log.error((Object)("Configured plugin module descriptor class " + entry.getValue() + " does not inherit from ModuleDescriptor"));
                descriptorClass = null;
            }
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Unable to add configured plugin module descriptor " + entry.getKey() + ". Class not found: " + entry.getValue()));
        }
        return descriptorClass;
    }

    public boolean hasModuleDescriptor(String type) {
        return this.moduleDescriptorClasses.containsKey(type);
    }

    public void addModuleDescriptor(String type, Class moduleDescriptorClass) {
        this.moduleDescriptorClasses.put(type, moduleDescriptorClass);
    }

    public void removeModuleDescriptorForType(String type) {
        this.moduleDescriptorClasses.remove(type);
    }

    protected Map getDescriptorClassesMap() {
        return this.moduleDescriptorClasses;
    }

    public void setPermittedModuleKeys(List permittedModuleKeys) {
        if (permittedModuleKeys == null) {
            permittedModuleKeys = Collections.EMPTY_LIST;
        }
        this.permittedModuleKeys = permittedModuleKeys;
    }
}

