/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.loaders;

import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.impl.StaticPlugin;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.parsers.DescriptorParser;
import com.atlassian.plugin.parsers.DescriptorParserFactory;
import com.atlassian.plugin.parsers.XmlDescriptorParserFactory;
import com.atlassian.plugin.util.ClassLoaderUtils;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;

public class SinglePluginLoader
implements PluginLoader {
    protected Collection plugins;
    protected String resource;
    protected InputStream is;
    private DescriptorParserFactory descriptorParserFactory = new XmlDescriptorParserFactory();

    public SinglePluginLoader(String resource) {
        this.resource = resource;
    }

    public SinglePluginLoader(InputStream is) {
        this.is = is;
    }

    public Collection loadAllPlugins(ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        if (this.plugins == null) {
            this.plugins = Collections.singleton(this.loadPlugin(moduleDescriptorFactory));
        }
        return this.plugins;
    }

    public boolean supportsRemoval() {
        return false;
    }

    public boolean supportsAddition() {
        return false;
    }

    public Collection removeMissingPlugins() {
        throw new UnsupportedOperationException("This PluginLoader does not support removal.");
    }

    public Collection addFoundPlugins(ModuleDescriptorFactory moduleDescriptorFactory) {
        throw new UnsupportedOperationException("This PluginLoader does not support addition.");
    }

    public void removePlugin(Plugin plugin) throws PluginException {
        throw new PluginException("This PluginLoader does not support removal.");
    }

    protected Plugin loadPlugin(ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        Plugin plugin;
        InputStream source = this.getSource();
        if (source == null) {
            throw new PluginParseException("Invalid resource or inputstream specified to load plugins from.");
        }
        try {
            DescriptorParser parser = this.descriptorParserFactory.getInstance(source);
            plugin = parser.configurePlugin(moduleDescriptorFactory, this.getNewPlugin());
            if (parser.isSystemPlugin()) {
                plugin.setSystemPlugin(true);
            }
        }
        catch (PluginParseException e) {
            throw new PluginParseException("Unable to load plugin resource: " + this.resource + " - " + e.getMessage(), (Throwable)((Object)e));
        }
        return plugin;
    }

    protected StaticPlugin getNewPlugin() {
        return new StaticPlugin();
    }

    protected InputStream getSource() {
        if (this.resource == null) {
            return this.is;
        }
        return ClassLoaderUtils.getResourceAsStream(this.resource, this.getClass());
    }
}

