/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.util.zip;

import com.atlassian.plugin.util.zip.FileUnzipper;
import com.atlassian.plugin.util.zip.Unzipper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractUnzipper
implements Unzipper {
    protected static Log log = LogFactory.getLog((Class)FileUnzipper.class);
    protected File destDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected File saveEntry(InputStream is, ZipEntry entry) throws IOException {
        File file = new File(this.destDir, entry.getName());
        if (entry.isDirectory()) {
            file.mkdirs();
            return file;
        }
        File dir = new File(file.getParent());
        dir.mkdirs();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            IOUtils.copy((InputStream)is, (OutputStream)fos);
            fos.flush();
        }
        catch (FileNotFoundException fnfe) {
            File file2;
            try {
                log.error((Object)("Error extracting a file to '" + this.destDir + File.separator + entry.getName() + "'. This destination is invalid for writing an extracted file stream to. "));
                file2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fos);
            return file2;
        }
        IOUtils.closeQuietly((OutputStream)fos);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ZipEntry[] entries(ZipInputStream zis) throws IOException {
        ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
        try {
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                entries.add(zipEntry);
                zis.closeEntry();
                zipEntry = zis.getNextEntry();
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)zis);
        }
        return entries.toArray(new ZipEntry[entries.size()]);
    }

    public void conditionalUnzip() throws IOException {
        ArrayList<String> zipContents = new ArrayList<String>();
        ZipEntry[] zipEntries = this.entries();
        for (int i = 0; i < zipEntries.length; ++i) {
            zipContents.add(zipEntries[i].getName());
        }
        List targetDirContents = this.getContentsOfTargetDir(this.destDir);
        if (!((Object)targetDirContents).equals(zipContents)) {
            FileUtils.deleteDirectory((File)this.destDir);
            this.unzip();
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Target directory contents match zip contents. Do nothing.");
        }
    }

    protected List getContentsOfTargetDir(File dir) {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        };
        String[] children = dir.list(filter);
        if (children == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> targetDirContents = new ArrayList<String>();
        if (log.isDebugEnabled() && children.length > 0) {
            log.debug((Object)("Listing JAR files in " + dir.getAbsolutePath()));
        }
        for (int i = 0; i < children.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug((Object)children[i]);
            }
            targetDirContents.add(children[i]);
        }
        return targetDirContents;
    }
}

