/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.components;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.macro.RadeoxCompatibilityMacro;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.WikiMarkupParser;
import com.atlassian.renderer.v2.components.AbstractRendererComponent;
import com.atlassian.renderer.v2.components.HtmlEscapeRendererComponent;
import com.atlassian.renderer.v2.components.MacroTag;
import com.atlassian.renderer.v2.components.WikiContentRendererHandler;
import com.atlassian.renderer.v2.macro.Macro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.renderer.v2.macro.MacroManager;
import com.atlassian.renderer.v2.macro.ResourceAwareMacroDecorator;
import com.atlassian.util.profiling.UtilTimerStack;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Category;

public class MacroRendererComponent
extends AbstractRendererComponent {
    private static Category log = Category.getInstance((Class)MacroRendererComponent.class);
    private final MacroManager macroManager;
    private final SubRenderer subRenderer;

    public MacroRendererComponent(MacroManager macroManager, SubRenderer subRenderer) {
        this.macroManager = macroManager;
        this.subRenderer = subRenderer;
    }

    public boolean shouldRender(RenderMode renderMode) {
        return renderMode.renderMacros();
    }

    public String render(String wiki, RenderContext context) {
        WikiMarkupParser parser = new WikiMarkupParser(this.macroManager, new WikiContentRendererHandler(this, context));
        return parser.parse(wiki);
    }

    public void makeMacro(StringBuffer buffer, MacroTag startTag, String body, RenderContext context, boolean hasEndTag) {
        Macro macro = this.getMacroByName(startTag.command);
        Map params = this.makeParams(startTag.argString);
        if (context.isRenderingForWysiwyg()) {
            String tag = this.getWysiwygMacroElement(macro);
            if (macro == null || macro.getBodyRenderMode() != null && macro.getBodyRenderMode().equals(RenderMode.NO_RENDER) || !macro.hasBody()) {
                StringBuffer sb = new StringBuffer();
                if (tag != null) {
                    sb.append("<").append(tag).append(" class=\"macro\">");
                    sb.append(startTag.originalText).append(body.replaceAll("\n", "<br/>"));
                    if (body.length() > 0 || hasEndTag) {
                        sb.append("{").append(startTag.command).append("}");
                    }
                    sb.append("</").append(tag).append(">");
                    buffer.append(context.getRenderedContentStore().addBlock(sb.toString()));
                } else {
                    this.processMacro(startTag.command, macro, body, params, context, buffer);
                }
            } else if (!macro.suppressMacroRenderingDuringWysiwyg()) {
                if (tag != null) {
                    buffer.append(context.getRenderedContentStore().addBlock("<" + tag + " class=\"macro\" macrotext=\"" + startTag.originalText + "\" command=\"" + startTag.command + "\">"));
                }
                this.processMacro(startTag.command, macro, body, params, context, buffer);
                if (tag != null) {
                    buffer.append(context.getRenderedContentStore().addBlock("</" + tag + ">"));
                }
            } else {
                buffer.append(context.getRenderedContentStore().addBlock("<div class=\"wikisrc\">" + (macro.isInline() ? "" : "\n") + startTag.originalText + "</div>"));
                if (!((macro instanceof RadeoxCompatibilityMacro || macro instanceof ResourceAwareMacroDecorator && ((ResourceAwareMacroDecorator)macro).getMacro() instanceof RadeoxCompatibilityMacro) && body.equals(""))) {
                    RenderMode renderMode = RenderMode.suppress(256L);
                    if (macro.getBodyRenderMode() != null) {
                        renderMode = macro.getBodyRenderMode().and(renderMode);
                    }
                    buffer.append(context.addRenderedContent(this.subRenderer.render(body, context, renderMode)));
                    buffer.append(context.getRenderedContentStore().addBlock("<div class=\"wikisrc\">" + (macro.isInline() ? "" : "\n") + "{" + startTag.command + "}" + "</div>"));
                }
            }
            if (tag != null && tag.equals("div")) {
                buffer.append(context.getRenderedContentStore().addBlock("<p class=\"atl_conf_pad\">&#8201;</p>"));
            } else if (macro != null && !macro.suppressSurroundingTagDuringWysiwygRendering()) {
                buffer.append(context.getRenderedContentStore().addBlock("&#8201;"));
            }
        } else if (macro != null) {
            this.processMacro(startTag.command, macro, body, params, context, buffer);
        } else if (!context.getRenderMode().renderMacroErrorMessages()) {
            HtmlEscapeRendererComponent htmlEscapeRendererComponent = new HtmlEscapeRendererComponent();
            StringBuffer errorBuffer = new StringBuffer();
            errorBuffer.append(htmlEscapeRendererComponent.render(startTag.originalText, context));
            if (body != null && !"".equals(body.trim())) {
                errorBuffer.append(this.subRenderer.render(body, context, context.getRenderMode().and(RenderMode.suppress(257L))));
                errorBuffer.append("{").append(htmlEscapeRendererComponent.render(startTag.command, context)).append("}");
            }
            buffer.append(context.getRenderedContentStore().addBlock(errorBuffer.toString()));
        } else {
            buffer.append(this.makeMacroError(context, "Unknown macro: {" + startTag.command + "}", body));
        }
    }

    private Macro getMacroByName(String name) {
        if (name == null) {
            return null;
        }
        return this.macroManager.getEnabledMacro(name.toLowerCase());
    }

    private Map makeParams(String paramString) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(": = | RAW | = :", paramString == null ? "" : paramString);
        if (!TextUtils.stringSet((String)paramString)) {
            return params;
        }
        String[] paramStrs = paramString.split("\\|");
        for (int i = 0; i < paramStrs.length; ++i) {
            String paramStr = paramStrs[i];
            int idx = paramStr.indexOf("=");
            if (idx != -1) {
                if (idx == paramStr.length() - 1) {
                    params.put(paramStr.substring(0, idx).trim(), "");
                    continue;
                }
                params.put(paramStr.substring(0, idx).trim(), paramStr.substring(idx + 1).trim());
                continue;
            }
            params.put(String.valueOf(i), paramStr);
        }
        return params;
    }

    private String getWysiwygMacroElement(Macro macro) {
        if (macro == null) {
            return "div";
        }
        if (macro.suppressSurroundingTagDuringWysiwygRendering()) {
            return null;
        }
        if (macro.isInline()) {
            return "span";
        }
        return "div";
    }

    private void processMacro(String command, Macro macro, String body, Map params, RenderContext context, StringBuffer buffer) {
        String renderedBody = body;
        try {
            if (TextUtils.stringSet((String)body) && macro.getBodyRenderMode() != null && !macro.getBodyRenderMode().renderNothing()) {
                renderedBody = this.subRenderer.render(body, context, macro.getBodyRenderMode());
            }
            String macroResult = this.executeMacro(command, macro, params, renderedBody, context);
            if (macro.getBodyRenderMode() == null) {
                buffer.append(this.subRenderer.render(macroResult, context, RenderMode.MACROS_ONLY));
            } else if (macro.isInline()) {
                buffer.append(context.getRenderedContentStore().addInline(macroResult));
            } else {
                buffer.append(context.addRenderedContent(macroResult));
            }
        }
        catch (MacroException e) {
            log.info((Object)("Error formatting macro: " + command + ": " + e), (Throwable)e);
            buffer.append(this.makeMacroError(context, command + ": " + e.getMessage(), body));
        }
        catch (Throwable t) {
            if (this.isJunitError(t)) {
                throw (RuntimeException)t;
            }
            log.error((Object)("Unexpected error formatting macro: " + command), t);
            buffer.append(this.makeMacroError(context, "Error formatting macro: " + command + ": " + t.toString(), body));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String executeMacro(String command, Macro macro, Map params, String renderedBody, RenderContext context) throws MacroException {
        String profilingName = "Rendering macro: {" + command + "}";
        try {
            UtilTimerStack.push((String)profilingName);
            String string = macro.execute(params, renderedBody, context);
            return string;
        }
        finally {
            UtilTimerStack.pop((String)profilingName);
        }
    }

    private String makeMacroError(RenderContext context, String errorMessage, String body) {
        return context.addRenderedContent(RenderUtils.blockError(errorMessage, this.renderErrorBody(body, context)));
    }

    private String renderErrorBody(String body, RenderContext context) {
        return context.addRenderedContent(this.subRenderer.render(body, context, null));
    }

    private boolean isJunitError(Throwable t) {
        return t.getClass().getName().startsWith("junit.");
    }
}

