/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.trackback;

import com.atlassian.trackback.Trackback;
import com.atlassian.trackback.TrackbackFinder;
import com.atlassian.trackback.TrackbackHelper;
import com.atlassian.trackback.TrackbackSender;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultTrackbackHelper
implements TrackbackHelper {
    private final TrackbackFinder finder;
    private final TrackbackSender sender;
    private static Log log = LogFactory.getLog((Class)DefaultTrackbackHelper.class);

    public DefaultTrackbackHelper(TrackbackFinder finder, TrackbackSender sender) {
        this.finder = finder;
        this.sender = sender;
    }

    public void pingTrackbacksInContent(String content, Trackback ping) {
        List pingUrls = this.finder.findPingUrls(content);
        this.sendPings(pingUrls, ping);
    }

    public void pingTrackbacksInContent(List urlLinks, Trackback ping) {
        List pingUrls = this.finder.findPingUrls(urlLinks);
        this.sendPings(pingUrls, ping);
    }

    private void sendPings(List pingUrls, Trackback ping) {
        Iterator iterator = pingUrls.iterator();
        while (iterator.hasNext()) {
            String pingUrl = (String)iterator.next();
            try {
                this.sender.sendPing(pingUrl, ping);
            }
            catch (IOException e) {
                log.debug((Object)("IOException trying to send trackback to " + pingUrl));
                e.printStackTrace();
            }
        }
    }
}

