/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.osuser;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.impl.DuplicateEntityException;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.osuser.OSUAccessor;
import com.atlassian.user.impl.osuser.OSUEntityManager;
import com.atlassian.user.impl.osuser.OSUGroup;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.EntityNameAlphaComparator;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.util.Assert;
import com.opensymphony.user.ImmutableException;
import com.opensymphony.user.ManagerAccessor;
import com.opensymphony.user.provider.AccessProvider;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class OSUGroupManager
extends OSUEntityManager
implements GroupManager {
    protected final Logger log = Logger.getLogger(this.getClass());
    private final OSUAccessor osuserAccessor;
    private final AccessProvider accessProvider;

    public OSUGroupManager(RepositoryIdentifier repository, OSUAccessor accessor) {
        super(repository);
        this.osuserAccessor = accessor;
        this.accessProvider = accessor.getAccessProvider();
    }

    public Pager getGroups() {
        SortedSet atlassianGroups = this.getGroupsFromAccessProvider();
        return new DefaultPager(atlassianGroups);
    }

    private SortedSet getGroupsFromAccessProvider() {
        TreeSet<Group> atlassianGroups = new TreeSet<Group>(new EntityNameAlphaComparator());
        Iterator iterator = this.accessProvider.list().iterator();
        while (iterator.hasNext()) {
            String groupName = (String)iterator.next();
            Group atlassianGroup = this.getGroup(groupName);
            if (atlassianGroup == null) continue;
            atlassianGroups.add(atlassianGroup);
        }
        return atlassianGroups;
    }

    public Group createGroup(String groupName) throws EntityException {
        OSUGroup group = null;
        if (this.accessProvider.handles(groupName)) {
            throw new DuplicateEntityException("Group named [" + groupName + "] already exists in accessProvider [" + this.accessProvider.toString());
        }
        if (this.accessProvider.create(groupName)) {
            group = new OSUGroup(new com.opensymphony.user.Group(groupName, (ManagerAccessor)this.osuserAccessor));
        }
        return group;
    }

    public void removeGroup(Group group) throws EntityException, IllegalArgumentException {
        if (group == null) {
            throw new IllegalArgumentException("Group is null.");
        }
        if (!(group instanceof OSUGroup)) {
            throw new IllegalArgumentException("User is not a OSUGroup [" + group.getClass().getName());
        }
        Group groupToRemove = this.getGroup(group.getName());
        ArrayList users = this.accessProvider.listUsersInGroup(groupToRemove.getName());
        users = new ArrayList(users);
        for (int i = 0; i < users.size(); ++i) {
            String username = (String)users.get(i);
            this.accessProvider.removeFromGroup(username, groupToRemove.getName());
        }
        this.accessProvider.remove(group.getName());
    }

    public void addMembership(Group group, User user) {
        if (group == null || this.getGroup(group.getName()) == null) {
            throw new IllegalArgumentException("Cannot add membership for unknown group: [" + (group == null ? "null" : group.getName()) + "]");
        }
        this.accessProvider.addToGroup(user.getName(), group.getName());
    }

    public boolean hasMembership(Group group, User user) {
        if (!(group instanceof OSUGroup)) {
            return false;
        }
        return this.accessProvider.inGroup(user.getName(), group.getName());
    }

    public void removeMembership(Group group, User user) {
        if (group == null || this.getGroup(group.getName()) == null) {
            throw new IllegalArgumentException("Can't remove membership for unknown group: [" + (group == null ? "null" : group.getName()) + "]");
        }
        this.accessProvider.removeFromGroup(user.getName(), group.getName());
    }

    public boolean isReadOnly(Group group) throws EntityException {
        return !this.accessProvider.handles(group.getName());
    }

    public boolean supportsExternalMembership() throws EntityException {
        return false;
    }

    public Pager getMemberNames(Group group) throws EntityException {
        if (!(group instanceof OSUGroup)) {
            return new DefaultPager();
        }
        ArrayList memberNames = new ArrayList(this.accessProvider.listUsersInGroup(group.getName()));
        memberNames.removeAll(Arrays.asList(new Object[]{null}));
        Collections.sort(memberNames, Collator.getInstance());
        return new DefaultPager(memberNames);
    }

    public Pager getLocalMemberNames(Group group) throws EntityException {
        if (!(group instanceof OSUGroup)) {
            return new DefaultPager();
        }
        ArrayList memberNames = new ArrayList(this.accessProvider.listUsersInGroup(group.getName()));
        Collections.sort(memberNames, Collator.getInstance());
        return new DefaultPager(memberNames);
    }

    public Pager getExternalMemberNames(Group group) throws EntityException {
        throw new UnsupportedOperationException("External membership is not supported.");
    }

    public void saveGroup(Group group) throws EntityException {
        if (!this.accessProvider.handles(group.getName())) {
            return;
        }
        com.opensymphony.user.Group g = new com.opensymphony.user.Group(group.getName(), (ManagerAccessor)this.osuserAccessor);
        try {
            g.store();
        }
        catch (ImmutableException e) {
            throw new RepositoryException(e);
        }
    }

    public Group getGroup(String groupName) {
        if (!this.accessProvider.handles(groupName)) {
            return null;
        }
        com.opensymphony.user.Group osgroup = new com.opensymphony.user.Group(groupName, (ManagerAccessor)this.osuserAccessor);
        return new OSUGroup(osgroup);
    }

    public Pager getGroups(User user) throws RepositoryException {
        Assert.notNull(user, "User must not be null");
        if (!this.osuserAccessor.getCredentialsProvider().handles(user.getName())) {
            return new DefaultPager();
        }
        TreeSet<Group> groups = new TreeSet<Group>(new EntityNameAlphaComparator());
        List groupNames = this.accessProvider.listGroupsContainingUser(user.getName());
        Iterator iterator = groupNames.iterator();
        while (iterator.hasNext()) {
            String groupName = (String)iterator.next();
            groups.add(this.getGroup(groupName));
        }
        return new DefaultPager(groups);
    }

    public List getWritableGroups() {
        return new ArrayList(this.getGroupsFromAccessProvider());
    }

    public RepositoryIdentifier getIdentifier() {
        return this.repository;
    }

    public RepositoryIdentifier getRepository(Entity entity) throws EntityException {
        if (this.getGroup(entity.getName()) != null) {
            return this.repository;
        }
        return null;
    }

    public boolean isCreative() {
        List groupNames = this.accessProvider.list();
        if (groupNames.isEmpty()) {
            return true;
        }
        String groupName = (String)groupNames.get(0);
        return new com.opensymphony.user.Group(groupName, (ManagerAccessor)this.osuserAccessor).isMutable();
    }
}

