/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.search.page;

import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DefaultPager
implements Pager {
    private final List page = new ArrayList();
    private Iterator iter;
    private int index;

    public DefaultPager() {
        this(Collections.EMPTY_LIST);
    }

    public DefaultPager(Collection col) {
        if (col != null) {
            this.page.addAll(col);
        }
        this.iter = this.page.iterator();
    }

    public boolean isEmpty() {
        if (this.page == null) {
            return true;
        }
        return this.page.isEmpty();
    }

    public Iterator iterator() {
        return this.iter;
    }

    public List getCurrentPage() {
        return new ArrayList(this.page);
    }

    public void nextPage() {
    }

    public boolean onLastPage() {
        return true;
    }

    public void skipTo(int index) throws PagerException {
        int distance;
        if (index < 0) {
            throw new PagerException("Cannot skipTo a negative amount [" + index + "]");
        }
        int originalIndex = this.index;
        if (index > this.page.size()) {
            distance = this.page.size();
            this.index = this.page.size();
        } else {
            distance = index - this.index;
            this.index = index;
        }
        for (int i = originalIndex; i < distance; ++i) {
            this.iter.next();
        }
    }

    public int getIndex() {
        return this.index;
    }

    public int getIndexOfFirstItemInCurrentPage() {
        return 0;
    }

    public void remove() {
        throw new UnsupportedOperationException("This iterator does not support removal");
    }

    public boolean hasNext() {
        return this.iter.hasNext();
    }

    public Object next() {
        Object o = this.iter.next();
        ++this.index;
        return o;
    }
}

