/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.xwork;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequestWrapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Category;

public class FileUploadUtils {
    private static Category log = Category.getInstance((Class)FileUploadUtils.class);

    public static File getSingleFile() throws FileUploadException {
        UploadedFile uploadedFile = FileUploadUtils.getSingleUploadedFile();
        return uploadedFile == null ? null : uploadedFile.getFile();
    }

    public static UploadedFile getSingleUploadedFile() throws FileUploadException {
        MultiPartRequestWrapper multiWrapper = (MultiPartRequestWrapper)ServletActionContext.getRequest();
        UploadedFile[] uploadedFiles = FileUploadUtils.handleFileUpload(multiWrapper, true);
        if (uploadedFiles.length == 0) {
            return null;
        }
        return uploadedFiles[0];
    }

    public static void checkMultiPartRequestForErrors(MultiPartRequestWrapper multiWrapper) throws FileUploadException {
        if (multiWrapper.hasErrors()) {
            FileUploadException fileUploadException = new FileUploadException();
            Collection errors = multiWrapper.getErrors();
            Iterator i = errors.iterator();
            while (i.hasNext()) {
                String error = (String)i.next();
                log.error((Object)error);
                fileUploadException.addError(error);
            }
            throw fileUploadException;
        }
    }

    public static UploadedFile[] handleFileUpload(MultiPartRequestWrapper multiWrapper, boolean clean) throws FileUploadException {
        FileUploadUtils.checkMultiPartRequestForErrors(multiWrapper);
        Enumeration e = multiWrapper.getFileParameterNames();
        ArrayList<UploadedFile> uploadedFiles = new ArrayList<UploadedFile>();
        while (e.hasMoreElements()) {
            String inputValue = (String)e.nextElement();
            File[] files = multiWrapper.getFiles(inputValue);
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file == null && !clean) {
                    FileUploadException fileUploadException = new FileUploadException();
                    fileUploadException.addError("Error uploading: " + multiWrapper.getFileSystemNames(inputValue)[i]);
                    throw fileUploadException;
                }
                if (file == null) continue;
                UploadedFile uploadedFile = new UploadedFile(file, multiWrapper.getFileNames(inputValue)[i], multiWrapper.getContentTypes(inputValue)[i]);
                uploadedFiles.add(uploadedFile);
            }
        }
        return uploadedFiles.toArray(new UploadedFile[0]);
    }

    public static final class FileUploadException
    extends Exception {
        private List errors = new ArrayList();

        public void addError(String error) {
            this.errors.add(error);
        }

        public String[] getErrors() {
            return this.errors.toArray(new String[0]);
        }

        public String getMessage() {
            String s = "";
            String sep = "";
            Iterator i = this.errors.iterator();
            while (i.hasNext()) {
                s = s + sep + i.next();
                sep = ", ";
            }
            return s;
        }
    }

    public static final class UploadedFile {
        private File file;
        private String fileName;
        private String contentType;

        public UploadedFile(File file, String fileName, String contentType) {
            this.file = file;
            this.fileName = fileName;
            this.contentType = contentType;
        }

        public File getFile() {
            return this.file;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getContentType() {
            return this.contentType;
        }
    }
}

