/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.xwork.interceptors;

import com.atlassian.util.profiling.ProfilingUtils;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ActionProxy;
import com.opensymphony.xwork.interceptor.Interceptor;
import com.opensymphony.xwork.interceptor.PreResultListener;
import org.apache.log4j.Category;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;

public abstract class XWorkTransactionInterceptor
implements Interceptor {
    private static ThreadLocal currentTransactionStatus = new ThreadLocal();
    private static Category log = Category.getInstance((Class)XWorkTransactionInterceptor.class);

    public static TransactionStatus currentTransactionStatus() throws RuntimeException {
        TransactionStatus status = (TransactionStatus)currentTransactionStatus.get();
        if (status == null) {
            throw new RuntimeException("No transaction status in scope");
        }
        return status;
    }

    public void destroy() {
    }

    public void init() {
    }

    public abstract PlatformTransactionManager getTransactionManager();

    public String intercept(final ActionInvocation invocation) throws Exception {
        if (!this.shouldIntercept(invocation)) {
            return invocation.invoke();
        }
        DefaultTransactionAttribute transAtt = new DefaultTransactionAttribute(0);
        final TransactionStatus[] status = new TransactionStatus[1];
        TransactionStatus oldTransactionStatus = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting transaction for action '" + this.getDetails(invocation.getProxy()) + "'"));
        }
        status[0] = this.getTransactionManager().getTransaction((TransactionDefinition)transAtt);
        oldTransactionStatus = (TransactionStatus)currentTransactionStatus.get();
        currentTransactionStatus.set(status[0]);
        String retVal = null;
        try {
            try {
                if (status[0] != null) {
                    invocation.addPreResultListener(new PreResultListener((TransactionAttribute)transAtt){
                        private final /* synthetic */ TransactionAttribute val$transAtt;
                        {
                            this.val$transAtt = val$transAtt;
                        }

                        public void beforeResult(ActionInvocation actionInvocation, String s) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Committing transaction for " + XWorkTransactionInterceptor.this.getDetails(invocation.getProxy()) + " before result"));
                            }
                            XWorkTransactionInterceptor.this.getTransactionManager().commit(status[0]);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Opening new transaction for " + XWorkTransactionInterceptor.this.getDetails(invocation.getProxy()) + " result"));
                            }
                            status[0] = XWorkTransactionInterceptor.this.getTransactionManager().getTransaction((TransactionDefinition)this.val$transAtt);
                        }
                    });
                }
                retVal = invocation.invoke();
            }
            catch (Exception ex) {
                if (status[0] != null) {
                    this.onThrowable(invocation, (TransactionAttribute)transAtt, status[0], ex);
                }
                throw ex;
            }
            catch (Throwable t) {
                if (status[0] != null) {
                    this.onThrowable(invocation, (TransactionAttribute)transAtt, status[0], t);
                }
                throw new RuntimeException(t);
            }
            Object var8_6 = null;
            if (transAtt != null) {
                currentTransactionStatus.set(oldTransactionStatus);
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (transAtt != null) {
                currentTransactionStatus.set(oldTransactionStatus);
            }
            throw throwable;
        }
        if (status[0] != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invoking commit for transaction on method '" + this.getDetails(invocation.getProxy()) + "'"));
            }
            this.getTransactionManager().commit(status[0]);
        }
        return retVal;
    }

    protected abstract boolean shouldIntercept(ActionInvocation var1);

    private String getDetails(ActionProxy proxy) {
        String methodName = proxy.getConfig().getMethodName();
        if (methodName == null) {
            methodName = "execute";
        }
        String actionClazz = ProfilingUtils.getJustClassName((String)proxy.getConfig().getClassName());
        return proxy.getNamespace() + "/" + proxy.getActionName() + ".action (" + actionClazz + "." + methodName + "())";
    }

    private void onThrowable(ActionInvocation invocation, TransactionAttribute txAtt, TransactionStatus status, Throwable ex) {
        try {
            if (txAtt.rollbackOn(ex)) {
                log.error((Object)("Invoking rollback for transaction on action '" + this.getDetails(invocation.getProxy()) + "' due to throwable: " + ex), ex);
                this.getTransactionManager().rollback(status);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Action '" + this.getDetails(invocation.getProxy()) + "' threw throwable but this does not force transaction rollback: " + ex), ex);
                }
                this.getTransactionManager().commit(status);
            }
        }
        catch (Exception e) {
            log.error((Object)("Attempted rollback caused exception: " + e), (Throwable)e);
        }
    }
}

