/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.application.console;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.application.console.Coherence$Logger$Queue;
import com.tangosol.coherence.component.application.console.Coherence$Logger$ShutdownHook;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Logger;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.io.PrintStream;
import java.util.Map;

public class Coherence$Logger
extends Logger {
    private boolean __m_CommandPrompt;
    private transient boolean __m_Dead;
    private transient int __m_HashCode;
    private long __m_LastPromptTimeMillis;
    private boolean __m_PendingLineFeed;
    private boolean __m_PendingPrompt;
    private String __m_Prompt;
    private static ListMap __mapChildren;

    static {
        Coherence$Logger.__initStatic();
    }

    public Coherence$Logger() {
        this(null, null, true);
    }

    public Coherence$Logger(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setFormat("{date} Oracle Coherence {version} <{level}> (thread={thread}): {text}");
            this.setLevel(10);
            this.setLimit(65536);
            this.setParameters(new String[]{"{date}", "{level}", "{thread}", "{e}", "{text}", "{member}", "{role}", "{location}", "{product}", "{version}"});
            this.setPriority(3);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"Queue", (Object)Coherence$Logger$Queue.get_CLASS());
        Object object2 = __mapChildren.put((Object)"ShutdownHook", (Object)Coherence$Logger$ShutdownHook.get_CLASS());
    }

    protected String formatParameter(String sParamName, Object oParamValue) {
        if (!(sParamName != null) ? false : sParamName.length() > 2) {
            switch (sParamName.charAt(1)) {
                case 'm': {
                    if (!sParamName.equals("{member}")) break;
                    int nMember = oParamValue instanceof Integer ? (Integer)oParamValue : 0;
                    return nMember == 0 ? "n/a" : String.valueOf(nMember);
                }
                case 'l': 
                case 'r': {
                    if (!(sParamName.equals("{role}") ? true : sParamName.equals("{location}"))) break;
                    return oParamValue == null ? "" : (String)oParamValue;
                }
                case 'p': {
                    if (!sParamName.equals("{product}")) break;
                    String sProduct = (String)oParamValue;
                    return sProduct == null ? Coherence.TITLE : sProduct;
                }
                case 'v': {
                    if (!sParamName.equals("{version}")) break;
                    return Coherence.VERSION;
                }
            }
        }
        return super.formatParameter(sParamName, oParamValue);
    }

    public String getDefaultFormat() {
        return "{date} Oracle Coherence {version} <{level}> (thread={thread}, member={member}): {text}";
    }

    public int getDefaultLevel() {
        return 3;
    }

    public long getDefaultWaitMillis() {
        return 500L;
    }

    public int getHashCode() {
        int nHash = this.__m_HashCode;
        return nHash == 0 ? System.identityHashCode(this.get_Module()) : nHash;
    }

    protected long getLastPromptTimeMillis() {
        return this.__m_LastPromptTimeMillis;
    }

    public String getPrompt() {
        return this.__m_Prompt;
    }

    public String getThreadName() {
        return String.valueOf(super.getThreadName()) + "@" + this.getHashCode() + " " + Coherence.VERSION;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/application/console/Coherence$Logger".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new Coherence$Logger();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public boolean isCommandPrompt() {
        return this.__m_CommandPrompt;
    }

    public boolean isDead() {
        return this.__m_Dead;
    }

    public boolean isPendingLineFeed() {
        return this.__m_PendingLineFeed;
    }

    protected boolean isPendingPrompt() {
        return this.__m_PendingPrompt;
    }

    public void onInit() {
        super.onInit();
        this.setPrompt("?");
    }

    protected void onLog() {
        super.onLog();
        if (this.isPendingLineFeed()) {
            PrintStream out;
            PrintStream printStream = out = System.out;
            synchronized (printStream) {
                out.println();
            }
            this.setPendingLineFeed(false);
        }
        this.setPendingPrompt(this.isCommandPrompt());
    }

    protected void onNotify() {
        long lCurrent;
        super.onNotify();
        if (this.isPendingPrompt() && (lCurrent = Base.getSafeTimeMillis()) > this.getLastPromptTimeMillis() + this.getWaitMillis()) {
            PrintStream out;
            PrintStream printStream = out = System.out;
            synchronized (printStream) {
                out.print(String.valueOf("\nMap (") + this.getPrompt() + "): ");
                out.flush();
            }
            this.setPendingPrompt(false);
            this.setPendingLineFeed(true);
            this.setLastPromptTimeMillis(lCurrent);
        }
    }

    public void setCommandPrompt(boolean fPrompt) {
        this.__m_CommandPrompt = fPrompt;
        this.setPendingPrompt(fPrompt);
        this.setLastPromptTimeMillis(0L);
        this.setWaitMillis(fPrompt ? this.getDefaultWaitMillis() : 0L);
        this.setNotification(true);
    }

    public void setDead(boolean fDead) {
        this.__m_Dead = fDead;
        if (fDead) {
            this.shutdown();
        }
    }

    public void setHashCode(int n) {
        this.__m_HashCode = n;
        this.getThread().setName(this.getThreadName());
    }

    protected void setLastPromptTimeMillis(long nTime) {
        this.__m_LastPromptTimeMillis = nTime;
    }

    public void setPendingLineFeed(boolean fPending) {
        this.__m_PendingLineFeed = fPending;
    }

    protected void setPendingPrompt(boolean fPending) {
        this.__m_PendingPrompt = fPending;
    }

    public void setPrompt(String sPrompt) {
        this.__m_Prompt = sPrompt;
    }
}

