/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.comm;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Comm;
import com.tangosol.coherence.component.comm.Channel;
import com.tangosol.coherence.component.comm.Connection$Codec;
import com.tangosol.coherence.component.comm.ConnectionManager;
import com.tangosol.coherence.component.comm.messageFactory.MessagingFactory$ChannelAcceptRequest;
import com.tangosol.coherence.component.comm.messageFactory.MessagingFactory$ChannelCloseMessage;
import com.tangosol.coherence.component.comm.messageFactory.MessagingFactory$ChannelOpenRequest;
import com.tangosol.coherence.component.comm.messageFactory.MessagingFactory$DisconnectMessage;
import com.tangosol.coherence.component.comm.protocol.MessagingProtocol;
import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.io.WrapperDataInputStream;
import com.tangosol.io.WrapperDataOutputStream;
import com.tangosol.io.WrapperStreamFactory;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.messaging.Channel;
import com.tangosol.net.messaging.Connection;
import com.tangosol.net.messaging.ConnectionAcceptor;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.net.messaging.Message;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.LongArray;
import com.tangosol.util.SparseArray;
import com.tangosol.util.ThreadGate;
import com.tangosol.util.UUID;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;

public abstract class Connection
extends Comm
implements com.tangosol.net.messaging.Connection {
    private static final int MAX_PENDING = 100;
    private LongArray __m_ChannelArray;
    private LongArray __m_ChannelPendingArray;
    private Connection.Codec __m_Codec;
    private volatile com.tangosol.net.messaging.ConnectionManager __m_ConnectionManager;
    private UUID __m_Id;
    private Map __m_MessageFactoryMap;
    private volatile boolean __m_Open;
    private int __m_PeerEdition;
    private UUID __m_PeerId;
    private long __m_RequestTimeout;
    private ThreadGate __m_ThreadGate;
    private static ListMap __mapChildren;

    static {
        Connection.__initStatic();
    }

    public Connection(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"Codec", (Object)Connection$Codec.get_CLASS());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public com.tangosol.net.messaging.Channel acceptChannel(URI uri, ClassLoader loader, Channel.Receiver receiver, Subject subject) {
        ConnectionException eSend;
        block16: {
            boolean bl;
            Channel channel;
            eSend = null;
            ThreadGate gate = this.getThreadGate();
            if (gate.enter(0L) ^ true) {
                throw new ConnectionException("connection is closed");
            }
            try {
                try {
                    int nId;
                    if (this.isOpen() ^ true) {
                        throw new ConnectionException("connection is closed");
                    }
                    try {
                        nId = Integer.valueOf(uri.getSchemeSpecificPart());
                    }
                    catch (RuntimeException e) {
                        throw new IllegalArgumentException(String.valueOf("illegal URI: ") + uri);
                    }
                    if (nId == 0) {
                        throw new IllegalArgumentException("channel 0 is reserved");
                    }
                    if (this.getChannel(nId) != null) {
                        throw new IllegalArgumentException(String.valueOf("duplicate channel: ") + nId);
                    }
                    String sProtocol = uri.getFragment();
                    if (sProtocol == null) {
                        new IllegalArgumentException(String.valueOf("Illegal URI: ") + uri);
                    }
                    Channel channel0 = (Channel)this.getChannel(0);
                    Protocol.MessageFactory factory = channel0.getMessageFactory();
                    MessagingFactory$ChannelAcceptRequest request = (MessagingFactory$ChannelAcceptRequest)factory.createMessage(MessagingFactory$ChannelAcceptRequest.TYPE_ID);
                    byte[] abToken = this.generateIdentityToken(subject, channel0.getSerializer());
                    request.setChannelId(nId);
                    request.setIdentityToken(abToken);
                    if (!Base.equals((Object)channel0.request(request), (Object)Boolean.TRUE)) {
                        throw new RuntimeException(String.valueOf("error accepting channel; id=") + nId + ", protocol=" + sProtocol);
                    }
                    Channel channelNew = this.instantiateChannel(nId, sProtocol, loader, receiver, subject);
                    channelNew.open();
                    this.registerChannel(channelNew);
                    channel = channelNew;
                    Object var15_18 = null;
                    bl = eSend == null;
                }
                catch (ConnectionException e) {
                    eSend = e;
                    Object var15_19 = null;
                    if (eSend == null ? true : gate.isActiveThread()) {
                        gate.exit();
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                Object var15_20 = null;
                if (eSend == null ? true : gate.isActiveThread()) {
                    gate.exit();
                }
                throw throwable;
            }
            if (bl ? true : gate.isActiveThread()) {
                gate.exit();
            }
            return channel;
        }
        this.close(eSend);
        throw eSend;
    }

    public void acceptChannelInternal(int nId, byte[] abToken) {
        Component._assert(this.getThreadGate().isActiveThread());
        if (nId == 0) {
            throw new IllegalArgumentException("channel 0 is reserved");
        }
        if (this.getChannel(nId) != null) {
            throw new IllegalArgumentException(String.valueOf("channel already exists: ") + nId);
        }
        Channel channel = (Channel)this.getChannelPendingArray().remove((long)nId);
        if (channel == null) {
            throw new IllegalArgumentException(String.valueOf("no such channel: ") + nId);
        }
        channel.setSubject(this.assertIdentityToken(abToken, channel.getSerializer()));
        this.registerChannel(channel);
        channel.open();
    }

    protected WriteBuffer allocateWriteBuffer() {
        return new ByteArrayWriteBuffer(32);
    }

    protected Subject assertIdentityToken(byte[] abToken, Serializer serializer) {
        if (abToken != null) {
            Component._assert(serializer != null);
            try {
                ByteArrayReadBuffer buf = new ByteArrayReadBuffer(abToken);
                return (Subject)serializer.deserialize(buf.getBufferInput());
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public void close() {
        this.close(true);
    }

    public void close(Throwable t) {
        ConnectionManager manager;
        if (t instanceof ConnectionException) {
            ConnectionException e = (ConnectionException)t;
            if (this.getThreadGate().isActiveThread()) {
                throw e;
            }
            Throwable tCause = e.getCause();
            if (tCause != null) {
                t = tCause;
            }
        }
        if ((manager = this.closeInternal(false)) != null) {
            manager.onConnectionError(this, t);
        }
    }

    public void close(boolean fNotify) {
        ConnectionManager manager = this.closeInternal(fNotify);
        if (manager != null) {
            manager.onConnectionClosed(this);
        }
    }

    protected ConnectionManager closeInternal(boolean fNotify) {
        ConnectionManager manager;
        ThreadGate gate;
        block5: {
            gate = this.getThreadGate();
            Component._assert(gate.isActiveThread() ^ true);
            gate.close(-1L);
            try {
                if (this.isOpen()) {
                    try {
                        this.doClose(fNotify);
                    }
                    catch (Throwable t) {
                        Component._trace(t, String.valueOf("An error occured while closing a connection") + "; the connection will be marked as closed");
                    }
                    this.setOpen(false);
                    manager = (ConnectionManager)this.getConnectionManager();
                    this.setConnectionManager(null);
                    break block5;
                }
                manager = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                gate.open();
                throw throwable;
            }
        }
        Object var5_6 = null;
        gate.open();
        return manager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URI createChannel(Protocol protocol, ClassLoader loader, Channel.Receiver receiver) {
        Object object;
        ThreadGate gate = this.getThreadGate();
        if (gate.enter(0L) ^ true) {
            throw new ConnectionException("connection is closed");
        }
        try {
            LongArray longArray;
            LongArray laPending;
            if (this.isOpen() ^ true) {
                throw new ConnectionException("connection is closed");
            }
            if (protocol == null) {
                throw new IllegalArgumentException("protocol cannot be null");
            }
            String sProtocol = protocol.getName();
            if (sProtocol == null) {
                throw new IllegalArgumentException(String.valueOf("missing protocol name: ") + protocol);
            }
            int nId = this.generateChannelId();
            Channel channel = this.instantiateChannel(nId, sProtocol, loader, receiver, null);
            object = laPending = this.getChannelPendingArray();
            synchronized (object) {
                if (laPending.getSize() > MAX_PENDING) {
                    Object oChannel = laPending.remove(laPending.getFirstIndex());
                    Component._trace(String.valueOf("Maximum pending channel count reached; discarding: ") + oChannel, 2);
                }
                laPending.set((long)nId, (Object)channel);
            }
            try {
                object = new URI("channel", String.valueOf(nId), sProtocol);
                longArray = null;
            }
            catch (URISyntaxException e) {
                longArray = laPending;
                synchronized (longArray) {
                    laPending.remove((long)nId);
                    throw Comm.ensureRuntimeException(e, "error creating URI");
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            gate.exit();
            throw throwable;
        }
        gate.exit();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message decodeMessage(ReadBuffer rb) {
        Object var10_15;
        Message message;
        Channel channel;
        Throwable tDecode;
        block35: {
            Object var10_14;
            Message message2;
            block34: {
                Object var10_13;
                Message message3;
                block33: {
                    Object var10_12;
                    Message message4;
                    block32: {
                        Object var10_11;
                        Message message5;
                        block31: {
                            boolean bl;
                            Message message6;
                            block23: {
                                Component._assert(rb != null);
                                tDecode = null;
                                try {
                                    ThreadGate gateOuter;
                                    block30: {
                                        block29: {
                                            block26: {
                                                block25: {
                                                    block24: {
                                                        gateOuter = this.getThreadGate();
                                                        if (gateOuter.enter(0L) ^ true) {
                                                            message6 = null;
                                                            Object var10_10 = null;
                                                            bl = tDecode == null;
                                                            break block23;
                                                        }
                                                        try {
                                                            if (this.isOpen() ^ true) {
                                                                message5 = null;
                                                                var10_11 = null;
                                                                break block24;
                                                            }
                                                            try {
                                                                ThreadGate gateInner;
                                                                block28: {
                                                                    block27: {
                                                                        ReadBuffer.BufferInput in = this.filterBuffer(rb).getBufferInput();
                                                                        int nId = in.readPackedInt();
                                                                        channel = (Channel)this.getChannel(nId);
                                                                        if (channel == null) {
                                                                            if (Component._isTraceEnabled(6)) {
                                                                                Component._trace(String.valueOf("Received a message sent through an unknown channel: ") + nId, 6);
                                                                            }
                                                                            message4 = null;
                                                                            break block25;
                                                                        }
                                                                        gateInner = channel.getThreadGate();
                                                                        if (gateInner.enter(0L) ^ true) {
                                                                            message3 = null;
                                                                            break block26;
                                                                        }
                                                                        try {
                                                                            if (channel.isOpen() ^ true) {
                                                                                message2 = null;
                                                                                var10_14 = null;
                                                                                break block27;
                                                                            }
                                                                            message = this.getCodec().decode((com.tangosol.net.messaging.Channel)channel, in);
                                                                            break block28;
                                                                        }
                                                                        catch (Throwable throwable) {
                                                                            Object var10_16 = null;
                                                                            gateInner.exit();
                                                                            throw throwable;
                                                                        }
                                                                    }
                                                                    gateInner.exit();
                                                                    break block29;
                                                                }
                                                                var10_15 = null;
                                                                gateInner.exit();
                                                                break block30;
                                                            }
                                                            catch (Throwable t) {
                                                                tDecode = t;
                                                                Message message7 = null;
                                                                Object var10_17 = null;
                                                                gateOuter.exit();
                                                                var10_17 = null;
                                                                if (tDecode == null) {
                                                                    this.releaseReadBuffer(rb);
                                                                    return message7;
                                                                }
                                                                this.releaseReadBuffer(rb, tDecode);
                                                                Component._trace(tDecode, "Error decoding message");
                                                                return message7;
                                                            }
                                                        }
                                                        catch (Throwable throwable) {
                                                            Object var10_18 = null;
                                                            gateOuter.exit();
                                                            throw throwable;
                                                        }
                                                    }
                                                    gateOuter.exit();
                                                    break block31;
                                                }
                                                var10_12 = null;
                                                gateOuter.exit();
                                                break block32;
                                            }
                                            var10_13 = null;
                                            gateOuter.exit();
                                            break block33;
                                        }
                                        var10_14 = null;
                                        gateOuter.exit();
                                        break block34;
                                    }
                                    var10_15 = null;
                                    gateOuter.exit();
                                    break block35;
                                }
                                catch (Throwable throwable) {
                                    Object var10_19 = null;
                                    if (tDecode == null) {
                                        this.releaseReadBuffer(rb);
                                        throw throwable;
                                    }
                                    this.releaseReadBuffer(rb, tDecode);
                                    Component._trace(tDecode, "Error decoding message");
                                    throw throwable;
                                }
                            }
                            if (bl) {
                                this.releaseReadBuffer(rb);
                                return message6;
                            }
                            this.releaseReadBuffer(rb, tDecode);
                            Component._trace(tDecode, "Error decoding message");
                            return message6;
                        }
                        var10_11 = null;
                        if (tDecode == null) {
                            this.releaseReadBuffer(rb);
                            return message5;
                        }
                        this.releaseReadBuffer(rb, tDecode);
                        Component._trace(tDecode, "Error decoding message");
                        return message5;
                    }
                    var10_12 = null;
                    if (tDecode == null) {
                        this.releaseReadBuffer(rb);
                        return message4;
                    }
                    this.releaseReadBuffer(rb, tDecode);
                    Component._trace(tDecode, "Error decoding message");
                    return message4;
                }
                var10_13 = null;
                if (tDecode == null) {
                    this.releaseReadBuffer(rb);
                    return message3;
                }
                this.releaseReadBuffer(rb, tDecode);
                Component._trace(tDecode, "Error decoding message");
                return message3;
            }
            var10_14 = null;
            if (tDecode == null) {
                this.releaseReadBuffer(rb);
                return message2;
            }
            this.releaseReadBuffer(rb, tDecode);
            Component._trace(tDecode, "Error decoding message");
            return message2;
        }
        var10_15 = null;
        if (tDecode == null) {
            this.releaseReadBuffer(rb);
        } else {
            this.releaseReadBuffer(rb, tDecode);
            Component._trace(tDecode, "Error decoding message");
        }
        message.setChannel((com.tangosol.net.messaging.Channel)channel);
        return message;
    }

    protected void disconnect() {
        com.tangosol.net.messaging.Channel channel0 = this.getChannel(0);
        if (channel0 != null) {
            Protocol.MessageFactory factory = channel0.getMessageFactory();
            channel0.send(factory.createMessage(MessagingFactory$DisconnectMessage.TYPE_ID));
        }
    }

    protected void doClose(boolean fNotify) {
        Channel channel0;
        LongArray laChannel;
        LongArray longArray = laChannel = this.getChannelArray();
        synchronized (longArray) {
            LongArray.Iterator iter = laChannel.iterator();
            while (iter.hasNext()) {
                Channel channel = (Channel)iter.next();
                if (!(channel.getId() != 0)) continue;
                iter.remove();
                channel.close(fNotify);
            }
        }
        this.getChannelPendingArray().clear();
        if (fNotify) {
            try {
                this.disconnect();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if ((channel0 = (Channel)this.getChannel(0)) != null) {
            channel0.close(false);
        }
        this.setPeerId(null);
    }

    protected void doOpen() {
        com.tangosol.net.messaging.ConnectionManager manager = this.getConnectionManager();
        Component._assert(manager != null);
        if (this.getCodec() == null) {
            this.setCodec((Connection$Codec)this._newChild("Codec"));
        }
        Channel channel = this.instantiateChannel(0, MessagingProtocol.getInstance().getName(), null, null, null);
        channel.open();
        this.registerChannel(channel);
    }

    protected void doSend(WriteBuffer wb) {
        ConnectionManager manager = (ConnectionManager)this.getConnectionManager();
        manager.onSend(this, wb);
    }

    protected ReadBuffer filterBuffer(ReadBuffer rb) throws IOException {
        ConnectionManager manager = (ConnectionManager)this.getConnectionManager();
        Component._assert(manager != null);
        List list = manager.getWrapperStreamFactoryList();
        if (list == null ? true : list.isEmpty()) {
            return rb;
        }
        ByteArrayWriteBuffer bawb = new ByteArrayWriteBuffer(rb.length());
        Object in = new WrapperDataInputStream((DataInput)rb.getBufferInput());
        int i = list.size() - 1;
        while (i >= 0) {
            in = ((WrapperStreamFactory)list.get(i)).getInputStream((InputStream)in);
            --i;
        }
        WriteBuffer.BufferOutput out = bawb.getBufferOutput();
        byte[] ab = new byte[1024];
        int c = ((InputStream)in).read(ab);
        while (c != -1) {
            out.write(ab, 0, c);
            c = ((InputStream)in).read(ab);
        }
        return new ByteArrayReadBuffer(bawb.getRawByteArray(), 0, bawb.length());
    }

    protected WriteBuffer filterBuffer(WriteBuffer wb) throws IOException {
        ConnectionManager manager = (ConnectionManager)this.getConnectionManager();
        Component._assert(manager != null);
        List list = manager.getWrapperStreamFactoryList();
        if (list == null ? true : list.isEmpty()) {
            return wb;
        }
        WriteBuffer wbNew = this.allocateWriteBuffer();
        try {
            Object out = new WrapperDataOutputStream((DataOutput)wbNew.getBufferOutput());
            int i = 0;
            int c = list.size();
            while (i < c) {
                out = ((WrapperStreamFactory)list.get(i)).getOutputStream((OutputStream)out);
                ++i;
            }
            ReadBuffer.BufferInput in = wb.getUnsafeReadBuffer().getBufferInput();
            byte[] ab = new byte[1024];
            int c2 = in.read(ab);
            while (c2 != -1) {
                ((OutputStream)out).write(ab, 0, c2);
                c2 = in.read(ab);
            }
            ((OutputStream)out).close();
            this.releaseWriteBuffer(wb);
            return wbNew;
        }
        catch (Throwable t) {
            this.releaseWriteBuffer(wbNew, t);
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw Comm.ensureRuntimeException(t);
        }
    }

    protected int generateChannelId() {
        int nId;
        LongArray laPending = this.getChannelPendingArray();
        int nScale = this.getConnectionManager() instanceof ConnectionAcceptor ? 1 : -1;
        while (((nId = Base.getRandom().nextInt(Integer.MAX_VALUE) * nScale) == 0 ? true : this.getChannel(nId) != null) ? true : laPending.get((long)nId) != null) {
        }
        return nId;
    }

    protected byte[] generateIdentityToken(Subject subject, Serializer serializer) {
        if (subject != null) {
            Component._assert(serializer != null);
            try {
                ByteArrayWriteBuffer buf = new ByteArrayWriteBuffer(0);
                serializer.serialize(buf.getBufferOutput(), (Object)subject);
                return buf.getRawByteArray();
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public com.tangosol.net.messaging.Channel getChannel(int nId) {
        LongArray laChannel;
        LongArray longArray = laChannel = this.getChannelArray();
        synchronized (longArray) {
            Channel channel = (Channel)laChannel.get((long)nId);
            Object var5_5 = null;
            return channel;
        }
    }

    protected LongArray getChannelArray() {
        return this.__m_ChannelArray;
    }

    protected LongArray getChannelPendingArray() {
        return this.__m_ChannelPendingArray;
    }

    public Collection getChannels() {
        LongArray laChannel = this.getChannelArray();
        LinkedList list = new LinkedList();
        LongArray longArray = laChannel;
        synchronized (longArray) {
            LongArray.Iterator iter = laChannel.iterator();
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        return list;
    }

    public Connection.Codec getCodec() {
        return this.__m_Codec;
    }

    public com.tangosol.net.messaging.ConnectionManager getConnectionManager() {
        return this.__m_ConnectionManager;
    }

    protected String getDescription() {
        return String.valueOf("Id=") + this.getId() + ", Open=" + this.isOpen();
    }

    public UUID getId() {
        return this.__m_Id;
    }

    public Map getMessageFactoryMap() {
        return this.__m_MessageFactoryMap;
    }

    public int getPeerEdition() {
        return this.__m_PeerEdition;
    }

    public UUID getPeerId() {
        return this.__m_PeerId;
    }

    public long getRequestTimeout() {
        return this.__m_RequestTimeout;
    }

    public ThreadGate getThreadGate() {
        return this.__m_ThreadGate;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/comm/Connection".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    private final Component get_Module() {
        return this;
    }

    protected Channel instantiateChannel(int nId, String sProtocol, ClassLoader loader, Channel.Receiver receiver, Subject subject) {
        Protocol.MessageFactory factory = (Protocol.MessageFactory)this.getMessageFactoryMap().get(sProtocol);
        if (factory == null) {
            throw new IllegalArgumentException(String.valueOf("unknown protocol: ") + sProtocol);
        }
        if (receiver != null) {
            Protocol protocol = receiver.getProtocol();
            if (protocol == null) {
                throw new IllegalArgumentException(String.valueOf("missing receiver name: ") + receiver);
            }
            if (protocol != factory.getProtocol()) {
                throw new IllegalArgumentException(String.valueOf("protocol mismatch; expected ") + factory.getProtocol() + ", retrieved " + protocol + ")");
            }
        }
        ConnectionManager manager = (ConnectionManager)this.getConnectionManager();
        Channel channel = new Channel();
        channel.setId(nId);
        channel.setConnection(this);
        channel.setMessageFactory(factory);
        channel.setReceiver(receiver);
        channel.setRequestTimeout(this.getRequestTimeout());
        channel.setSerializer(manager.instantiateSerializer(loader));
        channel.setSubject(subject);
        return channel;
    }

    public boolean isOpen() {
        return this.__m_Open;
    }

    public void onChannelClosed(com.tangosol.net.messaging.Channel channel, boolean fNotify) {
        ThreadGate gate = this.getThreadGate();
        if (gate.enter(0L)) {
            block7: {
                try {
                    if (!this.isOpen()) break block7;
                    int nId = channel.getId();
                    if (!(nId != 0) ? false : fNotify) {
                        com.tangosol.net.messaging.Channel channel0 = this.getChannel(0);
                        Protocol.MessageFactory factory = channel0.getMessageFactory();
                        MessagingFactory$ChannelCloseMessage message = (MessagingFactory$ChannelCloseMessage)factory.createMessage(MessagingFactory$ChannelCloseMessage.TYPE_ID);
                        message.setChannelId(nId);
                        try {
                            channel0.send((Message)message);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    this.unregisterChannel(channel);
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    gate.exit();
                    throw throwable;
                }
            }
            Object var5_6 = null;
            gate.exit();
        }
        if (Component._isTraceEnabled(6)) {
            Component._trace(String.valueOf("Closed: ") + channel, 6);
        }
    }

    public void onChannelOpened(com.tangosol.net.messaging.Channel channel) {
        if (Component._isTraceEnabled(6)) {
            Component._trace(String.valueOf("Opened: ") + channel, 6);
        }
    }

    public void onInit() {
        this.setChannelArray((LongArray)new SparseArray());
        this.setChannelPendingArray((LongArray)new SparseArray());
        this.setThreadGate(new ThreadGate());
        super.onInit();
    }

    public void onReceive(Message message) {
        Component._assert(message != null);
        Channel channel = (Channel)message.getChannel();
        Component._assert(channel != null);
        channel.onReceive(message);
    }

    public void open() {
        ConnectionManager manager;
        ThreadGate gate;
        block4: {
            gate = this.getThreadGate();
            Component._assert(gate.isActiveThread() ^ true);
            gate.close(-1L);
            try {
                if (this.isOpen()) {
                    manager = null;
                    break block4;
                }
                this.doOpen();
                this.setOpen(true);
                manager = (ConnectionManager)this.getConnectionManager();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                gate.open();
                throw throwable;
            }
        }
        Object var4_3 = null;
        gate.open();
        if (manager != null) {
            manager.onConnectionOpened(this);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public com.tangosol.net.messaging.Channel openChannel(Protocol protocol, String sName, ClassLoader loader, Channel.Receiver receiver, Subject subject) {
        ConnectionException eSend;
        block12: {
            boolean bl;
            Channel channel;
            eSend = null;
            ThreadGate gate = this.getThreadGate();
            if (gate.enter(0L) ^ true) {
                throw new ConnectionException("connection is closed");
            }
            try {
                try {
                    if (this.isOpen() ^ true) {
                        throw new ConnectionException("connection is closed");
                    }
                    if (protocol == null) {
                        throw new IllegalArgumentException("protocol cannot be null");
                    }
                    if (sName == null) {
                        throw new IllegalArgumentException("name cannot be null");
                    }
                    String sProtocol = protocol.getName();
                    Component._assert(sName != null);
                    Channel channel0 = (Channel)this.getChannel(0);
                    Protocol.MessageFactory factory = channel0.getMessageFactory();
                    MessagingFactory$ChannelOpenRequest request = (MessagingFactory$ChannelOpenRequest)factory.createMessage(MessagingFactory$ChannelOpenRequest.TYPE_ID);
                    byte[] abToken = this.generateIdentityToken(subject, channel0.getSerializer());
                    request.setIdentityToken(abToken);
                    request.setProtocolName(sProtocol);
                    request.setReceiverName(sName);
                    Integer IId = (Integer)channel0.request(request);
                    Channel channel2 = this.instantiateChannel(IId, sProtocol, loader, receiver, subject);
                    channel2.open();
                    this.registerChannel(channel2);
                    channel = channel2;
                    Object var16_18 = null;
                    bl = eSend == null;
                }
                catch (ConnectionException e) {
                    eSend = e;
                    Object var16_19 = null;
                    if (eSend == null ? true : gate.isActiveThread()) {
                        gate.exit();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                if (eSend == null ? true : gate.isActiveThread()) {
                    gate.exit();
                }
                throw throwable;
            }
            if (bl ? true : gate.isActiveThread()) {
                gate.exit();
            }
            return channel;
        }
        this.close(eSend);
        throw eSend;
    }

    public int openChannelInternal(String sProtocol, ClassLoader loader, Channel.Receiver receiver, byte[] abToken) {
        Component._assert(this.getThreadGate().isActiveThread());
        Channel channel0 = (Channel)this.getChannel(0);
        Subject subject = this.assertIdentityToken(abToken, channel0.getSerializer());
        int nId = this.generateChannelId();
        Channel channel = this.instantiateChannel(nId, sProtocol, loader, receiver, subject);
        this.registerChannel(channel);
        channel.open();
        return nId;
    }

    protected void registerChannel(com.tangosol.net.messaging.Channel channel) {
        LongArray laChannel;
        LongArray longArray = laChannel = this.getChannelArray();
        synchronized (longArray) {
            Object oChannel = laChannel.set((long)channel.getId(), (Object)channel);
            if (oChannel != null) {
                laChannel.set((long)channel.getId(), oChannel);
                throw new IllegalArgumentException(String.valueOf("duplicate channel: ") + channel);
            }
        }
    }

    protected void releaseReadBuffer(ReadBuffer rb) {
    }

    protected void releaseReadBuffer(ReadBuffer rb, Throwable t) {
        this.releaseReadBuffer(rb);
    }

    protected void releaseWriteBuffer(WriteBuffer wb) {
        wb.clear();
    }

    protected void releaseWriteBuffer(WriteBuffer wb, Throwable t) {
        this.releaseWriteBuffer(wb);
    }

    public void send(Message message) {
        Component._assert(message != null);
        com.tangosol.net.messaging.Channel channel = message.getChannel();
        Component._assert(channel != null);
        Component._assert(channel.getConnection() == this);
        Component._assert(this.getThreadGate().isActiveThread());
        WriteBuffer wb = this.allocateWriteBuffer();
        try {
            WriteBuffer.BufferOutput out = wb.getBufferOutput();
            out.writePackedInt(channel.getId());
            this.getCodec().encode(channel, message, out);
            wb = this.filterBuffer(wb);
        }
        catch (Throwable t) {
            this.releaseWriteBuffer(wb, t);
            throw Comm.ensureRuntimeException(t, "error encoding message");
        }
        try {
            this.doSend(wb);
        }
        finally {
            Object var5_7 = null;
            this.releaseWriteBuffer(wb);
        }
    }

    protected void setChannelArray(LongArray la) {
        this.__m_ChannelArray = la;
    }

    protected void setChannelPendingArray(LongArray la) {
        this.__m_ChannelPendingArray = la;
    }

    public void setCodec(Connection.Codec codec) {
        Component._assert(this.isOpen() ^ true);
        this.__m_Codec = codec;
    }

    public void setConnectionManager(com.tangosol.net.messaging.ConnectionManager manager) {
        Component._assert(this.isOpen() ^ true);
        this.__m_ConnectionManager = manager;
    }

    public void setId(UUID uuid) {
        Component._assert(this.getId() == null);
        this.__m_Id = uuid;
    }

    public void setMessageFactoryMap(Map map) {
        Component._assert(this.isOpen() ^ true);
        this.__m_MessageFactoryMap = map;
    }

    protected void setOpen(boolean fOpen) {
        this.__m_Open = fOpen;
    }

    public void setPeerEdition(int nEdition) {
        this.__m_PeerEdition = nEdition;
    }

    public void setPeerId(UUID uuid) {
        this.__m_PeerId = uuid;
    }

    public void setRequestTimeout(long cMillis) {
        this.__m_RequestTimeout = cMillis;
    }

    protected void setThreadGate(ThreadGate gate) {
        this.__m_ThreadGate = gate;
    }

    protected void unregisterChannel(com.tangosol.net.messaging.Channel channel) {
        LongArray laChannel;
        LongArray longArray = laChannel = this.getChannelArray();
        synchronized (longArray) {
            laChannel.remove((long)channel.getId());
        }
    }
}

