/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.comm;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Comm;
import com.tangosol.coherence.component.comm.Connection;
import com.tangosol.coherence.component.comm.ConnectionManager$ConnectionCloseTask;
import com.tangosol.coherence.component.comm.ConnectionManager$ConnectionEventTask;
import com.tangosol.coherence.component.comm.ConnectionManager$Daemon;
import com.tangosol.coherence.component.comm.ConnectionManager$DaemonPool;
import com.tangosol.coherence.component.comm.ConnectionManager$EventDispatcher;
import com.tangosol.coherence.component.comm.ConnectionManager$MessageDispatchTask;
import com.tangosol.coherence.component.comm.ConnectionManager$MessageExecuteTask;
import com.tangosol.coherence.component.comm.messageFactory.MessagingFactory$PingRequest;
import com.tangosol.coherence.component.comm.protocol.MessagingProtocol;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.coherence.component.util.daemon.QueueProcessor;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.license.LicenseException;
import com.tangosol.net.messaging.Channel;
import com.tangosol.net.messaging.Connection;
import com.tangosol.net.messaging.ConnectionEvent;
import com.tangosol.net.messaging.ConnectionListener;
import com.tangosol.net.messaging.Message;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.net.messaging.Request;
import com.tangosol.run.xml.XmlConfigurable;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.ListMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.UUID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ConnectionManager
extends Comm
implements com.tangosol.net.messaging.ConnectionManager {
    private Connection.Codec __m_Codec;
    private XmlElement __m_Config;
    private ClassLoader __m_ContextClassLoader;
    private DaemonPool __m_DaemonPool;
    private QueueProcessor __m_EventDispatcher;
    private Listeners __m_Listeners;
    private transient Map __m_MessageFactoryMap;
    private long __m_PingInterval;
    private long __m_PingLastMillis;
    private Collection __m_PingStatus;
    private long __m_PingTimeout;
    private Map __m_ProtocolMap;
    private Map __m_ReceiverMap;
    private long __m_RequestTimeout;
    private volatile boolean __m_Running;
    private Class __m_SerializerClass;
    private XmlElement __m_SerializerConfig;
    private long __m_StatsBytesReceived;
    private long __m_StatsBytesSent;
    private long __m_StatsMessagesReceived;
    private long __m_StatsMessagesSent;
    private transient long __m_StatsReset;
    private int __m_ThreadCount;
    private List __m_WrapperStreamFactoryList;
    private static ListMap __mapChildren;
    private static transient String __s_LicenseError;
    private static UUID __s_ProcessId;
    private static /* synthetic */ Class __sf0;
    private static /* synthetic */ Class __sf1;
    private static /* synthetic */ Class __sf2;
    private static /* synthetic */ Class __sf3;

    static {
        ConnectionManager._initStatic();
    }

    public ConnectionManager() {
        this(null, null, true);
    }

    public ConnectionManager(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this._addChild(new ConnectionManager$Daemon("Daemon", this, true), "Daemon");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"ConnectionCloseTask", (Object)ConnectionManager$ConnectionCloseTask.get_CLASS());
        Object object2 = __mapChildren.put((Object)"ConnectionEventTask", (Object)ConnectionManager$ConnectionEventTask.get_CLASS());
        Object object3 = __mapChildren.put((Object)"DaemonPool", (Object)ConnectionManager$DaemonPool.get_CLASS());
        Object object4 = __mapChildren.put((Object)"EventDispatcher", (Object)ConnectionManager$EventDispatcher.get_CLASS());
        Object object5 = __mapChildren.put((Object)"MessageDispatchTask", (Object)ConnectionManager$MessageDispatchTask.get_CLASS());
        Object object6 = __mapChildren.put((Object)"MessageExecuteTask", (Object)ConnectionManager$MessageExecuteTask.get_CLASS());
    }

    private static /* synthetic */ Class __sm0() {
        Class<?> clazz = __sf0;
        if (clazz == null) {
            try {
                clazz = __sf0 = Class.forName("com.tangosol.io.WrapperStreamFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private static /* synthetic */ Class __sm1() {
        Class<?> clazz = __sf1;
        if (clazz == null) {
            try {
                clazz = __sf1 = Class.forName("com.tangosol.net.messaging.Connection$Codec");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private static /* synthetic */ Class __sm2() {
        Class<?> clazz = __sf2;
        if (clazz == null) {
            try {
                clazz = __sf2 = Class.forName("com.tangosol.io.Serializer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private static /* synthetic */ Class __sm3() {
        Class<?> clazz = __sf3;
        if (clazz == null) {
            try {
                clazz = __sf3 = Class.forName("com.tangosol.run.xml.XmlConfigurable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private static void _initStatic$Default() {
        ConnectionManager.__initStatic();
    }

    protected static void _initStatic() {
        ConnectionManager.setProcessId(new UUID());
        ConnectionManager._initStatic$Default();
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.getListeners().add((EventListener)listener);
    }

    public void closeConnection(Connection connection, boolean fNotify, Throwable t) {
        ConnectionManager$ConnectionCloseTask task = new ConnectionManager$ConnectionCloseTask();
        task.setConnection(connection);
        task.setError(t);
        task.setNotify(fNotify);
        this.execute(task);
    }

    public synchronized void configure(XmlElement xml) {
        Component._assert(this.isRunning() ^ true);
        this.doConfigure(xml);
        this.setConfig(xml);
    }

    protected void dispatchConnectionEvent(ConnectionEvent evt) {
        Listeners listeners = this.getListeners();
        if (listeners.isEmpty() ^ true) {
            ConnectionManager$ConnectionEventTask task = new ConnectionManager$ConnectionEventTask();
            task.setConnectionEvent(evt);
            task.setListeners(listeners);
            this.ensureEventDispatcher().getQueue().add(task);
        }
    }

    protected void doConfigure(XmlElement xml) {
        XmlElement xmlCat = xml.getSafeElement("outgoing-message-handler");
        this.setRequestTimeout(ConnectionManager.parseTime(xmlCat, "request-timeout", this.getRequestTimeout()));
        this.setPingTimeout(ConnectionManager.parseTime(xmlCat, "heartbeat-timeout", this.getRequestTimeout()));
        this.setPingInterval(ConnectionManager.parseTime(xmlCat, "heartbeat-interval", this.getPingInterval()));
        xmlCat = xml.getSafeElement("incoming-message-handler");
        this.setThreadCount(xmlCat.getSafeElement("thread-count").getInt(this.getThreadCount()));
        xmlCat = xml.getSafeElement("filters");
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator iter = xmlCat.getElements("filter");
        while (iter.hasNext()) {
            XmlElement xmlSub = (XmlElement)iter.next();
            Class clz = this.ensureClass(xmlSub, ConnectionManager.__sm0());
            Object o = ConnectionManager.instantiateClass(clz, xmlSub);
            if (!(o != null)) continue;
            list.add(o);
        }
        if (list.isEmpty() ^ true) {
            this.setWrapperStreamFactoryList((List)new ImmutableArrayList(list));
        }
        xmlCat = xml.getElement("message-codec");
        Class clz = this.ensureClass(xmlCat, ConnectionManager.__sm1());
        this.setCodec((Connection.Codec)ConnectionManager.instantiateClass(clz, xmlCat));
        xmlCat = xml.getElement("serializer");
        clz = this.ensureClass(xmlCat, ConnectionManager.__sm2());
        if (clz != null) {
            this.setSerializerClass(clz);
            this.setSerializerConfig(xmlCat);
        }
    }

    protected void doShutdown() {
        this.doStop();
    }

    protected void doStart() {
        int cThreads;
        DaemonPool pool;
        if (this.getConfig() == null) {
            throw new IllegalStateException("missing configuration");
        }
        if (this.getProtocolMap().isEmpty()) {
            throw new IllegalStateException("missing a registered protocol");
        }
        HashMap<String, Protocol.MessageFactory> map = new HashMap<String, Protocol.MessageFactory>();
        Iterator iter = this.getProtocols().values().iterator();
        while (iter.hasNext()) {
            Protocol protocol = (Protocol)iter.next();
            int nVersion = protocol.getCurrentVersion();
            String sName = protocol.getName();
            Protocol.MessageFactory factory = protocol.getMessageFactory(nVersion);
            if (sName == null) {
                throw new IllegalArgumentException(String.valueOf("protocol has no name: ") + protocol);
            }
            if (factory == null) {
                throw new IllegalArgumentException(String.valueOf("unsupported protocol version: ") + nVersion);
            }
            map.put(sName, factory);
        }
        this.setMessageFactoryMap(Collections.unmodifiableMap(map));
        if (this.getEventDispatcher() == null) {
            this.setEventDispatcher((QueueProcessor)this._newChild("EventDispatcher"));
        }
        if ((pool = this.getDaemonPool()) == null && (cThreads = this.getThreadCount()) > 0) {
            pool = (DaemonPool)this._newChild("DaemonPool");
            pool.setThreadGroup(new ThreadGroup(this.get_Name()));
            pool.setDaemonCount(cThreads);
            pool.start();
            this.setDaemonPool(pool);
        }
        QueueProcessor daemon = this.getDaemon();
        daemon.setWaitMillis(this.getPingInterval());
        daemon.start();
    }

    protected void doStop() {
        QueueProcessor dispatcher;
        this.getDaemon().stop();
        DaemonPool pool = this.getDaemonPool();
        if (pool instanceof ConnectionManager$DaemonPool) {
            pool.stop();
            this.setDaemonPool(null);
        }
        if ((dispatcher = this.getEventDispatcher()) instanceof ConnectionManager$EventDispatcher) {
            dispatcher.stop();
            this.setEventDispatcher(null);
        }
        this.setMessageFactoryMap(null);
    }

    public void drainEvents() {
        QueueProcessor daemon = this.getEventDispatcher();
        if (daemon instanceof ConnectionManager$EventDispatcher) {
            ((ConnectionManager$EventDispatcher)daemon).drainQueue();
        }
    }

    protected Class ensureClass(XmlElement xmlConfig, Class clzAssignable) {
        String sClass;
        XmlElement xmlClass = xmlConfig == null ? null : xmlConfig.getElement("class-name");
        if (xmlClass != null && (sClass = xmlClass.getString()).length() > 0) {
            Class clz;
            try {
                clz = ExternalizableHelper.loadClass((String)sClass, (ClassLoader)this.getContextClassLoader(), null);
            }
            catch (Throwable t) {
                Component._trace(t, String.valueOf("Cannot load class \"") + sClass + "\" specified in " + "configuration element \"" + xmlConfig.getName() + '\"');
                return null;
            }
            if (!(clzAssignable != null) ? false : clzAssignable.isAssignableFrom(clz) ^ true) {
                Component._trace(String.valueOf("The class \"") + sClass + "\" specified in configuration " + "element \"" + xmlConfig.getName() + "\" is not an " + "instance of \"" + clzAssignable.getName() + '\"', 1);
                return null;
            }
            return clz;
        }
        return null;
    }

    public QueueProcessor ensureEventDispatcher() {
        QueueProcessor dispatcher = this.getEventDispatcher();
        Component._assert(dispatcher != null);
        if (dispatcher.isStarted() ^ true) {
            dispatcher.start();
        }
        return dispatcher;
    }

    protected String ensureStringValue(XmlElement xmlConfig, String sName, String sDefault) {
        String sValue = xmlConfig.getSafeElement(sName).getString(sDefault);
        if (sValue == null ? true : sValue.length() == 0) {
            throw new IllegalArgumentException(String.valueOf("the required \"") + sName + "\" configuration element is missing or empty");
        }
        return sValue;
    }

    public void execute(Runnable task) {
        DaemonPool pool = this.getDaemonPool();
        if (!(!(pool != null) ? false : pool.isStarted()) ? false : pool.getDaemonCount() > 0) {
            pool.add(task);
        } else {
            task.run();
        }
    }

    public String formatStats() {
        long cTotal = Math.max(System.currentTimeMillis() - this.getStatsReset(), 0L);
        long cbRcvd = this.getStatsBytesReceived();
        long cbSent = this.getStatsBytesSent();
        long cMsgsRcvd = this.getStatsMessagesReceived();
        long cMsgsSent = this.getStatsMessagesSent();
        long cbpsThruIn = cTotal == 0L ? 0L : cbRcvd / cTotal * 1000L;
        long cbpsThruOut = cTotal == 0L ? 0L : cbSent / cTotal * 1000L;
        StringBuffer sb = new StringBuffer();
        sb.append("BytesReceived=").append(Base.toMemorySizeString((long)cbRcvd, (boolean)false)).append(", BytesSent=").append(Base.toMemorySizeString((long)cbSent, (boolean)false)).append(", MessagesReceived=").append(cMsgsRcvd).append(", MessagesSent=").append(cMsgsSent).append(", ThroughputInbound=").append(Base.toBandwidthString((long)cbpsThruIn, (boolean)false)).append(", ThroughputOutbound=").append(Base.toBandwidthString((long)cbpsThruOut, (boolean)false));
        DaemonPool pool = this.getDaemonPool();
        if (!(pool instanceof ConnectionManager$DaemonPool) ? false : pool.isStarted()) {
            long cPoolTotal = pool.getStatsActiveMillis();
            int cBacklog = pool.getStatsMaxBacklog();
            long cTasks = pool.getStatsTaskCount();
            float flAvgThread = cTotal == 0L ? 0.0f : (float)((double)cPoolTotal / (double)cTotal);
            float flAvgTask = cTasks == 0L ? 0.0f : (float)((double)cPoolTotal / (double)cTasks);
            sb.append(", AverageActiveThreadCount=").append(flAvgThread).append(", Tasks=").append(cTasks).append(", AverageTaskDuration=").append(flAvgTask).append("ms, MaximumBacklog=").append(cBacklog);
        }
        return sb.toString();
    }

    public Connection.Codec getCodec() {
        return this.__m_Codec;
    }

    protected XmlElement getConfig() {
        return this.__m_Config;
    }

    public ClassLoader getContextClassLoader() {
        return this.__m_ContextClassLoader;
    }

    public QueueProcessor getDaemon() {
        return (QueueProcessor)this._findChild("Daemon");
    }

    public DaemonPool getDaemonPool() {
        return this.__m_DaemonPool;
    }

    protected String getDescription() {
        Class clz;
        Connection.Codec codec;
        StringBuffer sb = new StringBuffer();
        sb.append("Running=").append(this.isRunning()).append(", ThreadCount=").append(this.getThreadCount());
        List list = this.getWrapperStreamFactoryList();
        if (!(list != null) ? false : list.isEmpty() ^ true) {
            sb.append(", Filters=[");
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                sb.append(iter.next().getClass().getName());
                if (!iter.hasNext()) continue;
                sb.append(',');
            }
            sb.append(']');
        }
        if ((codec = this.getCodec()) != null) {
            sb.append(", Codec=").append(codec);
        }
        if ((clz = this.getSerializerClass()) != null) {
            sb.append(", Serializer=").append(clz.getName());
        }
        sb.append(", PingInterval=").append(this.getPingInterval()).append(", PingTimeout=").append(this.getPingTimeout()).append(", RequestTimeout=").append(this.getRequestTimeout());
        return sb.toString();
    }

    public QueueProcessor getEventDispatcher() {
        return this.__m_EventDispatcher;
    }

    protected static String getLicenseError() {
        return __s_LicenseError;
    }

    protected Listeners getListeners() {
        return this.__m_Listeners;
    }

    protected Map getMessageFactoryMap() {
        return this.__m_MessageFactoryMap;
    }

    public long getPingInterval() {
        return this.__m_PingInterval;
    }

    public long getPingLastMillis() {
        return this.__m_PingLastMillis;
    }

    public long getPingNextMillis() {
        long ldtLast = this.getPingLastMillis();
        long cMillis = this.getPingInterval();
        return cMillis == 0L ? Long.MAX_VALUE : (ldtLast == 0L ? Base.getSafeTimeMillis() : ldtLast + cMillis);
    }

    public Collection getPingStatus() {
        return this.__m_PingStatus;
    }

    public long getPingTimeout() {
        return this.__m_PingTimeout;
    }

    public long getPingTimeoutMillis() {
        long ldtLast = this.getPingLastMillis();
        long cMillis = this.getPingTimeout();
        return (ldtLast == 0L ? true : cMillis == 0L) ? Long.MAX_VALUE : ldtLast + cMillis;
    }

    public static UUID getProcessId() {
        return __s_ProcessId;
    }

    public Protocol getProtocol(String sName) {
        return (Protocol)this.getProtocolMap().get(sName);
    }

    protected Map getProtocolMap() {
        return this.__m_ProtocolMap;
    }

    public Map getProtocols() {
        Map map;
        Map map2 = map = this.getProtocolMap();
        synchronized (map2) {
            HashMap hashMap = new HashMap(map);
            Object var4_4 = null;
            return hashMap;
        }
    }

    public Channel.Receiver getReceiver(String sName) {
        return (Channel.Receiver)this.getReceiverMap().get(sName);
    }

    protected Map getReceiverMap() {
        return this.__m_ReceiverMap;
    }

    public Map getReceivers() {
        Map map;
        Map map2 = map = this.getReceiverMap();
        synchronized (map2) {
            HashMap hashMap = new HashMap(map);
            Object var4_4 = null;
            return hashMap;
        }
    }

    protected long getRequestTimeout() {
        return this.__m_RequestTimeout;
    }

    protected Class getSerializerClass() {
        return this.__m_SerializerClass;
    }

    protected XmlElement getSerializerConfig() {
        return this.__m_SerializerConfig;
    }

    public long getStatsBytesReceived() {
        return this.__m_StatsBytesReceived;
    }

    public long getStatsBytesSent() {
        return this.__m_StatsBytesSent;
    }

    public long getStatsMessagesReceived() {
        return this.__m_StatsMessagesReceived;
    }

    public long getStatsMessagesSent() {
        return this.__m_StatsMessagesSent;
    }

    public long getStatsReset() {
        return this.__m_StatsReset;
    }

    protected int getThreadCount() {
        return this.__m_ThreadCount;
    }

    public List getWrapperStreamFactoryList() {
        return this.__m_WrapperStreamFactoryList;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/comm/ConnectionManager".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new ConnectionManager();
    }

    private final Component get_Module() {
        return this;
    }

    protected static Object instantiateClass(Class clz, XmlElement xmlConfig) {
        block8: {
            Object[] aoParam;
            if (!(clz != null)) break block8;
            try {
                aoParam = XmlHelper.parseInitParams((XmlElement)xmlConfig.getElement("init-params"));
            }
            catch (RuntimeException e) {
                aoParam = ClassHelper.VOID;
            }
            try {
                if (!(aoParam == ClassHelper.VOID) ? false : ConnectionManager.__sm3().isAssignableFrom(clz)) {
                    XmlConfigurable target = (XmlConfigurable)clz.newInstance();
                    XmlElement xmlParent = xmlConfig.getSafeElement("config");
                    XmlElement xmlParams = xmlConfig.getSafeElement("init-params");
                    if (xmlParent.isMutable() ^ true) {
                        xmlParent = (XmlElement)xmlParent.clone();
                    }
                    XmlHelper.transformInitParams((XmlElement)xmlParent, (XmlElement)xmlParams);
                    try {
                        target.setConfig(xmlParent);
                        return target;
                    }
                    catch (Throwable t) {
                        Component._trace(t, String.valueOf("Error configuring class \"") + clz.getName() + "\" specified in configuration element \"" + xmlConfig.getName() + '\"');
                        break block8;
                    }
                }
                return ClassHelper.newInstance((Class)clz, (Object[])aoParam);
            }
            catch (Throwable t) {
                Component._trace(t, String.valueOf("Cannot instantiate class \"") + clz.getName() + "\" specified in configuration element \"" + xmlConfig.getName() + '\"');
            }
        }
        return null;
    }

    public Serializer instantiateSerializer(ClassLoader loader) {
        Class clz = this.getSerializerClass();
        Serializer serializer = clz == null ? null : (Serializer)ConnectionManager.instantiateClass(clz, this.getSerializerConfig());
        if (serializer instanceof ClassLoaderAware) {
            if (loader == null) {
                loader = this.getContextClassLoader();
            }
            try {
                ((ClassLoaderAware)serializer).setContextClassLoader(loader);
            }
            catch (Throwable t) {
                Component._trace(t, String.valueOf("Error configuring class \"") + clz.getName() + '\"');
            }
        }
        if (serializer == null) {
            serializer = ExternalizableHelper.ensureSerializer((ClassLoader)loader);
        }
        return serializer;
    }

    public boolean isRunning() {
        return this.__m_Running;
    }

    public boolean isServiceThread(boolean fStrict) {
        Thread thread = Thread.currentThread();
        QueueProcessor dispatcher = this.getEventDispatcher();
        if (thread == this.getDaemon().getThread() ? true : (!(dispatcher != null) ? false : thread == dispatcher.getThread())) {
            return true;
        }
        if (fStrict ^ true) {
            DaemonPool pool = this.getDaemonPool();
            return !(pool != null) ? false : pool.getThreadGroup() == thread.getThreadGroup();
        }
        return false;
    }

    public void onConnectionClosed(com.tangosol.net.messaging.Connection connection) {
        this.dispatchConnectionEvent(new ConnectionEvent(connection, ConnectionEvent.CONNECTION_CLOSED));
        if (Component._isTraceEnabled(6)) {
            Component._trace(String.valueOf("Closed: ") + connection, 6);
        }
    }

    public void onConnectionError(com.tangosol.net.messaging.Connection connection, Throwable cause) {
        this.dispatchConnectionEvent(new ConnectionEvent(connection, ConnectionEvent.CONNECTION_ERROR, cause));
        if (Component._isTraceEnabled(6)) {
            Component._trace(String.valueOf("Closed: ") + connection + ": " + Component.getStackTrace(cause), 6);
        }
    }

    public void onConnectionOpened(com.tangosol.net.messaging.Connection connection) {
        if (Component._isTraceEnabled(6)) {
            Component._trace(String.valueOf("Opened: ") + connection, 6);
        }
    }

    public void onInit() {
        if (ConnectionManager.getLicenseError() != null) {
            throw new LicenseException(String.valueOf("cannot instantiate ") + this.get_Name() + ": " + ConnectionManager.getLicenseError());
        }
        this.setListeners(new Listeners());
        this.setProtocolMap(new HashMap());
        this.setReceiverMap(new HashMap());
        this.registerProtocol(MessagingProtocol.getInstance());
        super.onInit();
    }

    public void onReceive(Connection connection, ReadBuffer rb) {
        ConnectionManager$MessageDispatchTask task = new ConnectionManager$MessageDispatchTask();
        task.setConnection(connection);
        task.setReadBuffer(rb);
        this.getDaemon().getQueue().add(task);
        this.setStatsBytesReceived(this.getStatsBytesReceived() + (long)rb.length());
        this.setStatsMessagesReceived(this.getStatsMessagesReceived() + (long)1);
    }

    public void onSend(Connection connection, WriteBuffer wb) {
        this.setStatsBytesSent(this.getStatsBytesSent() + (long)wb.length());
        this.setStatsMessagesSent(this.getStatsMessagesSent() + (long)1);
    }

    protected static long parseMemorySize(XmlElement xml, String sName, long cbDefault) {
        if (xml == null) {
            return cbDefault;
        }
        String sBytes = xml.getSafeElement(sName).getString();
        if (sBytes.length() == 0) {
            return cbDefault;
        }
        try {
            return Base.parseMemorySize((String)sBytes);
        }
        catch (RuntimeException e) {
            throw Comm.ensureRuntimeException(e, String.valueOf("illegal \"") + sName + "\" value: " + sBytes);
        }
    }

    protected static long parseTime(XmlElement xml, String sName, long ldtDefault) {
        if (xml == null) {
            return ldtDefault;
        }
        String sTime = xml.getSafeElement(sName).getString();
        if (sTime.length() == 0) {
            return ldtDefault;
        }
        try {
            return Base.parseTime((String)sTime);
        }
        catch (RuntimeException e) {
            throw Comm.ensureRuntimeException(e, String.valueOf("illegal \"") + sName + "\" value: " + sTime);
        }
    }

    public void ping() {
        this.setPingLastMillis(System.currentTimeMillis());
    }

    protected boolean ping(com.tangosol.net.messaging.Connection connection) {
        try {
            Channel channel0;
            if ((!(connection != null) ? false : connection.isOpen()) && (!((channel0 = connection.getChannel(0)) != null) ? false : channel0.isOpen())) {
                Protocol.MessageFactory factory = channel0.getMessageFactory();
                Message message = factory.createMessage(MessagingFactory$PingRequest.TYPE_ID);
                if (this.getPingTimeout() == 0L) {
                    channel0.send(message);
                } else {
                    ArrayList<Request.Status> col = this.getPingStatus();
                    if (col == null) {
                        col = new ArrayList<Request.Status>();
                        this.setPingStatus(col);
                    }
                    col.add(channel0.send((Request)((MessagingFactory$PingRequest)message)));
                }
                return true;
            }
        }
        catch (RuntimeException runtimeException) {}
        return false;
    }

    public synchronized void registerProtocol(Protocol protocol) {
        if (this.isRunning()) {
            throw new IllegalStateException("cannot register a protocol while running");
        }
        if (protocol == null) {
            throw new IllegalArgumentException("protocol cannot be null");
        }
        String sName = protocol.getName();
        if (sName == null) {
            throw new IllegalArgumentException(String.valueOf("missing protocol name: ") + protocol);
        }
        this.getProtocolMap().put(sName, protocol);
    }

    public synchronized void registerReceiver(Channel.Receiver receiver) {
        if (this.isRunning()) {
            throw new IllegalStateException("cannot register a receiver while running");
        }
        if (receiver == null) {
            throw new IllegalArgumentException("receiver cannot be null");
        }
        String sName = receiver.getName();
        if (sName == null) {
            throw new IllegalArgumentException(String.valueOf("missing receiver name: ") + receiver);
        }
        this.getReceiverMap().put(sName, receiver);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.getListeners().remove((EventListener)listener);
    }

    public void resetStats() {
        DaemonPool pool = this.getDaemonPool();
        if (pool instanceof ConnectionManager$DaemonPool) {
            pool.resetStats();
        }
        this.setStatsBytesReceived(0L);
        this.setStatsBytesSent(0L);
        this.setStatsMessagesReceived(0L);
        this.setStatsMessagesSent(0L);
        this.setStatsReset(System.currentTimeMillis());
    }

    public synchronized void setCodec(Connection.Codec codec) {
        if (this.isRunning()) {
            throw new IllegalStateException("cannot configure a codec while running");
        }
        this.__m_Codec = codec;
    }

    protected void setConfig(XmlElement xml) {
        this.__m_Config = xml;
    }

    public void setContextClassLoader(ClassLoader loader) {
        this.__m_ContextClassLoader = loader;
    }

    public void setDaemonPool(DaemonPool pool) {
        Component._assert(this.isRunning() ^ true ? true : pool == null);
        if (pool != null) {
            this.setThreadCount(pool.getDaemonCount());
        }
        this.__m_DaemonPool = pool;
    }

    public void setEventDispatcher(QueueProcessor daemon) {
        this.__m_EventDispatcher = daemon;
    }

    protected static void setLicenseError(String sMsg) {
        __s_LicenseError = sMsg;
    }

    protected void setListeners(Listeners listeners) {
        this.__m_Listeners = listeners;
    }

    protected void setMessageFactoryMap(Map map) {
        this.__m_MessageFactoryMap = map;
    }

    protected void setPingInterval(long cMillis) {
        this.__m_PingInterval = cMillis;
    }

    protected void setPingLastMillis(long ldt) {
        this.__m_PingLastMillis = ldt;
    }

    protected void setPingStatus(Collection col) {
        this.__m_PingStatus = col;
    }

    protected void setPingTimeout(long cMillis) {
        this.__m_PingTimeout = cMillis;
    }

    public static void setProcessId(UUID uuid) {
        Component._assert(uuid != null);
        __s_ProcessId = uuid;
    }

    protected void setProtocolMap(Map map) {
        this.__m_ProtocolMap = map;
    }

    protected void setReceiverMap(Map map) {
        this.__m_ReceiverMap = map;
    }

    protected void setRequestTimeout(long cMillis) {
        this.__m_RequestTimeout = cMillis;
    }

    protected void setRunning(boolean fRunning) {
        this.__m_Running = fRunning;
    }

    protected void setSerializerClass(Class clz) {
        this.__m_SerializerClass = clz;
    }

    protected void setSerializerConfig(XmlElement xml) {
        this.__m_SerializerConfig = xml;
    }

    protected void setStatsBytesReceived(long cb) {
        this.__m_StatsBytesReceived = cb;
    }

    protected void setStatsBytesSent(long cb) {
        this.__m_StatsBytesSent = cb;
    }

    protected void setStatsMessagesReceived(long cMsgs) {
        this.__m_StatsMessagesReceived = cMsgs;
    }

    protected void setStatsMessagesSent(long cMsgs) {
        this.__m_StatsMessagesSent = cMsgs;
    }

    protected void setStatsReset(long ldt) {
        this.__m_StatsReset = ldt;
    }

    protected void setThreadCount(int cThreads) {
        this.__m_ThreadCount = cThreads;
    }

    protected void setWrapperStreamFactoryList(List list) {
        this.__m_WrapperStreamFactoryList = list;
    }

    public synchronized void shutdown() {
        if (this.isRunning()) {
            try {
                this.doShutdown();
            }
            catch (Throwable t) {
                Component._trace(t, String.valueOf("An error occured while shutting down a ") + this.get_Name() + "; the " + this.get_Name() + " will be marked as stopped");
            }
            this.setRunning(false);
            Component._trace(String.valueOf("Shutdown: ") + this.get_Name(), 5);
        }
    }

    public synchronized void start() {
        if (this.isRunning() ^ true) {
            this.doStart();
            this.setRunning(true);
            Component._trace(String.valueOf("Started: ") + this, 5);
        }
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            try {
                this.doStop();
            }
            catch (Throwable t) {
                Component._trace(t, String.valueOf("An error occured while stopping a ") + this.get_Name() + "; the " + this.get_Name() + " will be marked as stopped");
            }
            this.setRunning(false);
            Component._trace(String.valueOf("Stopped: ") + this.get_Name(), 5);
        }
    }
}

