/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.comm;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Comm;
import com.tangosol.coherence.component.comm.Message;
import com.tangosol.coherence.component.comm.message.Request;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.util.AtomicCounter;
import com.tangosol.util.WrapperException;
import java.util.Iterator;
import java.util.Map;

public class MessageFactory
extends Comm
implements Protocol.MessageFactory {
    private transient Class[] __m_MessageClass;
    private Protocol __m_Protocol;
    private int __m_Version;
    private static transient AtomicCounter __s_RequestCounter;

    static {
        MessageFactory._initStatic();
    }

    public MessageFactory() {
        this(null, null, true);
    }

    public MessageFactory(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setVersion(1);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void _initStatic$Default() {
    }

    protected static void _initStatic() {
        MessageFactory._initStatic$Default();
        MessageFactory.setRequestCounter(AtomicCounter.newAtomicCounter());
    }

    /*
     * WARNING - void declaration
     */
    public com.tangosol.net.messaging.Message createMessage(int nType) {
        Class clz = this.getMessageClass(nType);
        if (clz == null) {
            throw new IllegalArgumentException(String.valueOf("Unable to instantiate a Message of type: ") + nType);
        }
        try {
            void e;
            Message message = (Message)clz.newInstance();
            message.setImplVersion(this.getVersion());
            if (message instanceof Request) {
                ((Request)message).setId(MessageFactory.getRequestCounter().increment(1L));
            }
            return e;
        }
        catch (Exception e) {
            throw Comm.ensureRuntimeException(e, String.valueOf("error instantiating a message of type: ") + clz.getName());
        }
    }

    protected String getDescription() {
        return String.valueOf("Protocol=") + this.getProtocol() + ", Version=" + this.getVersion();
    }

    protected Class[] getMessageClass() {
        return this.__m_MessageClass;
    }

    protected Class getMessageClass(int i) {
        Class[] aClz = this.getMessageClass();
        return (!(aClz != null) ? false : i < aClz.length) ? aClz[i] : null;
    }

    public Protocol getProtocol() {
        return this.__m_Protocol;
    }

    protected static AtomicCounter getRequestCounter() {
        return __s_RequestCounter;
    }

    public int getVersion() {
        return this.__m_Version;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/comm/MessageFactory".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new MessageFactory();
    }

    private final Component get_Module() {
        return this;
    }

    public void onInit() {
        Class clzMessage = Message.get_CLASS();
        Map mapClz = this.get_ChildClasses();
        if (mapClz != null) {
            Iterator iter = mapClz.values().iterator();
            while (iter.hasNext()) {
                Class clz = (Class)iter.next();
                if (!clzMessage.isAssignableFrom(clz)) continue;
                try {
                    Message message = (Message)clz.newInstance();
                    int nType = message.getTypeId();
                    if (this.getMessageClass(nType) != null) {
                        throw new IllegalStateException(String.valueOf("duplicate message type ") + nType + ": " + clz + ", " + this.getMessageClass(nType));
                    }
                    this.setMessageClass(nType, clz);
                }
                catch (Exception e) {
                    Component._trace(e, String.valueOf("Unable to instantiate a message of type \"") + clz + '\"');
                }
            }
        }
        super.onInit();
    }

    protected void setMessageClass(int i, Class clz) {
        Component._assert(clz != null);
        Class[] aClz = this.getMessageClass();
        if (aClz == null ? true : i >= aClz.length) {
            Class[] aClzNew = new Class[Math.max(i + (i >>> 1), i + 4)];
            if (aClz != null) {
                System.arraycopy(aClz, 0, aClzNew, 0, aClz.length);
            }
            aClz = aClzNew;
            this.setMessageClass(aClzNew);
        }
        aClz[i] = clz;
    }

    protected void setMessageClass(Class[] aClz) {
        this.__m_MessageClass = aClz;
    }

    public void setProtocol(Protocol protocol) {
        this.__m_Protocol = protocol;
    }

    protected static void setRequestCounter(AtomicCounter pRequestCounter) {
        __s_RequestCounter = pRequestCounter;
    }

    protected void setVersion(int nVersion) {
        this.__m_Version = nVersion;
    }
}

