/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.comm.connection;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Comm;
import com.tangosol.coherence.component.comm.Connection;
import com.tangosol.coherence.component.comm.Connection$Codec;
import com.tangosol.coherence.component.comm.ConnectionManager;
import com.tangosol.coherence.component.comm.util.JmsUtil;
import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.util.ListMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;

public class JmsConnection
extends Connection
implements MessageListener {
    private int __m_MessageDeliveryMode;
    private long __m_MessageExpiration;
    private int __m_MessagePriority;
    private Queue __m_QueueIn;
    private Queue __m_QueueOut;
    private QueueReceiver __m_QueueReceiver;
    private QueueSender __m_QueueSender;
    private QueueSession __m_QueueSession;
    private static ListMap __mapChildren;

    static {
        JmsConnection.__initStatic();
    }

    public JmsConnection() {
        this(null, null, true);
    }

    public JmsConnection(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"Codec", (Object)Connection$Codec.get_CLASS());
    }

    protected void doClose(boolean fNotify) {
        super.doClose(fNotify);
        JmsUtil.close((MessageConsumer)this.getQueueReceiver());
        JmsUtil.close((MessageProducer)this.getQueueSender());
        JmsUtil.close((Session)this.getQueueSession());
        JmsUtil.delete((Destination)this.getQueueIn());
        this.setQueueIn(null);
        this.setQueueOut(null);
        this.setQueueReceiver(null);
        this.setQueueSender(null);
        this.setQueueSession(null);
    }

    protected void doOpen() {
        super.doOpen();
        QueueSession session = this.getQueueSession();
        Component._assert(session != null);
        Queue queueIn = this.getQueueIn();
        Component._assert(queueIn != null);
        Queue queueOut = this.getQueueOut();
        Component._assert(queueOut != null);
        try {
            QueueReceiver receiver = session.createReceiver(queueIn);
            QueueSender sender = session.createSender(queueOut);
            this.setQueueReceiver(receiver);
            this.setQueueSender(sender);
            receiver.setMessageListener((MessageListener)this);
            sender.setDisableMessageID(true);
            sender.setDisableMessageTimestamp(true);
        }
        catch (JMSException e) {
            this.doClose(false);
            throw Comm.ensureRuntimeException(e, "error opening connection");
        }
    }

    protected void doSend(WriteBuffer wb) {
        QueueSession session;
        byte[] ab = wb instanceof ByteArrayWriteBuffer ? ((ByteArrayWriteBuffer)wb).getRawByteArray() : wb.toByteArray();
        QueueSession queueSession = session = this.getQueueSession();
        synchronized (queueSession) {
            BytesMessage message;
            try {
                message = this.getQueueSession().createBytesMessage();
                message.setJMSDeliveryMode(this.getMessageDeliveryMode());
                message.setJMSExpiration(this.getMessageExpiration());
                message.setJMSPriority(this.getMessagePriority());
                message.setJMSReplyTo((Destination)this.getQueueReceiver().getQueue());
                int cb = wb.length();
                JmsUtil.writePackedInt(message, cb);
                message.writeBytes(ab, 0, cb);
            }
            catch (JMSException e) {
                throw new ConnectionException("error creating a JMS Message", (Throwable)e);
            }
            try {
                this.getQueueSender().send((Message)message);
            }
            catch (JMSException e) {
                throw new ConnectionException("error sending a JMS Message", (Throwable)e);
            }
        }
        super.doSend(wb);
    }

    protected String getDescription() {
        return String.valueOf(super.getDescription()) + ", In=" + this.getQueueIn() + ", Out=" + this.getQueueOut();
    }

    public int getMessageDeliveryMode() {
        return this.__m_MessageDeliveryMode;
    }

    public long getMessageExpiration() {
        return this.__m_MessageExpiration;
    }

    public int getMessagePriority() {
        return this.__m_MessagePriority;
    }

    public Queue getQueueIn() {
        return this.__m_QueueIn;
    }

    public Queue getQueueOut() {
        return this.__m_QueueOut;
    }

    protected QueueReceiver getQueueReceiver() {
        return this.__m_QueueReceiver;
    }

    protected QueueSender getQueueSender() {
        return this.__m_QueueSender;
    }

    public QueueSession getQueueSession() {
        return this.__m_QueueSession;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/comm/connection/JmsConnection".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new JmsConnection();
    }

    private final Component get_Module() {
        return this;
    }

    public void onMessage(Message message) {
        ConnectionManager manager = (ConnectionManager)this.getConnectionManager();
        Component._assert(manager != null);
        if (message instanceof BytesMessage) {
            BytesMessage bMessage = (BytesMessage)message;
            try {
                int cb = JmsUtil.readPackedInt(bMessage);
                if (cb < 0) {
                    throw new JMSException("Received a message with a negative length");
                }
                if (cb == 0) {
                    throw new JMSException("Received a message with a length of zero");
                }
                byte[] ab = new byte[cb];
                int cbRead = bMessage.readBytes(ab);
                if (!(cbRead == cb)) {
                    throw new JMSException(String.valueOf("Error reading a message; expected ") + cb + " bytes, read " + cbRead + " bytes instead");
                }
                manager.onReceive(this, (ReadBuffer)new ByteArrayReadBuffer(ab));
            }
            catch (JMSException e) {
                this.close(e);
            }
        } else {
            this.close(new JMSException(String.valueOf("Received an unexpected message: ") + message));
        }
    }

    public void setMessageDeliveryMode(int nMode) {
        this.__m_MessageDeliveryMode = nMode;
    }

    public void setMessageExpiration(long cMillis) {
        this.__m_MessageExpiration = cMillis;
    }

    public void setMessagePriority(int nPriority) {
        this.__m_MessagePriority = nPriority;
    }

    public void setQueueIn(Queue queue) {
        Component._assert(this.isOpen() ^ true ? true : queue == null);
        this.__m_QueueIn = queue;
    }

    public void setQueueOut(Queue queue) {
        Component._assert(this.isOpen() ^ true ? true : queue == null);
        this.__m_QueueOut = queue;
    }

    protected void setQueueReceiver(QueueReceiver receiver) {
        Component._assert(this.isOpen() ^ true ? true : receiver == null);
        this.__m_QueueReceiver = receiver;
    }

    protected void setQueueSender(QueueSender sender) {
        Component._assert(this.isOpen() ^ true ? true : sender == null);
        this.__m_QueueSender = sender;
    }

    public void setQueueSession(QueueSession session) {
        Component._assert(this.isOpen() ^ true ? true : session == null);
        this.__m_QueueSession = session;
    }
}

