/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.comm.connectionManager;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.comm.Connection;
import com.tangosol.coherence.component.comm.ConnectionManager;
import com.tangosol.coherence.component.comm.ConnectionManager$ConnectionCloseTask;
import com.tangosol.coherence.component.comm.ConnectionManager$ConnectionEventTask;
import com.tangosol.coherence.component.comm.ConnectionManager$DaemonPool;
import com.tangosol.coherence.component.comm.ConnectionManager$EventDispatcher;
import com.tangosol.coherence.component.comm.ConnectionManager$MessageDispatchTask;
import com.tangosol.coherence.component.comm.ConnectionManager$MessageExecuteTask;
import com.tangosol.coherence.component.comm.messageFactory.MessagingFactory$ConnectRequest;
import com.tangosol.net.messaging.Channel;
import com.tangosol.net.messaging.ConnectionEvent;
import com.tangosol.net.messaging.ConnectionInitiator;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.net.messaging.Request;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.UUID;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class Initiator
extends ConnectionManager
implements ConnectionInitiator {
    private long __m_ConnectTimeout;
    private Connection __m_Connection;
    private static ListMap __mapChildren;

    static {
        Initiator.__initStatic();
    }

    public Initiator(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"ConnectionCloseTask", (Object)ConnectionManager$ConnectionCloseTask.get_CLASS());
        Object object2 = __mapChildren.put((Object)"ConnectionEventTask", (Object)ConnectionManager$ConnectionEventTask.get_CLASS());
        Object object3 = __mapChildren.put((Object)"DaemonPool", (Object)ConnectionManager$DaemonPool.get_CLASS());
        Object object4 = __mapChildren.put((Object)"EventDispatcher", (Object)ConnectionManager$EventDispatcher.get_CLASS());
        Object object5 = __mapChildren.put((Object)"MessageDispatchTask", (Object)ConnectionManager$MessageDispatchTask.get_CLASS());
        Object object6 = __mapChildren.put((Object)"MessageExecuteTask", (Object)ConnectionManager$MessageExecuteTask.get_CLASS());
    }

    protected void connect(Connection connection) {
        Protocol.MessageFactory factory;
        Component._assert(connection != null);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Iterator iter = this.getMessageFactoryMap().values().iterator();
        while (iter.hasNext()) {
            factory = (Protocol.MessageFactory)iter.next();
            String sProtocol = factory.getProtocol().getName();
            int nVersion = factory.getVersion();
            map.put(sProtocol, Base.makeInteger((int)nVersion));
        }
        Channel channel0 = connection.getChannel(0);
        Component._assert(channel0 != null);
        factory = channel0.getMessageFactory();
        MessagingFactory$ConnectRequest request = (MessagingFactory$ConnectRequest)factory.createMessage(MessagingFactory$ConnectRequest.TYPE_ID);
        request.setClientId(ConnectionManager.getProcessId());
        request.setEdition(((Coherence)Coherence.get_Instance()).getEdition());
        request.setProtocolMap(map);
        Object[] ao = (Object[])channel0.request((Request)request, this.getConnectTimeout());
        Component._assert(!(ao != null) ? false : ao.length == 2);
        connection.setId((UUID)ao[0]);
        connection.setPeerId((UUID)ao[1]);
    }

    protected void doStop() {
        Connection connection = this.getConnection();
        if (connection != null) {
            connection.close();
        }
        super.doStop();
    }

    public synchronized com.tangosol.net.messaging.Connection ensureConnection() {
        if (this.isRunning() ^ true) {
            throw new IllegalStateException(String.valueOf(this.get_Name()) + " is not running");
        }
        Connection connection = this.getConnection();
        if (connection == null ? true : connection.isOpen() ^ true) {
            connection = this.instantiateConnection();
            connection.setCodec(this.getCodec());
            connection.setConnectionManager(this);
            connection.setMessageFactoryMap(this.getMessageFactoryMap());
            connection.setRequestTimeout(this.getRequestTimeout());
            connection.open();
            this.connect(connection);
            this.onConnectionInitiated(connection);
        }
        return connection;
    }

    protected long getConnectTimeout() {
        return this.__m_ConnectTimeout;
    }

    public Connection getConnection() {
        return this.__m_Connection;
    }

    protected String getDescription() {
        return String.valueOf(super.getDescription()) + ", ConnectTimeout=" + this.getConnectTimeout();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/comm/connectionManager/Initiator".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    private final Component get_Module() {
        return this;
    }

    protected Connection instantiateConnection() {
        return null;
    }

    public void onConnectionClosed(com.tangosol.net.messaging.Connection connection) {
        Initiator initiator = this;
        synchronized (initiator) {
            if (connection == this.getConnection()) {
                this.setConnection(null);
            } else {
                connection = null;
            }
        }
        if (connection != null) {
            super.onConnectionClosed(connection);
        }
    }

    public void onConnectionError(com.tangosol.net.messaging.Connection connection, Throwable cause) {
        Initiator initiator = this;
        synchronized (initiator) {
            if (connection == this.getConnection()) {
                this.setConnection(null);
            } else {
                connection = null;
            }
        }
        if (connection != null) {
            super.onConnectionError(connection, cause);
        }
    }

    protected void onConnectionInitiated(com.tangosol.net.messaging.Connection connection) {
        Component._assert(this.getConnection() == null);
        Component._assert(connection.getConnectionManager() == this);
        this.setConnection((Connection)connection);
        this.dispatchConnectionEvent(new ConnectionEvent(connection, ConnectionEvent.CONNECTION_INITIATED));
        if (Component._isTraceEnabled(6)) {
            Component._trace(String.valueOf("Connected: ") + connection, 6);
        }
    }

    public void ping() {
        if (this.ping(this.getConnection())) {
            super.ping();
        }
    }

    protected void setConnectTimeout(long cMillis) {
        this.__m_ConnectTimeout = cMillis;
    }

    protected void setConnection(Connection connection) {
        this.__m_Connection = connection;
    }

    public void setPingLastMillis(long ldt) {
        super.setPingLastMillis(ldt);
    }
}

