/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.comm.connectionManager.acceptor;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.comm.ConnectionManager;
import com.tangosol.coherence.component.comm.connection.TcpConnection;
import com.tangosol.coherence.component.comm.connectionManager.acceptor.TcpAcceptor;
import com.tangosol.coherence.component.comm.connectionManager.acceptor.TcpAcceptor$ByteBufferPool;
import com.tangosol.coherence.component.comm.connectionManager.acceptor.TcpAcceptor$ByteBufferReadBuffer;
import com.tangosol.coherence.component.comm.connectionManager.acceptor.TcpAcceptor$TcpConnection$Codec;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.queue.concurrentQueue.DualQueue;
import com.tangosol.io.MultiBufferWriteBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.ThreadGate;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Map;

public class TcpAcceptor$TcpConnection
extends TcpConnection {
    public static final int IN_DECODED = 1;
    public static final int IN_INITIAL = 0;
    public static final int IN_PREPARED = 2;
    public static final int OUT_ENCODED = 2;
    public static final int OUT_INITIAL = 0;
    public static final int OUT_PREPARED = 1;
    private TcpAcceptor __m_Acceptor;
    private ByteBuffer __m_IncomingByteBuffer;
    private ByteBuffer[] __m_IncomingByteBufferArray;
    private int __m_IncomingByteBufferIndex;
    private int __m_IncomingBytesRead;
    private int __m_IncomingBytesTotal;
    private int __m_IncomingState;
    private ByteBuffer __m_OutgoingByteBuffer;
    private ByteBuffer[] __m_OutgoingByteBufferArray;
    private int __m_OutgoingByteBufferIndex;
    private int __m_OutgoingBytesTotal;
    private int __m_OutgoingBytesWritten;
    private MultiBufferWriteBuffer __m_OutgoingMessage;
    private Queue __m_OutgoingQueue;
    private int __m_OutgoingState;
    private SelectionKey __m_SelectionKey;
    private SocketChannel __m_SocketChannel;
    private static ListMap __mapChildren;

    static {
        TcpAcceptor$TcpConnection.__initStatic();
    }

    public TcpAcceptor$TcpConnection() {
        this(null, null, true);
    }

    public TcpAcceptor$TcpConnection(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"Codec", (Object)TcpAcceptor$TcpConnection$Codec.get_CLASS());
    }

    protected WriteBuffer allocateWriteBuffer() {
        return new MultiBufferWriteBuffer((MultiBufferWriteBuffer.WriteBufferPool)this.getAcceptor().getByteBufferPoolOut());
    }

    protected ConnectionManager closeInternal(boolean fNotify) {
        ConnectionManager connectionManager;
        ThreadGate gate = this.getThreadGate();
        gate.barEntry(-1L);
        try {
            this.notifyWaitingThreads();
            connectionManager = super.closeInternal(fNotify);
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            gate.open();
            throw throwable;
        }
        gate.open();
        return connectionManager;
    }

    protected void doSend(WriteBuffer wb) {
        TcpAcceptor acceptor = this.getAcceptor();
        Queue queue = this.getOutgoingQueue();
        TcpAcceptor$ByteBufferPool pool = acceptor.getByteBufferPoolOut();
        WriteBuffer writeBuffer = wb;
        synchronized (writeBuffer) {
            boolean fFlush;
            Queue queue2 = queue;
            synchronized (queue2) {
                queue.add(wb);
                fFlush = queue.size() == 1;
            }
            if (fFlush) {
                acceptor.getConnectionFlushQueue().add(this);
                acceptor.getSelector().wakeup();
            }
            if (pool.getOverflow() > 0) {
                long ldt = Base.getSafeTimeMillis();
                if (acceptor.getLastThrottleWarningTimestamp() < ldt - 30000L) {
                    acceptor.setLastThrottleWarningTimestamp(ldt);
                    Component._trace(String.valueOf("Outgoing ByteBufferPool exhausted; throttling ") + Thread.currentThread() + " by sending synchronously", 2);
                }
                try {
                    wb.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        super.doSend(wb);
    }

    protected TcpAcceptor getAcceptor() {
        return this.__m_Acceptor;
    }

    public ByteBuffer getIncomingByteBuffer() {
        return this.__m_IncomingByteBuffer;
    }

    public ByteBuffer[] getIncomingByteBufferArray() {
        return this.__m_IncomingByteBufferArray;
    }

    public int getIncomingByteBufferIndex() {
        return this.__m_IncomingByteBufferIndex;
    }

    public int getIncomingBytesRead() {
        return this.__m_IncomingBytesRead;
    }

    public int getIncomingBytesTotal() {
        return this.__m_IncomingBytesTotal;
    }

    public int getIncomingState() {
        return this.__m_IncomingState;
    }

    public ByteBuffer getOutgoingByteBuffer() {
        return this.__m_OutgoingByteBuffer;
    }

    public ByteBuffer[] getOutgoingByteBufferArray() {
        return this.__m_OutgoingByteBufferArray;
    }

    public int getOutgoingByteBufferIndex() {
        return this.__m_OutgoingByteBufferIndex;
    }

    public int getOutgoingBytesTotal() {
        return this.__m_OutgoingBytesTotal;
    }

    public int getOutgoingBytesWritten() {
        return this.__m_OutgoingBytesWritten;
    }

    public MultiBufferWriteBuffer getOutgoingMessage() {
        return this.__m_OutgoingMessage;
    }

    public Queue getOutgoingQueue() {
        return this.__m_OutgoingQueue;
    }

    public int getOutgoingState() {
        return this.__m_OutgoingState;
    }

    public SelectionKey getSelectionKey() {
        return this.__m_SelectionKey;
    }

    public SocketChannel getSocketChannel() {
        return this.__m_SocketChannel;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/comm/connectionManager/acceptor/TcpAcceptor$TcpConnection".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new TcpAcceptor$TcpConnection();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    protected void notifyWaitingThreads() {
        Object o = this.getOutgoingMessage();
        if (o != null) {
            MultiBufferWriteBuffer multiBufferWriteBuffer = o;
            synchronized (multiBufferWriteBuffer) {
                o.notify();
            }
        }
        Iterator iter = this.getOutgoingQueue().iterator();
        while (iter.hasNext()) {
            Object object = o = iter.next();
            synchronized (object) {
                o.notify();
            }
        }
    }

    public void onInit() {
        this.setAcceptor((TcpAcceptor)this.get_Module());
        this.setOutgoingQueue(new DualQueue());
        super.onInit();
    }

    protected void releaseReadBuffer(ReadBuffer rb) {
        if (rb instanceof TcpAcceptor$ByteBufferReadBuffer) {
            ((TcpAcceptor$ByteBufferReadBuffer)rb).release();
        } else if (!(rb == null)) {
            Component._assert(false, String.valueOf("invalid ReadBuffer type: ") + rb.getClass());
        }
    }

    protected void releaseWriteBuffer(WriteBuffer wb) {
    }

    protected void releaseWriteBuffer(WriteBuffer wb, Throwable t) {
        this.getAcceptor().getByteBufferPoolOut().release(wb);
    }

    protected void setAcceptor(TcpAcceptor acceptor) {
        this.__m_Acceptor = acceptor;
    }

    public void setConnectionManager(com.tangosol.net.messaging.ConnectionManager manager) {
        super.setConnectionManager(manager);
        this.setAcceptor((TcpAcceptor)manager);
    }

    public void setIncomingByteBuffer(ByteBuffer buf) {
        this.__m_IncomingByteBuffer = buf;
    }

    public void setIncomingByteBufferArray(ByteBuffer[] abuf) {
        this.__m_IncomingByteBufferArray = abuf;
    }

    public void setIncomingByteBufferIndex(int i) {
        this.__m_IncomingByteBufferIndex = i;
    }

    public void setIncomingBytesRead(int cb) {
        this.__m_IncomingBytesRead = cb;
    }

    public void setIncomingBytesTotal(int cb) {
        this.__m_IncomingBytesTotal = cb;
    }

    public void setIncomingState(int nState) {
        this.__m_IncomingState = nState;
    }

    public void setOutgoingByteBuffer(ByteBuffer buf) {
        this.__m_OutgoingByteBuffer = buf;
    }

    public void setOutgoingByteBufferArray(ByteBuffer[] abuf) {
        this.__m_OutgoingByteBufferArray = abuf;
    }

    public void setOutgoingByteBufferIndex(int i) {
        this.__m_OutgoingByteBufferIndex = i;
    }

    public void setOutgoingBytesTotal(int cb) {
        this.__m_OutgoingBytesTotal = cb;
    }

    public void setOutgoingBytesWritten(int cb) {
        this.__m_OutgoingBytesWritten = cb;
    }

    public void setOutgoingMessage(MultiBufferWriteBuffer buf) {
        this.__m_OutgoingMessage = buf;
    }

    protected void setOutgoingQueue(Queue queue) {
        this.__m_OutgoingQueue = queue;
    }

    public void setOutgoingState(int nState) {
        this.__m_OutgoingState = nState;
    }

    public void setSelectionKey(SelectionKey key) {
        this.__m_SelectionKey = key;
    }

    public void setSocketChannel(SocketChannel channel) {
        this.__m_SocketChannel = channel;
    }
}

