/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.comm.connectionManager.acceptor;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.comm.connectionManager.acceptor.TcpAcceptor;
import com.tangosol.coherence.component.comm.connectionManager.acceptor.TcpAcceptor$ByteBufferPool;
import com.tangosol.coherence.component.comm.connectionManager.acceptor.TcpAcceptor$ByteBufferReadBuffer;
import com.tangosol.coherence.component.comm.connectionManager.acceptor.TcpAcceptor$TcpConnection;
import com.tangosol.coherence.component.comm.util.TcpUtil;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.io.MultiBufferReadBuffer;
import com.tangosol.io.MultiBufferWriteBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.nio.ByteBufferReadBuffer;
import com.tangosol.io.nio.ByteBufferWriteBuffer;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;

public class TcpAcceptor$TcpProcessor
extends Daemon {
    private TcpAcceptor __m_Acceptor;

    public TcpAcceptor$TcpProcessor() {
        this(null, null, true);
    }

    public TcpAcceptor$TcpProcessor(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    protected void closeConnection(TcpAcceptor$TcpConnection connection, Throwable t) {
        TcpUtil.cancel(connection.getSelectionKey());
        this.getAcceptor().closeConnection(connection, false, t);
    }

    protected void flushConnections() {
        Queue queue = this.getAcceptor().getConnectionFlushQueue();
        TcpAcceptor$TcpConnection connection = (TcpAcceptor$TcpConnection)queue.removeNoWait();
        while (connection != null) {
            SelectionKey key = connection.getSelectionKey();
            if (key != null) {
                try {
                    key.interestOps(key.interestOps() | SelectionKey.OP_WRITE);
                }
                catch (CancelledKeyException e) {
                    // empty catch block
                }
            }
            connection = (TcpAcceptor$TcpConnection)queue.removeNoWait();
        }
    }

    protected TcpAcceptor getAcceptor() {
        return this.__m_Acceptor;
    }

    public String getThreadName() {
        return String.valueOf(this.get_Module().get_Name()) + ':' + super.getThreadName();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/comm/connectionManager/acceptor/TcpAcceptor$TcpProcessor".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new TcpAcceptor$TcpProcessor();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    protected void onAccept(SelectionKey keyAccept) {
        SelectionKey key;
        TcpAcceptor$TcpConnection connection;
        SocketChannel channel;
        if (keyAccept.isValid() ^ true) {
            return;
        }
        TcpAcceptor acceptor = this.getAcceptor();
        try {
            ServerSocketChannel channelServer = (ServerSocketChannel)keyAccept.channel();
            channel = channelServer.accept();
        }
        catch (ClosedChannelException e) {
            if (this.isExiting() ^ true) {
                Component._trace(e, "Caught an exception while accepting a Socket connection");
            }
            return;
        }
        catch (IOException e) {
            Component._trace(e, "Error accepting a Socket connection");
            return;
        }
        try {
            connection = (TcpAcceptor$TcpConnection)acceptor.openConnection(channel);
        }
        catch (RuntimeException e) {
            connection = null;
            Component._trace(e, String.valueOf("Error creating a connection for \"") + channel.socket() + '\"');
        }
        if (connection == null) {
            TcpUtil.close(channel);
            return;
        }
        try {
            key = channel.register(acceptor.getSelector(), SelectionKey.OP_READ);
        }
        catch (ClosedChannelException e) {
            this.closeConnection(connection, e);
            return;
        }
        key.attach(connection);
        connection.setSelectionKey(key);
    }

    protected void onException(Throwable e) {
        if (this.isExiting()) {
            Component._trace(String.valueOf(this.get_Name()) + " caught an unhandled exception (" + e.getClass().getName() + ": " + e.getMessage() + ") while exiting.", 4);
        } else {
            Component._trace(String.valueOf("Terminating ") + this.get_Name() + " due to unhandled exception: " + e.getClass().getName(), 1);
            Component._trace(e);
            this.getAcceptor().stop();
        }
    }

    protected void onExit() {
        block3: {
            Selector selector = this.getAcceptor().getSelector();
            if (!(selector != null)) break block3;
            try {
                while (selector.keys().isEmpty() ^ true) {
                    this.releaseConnections();
                    selector.selectNow();
                    Thread.currentThread();
                    Thread.yield();
                }
            }
            catch (IOException e) {
                this.onException(e);
            }
        }
    }

    public void onInit() {
        this.setAcceptor((TcpAcceptor)this.get_Parent());
        super.onInit();
    }

    protected void onNotify() {
        Selector selector = this.getAcceptor().getSelector();
        Component._assert(selector != null);
        while (this.isExiting() ^ true) {
            try {
                int cKeys = selector.select(500L);
                if (cKeys > 0) {
                    this.onSelect(selector.selectedKeys());
                }
                this.flushConnections();
                this.releaseConnections();
            }
            catch (IOException e) {
                if (!(this.isExiting() ^ true)) continue;
                Component._trace(e, String.valueOf("Caught an I/O exception while processing a Socket; ") + "the exception has been logged and will be ignored");
            }
            catch (ClosedSelectorException e) {
                this.onException(e);
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onRead(SelectionKey keyRead) {
        block30: {
            block29: {
                block28: {
                    if (keyRead.isValid() ^ true) {
                        return;
                    }
                    connection = (TcpAcceptor$TcpConnection)keyRead.attachment();
                    if (connection == null != false ? true : connection.isOpen() ^ true) {
                        keyRead.interestOps(keyRead.interestOps() & ~SelectionKey.OP_READ);
                        return;
                    }
                    channel = (SocketChannel)keyRead.channel();
                    acceptor = this.getAcceptor();
                    pool = acceptor.getByteBufferPoolIn();
                    buf = connection.getIncomingByteBuffer();
                    abuf = connection.getIncomingByteBufferArray();
                    iBuffer = connection.getIncomingByteBufferIndex();
                    cbTotal = connection.getIncomingBytesTotal();
                    cbRead = connection.getIncomingBytesRead();
                    nState = connection.getIncomingState();
                    try {
                        block31: {
                            try {
                                switch (nState) {
                                    default: {
                                        throw new IllegalStateException(String.valueOf("unknown state: ") + nState);
                                    }
                                    case 0: {
                                        if (buf == null) {
                                            buf = ByteBuffer.allocate(5);
                                            connection.setIncomingByteBuffer(buf);
                                        }
                                        if (channel.read(buf) == -1) {
                                            this.closeConnection(connection, null);
                                            var15_12 = null;
                                            connection.setIncomingByteBufferArray(abuf);
                                            connection.setIncomingByteBufferIndex(iBuffer);
                                            connection.setIncomingBytesTotal(cbTotal);
                                            connection.setIncomingBytesRead(cbRead);
                                            connection.setIncomingState(nState);
                                            return;
                                        }
                                        cbTotal = TcpAcceptor$TcpProcessor.readMessageLength(buf);
                                        if (cbTotal < 0) {
                                            break block28;
                                        }
                                        nState = TcpAcceptor$TcpConnection.IN_DECODED;
                                    }
                                    case 1: {
                                        cbBuffer = pool.getBufferSize();
                                        cBuffers = cbTotal / cbBuffer;
                                        cbLast = cbTotal % cbBuffer;
                                        if (cbLast > 0) {
                                            ++cBuffers;
                                        }
                                        abuf = new ByteBuffer[cBuffers];
                                        i = 0;
                                        while (true) {
                                            if (i < cBuffers) ** GOTO lbl51
lbl51:
                                            // 1 sources

                                            abuf[i] = (ByteBuffer)pool.acquire();
                                            ++i;
                                        }
                                        if (cbLast > 0) {
                                            abuf[cBuffers - 1].limit(cbLast);
                                        }
                                        if ((cbRead = buf.remaining()) > 0) {
                                            abuf[0].put(buf);
                                        }
                                        buf.clear();
                                        nState = TcpAcceptor$TcpConnection.IN_PREPARED;
                                        break;
                                    }
                                    case 2: 
                                }
                                c = abuf.length;
                                while (true) {
                                    block32: {
                                        if (iBuffer < c) break block32;
                                    }
                                    bufMsg = abuf[iBuffer];
                                    cb = channel.read(bufMsg);
                                    if (cb == -1) {
                                        this.closeConnection(connection, null);
                                        break block29;
                                    }
                                    cbRead += cb;
                                    if (bufMsg.hasRemaining()) {
                                        break block30;
                                    }
                                    ++iBuffer;
                                }
                                if (cbRead == cbTotal) {
                                    cBuffers = abuf.length;
                                    if (cBuffers == 1) {
                                        rb = new ByteBufferReadBuffer((ByteBuffer)abuf[0].flip());
                                    } else {
                                        arb = new ReadBuffer[cBuffers];
                                        i = 0;
                                        while (true) {
                                            if (!(i < cBuffers)) {
                                                rb = new MultiBufferReadBuffer(arb);
                                                break;
                                            }
                                            arb[i] = new ByteBufferReadBuffer((ByteBuffer)abuf[i].flip());
                                            ++i;
                                        }
                                    }
                                    bbrb = new TcpAcceptor$ByteBufferReadBuffer();
                                    bbrb.setByteBuffer(abuf);
                                    bbrb.setByteBufferPool(pool);
                                    bbrb.setWrappedReadBuffer((ReadBuffer)rb);
                                    acceptor.onReceive(connection, bbrb);
                                    abuf = null;
                                    iBuffer = 0;
                                    cbTotal = 0;
                                    cbRead = 0;
                                    nState = TcpAcceptor$TcpConnection.IN_INITIAL;
                                    break block31;
                                }
                                if (cbRead < cbTotal) {
                                    Component._assert(iBuffer < abuf.length);
                                } else {
                                    Component._assert(false, String.valueOf("expected to read ") + cbTotal + " bytes; " + "read " + cbRead + " bytes");
                                }
                            }
                            catch (Exception e) {
                                this.closeConnection(connection, e);
                            }
                        }
                        var15_17 = null;
                        connection.setIncomingByteBufferArray(abuf);
                        connection.setIncomingByteBufferIndex(iBuffer);
                        connection.setIncomingBytesTotal(cbTotal);
                        connection.setIncomingBytesRead(cbRead);
                        connection.setIncomingState(nState);
                        return;
                    }
                    catch (Throwable var12_21) {
                        var15_18 = null;
                        connection.setIncomingByteBufferArray(abuf);
                        connection.setIncomingByteBufferIndex(iBuffer);
                        connection.setIncomingBytesTotal(cbTotal);
                        connection.setIncomingBytesRead(cbRead);
                        connection.setIncomingState(nState);
                        throw var12_21;
                    }
                }
                var15_13 = null;
                connection.setIncomingByteBufferArray(abuf);
                connection.setIncomingByteBufferIndex(iBuffer);
                connection.setIncomingBytesTotal(cbTotal);
                connection.setIncomingBytesRead(cbRead);
                connection.setIncomingState(nState);
                return;
            }
            var15_15 = null;
            connection.setIncomingByteBufferArray(abuf);
            connection.setIncomingByteBufferIndex(iBuffer);
            connection.setIncomingBytesTotal(cbTotal);
            connection.setIncomingBytesRead(cbRead);
            connection.setIncomingState(nState);
            return;
        }
        var15_16 = null;
        connection.setIncomingByteBufferArray(abuf);
        connection.setIncomingByteBufferIndex(iBuffer);
        connection.setIncomingBytesTotal(cbTotal);
        connection.setIncomingBytesRead(cbRead);
        connection.setIncomingState(nState);
    }

    protected void onSelect(Set setKeys) {
        Iterator iter = setKeys.iterator();
        while (iter.hasNext()) {
            SelectionKey key = (SelectionKey)iter.next();
            iter.remove();
            if (key.isValid() ^ true) continue;
            try {
                if (key.isAcceptable()) {
                    this.onAccept(key);
                }
                if (key.isReadable()) {
                    this.onRead(key);
                }
                if (!key.isWritable()) continue;
                this.onWrite(key);
            }
            catch (CancelledKeyException e) {
                // empty catch block
            }
        }
    }

    protected void onWait() throws InterruptedException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onWrite(SelectionKey keyWrite) {
        Object var15_19;
        if (keyWrite.isValid() ^ true) {
            return;
        }
        TcpAcceptor$TcpConnection connection = (TcpAcceptor$TcpConnection)keyWrite.attachment();
        if (connection == null ? true : connection.isOpen() ^ true) {
            keyWrite.interestOps(keyWrite.interestOps() & ~SelectionKey.OP_WRITE);
            return;
        }
        SocketChannel channel = (SocketChannel)keyWrite.channel();
        TcpAcceptor$ByteBufferPool pool = this.getAcceptor().getByteBufferPoolOut();
        MultiBufferWriteBuffer mbwb = connection.getOutgoingMessage();
        ByteBuffer buf = connection.getOutgoingByteBuffer();
        ByteBuffer[] abuf = connection.getOutgoingByteBufferArray();
        int iBuffer = connection.getOutgoingByteBufferIndex();
        int cbTotal = connection.getOutgoingBytesTotal();
        int cbWritten = connection.getOutgoingBytesWritten();
        Queue queue = connection.getOutgoingQueue();
        int nState = connection.getOutgoingState();
        block12: while (true) {
            try {
                try {}
                catch (Exception e) {
                    this.closeConnection(connection, e);
                    Object var15_20 = null;
                    connection.setOutgoingMessage(mbwb);
                    connection.setOutgoingByteBufferArray(abuf);
                    connection.setOutgoingByteBufferIndex(iBuffer);
                    connection.setOutgoingBytesTotal(cbTotal);
                    connection.setOutgoingBytesWritten(cbWritten);
                    connection.setOutgoingState(nState);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var15_21 = null;
                connection.setOutgoingMessage(mbwb);
                connection.setOutgoingByteBufferArray(abuf);
                connection.setOutgoingByteBufferIndex(iBuffer);
                connection.setOutgoingBytesTotal(cbTotal);
                connection.setOutgoingBytesWritten(cbWritten);
                connection.setOutgoingState(nState);
                throw throwable;
            }
            while (true) {
                switch (nState) {
                    default: {
                        throw new IllegalStateException(String.valueOf("unknown state: ") + nState);
                    }
                    case 0: {
                        if (buf == null) {
                            buf = ByteBuffer.allocate(5);
                            connection.setOutgoingByteBuffer(buf);
                        }
                        if ((mbwb = (MultiBufferWriteBuffer)queue.removeNoWait()) == null) {
                            keyWrite.interestOps(keyWrite.interestOps() & ~SelectionKey.OP_WRITE);
                            var15_19 = null;
                            connection.setOutgoingMessage(mbwb);
                            connection.setOutgoingByteBufferArray(abuf);
                            connection.setOutgoingByteBufferIndex(iBuffer);
                            connection.setOutgoingBytesTotal(cbTotal);
                            connection.setOutgoingBytesWritten(cbWritten);
                            connection.setOutgoingState(nState);
                            return;
                        }
                        cbTotal = mbwb.length();
                        if (cbTotal == 0) {
                            pool.release((WriteBuffer)mbwb);
                            continue block12;
                        }
                        int cBuffers = mbwb.getBufferCount();
                        abuf = new ByteBuffer[cBuffers];
                        int i = 0;
                        while (true) {
                            if (!(i < cBuffers)) {
                                TcpAcceptor$TcpProcessor.writeMessageLength(buf, cbTotal);
                                nState = TcpAcceptor$TcpConnection.OUT_PREPARED;
                                break;
                            }
                            ByteBufferWriteBuffer bbwb = (ByteBufferWriteBuffer)mbwb.getBuffer(i);
                            abuf[i] = (ByteBuffer)((Buffer)bbwb.getByteBuffer()).flip();
                            ++i;
                        }
                    }
                    case 1: {
                        channel.write(buf);
                        if (buf.hasRemaining()) {
                            var15_19 = null;
                            connection.setOutgoingMessage(mbwb);
                            connection.setOutgoingByteBufferArray(abuf);
                            connection.setOutgoingByteBufferIndex(iBuffer);
                            connection.setOutgoingBytesTotal(cbTotal);
                            connection.setOutgoingBytesWritten(cbWritten);
                            connection.setOutgoingState(nState);
                            return;
                        }
                        ((Buffer)buf).clear();
                        nState = TcpAcceptor$TcpConnection.OUT_ENCODED;
                        break;
                    }
                    case 2: 
                }
                int c22 = abuf.length;
                while (iBuffer < c22) {
                    ByteBuffer bufMsg = abuf[iBuffer];
                    cbWritten += channel.write(bufMsg);
                    if (bufMsg.hasRemaining()) {
                        var15_19 = null;
                        connection.setOutgoingMessage(mbwb);
                        connection.setOutgoingByteBufferArray(abuf);
                        connection.setOutgoingByteBufferIndex(iBuffer);
                        connection.setOutgoingBytesTotal(cbTotal);
                        connection.setOutgoingBytesWritten(cbWritten);
                        connection.setOutgoingState(nState);
                        return;
                    }
                    abuf[iBuffer] = null;
                    pool.release(bufMsg);
                    ++iBuffer;
                }
                if (!(cbWritten == cbTotal)) break block12;
                MultiBufferWriteBuffer c22 = mbwb;
                synchronized (c22) {
                    mbwb.notify();
                }
                mbwb = null;
                abuf = null;
                iBuffer = 0;
                cbTotal = 0;
                cbWritten = 0;
                nState = TcpAcceptor$TcpConnection.OUT_INITIAL;
            }
            break;
        }
        if (cbWritten < cbTotal) {
            Component._assert(iBuffer < abuf.length);
            var15_19 = null;
            connection.setOutgoingMessage(mbwb);
            connection.setOutgoingByteBufferArray(abuf);
            connection.setOutgoingByteBufferIndex(iBuffer);
            connection.setOutgoingBytesTotal(cbTotal);
            connection.setOutgoingBytesWritten(cbWritten);
            connection.setOutgoingState(nState);
            return;
        }
        Component._assert(false, String.valueOf("expected to write ") + cbTotal + " bytes; " + "wrote " + cbWritten + " bytes");
        var15_19 = null;
        connection.setOutgoingMessage(mbwb);
        connection.setOutgoingByteBufferArray(abuf);
        connection.setOutgoingByteBufferIndex(iBuffer);
        connection.setOutgoingBytesTotal(cbTotal);
        connection.setOutgoingBytesWritten(cbWritten);
        connection.setOutgoingState(nState);
    }

    protected static int readMessageLength(ByteBuffer buf) {
        int nPos = buf.position();
        if (nPos == 0) {
            return -1;
        }
        int b = buf.get(0) & 0xFF;
        if ((b & 0x40) != 0) {
            throw new IllegalArgumentException("Received a message with a negative length");
        }
        int cb = b & 0x3F;
        int i = 1;
        int cBits = 6;
        while ((b & 0x80) != 0) {
            if (i == nPos) {
                return -1;
            }
            b = buf.get(i++) & 0xFF;
            cb |= (b & 0x7F) << cBits;
            cBits += 7;
        }
        ((Buffer)buf).limit(buf.position());
        ((Buffer)buf).position(i);
        if (cb == 0) {
            throw new IllegalArgumentException("Received a message with a length of zero");
        }
        return cb;
    }

    protected void releaseConnection(TcpAcceptor$TcpConnection connection) {
        TcpUtil.cancel(connection.getSelectionKey());
        TcpUtil.close(connection.getSocket());
        TcpUtil.close(connection.getSocketChannel());
        TcpAcceptor$ByteBufferPool poolIn = this.getAcceptor().getByteBufferPoolIn();
        TcpAcceptor$ByteBufferPool poolOut = this.getAcceptor().getByteBufferPoolOut();
        poolIn.release(connection.getIncomingByteBufferArray());
        poolOut.release(connection.getOutgoingByteBufferArray());
        Queue queue = connection.getOutgoingQueue();
        WriteBuffer wb = (WriteBuffer)queue.removeNoWait();
        while (wb != null) {
            poolOut.release(wb);
            wb = (WriteBuffer)queue.removeNoWait();
        }
        connection.setSelectionKey(null);
        connection.setSocket(null);
        connection.setSocketChannel(null);
        connection.setIncomingByteBuffer(null);
        connection.setIncomingByteBufferArray(null);
        connection.setIncomingByteBufferIndex(0);
        connection.setIncomingBytesTotal(0);
        connection.setIncomingBytesRead(0);
        connection.setOutgoingByteBuffer(null);
        connection.setOutgoingByteBufferArray(null);
        connection.setOutgoingByteBufferIndex(0);
        connection.setOutgoingBytesTotal(0);
        connection.setOutgoingBytesWritten(0);
        if (Component._isTraceEnabled(6)) {
            Component._trace(String.valueOf("Released: ") + connection, 6);
        }
    }

    protected void releaseConnections() {
        Queue queue = this.getAcceptor().getConnectionReleaseQueue();
        TcpAcceptor$TcpConnection connection = (TcpAcceptor$TcpConnection)queue.removeNoWait();
        while (connection != null) {
            this.releaseConnection(connection);
            connection = (TcpAcceptor$TcpConnection)queue.removeNoWait();
        }
    }

    protected void setAcceptor(TcpAcceptor acceptor) {
        this.__m_Acceptor = acceptor;
    }

    public void stop() {
        Thread thread;
        TcpAcceptor$TcpProcessor tcpAcceptor$TcpProcessor = this;
        synchronized (tcpAcceptor$TcpProcessor) {
            if (this.isStarted()) {
                this.setExiting(true);
                thread = this.getThread();
            } else {
                thread = null;
            }
        }
        Thread threadThis = Thread.currentThread();
        if (!(thread != null) ? false : thread != threadThis) {
            try {
                this.getAcceptor().getSelector().wakeup();
            }
            catch (Throwable t) {
                // empty catch block
            }
            boolean fInterrupt = Thread.interrupted();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                fInterrupt = true;
            }
            if (fInterrupt) {
                threadThis.interrupt();
            }
        }
    }

    protected static void writeMessageLength(ByteBuffer buf, int cb) {
        Component._assert(cb >= 0);
        int b = cb & 0x3F;
        cb >>>= 6;
        while (cb != 0) {
            buf.put((byte)(b |= 0x80));
            b = cb & 0x7F;
            cb >>>= 7;
        }
        buf.put((byte)b);
        ((Buffer)buf).flip();
    }
}

