/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.comm.connectionManager.initiator;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Comm;
import com.tangosol.coherence.component.comm.Connection;
import com.tangosol.coherence.component.comm.ConnectionManager;
import com.tangosol.coherence.component.comm.ConnectionManager$ConnectionCloseTask;
import com.tangosol.coherence.component.comm.ConnectionManager$ConnectionEventTask;
import com.tangosol.coherence.component.comm.ConnectionManager$Daemon;
import com.tangosol.coherence.component.comm.ConnectionManager$DaemonPool;
import com.tangosol.coherence.component.comm.ConnectionManager$EventDispatcher;
import com.tangosol.coherence.component.comm.ConnectionManager$MessageDispatchTask;
import com.tangosol.coherence.component.comm.ConnectionManager$MessageExecuteTask;
import com.tangosol.coherence.component.comm.connectionManager.Initiator;
import com.tangosol.coherence.component.comm.connectionManager.initiator.TcpInitiator$TcpConnection;
import com.tangosol.coherence.component.comm.util.TcpUtil;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class TcpInitiator
extends Initiator {
    private boolean __m_KeepAliveEnabled;
    private long __m_LingerTimeout;
    private InetSocketAddress __m_LocalAddress;
    private boolean __m_LocalAddressReusable;
    private long __m_ReceiveBufferSize;
    private InetSocketAddress[] __m_RemoteAddress;
    private int __m_RemoteAddressIndex;
    private long __m_SendBufferSize;
    private boolean __m_TcpDelayEnabled;
    private static ListMap __mapChildren;

    static {
        TcpInitiator.__initStatic();
    }

    public TcpInitiator() {
        this(null, null, true);
    }

    public TcpInitiator(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setKeepAliveEnabled(true);
            this.setLingerTimeout(-1L);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this._addChild(new ConnectionManager$Daemon("Daemon", this, true), "Daemon");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"ConnectionCloseTask", (Object)ConnectionManager$ConnectionCloseTask.get_CLASS());
        Object object2 = __mapChildren.put((Object)"ConnectionEventTask", (Object)ConnectionManager$ConnectionEventTask.get_CLASS());
        Object object3 = __mapChildren.put((Object)"DaemonPool", (Object)ConnectionManager$DaemonPool.get_CLASS());
        Object object4 = __mapChildren.put((Object)"EventDispatcher", (Object)ConnectionManager$EventDispatcher.get_CLASS());
        Object object5 = __mapChildren.put((Object)"MessageDispatchTask", (Object)ConnectionManager$MessageDispatchTask.get_CLASS());
        Object object6 = __mapChildren.put((Object)"MessageExecuteTask", (Object)ConnectionManager$MessageExecuteTask.get_CLASS());
        Object object7 = __mapChildren.put((Object)"TcpConnection", (Object)TcpInitiator$TcpConnection.get_CLASS());
    }

    protected void configureSocket(Socket socket) {
        try {
            TcpUtil.setKeepAlive(socket, this.isKeepAliveEnabled());
            TcpUtil.setReuseAddress(socket, this.isLocalAddressReusable());
            TcpUtil.setTcpNoDelay(socket, this.isTcpDelayEnabled() ^ true);
            TcpUtil.setReceiveBufferSize(socket, (int)this.getReceiveBufferSize());
            TcpUtil.setSendBufferSize(socket, (int)this.getSendBufferSize());
            long cMillis = this.getLingerTimeout();
            int cSecs = cMillis >= (long)0 ? (int)(cMillis / 1000L) : -1;
            TcpUtil.setSoLinger(socket, cSecs);
        }
        catch (Exception e) {
            throw Comm.ensureRuntimeException(e, "error configuring Socket");
        }
        InetSocketAddress addr = this.getLocalAddress();
        if (addr != null) {
            Component._trace(String.valueOf("Binding Socket to ") + TcpUtil.toString(addr), 6);
            try {
                socket.bind(addr);
            }
            catch (Exception e) {
                throw Comm.ensureRuntimeException(e, String.valueOf("error binding Socket to ") + TcpUtil.toString(addr));
            }
            if (socket.isBound() ^ true) {
                throw new RuntimeException(String.valueOf("could not bind Socket to ") + TcpUtil.toString(addr));
            }
        }
    }

    protected void doConfigure(XmlElement xml) {
        super.doConfigure(xml);
        XmlElement xmlCat = xml.getSafeElement("tcp-initiator");
        XmlElement xmlSub = xmlCat.getSafeElement("local-address");
        this.setLocalAddress(TcpInitiator.parseLocalSocketAddress(xmlSub));
        this.setLocalAddressReusable(xmlSub.getSafeElement("reusable").getBoolean(this.isLocalAddressReusable()));
        xmlSub = xmlCat.getSafeElement("remote-addresses");
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>();
        Iterator iter = xmlSub.getElements("socket-address");
        while (iter.hasNext()) {
            XmlElement xmlVal = (XmlElement)iter.next();
            InetSocketAddress addr = TcpInitiator.parseRemoteSocketAddress(xmlVal);
            if (!(addr != null)) continue;
            list.add(addr);
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException(String.valueOf("the \"remote-addresses\" element ") + "does not contain a valid \"socket-address\" element");
        }
        Object[] aaddr = list.toArray(new InetSocketAddress[0]);
        this.setRemoteAddress((InetSocketAddress[])Base.randomize((Object[])aaddr));
        this.setKeepAliveEnabled(xmlCat.getSafeElement("keep-alive-enabled").getBoolean(this.isKeepAliveEnabled()));
        this.setTcpDelayEnabled(xmlCat.getSafeElement("tcp-delay-enabled").getBoolean(this.isTcpDelayEnabled()));
        this.setReceiveBufferSize(ConnectionManager.parseMemorySize(xmlCat, "receive-buffer-size", this.getReceiveBufferSize()));
        this.setSendBufferSize(ConnectionManager.parseMemorySize(xmlCat, "send-buffer-size", this.getSendBufferSize()));
        this.setConnectTimeout(ConnectionManager.parseTime(xmlCat, "connect-timeout", this.getRequestTimeout()));
        this.setLingerTimeout(ConnectionManager.parseTime(xmlCat, "linger-timeout", this.getLingerTimeout()));
    }

    protected String getDescription() {
        InetSocketAddress[] aaddr;
        StringBuffer sb = new StringBuffer(super.getDescription());
        InetSocketAddress addr = this.getLocalAddress();
        if (addr != null) {
            sb.append(", LocalAddress=").append(TcpUtil.toString(addr)).append(", LocalAddressReusable=").append(this.isLocalAddressReusable());
        }
        if ((aaddr = this.getRemoteAddress()) != null) {
            sb.append(", RemoteAddresses=[");
            int i = 0;
            int c = aaddr.length;
            while (i < c) {
                sb.append(TcpUtil.toString(aaddr[i]));
                if (!(++i < c)) continue;
                sb.append(',');
            }
            sb.append(']');
        }
        sb.append(", KeepAliveEnabled=").append(this.isKeepAliveEnabled()).append(", TcpDelayEnabled=").append(this.isTcpDelayEnabled()).append(", ReceiveBufferSize=").append(Base.toMemorySizeString((long)this.getReceiveBufferSize())).append(", SendBufferSize=").append(Base.toMemorySizeString((long)this.getSendBufferSize())).append(", LingerTimeout=").append(this.getLingerTimeout());
        return sb.toString();
    }

    protected long getLingerTimeout() {
        return this.__m_LingerTimeout;
    }

    protected InetSocketAddress getLocalAddress() {
        return this.__m_LocalAddress;
    }

    protected long getReceiveBufferSize() {
        return this.__m_ReceiveBufferSize;
    }

    protected InetSocketAddress[] getRemoteAddress() {
        return this.__m_RemoteAddress;
    }

    protected InetSocketAddress getRemoteAddress(int i) {
        return this.getRemoteAddress()[i];
    }

    public int getRemoteAddressIndex() {
        return this.__m_RemoteAddressIndex;
    }

    protected long getSendBufferSize() {
        return this.__m_SendBufferSize;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/comm/connectionManager/initiator/TcpInitiator".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new TcpInitiator();
    }

    private final Component get_Module() {
        return this;
    }

    protected Connection instantiateConnection() {
        int cMillis = (int)this.getConnectTimeout();
        cMillis = cMillis < 0 ? 0 : Math.max(cMillis, 1);
        Socket socket = this.instantiateSocket();
        int i = 0;
        int c = this.getRemoteAddress().length;
        while (i < c) {
            InetSocketAddress addr = this.getRemoteAddress(this.getRemoteAddressIndex());
            try {
                addr = new InetSocketAddress(addr.getHostName(), addr.getPort());
                Component._trace(String.valueOf("Opening Socket connection to ") + TcpUtil.toString(addr), 5);
                socket.connect(addr, cMillis);
                Component._trace(String.valueOf("Connected to ") + TcpUtil.toString(addr), 3);
                break;
            }
            catch (Exception e) {
                Component._trace(String.valueOf("Error opening Socket connection to ") + TcpUtil.toString(addr) + ": " + e, 2);
                TcpUtil.close(socket);
                socket = this.instantiateSocket();
                this.setRemoteAddressIndex((this.getRemoteAddressIndex() + 1) % c);
                ++i;
            }
        }
        if (socket.isConnected() ^ true) {
            TcpUtil.close(socket);
            throw new ConnectionException(String.valueOf("could not establish a Socket connection to one ") + "of the remote addresses specified in the \"remote-addresses\" " + "configuration element; make sure this element contains an address " + "and port of a running TcpAcceptor");
        }
        TcpInitiator$TcpConnection connection = (TcpInitiator$TcpConnection)this._newChild("TcpConnection");
        connection.setSocket(socket);
        return connection;
    }

    protected Socket instantiateSocket() {
        Socket socket = new Socket();
        this.configureSocket(socket);
        return socket;
    }

    protected boolean isKeepAliveEnabled() {
        return this.__m_KeepAliveEnabled;
    }

    protected boolean isLocalAddressReusable() {
        return this.__m_LocalAddressReusable;
    }

    protected boolean isTcpDelayEnabled() {
        return this.__m_TcpDelayEnabled;
    }

    protected static InetSocketAddress parseLocalSocketAddress(XmlElement xml) {
        InetAddress addr;
        XmlElement xmlAddr = xml.getElement("address");
        XmlElement xmlPort = xml.getElement("port");
        if (!(xmlAddr == null) ? false : xmlPort == null) {
            return null;
        }
        String sAddr = xmlAddr == null ? "localhost" : xmlAddr.getString();
        int nPort = xmlPort == null ? 0 : xmlPort.getInt();
        try {
            addr = sAddr.equals("localhost") ? InetAddressHelper.getLocalHost() : InetAddress.getByName(sAddr);
        }
        catch (Exception e) {
            throw Comm.ensureRuntimeException(e, String.valueOf("the \"") + xml.getName() + "\" configuration " + "element contains an invalid \"address\" element");
        }
        try {
            return new InetSocketAddress(addr, nPort);
        }
        catch (RuntimeException e) {
            throw Comm.ensureRuntimeException(e, String.valueOf("the \"") + xml.getName() + "\" configuration " + "element contains an invalid \"port\" element");
        }
    }

    protected static InetSocketAddress parseRemoteSocketAddress(XmlElement xml) {
        InetAddress addr;
        XmlElement xmlAddr = xml.getElement("address");
        XmlElement xmlPort = xml.getElement("port");
        if (xmlAddr == null ? true : xmlPort == null) {
            return null;
        }
        try {
            String sAddr = xmlAddr.getString();
            addr = sAddr.equals("localhost") ? InetAddressHelper.getLocalHost() : InetAddress.getByName(sAddr);
        }
        catch (Exception e) {
            throw Comm.ensureRuntimeException(e, String.valueOf("the \"") + xml.getName() + "\" configuration " + "element contains an invalid \"address\" element");
        }
        try {
            return new InetSocketAddress(addr, xmlPort.getInt());
        }
        catch (RuntimeException e) {
            throw Comm.ensureRuntimeException(e, String.valueOf("the \"") + xml.getName() + "\" configuration " + "element contains an invalid \"port\" element");
        }
    }

    protected void setKeepAliveEnabled(boolean fEnabled) {
        this.__m_KeepAliveEnabled = fEnabled;
    }

    protected void setLingerTimeout(long cMillis) {
        this.__m_LingerTimeout = cMillis;
    }

    protected void setLocalAddress(InetSocketAddress addr) {
        this.__m_LocalAddress = addr;
    }

    protected void setLocalAddressReusable(boolean fReusable) {
        this.__m_LocalAddressReusable = fReusable;
    }

    protected void setReceiveBufferSize(long cb) {
        this.__m_ReceiveBufferSize = cb;
    }

    protected void setRemoteAddress(int i, InetSocketAddress addr) {
        this.getRemoteAddress()[i] = addr;
    }

    protected void setRemoteAddress(InetSocketAddress[] addr) {
        this.__m_RemoteAddress = addr;
    }

    public void setRemoteAddressIndex(int pRemoteAddressIndex) {
        this.__m_RemoteAddressIndex = pRemoteAddressIndex;
    }

    protected void setSendBufferSize(long cb) {
        this.__m_SendBufferSize = cb;
    }

    protected void setTcpDelayEnabled(boolean fEnabled) {
        this.__m_TcpDelayEnabled = fEnabled;
    }
}

