/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.manageable.modelAdapter;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.manageable.ModelAdapter;
import java.util.Date;
import java.util.Map;

public class ClusterNodeMBean
extends ModelAdapter {
    private transient int __m_BufferPublishSize;
    private transient int __m_BufferReceiveSize;
    private transient int __m_BurstCount;
    private transient int __m_BurstDelay;
    private transient String __m_LoggingFormat;
    private transient int __m_LoggingLevel;
    private transient int __m_LoggingLimit;
    private transient int __m_MulticastThreshold;
    private transient int __m_ResendDelay;
    private transient int __m_SendAckDelay;
    private transient int __m_TrafficJamCount;
    private transient int __m_TrafficJamDelay;

    public ClusterNodeMBean() {
        this(null, null, true);
    }

    public ClusterNodeMBean(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void ensureCacheService(String sCacheName) {
    }

    public void ensureInvocationService(String sServiceName) {
    }

    public int getBufferPublishSize() {
        return this.__m_BufferPublishSize;
    }

    public int getBufferReceiveSize() {
        return this.__m_BufferReceiveSize;
    }

    public int getBurstCount() {
        return this.__m_BurstCount;
    }

    public int getBurstDelay() {
        return this.__m_BurstDelay;
    }

    public int getCpuCount() {
        return 0;
    }

    public int getId() {
        return 0;
    }

    public String getLoggingDestination() {
        return null;
    }

    public String getLoggingFormat() {
        return this.__m_LoggingFormat;
    }

    public int getLoggingLevel() {
        return this.__m_LoggingLevel;
    }

    public int getLoggingLimit() {
        return this.__m_LoggingLimit;
    }

    public int getMachineId() {
        return 0;
    }

    public String getMachineName() {
        return null;
    }

    public String getMemberName() {
        return null;
    }

    public int getMemoryAvailableMB() {
        return 0;
    }

    public int getMemoryMaxMB() {
        return 0;
    }

    public String getMulticastAddress() {
        return null;
    }

    public int getMulticastPort() {
        return 0;
    }

    public int getMulticastTTL() {
        return 0;
    }

    public int getMulticastThreshold() {
        return this.__m_MulticastThreshold;
    }

    public long getNackSent() {
        return 0L;
    }

    public float getPacketDeliveryEfficiency() {
        return 0.0f;
    }

    public long getPacketsBundled() {
        return 0L;
    }

    public long getPacketsReceived() {
        return 0L;
    }

    public long getPacketsRepeated() {
        return 0L;
    }

    public long getPacketsResent() {
        return 0L;
    }

    public long getPacketsResentEarly() {
        return 0L;
    }

    public long getPacketsResentExcess() {
        return 0L;
    }

    public long getPacketsSent() {
        return 0L;
    }

    public int getPriority() {
        return 0;
    }

    public String getProcessName() {
        return null;
    }

    public String getProductEdition() {
        return null;
    }

    public float getPublisherPacketUtilization() {
        return 0.0f;
    }

    public float getPublisherSuccessRate() {
        return 0.0f;
    }

    public String getRackName() {
        return null;
    }

    public float getReceiverPacketUtilization() {
        return 0.0f;
    }

    public float getReceiverSuccessRate() {
        return 0.0f;
    }

    public int getResendDelay() {
        return this.__m_ResendDelay;
    }

    public String getRoleName() {
        return null;
    }

    public int getSendAckDelay() {
        return this.__m_SendAckDelay;
    }

    public int getSendQueueSize() {
        return 0;
    }

    public String getSiteName() {
        return null;
    }

    public int getSocketCount() {
        return 0;
    }

    public String getStatistics() {
        return null;
    }

    public long getTcpRingFailures() {
        return 0L;
    }

    public long getTcpRingTimeouts() {
        return 0L;
    }

    public Date getTimestamp() {
        return null;
    }

    public int getTrafficJamCount() {
        return this.__m_TrafficJamCount;
    }

    public int getTrafficJamDelay() {
        return this.__m_TrafficJamDelay;
    }

    public String getUnicastAddress() {
        return null;
    }

    public int getUnicastPort() {
        return 0;
    }

    public int getWeakestChannel() {
        return 0;
    }

    public String[] getWellKnownAddresses() {
        return null;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/manageable/modelAdapter/ClusterNodeMBean".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Object[] get_ComponentInfo() {
        return new Object[]{"ClusterNodeMBean represents a Cluster member."};
    }

    public static Component get_Instance() {
        return new ClusterNodeMBean();
    }

    protected Map get_MethodInfo() {
        Map mapInfo = super.get_MethodInfo();
        mapInfo.put("ensureCacheService(Ljava.lang.String;)", new Object[]{"Ensure that a CacheService for the specified cache runs at the cluster node represented by this MBean. This method will use the configurable cache factory to find out which cache service to start if necessary. Return value indicates the service name; null if a match could not be found.", "ensureCacheService", "V", new String[]{"sCacheName"}, new String[]{"Ljava.lang.String;"}});
        mapInfo.put("ensureInvocationService(Ljava.lang.String;)", new Object[]{"Ensure that an InvocationService with the specified name runs at the cluster node represented by this MBean.", "ensureInvocationService", "V", new String[]{"sServiceName"}, new String[]{"Ljava.lang.String;"}});
        mapInfo.put("resetStatistics()", new Object[]{"Reset the cluster node statistics.", "resetStatistics", "V", new String[0], new String[0]});
        mapInfo.put("shutdown()", new Object[]{"Stop all the clustered services running at this node (controlled shutdown). The management of this node will node be available until the node is restarted (manually or programmatically).", "shutdown", "V", new String[0], new String[0]});
        return mapInfo;
    }

    private final Component get_Module() {
        return this;
    }

    protected Map get_PropertyInfo() {
        Map mapInfo = super.get_PropertyInfo();
        mapInfo.put("BufferPublishSize", new Object[]{"The buffer size of the unicast datagram socket used by the Publisher, measured in the number of packets. Changing this value at runtime is an inherently unsafe operation that will pause all network communications and may result in the termination of all cluster services.", "getBufferPublishSize", "setBufferPublishSize", "I"});
        mapInfo.put("BufferReceiveSize", new Object[]{"The buffer size of the unicast datagram socket used by the Receiver, measured in the number of packets. Changing this value at runtime is an inherently unsafe operation that will pause all network communications and may result in the termination of all cluster services.", "getBufferReceiveSize", "setBufferReceiveSize", "I"});
        mapInfo.put("BurstCount", new Object[]{"The maximum number of packets to send without pausing. Anything less than one (e.g. zero) means no limit.", "getBurstCount", "setBurstCount", "I"});
        mapInfo.put("BurstDelay", new Object[]{"The number of milliseconds to pause between bursts. Anything less than one (e.g. zero) is treated as one millisecond.", "getBurstDelay", "setBurstDelay", "I"});
        mapInfo.put("CpuCount", new Object[]{"Number of CPU cores for the machine this Member is running on.", "getCpuCount", null, "I"});
        mapInfo.put("FlowControlEnabled", new Object[]{"Indicates whether or not FlowControl is enabled.", "isFlowControlEnabled", null, "Z"});
        mapInfo.put("Id", new Object[]{"The short Member id that uniquely identifies the Member at this point in time and does not change for the life of this Member. ", "getId", null, "I"});
        mapInfo.put("LoggingDestination", new Object[]{"The output device used by the logging system. Valid values are stdout, stderr, jdk, log4j, or a file name.", "getLoggingDestination", null, "Ljava/lang/String;"});
        mapInfo.put("LoggingFormat", new Object[]{"Specifies how messages will be formatted before being passed to the log destination", "getLoggingFormat", "setLoggingFormat", "Ljava/lang/String;"});
        mapInfo.put("LoggingLevel", new Object[]{"Specifies which logged messages will be output to the log destination. Valid values are non-negative integers or -1 to disable all logger output.", "getLoggingLevel", "setLoggingLevel", "I"});
        mapInfo.put("LoggingLimit", new Object[]{"The maximum number of characters that the logger daemon will process from the message queue before discarding all remaining messages in the queue. Valid values are integers in the range [0...]. Zero implies no limit.", "getLoggingLimit", "setLoggingLimit", "I"});
        mapInfo.put("MachineId", new Object[]{"The Member`s machine Id. ", "getMachineId", null, "I"});
        mapInfo.put("MachineName", new Object[]{"A configured name that should be the same for all Members that are on the same physical machine, and different for Members that are on different physical machines.", "getMachineName", null, "Ljava/lang/String;"});
        mapInfo.put("MemberName", new Object[]{"A configured name that must be unique for every Member.", "getMemberName", null, "Ljava/lang/String;"});
        mapInfo.put("MemoryAvailableMB", new Object[]{"The total amount of memory in the JVM available for new objects in MB.", "getMemoryAvailableMB", null, "I"});
        mapInfo.put("MemoryMaxMB", new Object[]{"The maximum amount of memory that the JVM will attempt to use in MB.", "getMemoryMaxMB", null, "I"});
        mapInfo.put("MulticastAddress", new Object[]{"The IP address of the Member`s MulticastSocket for group communication.", "getMulticastAddress", null, "Ljava/lang/String;"});
        mapInfo.put("MulticastEnabled", new Object[]{"Specifies whether or not this Member uses multicast for group communication. If false, this Member will use the WellKnownAddresses to join the cluster and point-to-point unicast to communicate with other Members of the cluster.", "isMulticastEnabled", null, "Z"});
        mapInfo.put("MulticastPort", new Object[]{"The port of the Member`s MulticastSocket for group communication.", "getMulticastPort", null, "I"});
        mapInfo.put("MulticastThreshold", new Object[]{"The percentage (0 to 100) of the servers in the cluster that a packet will be sent to, above which the packet will be multicasted and below which it will be unicasted.", "getMulticastThreshold", "setMulticastThreshold", "I"});
        mapInfo.put("MulticastTTL", new Object[]{"The time-to-live for multicast packets sent out on this Member`s MulticastSocket.", "getMulticastTTL", null, "I"});
        mapInfo.put("NackEnabled", new Object[]{"Indicates whether or not the early packet loss detection protocol is enabled.", "isNackEnabled", null, "Z"});
        mapInfo.put("NackSent", new Object[]{"The total number of NACK packets sent since the node statistics were last reset.", "getNackSent", null, "J"});
        mapInfo.put("PacketDeliveryEfficiency", new Object[]{"The efficiency of packet loss detection and retransmission.  A low efficiency is an indication that there is a high rate of unnecessary packet retransmissions.", "getPacketDeliveryEfficiency", null, "F"});
        mapInfo.put("PacketsBundled", new Object[]{"The total number of packets which were bundled prior to transmission.  The total number of network transmissions is equal to (PacketsSent - PacketsBundled).", "getPacketsBundled", null, "J"});
        mapInfo.put("PacketsReceived", new Object[]{"The number of packets received since the node statistics were last reset.", "getPacketsReceived", null, "J"});
        mapInfo.put("PacketsRepeated", new Object[]{"The number of duplicate packets received since the node statistics were last reset.", "getPacketsRepeated", null, "J"});
        mapInfo.put("PacketsResent", new Object[]{"The number of packets resent since the node statistics were last reset. A packet is resent when there is no ACK received within a timeout period.", "getPacketsResent", null, "J"});
        mapInfo.put("PacketsResentEarly", new Object[]{"The total number of packets resent ahead of schedule. A packet is resent ahead of schedule when there is a NACK indicating that the packet has not been received.", "getPacketsResentEarly", null, "J"});
        mapInfo.put("PacketsResentExcess", new Object[]{"The total number of packet retransmissions which were later proven unnecessary.", "getPacketsResentExcess", null, "J"});
        mapInfo.put("PacketsSent", new Object[]{"The number of packets sent since the node statistics were last reset.", "getPacketsSent", null, "J"});
        mapInfo.put("Priority", new Object[]{"The priority or \"weight\" of the Member; used to determine tie-breakers.", "getPriority", null, "I"});
        mapInfo.put("ProcessName", new Object[]{"A configured name that should be the same for Members that are in the same process (JVM), and different for Members that are in different processes. If not explicitly provided, for processes running with JRE 1.5 or higher the name will be calculated internally as the Name attribute of the system RuntimeMXBean, which normally represents the process identifier (PID).", "getProcessName", null, "Ljava/lang/String;"});
        mapInfo.put("ProductEdition", new Object[]{"The product edition this Member is running. Possible values  are: Standard Edition (SE), Enterprise Edition (EE), Grid Edition (GE).", "getProductEdition", null, "Ljava/lang/String;"});
        mapInfo.put("PublisherPacketUtilization", new Object[]{"The publisher packet utilization for this cluster node since the node socket was last reopened. This value is a ratio of the number of bytes sent to the number that would have been sent had all packets been full. A low utilization indicates that data is not being sent in large enough chunks to make efficient use of the network.", "getPublisherPacketUtilization", null, "F"});
        mapInfo.put("PublisherSuccessRate", new Object[]{"The publisher success rate for this cluster node since the node statistics were last reset. Publisher success rate is a ratio of the number of packets successfully delivered in a first attempt to the total number of sent packets. A failure count is incremented when there is no ACK received within a timeout period. It could be caused by either very high network latency or a high packet drop rate.", "getPublisherSuccessRate", null, "F"});
        mapInfo.put("RackName", new Object[]{"A configured name that should be the same for Members that are on the same physical \"rack\" (or frame or cage), and different for Members that are on different physical \"racks\".", "getRackName", null, "Ljava/lang/String;"});
        mapInfo.put("ReceiverPacketUtilization", new Object[]{"The receiver packet utilization for this cluster node since the socket was last reopened. This value is a ratio of the number of bytes received to the number that would have been received had all packets been full. A low utilization indicates that data is not being sent in large enough chunks to make efficient use of the network.", "getReceiverPacketUtilization", null, "F"});
        mapInfo.put("ReceiverSuccessRate", new Object[]{"The receiver success rate for this cluster node since the node statistics were last reset. Receiver success rate is a ratio of the number of packets successfully acknowledged in a first attempt to the total number of received packets. A failure count is incremented when a re-delivery of previously received packet is detected. It could be caused by either very high inbound network latency or lost ACK packets.", "getReceiverSuccessRate", null, "F"});
        mapInfo.put("ResendDelay", new Object[]{"The minimum number of milliseconds that a packet will remain queued in the Publisher`s re-send queue before it is resent to the recipient(s) if the packet has not been acknowledged. Setting this value too low can overflow the network with unnecessary repetitions. Setting the value too high can increase the overall latency by delaying the re-sends of dropped packets. Additionally, change of this value may need to be accompanied by a change in SendAckDelay value.", "getResendDelay", "setResendDelay", "I"});
        mapInfo.put("RoleName", new Object[]{"A configured name that can be used to indicate the role of a Member to the application. While managed by Coherence, this property is used only by the application.", "getRoleName", null, "Ljava/lang/String;"});
        mapInfo.put("SendAckDelay", new Object[]{"The minimum number of milliseconds between the queueing of an Ack packet and the sending of the same. This value should be not more then a half of the ResendDelay value.", "getSendAckDelay", "setSendAckDelay", "I"});
        mapInfo.put("SendQueueSize", new Object[]{"The number of packets currently scheduled for delivery. This number includes both packets that are to be sent immediately and packets that have already been sent and awaiting for acknowledgment. Packets that do not receive an acknowledgment within ResendDelay interval will be automatically resent.", "getSendQueueSize", null, "I"});
        mapInfo.put("SiteName", new Object[]{"A configured name that should be the same for Members that are on the same physical site (e.g. data center), and different for Members that are on different physical sites.", "getSiteName", null, "Ljava/lang/String;"});
        mapInfo.put("SocketCount", new Object[]{"Number of CPU sockets for the machine this Member is running on.", "getSocketCount", null, "I"});
        mapInfo.put("Statistics", new Object[]{"Statistics for this cluster node in a human readable format.", "getStatistics", null, "Ljava/lang/String;"});
        mapInfo.put("TcpRingFailures", new Object[]{"The number of recovered TcpRing disconnects since the node statistics were last reset. A recoverable disconnect is an abnormal event that is registered when the TcpRing peer drops the TCP connection, but recovers after no more then maximum configured number of attempts.This value will be -1 if the TcpRing is disabled.", "getTcpRingFailures", null, "J"});
        mapInfo.put("TcpRingTimeouts", new Object[]{"The number of TcpRing timeouts since the node statistics were last reset. A timeout is a normal, but relatively rare event that is registered when the TcpRing peer did not ping this node within a heartbeat interval. This value will be -1 if the TcpRing is disabled.", "getTcpRingTimeouts", null, "J"});
        mapInfo.put("Timestamp", new Object[]{"The date/time value (in cluster time) that this Member joined the cluster.", "getTimestamp", null, "Ljava/util/Date;"});
        mapInfo.put("TrafficJamCount", new Object[]{"The maximum total number of packets in the send and resend queues that forces the publisher to pause client threads. Zero means no limit.", "getTrafficJamCount", "setTrafficJamCount", "I"});
        mapInfo.put("TrafficJamDelay", new Object[]{"The number of milliseconds to pause client threads when a traffic jam condition has been reached. Anything less than one (e.g. zero) is treated as one millisecond.", "getTrafficJamDelay", "setTrafficJamDelay", "I"});
        mapInfo.put("UnicastAddress", new Object[]{"The IP address of the Member`s DatagramSocket for point-to-point communication.", "getUnicastAddress", null, "Ljava/lang/String;"});
        mapInfo.put("UnicastPort", new Object[]{"The port of the Member`s DatagramSocket for point-to-point communication.", "getUnicastPort", null, "I"});
        mapInfo.put("WeakestChannel", new Object[]{"The id of the cluster node to which this node is having the most difficulty communicating, or -1 if none is found.  A channel is considered to be weak if either the point-to-point publisher or receiver success rates are below 1.0.", "getWeakestChannel", null, "I"});
        mapInfo.put("WellKnownAddresses", new Object[]{"An array of well-known socket addresses that this Member uses to join the cluster.", "getWellKnownAddresses", null, "[Ljava/lang/String;"});
        return mapInfo;
    }

    public boolean isFlowControlEnabled() {
        return false;
    }

    public boolean isMulticastEnabled() {
        return false;
    }

    public boolean isNackEnabled() {
        return false;
    }

    public void resetStatistics() {
    }

    public void setBufferPublishSize(int cPackets) {
        this.__m_BufferPublishSize = cPackets;
    }

    public void setBufferReceiveSize(int cPackets) {
        this.__m_BufferReceiveSize = cPackets;
    }

    public void setBurstCount(int cPackets) {
        this.__m_BurstCount = cPackets;
    }

    public void setBurstDelay(int cDelay) {
        this.__m_BurstDelay = cDelay;
    }

    public void setLoggingFormat(String sFormat) {
        this.__m_LoggingFormat = sFormat;
    }

    public void setLoggingLevel(int nLevel) {
        this.__m_LoggingLevel = nLevel;
    }

    public void setLoggingLimit(int cChars) {
        this.__m_LoggingLimit = cChars;
    }

    public void setMulticastThreshold(int nThreshold) {
        this.__m_MulticastThreshold = nThreshold;
    }

    public void setResendDelay(int cDelay) {
        this.__m_ResendDelay = cDelay;
    }

    public void setSendAckDelay(int cDelay) {
        this.__m_SendAckDelay = cDelay;
    }

    public void setTrafficJamCount(int cPackets) {
        this.__m_TrafficJamCount = cPackets;
    }

    public void setTrafficJamDelay(int cDelay) {
        this.__m_TrafficJamDelay = cDelay;
    }

    public void shutdown() {
    }
}

