/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlSerializable;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.LiteMap;
import com.tangosol.util.SafeLinkedList;
import com.tangosol.util.WrapperException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ClusterConfig
extends Net
implements XmlSerializable {
    public static final int SHUTDOWN_FORCE = 1;
    public static final int SHUTDOWN_GRACEFUL = 2;
    public static final int SHUTDOWN_NONE = 0;
    private List __m_AuthorizedHostList;
    private int __m_ClusterAnnounceTimeout;
    private int __m_ClusterHeartbeatDelay;
    private String __m_ClusterName;
    private int __m_ClusterTimestampMaxVariance;
    private int __m_Edition;
    private transient String __m_EditionName;
    private Map __m_FilterConfigMap;
    private List __m_FilterList;
    private Map __m_FilterMap;
    private boolean __m_FlowControlEnabled;
    private InetAddress __m_GroupAddress;
    private transient String __m_GroupAddressString;
    private int __m_GroupBufferFactor;
    private InetAddress __m_GroupInterface;
    private transient String __m_GroupInterfaceString;
    private int __m_GroupListenerPriority;
    private int __m_GroupPort;
    private int __m_GroupTimeToLive;
    private InetAddress __m_LocalAddress;
    private transient String __m_LocalAddressString;
    private int __m_LocalBufferFactor;
    private int __m_LocalListenerPriority;
    private int __m_LocalMachineId;
    private int __m_LocalPort;
    private boolean __m_LocalPortAuto;
    private int __m_LostPacketThreshold;
    private String __m_MachineName;
    private String __m_MemberName;
    private int __m_MemberPriority;
    private int __m_Mode;
    private transient String __m_ModeName;
    private int __m_OutstandingPacketMaximum;
    private int __m_OutstandingPacketMinimum;
    private double __m_PacketBundlingAggression;
    private long __m_PacketBundlingThresholdNanos;
    private int __m_PacketMaxLength;
    private int __m_PacketPreferredLength;
    private String __m_ProcessName;
    private int __m_PublisherAckDelay;
    private int __m_PublisherBufferFactor;
    private int __m_PublisherBurstCount;
    private int __m_PublisherBurstDelay;
    private int __m_PublisherCloggedCount;
    private int __m_PublisherCloggedDelay;
    private int __m_PublisherGroupThreshold;
    private int __m_PublisherNackDelay;
    private int __m_PublisherPacketPoolCapacity;
    private int __m_PublisherPacketPoolInitialSize;
    private int __m_PublisherPriority;
    private int __m_PublisherResendDelay;
    private int __m_PublisherResendTimeout;
    private String __m_RackName;
    private boolean __m_ReadOnly;
    private boolean __m_ReceiverNackEnabled;
    private int __m_ReceiverPacketPoolCapacity;
    private int __m_ReceiverPacketPoolInitialSize;
    private int __m_ReceiverPriority;
    private String __m_RoleName;
    private Map __m_ServiceConfigMap;
    private Map __m_ServiceFilterMap;
    private Map __m_ServiceMap;
    private int __m_ShutdownHookOption;
    private String __m_SiteName;
    private int __m_SpeakerPriority;
    private int __m_SpeakerVolumeMinimum;
    private boolean __m_TcmpEnabled;
    private boolean __m_TcpRingEnabled;
    private int __m_TcpRingExceptionMaximum;
    private int __m_TcpRingPriority;
    private List __m_WellKnownAddressList;

    public ClusterConfig() {
        this(null, null, true);
    }

    public ClusterConfig(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setAuthorizedHostList((List)new SafeLinkedList());
            this.setFilterConfigMap((Map)new ListMap());
            this.setFilterList((List)new SafeLinkedList());
            this.setFilterMap((Map)new ListMap());
            this.setServiceConfigMap((Map)new LiteMap());
            this.setServiceFilterMap((Map)new LiteMap());
            this.setServiceMap((Map)new LiteMap());
            this.setWellKnownAddressList((List)new SafeLinkedList());
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    protected void addAuthorizedHostString(String sAddrFrom, String sAddrTo) {
        InetAddress addrTo;
        InetAddress addrFrom;
        if (sAddrFrom == null ? true : sAddrFrom.length() == 0) {
            Component._assert(sAddrTo == null ? true : sAddrTo.length() == 0, "Both <from-ip> and <to-ip> elements must be specifeid");
            return;
        }
        try {
            addrFrom = InetAddress.getByName(sAddrFrom);
            addrTo = sAddrTo == null ? addrFrom : InetAddress.getByName(sAddrTo);
        }
        catch (UnknownHostException e) {
            throw new WrapperException((Throwable)e);
        }
        long lFrom = InetAddressHelper.toLong((InetAddress)addrFrom);
        long lTo = InetAddressHelper.toLong((InetAddress)addrTo);
        if (lFrom > lTo) {
            throw new IllegalArgumentException(String.valueOf("Invalid IP range: [") + sAddrFrom + ", " + sAddrTo + ']');
        }
        this.getAuthorizedHostList().add(new long[]{lFrom, lTo});
    }

    protected void addWellKnownAddress(XmlElement xml) {
        String sAddr = xml.getSafeElement("address").getString();
        int nPort = xml.getSafeElement("port").getInt();
        if (!(sAddr.length() > 0) ? false : nPort != 0) {
            try {
                this.getWellKnownAddressList().add(new InetSocketAddress(InetAddress.getByName(sAddr), nPort));
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException((Throwable)e, (String)(String.valueOf("Address=") + sAddr));
            }
        }
    }

    protected void check() {
        if (!this.isReadOnly() ? false : this.is_Constructed()) {
            throw new IllegalStateException("ClusterConfig is read-only!");
        }
    }

    protected void checkPriority(int nPriority) {
        this.check();
        if (!(nPriority != 0) ? false : (nPriority < Thread.MIN_PRIORITY ? true : nPriority > Thread.MAX_PRIORITY)) {
            throw new IllegalArgumentException(String.valueOf("Invalid priority: ") + nPriority);
        }
    }

    protected void checkRange(int nValue, int nFrom, int nTo) {
        this.check();
        if (nValue < nFrom ? true : nValue > nTo) {
            throw new IllegalArgumentException(String.valueOf("Value out of range [") + nFrom + ", " + nTo + "]: " + nValue);
        }
    }

    public void fromXml(XmlElement xml) {
        Component._assert(xml.getName().equals("cluster-config"));
        XmlElement xmlCat = xml.getSafeElement("member-identity");
        this.setClusterName(xmlCat.getSafeElement("cluster-name").getString(this.getClusterName()));
        if (xml.getElement("cluster-name") != null) {
            Component._trace(String.valueOf("Starting with Coherence 3.2 the \"cluster-name\" element is located ") + "in the \"member-identity\" group; please modify your operational " + "configuration accordingly.", 3);
            String sNewValue = this.getClusterName();
            if (sNewValue == null ? true : sNewValue.length() == 0) {
                this.setClusterName(xml.getSafeElement("cluster-name").getString());
            }
        }
        this.setSiteName(xmlCat.getSafeElement("site-name").getString(this.getSiteName()));
        this.setRackName(xmlCat.getSafeElement("rack-name").getString(this.getRackName()));
        this.setMachineName(xmlCat.getSafeElement("machine-name").getString(this.getMachineName()));
        this.setProcessName(xmlCat.getSafeElement("process-name").getString(this.getProcessName()));
        this.setMemberName(xmlCat.getSafeElement("member-name").getString(this.getMemberName()));
        this.setRoleName(xmlCat.getSafeElement("role-name").getString(this.getRoleName()));
        this.setMemberPriority(xmlCat.getSafeElement("priority").getInt(this.getMemberPriority()));
        xmlCat = xml.getSafeElement("unicast-listener");
        this.setLocalMachineId(xmlCat.getSafeElement("machine-id").getInt(this.getLocalMachineId()));
        this.setLocalAddressString(xmlCat.getSafeElement("address").getString(this.getLocalAddressString()));
        this.setLocalPort(xmlCat.getSafeElement("port").getInt(this.getLocalPort()));
        this.setLocalPortAuto(xmlCat.getSafeElement("port-auto-adjust").getBoolean(this.isLocalPortAuto()));
        XmlElement xmlSub = xmlCat.getSafeElement("packet-buffer");
        this.setLocalBufferFactor(xmlSub.getSafeElement("maximum-packets").getInt(this.getLocalBufferFactor()));
        this.setLocalListenerPriority(xmlCat.getSafeElement("priority").getInt(this.getLocalListenerPriority()));
        Iterator iter = xmlCat.getSafeElement("well-known-addresses").getElements("socket-address");
        while (iter.hasNext()) {
            this.addWellKnownAddress((XmlElement)iter.next());
        }
        xmlCat = xml.getSafeElement("multicast-listener");
        this.setGroupInterfaceString(xmlCat.getSafeElement("interface").getString(this.getGroupInterfaceString()));
        this.setGroupAddressString(xmlCat.getSafeElement("address").getString(this.getGroupAddressString()));
        this.setGroupPort(xmlCat.getSafeElement("port").getInt(this.getGroupPort()));
        this.setGroupTimeToLive(xmlCat.getSafeElement("time-to-live").getInt(this.getGroupTimeToLive()));
        xmlSub = xmlCat.getSafeElement("packet-buffer");
        this.setGroupBufferFactor(xmlSub.getSafeElement("maximum-packets").getInt(this.getGroupBufferFactor()));
        this.setGroupListenerPriority(xmlCat.getSafeElement("priority").getInt(this.getGroupListenerPriority()));
        this.setClusterAnnounceTimeout(xmlCat.getSafeElement("join-timeout-milliseconds").getInt(this.getClusterAnnounceTimeout()));
        this.setPublisherGroupThreshold(xmlCat.getSafeElement("multicast-threshold-percent").getInt(this.getPublisherGroupThreshold()));
        xmlCat = xml.getSafeElement("tcp-ring-listener");
        this.setTcpRingEnabled(xmlCat.getSafeElement("enabled").getBoolean(this.isTcpRingEnabled()));
        this.setTcpRingPriority(xmlCat.getSafeElement("priority").getInt(this.getTcpRingPriority()));
        this.setTcpRingExceptionMaximum(xmlCat.getSafeElement("maximum-socket-closed-exceptions").getInt(this.getTcpRingExceptionMaximum()));
        xmlCat = xml.getSafeElement("shutdown-listener");
        String sShutdownOption = xmlCat.getSafeElement("enabled").getString();
        int nShutdownOption = this.getShutdownHookOption();
        if (sShutdownOption.equals("force") ? true : sShutdownOption.equals("true")) {
            nShutdownOption = SHUTDOWN_FORCE;
        } else if (sShutdownOption.equals("none") ? true : sShutdownOption.equals("false")) {
            nShutdownOption = SHUTDOWN_NONE;
        } else if (sShutdownOption.equals("graceful")) {
            nShutdownOption = SHUTDOWN_GRACEFUL;
        }
        this.setShutdownHookOption(nShutdownOption);
        xmlCat = xml.getSafeElement("packet-speaker");
        xmlSub = xmlCat.getSafeElement("volume-threshold");
        this.setSpeakerVolumeMinimum(xmlSub.getSafeElement("minimum-packets").getInt(this.getSpeakerVolumeMinimum()));
        this.setSpeakerPriority(xmlCat.getSafeElement("priority").getInt(this.getSpeakerPriority()));
        xmlCat = xml.getSafeElement("packet-publisher");
        xmlSub = xmlCat.getSafeElement("packet-size");
        this.setPacketMaxLength(xmlSub.getSafeElement("maximum-length").getInt(this.getPacketMaxLength()));
        this.setPacketPreferredLength(xmlSub.getSafeElement("preferred-length").getInt(this.getPacketPreferredLength()));
        xmlSub = xmlCat.getSafeElement("packet-delivery");
        this.setPublisherResendDelay(xmlSub.getSafeElement("resend-milliseconds").getInt(this.getPublisherResendDelay()));
        this.setPublisherResendTimeout(xmlSub.getSafeElement("timeout-milliseconds").getInt(this.getPublisherResendTimeout()));
        this.setClusterHeartbeatDelay(xmlSub.getSafeElement("heartbeat-milliseconds").getInt(this.getClusterHeartbeatDelay()));
        XmlElement xmlSub2 = xmlSub.getSafeElement("flow-control");
        this.setFlowControlEnabled(xmlSub2.getSafeElement("enabled").getBoolean(this.isFlowControlEnabled()));
        this.setLostPacketThreshold(xmlSub2.getSafeElement("pause-detection/maximum-packets").getInt(this.getLostPacketThreshold()));
        XmlElement xmlVal = xmlSub2.getSafeElement("outstanding-packets");
        this.setOutstandingPacketMaximum(xmlVal.getSafeElement("maximum-packets").getInt(this.getOutstandingPacketMaximum()));
        this.setOutstandingPacketMinimum(xmlVal.getSafeElement("minimum-packets").getInt(this.getOutstandingPacketMinimum()));
        xmlSub2 = xmlSub.getSafeElement("packet-bundling");
        String sTime = xmlSub2.getSafeElement("maximum-deferral-time").getString();
        if (sTime.length() > 0) {
            this.setPacketBundlingThresholdNanos(Base.parseTimeNanos((String)sTime));
        }
        this.setPacketBundlingAggression(xmlSub2.getSafeElement("aggression-factor").getDouble(this.getPacketBundlingAggression()));
        xmlSub = xmlCat.getSafeElement("notification-queueing");
        this.setPublisherAckDelay(xmlSub.getSafeElement("ack-delay-milliseconds").getInt(this.getPublisherAckDelay()));
        this.setPublisherNackDelay(xmlSub.getSafeElement("nack-delay-milliseconds").getInt(this.getPublisherNackDelay()));
        xmlSub = xmlCat.getSafeElement("burst-mode");
        this.setPublisherBurstCount(xmlSub.getSafeElement("maximum-packets").getInt(this.getPublisherBurstCount()));
        this.setPublisherBurstDelay(xmlSub.getSafeElement("pause-milliseconds").getInt(this.getPublisherBurstDelay()));
        xmlSub = xmlCat.getSafeElement("traffic-jam");
        this.setPublisherCloggedCount(xmlSub.getSafeElement("maximum-packets").getInt(this.getPublisherCloggedCount()));
        this.setPublisherCloggedDelay(xmlSub.getSafeElement("pause-milliseconds").getInt(this.getPublisherCloggedDelay()));
        xmlSub = xmlCat.getSafeElement("packet-buffer");
        this.setPublisherBufferFactor(xmlSub.getSafeElement("maximum-packets").getInt(this.getPublisherBufferFactor()));
        xmlSub = xmlCat.getSafeElement("packet-pool");
        this.setPublisherPacketPoolInitialSize(xmlSub.getSafeElement("minimum-packets").getInt(this.getPublisherPacketPoolInitialSize()));
        this.setPublisherPacketPoolCapacity(xmlSub.getSafeElement("maximum-packets").getInt(this.getPublisherPacketPoolCapacity()));
        this.setPublisherPriority(xmlCat.getSafeElement("priority").getInt(this.getPublisherPriority()));
        this.setTcmpEnabled(xmlCat.getSafeElement("enabled").getBoolean(this.isTcmpEnabled()));
        xmlCat = xml.getSafeElement("incoming-message-handler");
        this.setClusterTimestampMaxVariance(xmlCat.getSafeElement("maximum-time-variance").getInt(this.getClusterTimestampMaxVariance()));
        this.setReceiverNackEnabled(xmlCat.getSafeElement("use-nack-packets").getBoolean(this.isReceiverNackEnabled()));
        xmlSub = xmlCat.getSafeElement("packet-pool");
        this.setReceiverPacketPoolInitialSize(xmlSub.getSafeElement("minimum-packets").getInt(this.getReceiverPacketPoolInitialSize()));
        this.setReceiverPacketPoolCapacity(xmlSub.getSafeElement("maximum-packets").getInt(this.getReceiverPacketPoolCapacity()));
        this.setReceiverPriority(xmlCat.getSafeElement("priority").getInt(this.getReceiverPriority()));
        xmlCat = xml.getSafeElement("outgoing-message-handler");
        this.getFilterList().addAll(ClusterConfig.parseFilterList(xmlCat));
        xmlCat = xml.getSafeElement("authorized-hosts");
        Iterator iter2 = xmlCat.getElements("host-address");
        while (iter2.hasNext()) {
            xmlVal = (XmlElement)iter2.next();
            this.addAuthorizedHostString(xmlVal.getString(), null);
        }
        iter2 = xmlCat.getElements("host-range");
        while (iter2.hasNext()) {
            xmlVal = (XmlElement)iter2.next();
            this.addAuthorizedHostString(xmlVal.getSafeElement("from-address").getString(), xmlVal.getSafeElement("to-address").getString());
        }
        Map mapService = this.getServiceMap();
        Map mapServiceConfig = this.getServiceConfigMap();
        Map mapServiceFilter = this.getServiceFilterMap();
        mapService.clear();
        mapServiceConfig.clear();
        mapServiceFilter.clear();
        Iterator iter3 = xml.getSafeElement("services").getElements("service");
        while (iter3.hasNext()) {
            XmlElement xmlService = (XmlElement)iter3.next();
            String sType = xmlService.getSafeElement("service-type").getString();
            String sComponent = xmlService.getSafeElement("service-component").getString();
            mapService.put(sType, sComponent);
            mapServiceConfig.put(sType, ClusterConfig.transposeParams(xmlService));
            mapServiceFilter.put(sType, ClusterConfig.parseFilterList(xmlService));
        }
        Map mapFilter = this.getFilterMap();
        Map mapFilterConfig = this.getFilterConfigMap();
        mapFilter.clear();
        mapFilterConfig.clear();
        Iterator iter4 = xml.getSafeElement("filters").getElements("filter");
        while (iter4.hasNext()) {
            XmlElement xmlFilter = (XmlElement)iter4.next();
            String sName = xmlFilter.getSafeElement("filter-name").getString();
            String sClass = xmlFilter.getSafeElement("filter-class").getString();
            mapFilter.put(sName, sClass);
            mapFilterConfig.put(sName, ClusterConfig.transposeParams(xmlFilter));
        }
        String sEdition = xml.getSafeElement("edition-name").getString(this.getEditionName());
        String sMode = xml.getSafeElement("license-mode").getString(this.getModeName());
        this.setEditionName(sEdition);
        this.setModeName(sMode);
    }

    public List getAuthorizedHostList() {
        return this.__m_AuthorizedHostList;
    }

    public int getClusterAnnounceTimeout() {
        return this.__m_ClusterAnnounceTimeout;
    }

    public int getClusterHeartbeatDelay() {
        return this.__m_ClusterHeartbeatDelay;
    }

    public String getClusterName() {
        return this.__m_ClusterName;
    }

    public int getClusterTimestampMaxVariance() {
        return this.__m_ClusterTimestampMaxVariance;
    }

    public int[] getCounters() {
        int nMachineId = this.getLocalMachineId();
        if (nMachineId == 0) {
            try {
                InetAddress addr = InetAddressHelper.getLocalHost();
                long lAddr = InetAddressHelper.toLong((InetAddress)addr);
                nMachineId = (int)((lAddr & 0xFF000000L) >>> 24 & (long)255 ^ (lAddr & 0xFF0000L) >>> 16 & (long)255 ^ (lAddr & 0xFF00L) >>> 8 & (long)255) << 8 | (int)(lAddr & 0xFFL) & 0xFF;
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (nMachineId == 0) {
                nMachineId = 1;
            }
        }
        int nCpu = Runtime.getRuntime().availableProcessors();
        return new int[]{nCpu, nCpu, nMachineId};
    }

    public int getEdition() {
        return this.__m_Edition;
    }

    public String getEditionName() {
        return Coherence.EDITION_NAMES[this.getEdition()];
    }

    public Map getFilterConfigMap() {
        return this.__m_FilterConfigMap;
    }

    public List getFilterList() {
        return this.__m_FilterList;
    }

    public Map getFilterMap() {
        return this.__m_FilterMap;
    }

    public InetAddress getGroupAddress() {
        return this.__m_GroupAddress;
    }

    public String getGroupAddressString() {
        InetAddress addr = this.getGroupAddress();
        return addr == null ? null : addr.getHostAddress();
    }

    public int getGroupBufferFactor() {
        return this.__m_GroupBufferFactor;
    }

    public InetAddress getGroupInterface() {
        return this.__m_GroupInterface;
    }

    public String getGroupInterfaceString() {
        InetAddress addr = this.getGroupInterface();
        return addr == null ? null : addr.getHostAddress();
    }

    public int getGroupListenerPriority() {
        return this.__m_GroupListenerPriority;
    }

    public int getGroupPort() {
        return this.__m_GroupPort;
    }

    public int getGroupTimeToLive() {
        return this.__m_GroupTimeToLive;
    }

    public InetAddress getLocalAddress() {
        return this.__m_LocalAddress;
    }

    public String getLocalAddressString() {
        InetAddress addr = this.getLocalAddress();
        return addr == null ? null : addr.getHostAddress();
    }

    public int getLocalBufferFactor() {
        return this.__m_LocalBufferFactor;
    }

    public int getLocalListenerPriority() {
        return this.__m_LocalListenerPriority;
    }

    public int getLocalMachineId() {
        return this.__m_LocalMachineId;
    }

    public int getLocalPort() {
        return this.__m_LocalPort;
    }

    public int getLostPacketThreshold() {
        return this.__m_LostPacketThreshold;
    }

    public String getMachineName() {
        return this.__m_MachineName;
    }

    public String getMemberName() {
        return this.__m_MemberName;
    }

    public int getMemberPriority() {
        return this.__m_MemberPriority;
    }

    public int getMode() {
        return this.__m_Mode;
    }

    public String getModeName() {
        return Coherence.MODE_NAMES[this.getMode()];
    }

    public int getOutstandingPacketMaximum() {
        return this.__m_OutstandingPacketMaximum;
    }

    public int getOutstandingPacketMinimum() {
        return this.__m_OutstandingPacketMinimum;
    }

    public double getPacketBundlingAggression() {
        return this.__m_PacketBundlingAggression;
    }

    public long getPacketBundlingThresholdNanos() {
        return this.__m_PacketBundlingThresholdNanos;
    }

    public int getPacketMaxLength() {
        return this.__m_PacketMaxLength;
    }

    public int getPacketPreferredLength() {
        return this.__m_PacketPreferredLength;
    }

    public String getProcessName() {
        return this.__m_ProcessName;
    }

    public int getPublisherAckDelay() {
        return this.__m_PublisherAckDelay;
    }

    public int getPublisherBufferFactor() {
        return this.__m_PublisherBufferFactor;
    }

    public int getPublisherBurstCount() {
        return this.__m_PublisherBurstCount;
    }

    public int getPublisherBurstDelay() {
        return this.__m_PublisherBurstDelay;
    }

    public int getPublisherCloggedCount() {
        return this.__m_PublisherCloggedCount;
    }

    public int getPublisherCloggedDelay() {
        return this.__m_PublisherCloggedDelay;
    }

    public int getPublisherGroupThreshold() {
        return this.__m_PublisherGroupThreshold;
    }

    public int getPublisherNackDelay() {
        return this.__m_PublisherNackDelay;
    }

    public int getPublisherPacketPoolCapacity() {
        return this.__m_PublisherPacketPoolCapacity;
    }

    public int getPublisherPacketPoolInitialSize() {
        return this.__m_PublisherPacketPoolInitialSize;
    }

    public int getPublisherPriority() {
        return this.__m_PublisherPriority;
    }

    public int getPublisherResendDelay() {
        return this.__m_PublisherResendDelay;
    }

    public int getPublisherResendTimeout() {
        return this.__m_PublisherResendTimeout;
    }

    public String getRackName() {
        return this.__m_RackName;
    }

    public int getReceiverPacketPoolCapacity() {
        return this.__m_ReceiverPacketPoolCapacity;
    }

    public int getReceiverPacketPoolInitialSize() {
        return this.__m_ReceiverPacketPoolInitialSize;
    }

    public int getReceiverPriority() {
        return this.__m_ReceiverPriority;
    }

    public String getRoleName() {
        return this.__m_RoleName;
    }

    public Map getServiceConfigMap() {
        return this.__m_ServiceConfigMap;
    }

    public Map getServiceFilterMap() {
        return this.__m_ServiceFilterMap;
    }

    public Map getServiceMap() {
        return this.__m_ServiceMap;
    }

    public int getShutdownHookOption() {
        return this.__m_ShutdownHookOption;
    }

    public String getSiteName() {
        return this.__m_SiteName;
    }

    public int getSpeakerPriority() {
        return this.__m_SpeakerPriority;
    }

    public int getSpeakerVolumeMinimum() {
        return this.__m_SpeakerVolumeMinimum;
    }

    public int getTcpRingExceptionMaximum() {
        return this.__m_TcpRingExceptionMaximum;
    }

    public int getTcpRingPriority() {
        return this.__m_TcpRingPriority;
    }

    public List getWellKnownAddressList() {
        return this.__m_WellKnownAddressList;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/ClusterConfig".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new ClusterConfig();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isAuthorizedHost(InetAddress addr) {
        List listHost = this.getAuthorizedHostList();
        if (listHost == null ? true : listHost.isEmpty()) {
            return true;
        }
        long lAddr = InetAddressHelper.toLong((InetAddress)addr);
        Iterator iter = listHost.iterator();
        while (iter.hasNext()) {
            long[] alAddr = (long[])iter.next();
            if (!(!(alAddr[0] <= lAddr) ? false : lAddr <= alAddr[1])) continue;
            return true;
        }
        return false;
    }

    public boolean isConfigured() {
        return true;
    }

    public boolean isFlowControlEnabled() {
        return this.__m_FlowControlEnabled;
    }

    public boolean isLocalPortAuto() {
        return this.__m_LocalPortAuto;
    }

    public boolean isReadOnly() {
        return this.__m_ReadOnly;
    }

    public boolean isReceiverNackEnabled() {
        return this.__m_ReceiverNackEnabled;
    }

    public boolean isTcmpEnabled() {
        return this.__m_TcmpEnabled;
    }

    public boolean isTcpRingEnabled() {
        return this.__m_TcpRingEnabled;
    }

    public static List parseFilterList(XmlElement xml) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator iter = xml.getSafeElement("use-filters").getElements("filter-name");
        while (iter.hasNext()) {
            String sName = ((XmlElement)iter.next()).getString();
            if (!(sName.length() > 0)) continue;
            list.add(sName);
        }
        return list.size() == 0 ? Collections.EMPTY_LIST : list;
    }

    protected void setAuthorizedHostList(List list) {
        this.__m_AuthorizedHostList = list;
    }

    public void setClusterAnnounceTimeout(int cMillis) {
        this.checkRange(cMillis, 1000, 1000000);
        this.__m_ClusterAnnounceTimeout = cMillis;
    }

    public void setClusterHeartbeatDelay(int cMillis) {
        this.checkRange(cMillis, 100, 60000);
        this.__m_ClusterHeartbeatDelay = cMillis;
    }

    public void setClusterName(String sClusterName) {
        if (!(sClusterName != null) ? false : sClusterName.length() > 32) {
            throw new IllegalArgumentException("Cluster names are limited to 32 characters in length.");
        }
        this.__m_ClusterName = sClusterName;
    }

    public void setClusterTimestampMaxVariance(int cMillis) {
        this.checkRange(cMillis, 1, 1000);
        this.__m_ClusterTimestampMaxVariance = cMillis;
    }

    public void setEdition(int n) {
        this.checkRange(n, 0, 5);
        this.__m_Edition = n;
    }

    public void setEditionName(String sName) {
        this.setEdition(Coherence.parseEditionName(sName));
    }

    protected void setFilterConfigMap(Map map) {
        this.__m_FilterConfigMap = map;
    }

    protected void setFilterList(List list) {
        this.__m_FilterList = list;
    }

    protected void setFilterMap(Map map) {
        this.__m_FilterMap = map;
    }

    public void setFlowControlEnabled(boolean pFlowControlEnabled) {
        this.__m_FlowControlEnabled = pFlowControlEnabled;
    }

    public void setGroupAddress(InetAddress addr) {
        this.check();
        if (!(addr != null) ? false : addr.isMulticastAddress() ^ true) {
            throw new IllegalArgumentException(String.valueOf("Invalid multicast address: ") + addr.getHostAddress());
        }
        this.__m_GroupAddress = addr;
    }

    public void setGroupAddressString(String sAddr) {
        if (Base.equals((Object)sAddr, (Object)this.getGroupAddressString())) {
            return;
        }
        InetAddress addr = null;
        if (!(sAddr != null) ? false : sAddr.trim().length() > 0) {
            try {
                addr = InetAddress.getByName(sAddr);
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException((Throwable)e, (String)(String.valueOf("Address=") + sAddr));
            }
        }
        this.setGroupAddress(addr);
        this.__m_GroupAddressString = sAddr;
    }

    public void setGroupBufferFactor(int cPackets) {
        this.checkRange(cPackets, 1, Integer.MAX_VALUE);
        this.__m_GroupBufferFactor = cPackets;
    }

    public void setGroupInterface(InetAddress addr) {
        this.check();
        if (!(addr != null) ? false : addr.isMulticastAddress()) {
            throw new IllegalArgumentException(String.valueOf("Invalid interface address: ") + addr.getHostAddress());
        }
        this.__m_GroupInterface = addr;
    }

    public void setGroupInterfaceString(String sAddr) {
        if (Base.equals((Object)sAddr, (Object)this.getGroupInterfaceString())) {
            return;
        }
        InetAddress addr = null;
        if (!(sAddr != null) ? false : sAddr.trim().length() > 0) {
            try {
                addr = InetAddress.getByName(sAddr);
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException((Throwable)e, (String)(String.valueOf("Address=") + sAddr));
            }
        }
        this.setGroupInterface(addr);
        this.__m_GroupInterfaceString = sAddr;
    }

    public void setGroupListenerPriority(int nPriority) {
        this.checkPriority(nPriority);
        this.__m_GroupListenerPriority = nPriority;
    }

    public void setGroupPort(int nPort) {
        this.checkRange(nPort, 1, 65536);
        this.__m_GroupPort = nPort;
    }

    public void setGroupTimeToLive(int cHops) {
        this.checkRange(cHops, 0, 255);
        this.__m_GroupTimeToLive = cHops;
    }

    public void setLocalAddress(InetAddress addr) {
        this.check();
        if (addr.isMulticastAddress()) {
            throw new IllegalArgumentException(String.valueOf("Invalid local address: ") + addr.getHostAddress());
        }
        this.__m_LocalAddress = addr;
    }

    public void setLocalAddressString(String sAddr) {
        InetAddress addr;
        if (Base.equals((Object)sAddr, (Object)this.getLocalAddressString())) {
            return;
        }
        try {
            if (sAddr.equals("localhost")) {
                addr = InetAddressHelper.getLocalHost();
            } else {
                addr = InetAddress.getByName(sAddr);
                if (InetAddressHelper.isLoopbackAddress((InetAddress)addr)) {
                    Component._trace(String.valueOf("Specified local address \"") + sAddr + "\" is a loopback address" + "; switching to the 'localhost' instead", 4);
                    addr = InetAddressHelper.getLocalHost();
                } else {
                    byte[] abAddr = addr.getAddress();
                    if (abAddr.length == 16) {
                        boolean fSuspect = true;
                        List listLocal = InetAddressHelper.getAllLocalAddresses();
                        Iterator iter = listLocal.iterator();
                        while (iter.hasNext()) {
                            InetAddress addrLocal = (InetAddress)iter.next();
                            if (!InetAddressHelper.virtuallyEqual((byte[])addrLocal.getAddress(), (byte[])abAddr)) continue;
                            fSuspect = false;
                            break;
                        }
                        if (fSuspect) {
                            Component._trace(String.valueOf("Local IPv6 address \"") + InetAddressHelper.toString((InetAddress)addr) + "\" does not correspond to any of the local interface addresses; " + "this cluster node may not be reachable by IPv4-bound nodes", 2);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException((Throwable)e, (String)(String.valueOf("Address=") + sAddr));
        }
        this.setLocalAddress(addr);
        this.__m_LocalAddressString = sAddr;
    }

    public void setLocalBufferFactor(int cPackets) {
        this.checkRange(cPackets, 1, Integer.MAX_VALUE);
        this.__m_LocalBufferFactor = cPackets;
    }

    public void setLocalListenerPriority(int nPriority) {
        this.check();
        this.checkPriority(nPriority);
        this.__m_LocalListenerPriority = nPriority;
    }

    public void setLocalMachineId(int nId) {
        this.checkRange(nId, 0, 65535);
        this.__m_LocalMachineId = nId;
    }

    public void setLocalPort(int nPort) {
        this.checkRange(nPort, 1, 65535);
        this.__m_LocalPort = nPort;
    }

    public void setLocalPortAuto(boolean fAuto) {
        this.check();
        this.__m_LocalPortAuto = fAuto;
    }

    public void setLostPacketThreshold(int cPackets) {
        this.checkRange(cPackets, 0, 65535);
        this.__m_LostPacketThreshold = cPackets;
    }

    public void setMachineName(String sName) {
        if (!(sName != null) ? false : sName.length() > 32) {
            throw new IllegalArgumentException("Machine name is limited to 32 characters in length.");
        }
        this.__m_MachineName = sName;
    }

    public void setMemberName(String sName) {
        if (!(sName != null) ? false : sName.length() > 32) {
            throw new IllegalArgumentException("Member name is limited to 32 characters in length.");
        }
        this.__m_MemberName = sName;
    }

    public void setMemberPriority(int nPriority) {
        this.check();
        this.checkPriority(nPriority);
        this.__m_MemberPriority = nPriority;
    }

    public void setMode(int n) {
        this.checkRange(n, 0, 2);
        this.__m_Mode = n;
    }

    public void setModeName(String sName) {
        this.setMode(Coherence.parseModeName(sName));
    }

    public void setOutstandingPacketMaximum(int cPackets) {
        this.checkRange(cPackets, 1, 65535);
        this.__m_OutstandingPacketMaximum = cPackets;
    }

    public void setOutstandingPacketMinimum(int cPackets) {
        this.checkRange(cPackets, 1, this.getOutstandingPacketMaximum());
        this.__m_OutstandingPacketMinimum = cPackets;
    }

    public void setPacketBundlingAggression(double dAggression) {
        this.checkRange((int)dAggression, 0, 1000);
        this.__m_PacketBundlingAggression = dAggression;
    }

    public void setPacketBundlingThresholdNanos(long cNanos) {
        this.__m_PacketBundlingThresholdNanos = cNanos;
    }

    public void setPacketMaxLength(int cbMax) {
        this.checkRange(cbMax, 256, 65535);
        this.__m_PacketMaxLength = cbMax;
    }

    public void setPacketPreferredLength(int cb) {
        this.checkRange(cb, 256, this.getPacketMaxLength());
        this.__m_PacketPreferredLength = cb;
    }

    public void setProcessName(String sName) {
        if (sName == null) {
            try {
                Class<?> clz = Class.forName("java.lang.management.ManagementFactory");
                Object oRT = ClassHelper.invokeStatic(clz, (String)"getRuntimeMXBean", (Object[])ClassHelper.VOID);
                sName = (String)ClassHelper.invoke((Object)oRT, (String)"getName", (Object[])ClassHelper.VOID);
                if (sName.length() > 32) {
                    sName = sName.substring(0, 32);
                }
            }
            catch (Throwable throwable) {}
        } else if (sName.length() > 32) {
            throw new IllegalArgumentException("Process name is limited to 32 characters in length.");
        }
        this.__m_ProcessName = sName;
    }

    public void setPublisherAckDelay(int cMillis) {
        this.checkRange(cMillis, 0, 60000);
        this.__m_PublisherAckDelay = cMillis;
    }

    public void setPublisherBufferFactor(int cPackets) {
        this.checkRange(cPackets, 1, Integer.MAX_VALUE);
        this.__m_PublisherBufferFactor = cPackets;
    }

    public void setPublisherBurstCount(int cMax) {
        this.checkRange(cMax, 0, 65535);
        this.__m_PublisherBurstCount = cMax;
    }

    public void setPublisherBurstDelay(int cMillis) {
        this.checkRange(cMillis, 0, 60000);
        this.__m_PublisherBurstDelay = cMillis;
    }

    public void setPublisherCloggedCount(int cMax) {
        this.checkRange(cMax, 0, 65535);
        this.__m_PublisherCloggedCount = cMax;
    }

    public void setPublisherCloggedDelay(int cMillis) {
        this.checkRange(cMillis, 0, 60000);
        this.__m_PublisherCloggedDelay = cMillis;
    }

    public void setPublisherGroupThreshold(int cPercent) {
        this.checkRange(cPercent, 0, 100);
        this.__m_PublisherGroupThreshold = cPercent;
    }

    public void setPublisherNackDelay(int cMillis) {
        this.checkRange(cMillis, 0, 60000);
        this.__m_PublisherNackDelay = cMillis;
    }

    public void setPublisherPacketPoolCapacity(int cSize) {
        this.checkRange(cSize, 1, 10000);
        this.__m_PublisherPacketPoolCapacity = cSize;
    }

    public void setPublisherPacketPoolInitialSize(int cSize) {
        this.checkRange(cSize, 1, 10000);
        this.__m_PublisherPacketPoolInitialSize = cSize;
    }

    public void setPublisherPriority(int nPriority) {
        this.checkPriority(nPriority);
        this.__m_PublisherPriority = nPriority;
    }

    public void setPublisherResendDelay(int cMillis) {
        this.checkRange(cMillis, 10, 1000);
        this.__m_PublisherResendDelay = cMillis;
    }

    public void setPublisherResendTimeout(int cMillis) {
        this.checkRange(cMillis, 1000, 1000000);
        this.__m_PublisherResendTimeout = cMillis;
    }

    public void setRackName(String sName) {
        if (!(sName != null) ? false : sName.length() > 32) {
            throw new IllegalArgumentException("Rack name is limited to 32 characters in length.");
        }
        this.__m_RackName = sName;
    }

    public void setReadOnly(boolean fReadOnly) {
        this.check();
        Iterator iter = this.getServiceFilterMap().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            List list = (List)entry.getValue();
            if (!(list != null)) continue;
            entry.setValue(Collections.unmodifiableList(list));
        }
        this.setFilterList(Collections.unmodifiableList(this.getFilterList()));
        this.setFilterMap(Collections.unmodifiableMap(this.getFilterMap()));
        this.setFilterConfigMap(Collections.unmodifiableMap(this.getFilterConfigMap()));
        this.setServiceMap(Collections.unmodifiableMap(this.getServiceMap()));
        this.setServiceFilterMap(Collections.unmodifiableMap(this.getServiceFilterMap()));
        this.setServiceConfigMap(Collections.unmodifiableMap(this.getServiceConfigMap()));
        this.__m_ReadOnly = fReadOnly;
    }

    public void setReceiverNackEnabled(boolean fRequest) {
        this.check();
        this.__m_ReceiverNackEnabled = fRequest;
    }

    public void setReceiverPacketPoolCapacity(int cSize) {
        this.checkRange(cSize, 1, 10000);
        this.__m_ReceiverPacketPoolCapacity = cSize;
    }

    public void setReceiverPacketPoolInitialSize(int cSize) {
        this.checkRange(cSize, 1, 10000);
        this.__m_ReceiverPacketPoolInitialSize = cSize;
    }

    public void setReceiverPriority(int nPriority) {
        this.checkPriority(nPriority);
        this.__m_ReceiverPriority = nPriority;
    }

    public void setRoleName(String sName) {
        if (!(sName != null) ? false : sName.length() > 32) {
            throw new IllegalArgumentException("Role name is limited to 32 characters in length.");
        }
        this.__m_RoleName = sName;
    }

    protected void setServiceConfigMap(Map map) {
        this.__m_ServiceConfigMap = map;
    }

    protected void setServiceFilterMap(Map map) {
        this.__m_ServiceFilterMap = map;
    }

    protected void setServiceMap(Map map) {
        this.__m_ServiceMap = map;
    }

    public void setShutdownHookOption(int nOption) {
        this.check();
        this.__m_ShutdownHookOption = nOption;
    }

    public void setSiteName(String sName) {
        if (!(sName != null) ? false : sName.length() > 32) {
            throw new IllegalArgumentException("Site name is limited to 32 characters in length.");
        }
        this.__m_SiteName = sName;
    }

    public void setSpeakerPriority(int nPriority) {
        this.checkPriority(nPriority);
        this.__m_SpeakerPriority = nPriority;
    }

    public void setSpeakerVolumeMinimum(int iVolume) {
        this.__m_SpeakerVolumeMinimum = iVolume;
    }

    public void setTcmpEnabled(boolean fEnabled) {
        this.check();
        this.__m_TcmpEnabled = fEnabled;
    }

    public void setTcpRingEnabled(boolean fEnabled) {
        this.check();
        this.__m_TcpRingEnabled = fEnabled;
    }

    public void setTcpRingExceptionMaximum(int cExceptions) {
        this.checkRange(cExceptions, 0, 255);
        this.__m_TcpRingExceptionMaximum = cExceptions;
    }

    public void setTcpRingPriority(int nPriority) {
        this.checkPriority(nPriority);
        this.__m_TcpRingPriority = nPriority;
    }

    protected void setWellKnownAddressList(List list) {
        this.__m_WellKnownAddressList = list;
    }

    public String toString() {
        XmlElement xml = this.toXml();
        xml.addAttribute("read-only").setBoolean(this.isReadOnly());
        xml.addAttribute("configured").setBoolean(this.isConfigured());
        xml.addAttribute("edition-name").setString(this.getEditionName());
        xml.addAttribute("license-mode").setString(this.getModeName());
        return xml.toString();
    }

    public XmlElement toXml() {
        String sOption;
        SimpleElement xml = new SimpleElement("cluster-config");
        if (this.getClusterName() != null) {
            xml.ensureElement("member-identity/cluster-name").setString(this.getClusterName());
        }
        if (this.getSiteName() != null) {
            xml.ensureElement("member-identity/site-name").setString(this.getSiteName());
        }
        if (this.getRackName() != null) {
            xml.ensureElement("member-identity/rack-name").setString(this.getRackName());
        }
        if (this.getMachineName() != null) {
            xml.ensureElement("member-identity/machine-name").setString(this.getMachineName());
        }
        if (this.getProcessName() != null) {
            xml.ensureElement("member-identity/jvm-name").setString(this.getProcessName());
        }
        if (this.getMemberName() != null) {
            xml.ensureElement("member-identity/member-name").setString(this.getMemberName());
        }
        if (this.getRoleName() != null) {
            xml.ensureElement("member-identity/role-name").setString(this.getRoleName());
        }
        xml.ensureElement("member-identity/priority").setInt(this.getMemberPriority());
        if (this.getLocalMachineId() != 0) {
            xml.ensureElement("unicast-listener/machine-id").setInt(this.getLocalMachineId());
        }
        if (this.getLocalAddressString() != null) {
            xml.ensureElement("unicast-listener/address").setString(this.getLocalAddressString());
        }
        xml.ensureElement("unicast-listener/port").setInt(this.getLocalPort());
        xml.ensureElement("unicast-listener/port-auto-adjust").setBoolean(this.isLocalPortAuto());
        xml.ensureElement("unicast-listener/packet-buffer/maximum-packets").setInt(this.getLocalBufferFactor());
        xml.ensureElement("unicast-listener/priority").setInt(this.getLocalListenerPriority());
        if (this.getGroupInterfaceString() != null) {
            xml.ensureElement("multicast-listener/interface").setString(this.getGroupInterfaceString());
        }
        if (this.getGroupAddressString() != null) {
            xml.ensureElement("multicast-listener/address").setString(this.getGroupAddressString());
        }
        xml.ensureElement("multicast-listener/port").setInt(this.getGroupPort());
        xml.ensureElement("multicast-listener/time-to-live").setInt(this.getGroupTimeToLive());
        xml.ensureElement("multicast-listener/packet-buffer/maximum-packets").setInt(this.getGroupBufferFactor());
        xml.ensureElement("multicast-listener/priority").setInt(this.getGroupListenerPriority());
        xml.ensureElement("multicast-listener/join-timeout-milliseconds").setInt(this.getClusterAnnounceTimeout());
        xml.ensureElement("multicast-listener/multicast-threshold-percent").setInt(this.getPublisherGroupThreshold());
        xml.ensureElement("tcp-ring-listener/enabled").setBoolean(this.isTcpRingEnabled());
        xml.ensureElement("tcp-ring-listener/maximum-socket-closed-exceptions").setInt(this.getTcpRingExceptionMaximum());
        xml.ensureElement("tcp-ring-listener/priority").setInt(this.getTcpRingPriority());
        switch (this.getShutdownHookOption()) {
            default: {
                sOption = "none";
                break;
            }
            case 1: {
                sOption = "force";
                break;
            }
            case 2: {
                sOption = "graceful";
                break;
            }
        }
        xml.ensureElement("shutdown-listener/enabled").setString(sOption);
        xml.ensureElement("packet-speaker/volume-threshold/minimum-packets").setInt(this.getSpeakerVolumeMinimum());
        xml.ensureElement("packet-speaker/priority").setInt(this.getSpeakerPriority());
        xml.ensureElement("packet-publisher/packet-size/maximum-length").setInt(this.getPacketMaxLength());
        xml.ensureElement("packet-publisher/packet-size/preferred-length").setInt(this.getPacketPreferredLength());
        xml.ensureElement("packet-publisher/packet-delivery/resend-milliseconds").setInt(this.getPublisherResendDelay());
        xml.ensureElement("packet-publisher/packet-delivery/timeout-milliseconds").setInt(this.getPublisherResendTimeout());
        xml.ensureElement("packet-publisher/packet-delivery/heartbeat-milliseconds").setInt(this.getClusterHeartbeatDelay());
        xml.ensureElement("packet-publisher/packet-delivery/flow-control/enabled").setBoolean(this.isFlowControlEnabled());
        xml.ensureElement("packet-publisher/packet-delivery/flow-control/pause-detection/maximum-packets").setInt(this.getLostPacketThreshold());
        xml.ensureElement("packet-publisher/packet-delivery/flow-control/outstanding-packets/minimum-packets").setInt(this.getOutstandingPacketMinimum());
        xml.ensureElement("packet-publisher/packet-delivery/flow-control/outstanding-packets/maximum-packets").setInt(this.getOutstandingPacketMaximum());
        xml.ensureElement("packet-publisher/packet-delivery/packet-bundling/maximum-deferral-time").setLong(this.getPacketBundlingThresholdNanos());
        xml.ensureElement("packet-publisher/packet-delivery/packet-bundling/aggression-factor").setDouble(this.getPacketBundlingAggression());
        xml.ensureElement("packet-publisher/notification-queueing/ack-delay-milliseconds").setInt(this.getPublisherAckDelay());
        xml.ensureElement("packet-publisher/notification-queueing/nack-delay-milliseconds").setInt(this.getPublisherNackDelay());
        xml.ensureElement("packet-publisher/burst-mode/maximum-packets").setInt(this.getPublisherBurstCount());
        xml.ensureElement("packet-publisher/burst-mode/pause-milliseconds").setInt(this.getPublisherBurstDelay());
        xml.ensureElement("packet-publisher/traffic-jam/maximum-packets").setInt(this.getPublisherCloggedCount());
        xml.ensureElement("packet-publisher/traffic-jam/pause-milliseconds").setInt(this.getPublisherCloggedDelay());
        xml.ensureElement("packet-publisher/packet-buffer/maximum-packets").setInt(this.getPublisherBufferFactor());
        xml.ensureElement("packet-publisher/packet-pool/minimum-packets").setInt(this.getPublisherPacketPoolInitialSize());
        xml.ensureElement("packet-publisher/packet-pool/maximum-packets").setInt(this.getPublisherPacketPoolCapacity());
        xml.ensureElement("packet-publisher/priority").setInt(this.getPublisherPriority());
        xml.ensureElement("packet-publisher/enabled").setBoolean(this.isTcmpEnabled());
        xml.ensureElement("incoming-message-handler/maximum-time-variance").setInt(this.getClusterTimestampMaxVariance());
        xml.ensureElement("incoming-message-handler/use-nack-packets").setBoolean(this.isReceiverNackEnabled());
        xml.ensureElement("incoming-message-handler/packet-pool/minimum-packets").setInt(this.getReceiverPacketPoolInitialSize());
        xml.ensureElement("incoming-message-handler/packet-pool/maximum-packets").setInt(this.getReceiverPacketPoolCapacity());
        xml.ensureElement("incoming-message-handler/priority").setInt(this.getReceiverPriority());
        if (this.getFilterList().isEmpty() ^ true) {
            XmlElement xmlList = xml.ensureElement("outgoing-message-handler/use-filters");
            Iterator iter = this.getFilterList().iterator();
            while (iter.hasNext()) {
                xmlList.addElement("filter-name").setString((String)iter.next());
            }
        }
        XmlElement xmlServices = xml.addElement("services");
        Map mapServices = this.getServiceMap();
        Map mapServiceFilters = this.getServiceFilterMap();
        Map mapServiceConfigs = this.getServiceConfigMap();
        Iterator iterService = mapServices.entrySet().iterator();
        while (iterService.hasNext()) {
            Iterator iter;
            Map.Entry entry = (Map.Entry)iterService.next();
            String sName = (String)entry.getKey();
            String sComponent = (String)entry.getValue();
            List listFilter = (List)mapServiceFilters.get(sName);
            XmlElement xmlConfig = (XmlElement)mapServiceConfigs.get(sName);
            XmlElement xmlService = xmlServices.addElement("service");
            xmlService.addElement("service-type").setString(sName);
            xmlService.addElement("service-component").setString(sComponent);
            if (!(listFilter != null) ? false : listFilter.isEmpty() ^ true) {
                XmlElement xmlFilters = xmlService.addElement("use-filters");
                iter = listFilter.iterator();
                while (iter.hasNext()) {
                    String sFilter = (String)iter.next();
                    xmlFilters.addElement("filter-name").setString(sFilter);
                }
            }
            if (!(!(xmlConfig != null) ? false : xmlConfig.getElementList().isEmpty() ^ true)) continue;
            XmlElement xmlParams = xmlService.addElement("init-params");
            iter = xmlConfig.getElementList().iterator();
            while (iter.hasNext()) {
                XmlElement xmlSetting = (XmlElement)iter.next();
                XmlElement xmlParam = xmlParams.addElement("init-param");
                xmlParam.addElement("param-name").setString(xmlSetting.getName());
                xmlParam.addElement("param-value").setString(xmlSetting.getString());
            }
        }
        XmlElement xmlFilters = xml.addElement("filters");
        Map mapFilters = this.getFilterMap();
        Map mapFilterConfigs = this.getFilterConfigMap();
        Iterator iterFilter = mapFilters.entrySet().iterator();
        while (iterFilter.hasNext()) {
            Map.Entry entry = (Map.Entry)iterFilter.next();
            String sName = (String)entry.getKey();
            String sClass = (String)entry.getValue();
            XmlElement xmlConfig = (XmlElement)mapFilterConfigs.get(sName);
            XmlElement xmlFilter = xmlFilters.addElement("filter");
            xmlFilter.addElement("filter-name").setString(sName);
            xmlFilter.addElement("filter-class").setString(sClass);
            if (!(!(xmlConfig != null) ? false : xmlConfig.getElementList().isEmpty() ^ true)) continue;
            XmlElement xmlParams = xmlFilter.addElement("init-params");
            Iterator iter = xmlConfig.getElementList().iterator();
            while (iter.hasNext()) {
                XmlElement xmlSetting = (XmlElement)iter.next();
                XmlElement xmlParam = xmlParams.addElement("init-param");
                xmlParam.addElement("param-name").setString(xmlSetting.getName());
                xmlParam.addElement("param-value").setString(xmlSetting.getString());
            }
        }
        return xml;
    }

    public static XmlElement transposeParams(XmlElement xml) {
        SimpleElement xmlConfig = new SimpleElement("config");
        Iterator iterParams = xml.getSafeElement("init-params").getElements("init-param");
        while (iterParams.hasNext()) {
            XmlElement xmlParam = (XmlElement)iterParams.next();
            String sParam = xmlParam.getSafeElement("param-name").getString("param");
            String sValue = xmlParam.getSafeElement("param-value").getString();
            xmlConfig.ensureElement(sParam).setString(sValue);
        }
        return xmlConfig;
    }
}

