/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.packet.NotifyPacket;
import com.tangosol.coherence.component.net.packet.messagePacket.Broadcast;
import com.tangosol.coherence.component.net.packet.messagePacket.Directed;
import com.tangosol.coherence.component.net.packet.messagePacket.Sequel;
import com.tangosol.coherence.component.net.packet.notifyPacket.Ack;
import com.tangosol.coherence.component.net.packet.notifyPacket.Request;
import com.tangosol.util.Base;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.sql.Time;

public abstract class Packet
extends Net {
    public static final int TRINT_DOMAIN_SPAN = 0x1000000;
    public static final int TRINT_MAX_VALUE = 0xFFFFFF;
    public static final int TRINT_MAX_VARIANCE = 0x800000;
    public static final int TYPE_ACK = 232718545;
    public static final int TYPE_BROADCAST = 232718546;
    public static final int TYPE_DIRECTED_FEW = 232718547;
    public static final int TYPE_DIRECTED_MANY = 232718548;
    public static final int TYPE_DIRECTED_ONE = 232718549;
    public static final int TYPE_REQUEST = 232718550;
    public static final int TYPE_SEQUEL_FEW = 232718551;
    public static final int TYPE_SEQUEL_MANY = 232718552;
    public static final int TYPE_SEQUEL_ONE = 232718553;
    private InetAddress __m_FromAddress;
    private int __m_FromId;
    private int __m_FromPort;
    private int __m_PacketType;
    private long __m_ReceivedMillis;
    private int __m_SentCount;
    private long __m_SentMillis;
    private int __m_ToId;

    public Packet(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public String getDescription() {
        return null;
    }

    public InetAddress getFromAddress() {
        return this.__m_FromAddress;
    }

    public int getFromId() {
        return this.__m_FromId;
    }

    public int getFromPort() {
        return this.__m_FromPort;
    }

    public int getPacketType() {
        return this.__m_PacketType;
    }

    public long getReceivedMillis() {
        return this.__m_ReceivedMillis;
    }

    public int getSentCount() {
        return this.__m_SentCount;
    }

    public long getSentMillis() {
        return this.__m_SentMillis;
    }

    public int getToId() {
        return this.__m_ToId;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/Packet".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private final Component get_Module() {
        return this;
    }

    public static Packet instantiate(DataInputStream stream, int nMemberId) throws IOException {
        Packet packet;
        int nType = stream.readInt();
        switch (nType) {
            case 232718546: {
                packet = new Broadcast();
                break;
            }
            case 232718547: 
            case 232718548: 
            case 232718549: {
                packet = new Directed();
                break;
            }
            case 232718551: 
            case 232718552: 
            case 232718553: {
                packet = new Sequel();
                break;
            }
            case 232718550: {
                packet = new Request();
                break;
            }
            case 232718545: {
                packet = new Ack();
                break;
            }
            default: {
                throw new IOException(String.valueOf("unknown packet type: ") + nType);
            }
        }
        packet.setPacketType(nType);
        if (nType != TYPE_BROADCAST) {
            packet.setToId(nMemberId);
        }
        packet.read(stream, nMemberId);
        packet.setReceivedMillis(Base.getSafeTimeMillis());
        return packet;
    }

    public boolean isAddressedTo(int nMemberId) {
        return this.getToId() == nMemberId;
    }

    public boolean isConfirmationRequired() {
        return false;
    }

    public boolean isDeferrable() {
        return !this.isConfirmationRequired() ? false : this.isOutgoingMultipoint() ^ true;
    }

    public static boolean isForMember(DataInputStream stream, int nMemberId) throws IOException {
        int nType = stream.readInt();
        if (nMemberId == 0) {
            return nType == TYPE_BROADCAST;
        }
        switch (nType) {
            case 232718546: {
                return true;
            }
            case 232718545: 
            case 232718549: 
            case 232718550: 
            case 232718553: {
                return stream.readUnsignedShort() == nMemberId;
            }
            case 232718547: 
            case 232718551: {
                int i = 0;
                int c = stream.readUnsignedByte();
                while (i < c) {
                    if (stream.readUnsignedShort() == nMemberId) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            case 232718548: 
            case 232718552: {
                int nMask;
                int cbSkip;
                int of = Member.calcByteOffset(nMemberId);
                int c = stream.readUnsignedByte();
                if (of >= c) {
                    return false;
                }
                if (of > 0 && stream.skipBytes(cbSkip = of << 2) != cbSkip) {
                    throw new IOException("skip bytes failed!");
                }
                int nBits = stream.readInt();
                return (nBits & (nMask = Member.calcByteMask(nMemberId))) != 0;
            }
        }
        return false;
    }

    public boolean isIncoming() {
        return this.getReceivedMillis() != 0L;
    }

    public boolean isOutgoing() {
        return this.getReceivedMillis() == 0L;
    }

    public boolean isOutgoingBroadcast() {
        return false;
    }

    public boolean isOutgoingMultipoint() {
        return false;
    }

    public static int makeTrint(long l) {
        return (int)(l & 0xFFFFFFL);
    }

    public void read(DataInputStream stream, int nMemberId) throws IOException {
    }

    public static int readUnsignedTrint(DataInputStream stream) throws IOException {
        return stream.readUnsignedByte() << 16 | stream.readUnsignedByte() << 8 | stream.readUnsignedByte();
    }

    public void setFromAddress(InetAddress addr) {
        this.__m_FromAddress = addr;
    }

    public void setFromId(int nId) {
        Component._assert(this.isIncoming() ^ true);
        this.__m_FromId = nId;
    }

    public void setFromPort(int nPort) {
        this.__m_FromPort = nPort;
    }

    protected void setPacketType(int nType) {
        this.__m_PacketType = nType;
    }

    protected void setReceivedMillis(long cMillis) {
        this.__m_ReceivedMillis = cMillis;
    }

    public void setSentCount(int cSent) {
        this.__m_SentCount = cSent;
    }

    public void setSentMillis(long cMillis) {
        this.__m_SentMillis = cMillis;
    }

    public void setToId(int nId) {
        Component._assert(this.isIncoming() ^ true);
        this.__m_ToId = nId;
    }

    public static void skip(DataInputStream stream) throws IOException {
        int nType = stream.readInt();
        switch (nType) {
            case 232718546: {
                Broadcast.skip(stream, nType);
                break;
            }
            case 232718547: 
            case 232718548: 
            case 232718549: {
                Directed.skip(stream, nType);
                break;
            }
            case 232718551: 
            case 232718552: 
            case 232718553: {
                Sequel.skip(stream, nType);
                break;
            }
            case 232718550: {
                NotifyPacket.skip(stream, nType);
                break;
            }
            case 232718545: {
                Ack.skip(stream, nType);
                break;
            }
            default: {
                throw new IOException(String.valueOf("unknown packet type: ") + nType);
            }
        }
    }

    public static void skip(DataInputStream stream, int nType) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        long lTime;
        StringBuffer sb = new StringBuffer();
        sb.append(this.get_Name()).append("{PacketType=0x").append(Base.toHexString((int)this.getPacketType(), (int)8)).append(", ToId=").append(this.getToId()).append(", FromId=").append(this.getFromId()).append(", Direction=");
        if (this.isIncoming()) {
            sb.append("Incoming, ReceivedMillis=");
            lTime = this.getReceivedMillis();
        } else {
            sb.append("Outgoing, SentCount=");
            sb.append(this.getSentCount());
            sb.append(", SentMillis=");
            lTime = this.getSentMillis();
        }
        if (lTime == (long)0) {
            sb.append("none");
        } else {
            sb.append(new Time(lTime));
            sb.append('.');
            sb.append(lTime % (long)1000);
        }
        String sDesc = this.getDescription();
        if (!(sDesc != null) ? false : sDesc.length() > 0) {
            sb.append(", ").append(sDesc);
        }
        sb.append('}');
        return sb.toString();
    }

    public static long translateTrint(int nTrint, long lCurrent) {
        long lLo = lCurrent - (long)TRINT_MAX_VARIANCE;
        long lHi = lCurrent + (long)TRINT_MAX_VARIANCE;
        nTrint &= TRINT_MAX_VALUE;
        long lBase = lCurrent >>> 24;
        int i = -1;
        while (i <= 1) {
            long lGuess = lBase + (long)i << 24 | (long)nTrint;
            if (!(lGuess >= lLo) ? false : lGuess <= lHi) {
                if (lGuess < 1L) {
                    if (lCurrent > 2048L) {
                        Component._trace(String.valueOf("Large gap while initializing packet translation; ") + "current=" + lCurrent + " packet=" + nTrint + " value=" + lGuess, 6);
                    }
                    Component._assert((lGuess += (long)TRINT_DOMAIN_SPAN) >= 1L);
                }
                return lGuess;
            }
            ++i;
        }
        throw new IllegalStateException(String.valueOf("translateTrint failed: ") + "nTrint=" + nTrint + ", lCurrent=" + lCurrent);
    }

    public void write(DataOutputStream stream, MemberSet setTo) throws IOException {
    }

    public static void writeTrint(DataOutputStream stream, int n) throws IOException {
        stream.writeByte(n >>> 16);
        stream.writeByte(n >>> 8);
        stream.writeByte(n);
    }

    public static void writeTrint(DataOutputStream stream, long l) throws IOException {
        Packet.writeTrint(stream, (int)(l & 0xFFFFFFL));
    }
}

