/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.memberSet.EmptyMemberSet;
import com.tangosol.coherence.component.net.memberSet.SingleMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.util.Base;
import java.util.Collection;

public class Poll
extends Net {
    private boolean __m_Closed;
    private long __m_InitTimeMillis;
    private MemberSet __m_LeftMemberSet;
    private long __m_PollId;
    private MemberSet __m_RemainingMemberSet;
    private MemberSet __m_RespondedMemberSet;
    private Object __m_Result;
    private Service __m_Service;

    public Poll() {
        this(null, null, true);
    }

    public Poll(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public synchronized void close() {
        if (this.isClosed() ^ true) {
            this.setClosed(true);
            Service svc = this.getService();
            if (svc != null) {
                svc.onPollClosed(this);
            }
            this.onCompletion();
        }
    }

    public void configureFrom(RequestMessage msg) {
        MemberSet setPoll;
        MemberSet setMsg = msg.getToMemberSet();
        switch (setMsg.size()) {
            case 0: {
                setPoll = (EmptyMemberSet)EmptyMemberSet.get_Instance();
                break;
            }
            case 1: {
                ServiceMemberSet setMember = msg.getService().getServiceMemberSet();
                int nId = setMsg.getFirstId();
                Member member = ((MemberSet)setMember).getMember(nId);
                if (member == null) {
                    setPoll = (EmptyMemberSet)EmptyMemberSet.get_Instance();
                    break;
                }
                setPoll = new SingleMemberSet();
                setPoll.add(member);
                break;
            }
            default: {
                setPoll = new MemberSet();
                setPoll.addAll((Collection)setMsg);
                break;
            }
        }
        this.setRemainingMemberSet(setPoll);
    }

    public String getDescription() {
        return null;
    }

    public long getInitTimeMillis() {
        return this.__m_InitTimeMillis;
    }

    public MemberSet getLeftMemberSet() {
        return this.__m_LeftMemberSet;
    }

    public long getPollId() {
        return this.__m_PollId;
    }

    public MemberSet getRemainingMemberSet() {
        return this.__m_RemainingMemberSet;
    }

    public MemberSet getRespondedMemberSet() {
        return this.__m_RespondedMemberSet;
    }

    public Object getResult() {
        return this.__m_Result;
    }

    public Service getService() {
        return this.__m_Service;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/Poll".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Poll();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isClosed() {
        return this.__m_Closed;
    }

    protected synchronized void onCompletion() {
        this.notifyAll();
    }

    public void onInit() {
        super.onInit();
        EmptyMemberSet setEmpty = (EmptyMemberSet)EmptyMemberSet.get_Instance();
        this.setRemainingMemberSet(setEmpty);
        this.setRespondedMemberSet(setEmpty);
        this.setLeftMemberSet(setEmpty);
        this.setInitTimeMillis(Base.getSafeTimeMillis());
    }

    public synchronized void onLeft(Member member) {
        MemberSet setRemain = this.getRemainingMemberSet();
        MemberSet setLeft = this.getLeftMemberSet();
        if (!(this.isClosed() ^ true) ? false : setRemain.contains(member)) {
            if (!(setRemain.size() == 1) ? false : setLeft.isEmpty()) {
                MemberSet setTemp = setLeft;
                setLeft = setRemain;
                setRemain = setTemp;
                this.setLeftMemberSet(setLeft);
                this.setRemainingMemberSet(setRemain);
            } else {
                setRemain.remove(member);
                if (setLeft instanceof EmptyMemberSet) {
                    setLeft = new MemberSet();
                    this.setLeftMemberSet(setLeft);
                }
                setLeft.add(member);
            }
            if (setRemain.isEmpty()) {
                this.close();
            }
        }
    }

    public synchronized void onResponded(Member member) {
        MemberSet setRemain = this.getRemainingMemberSet();
        MemberSet setResponded = this.getRespondedMemberSet();
        if (!(this.isClosed() ^ true) ? false : setRemain.contains(member)) {
            if (!(setRemain.size() == 1) ? false : setResponded.isEmpty()) {
                MemberSet setTemp = setResponded;
                setResponded = setRemain;
                setRemain = setTemp;
                this.setRespondedMemberSet(setResponded);
                this.setRemainingMemberSet(setRemain);
            } else {
                setRemain.remove(member);
                if (setResponded instanceof EmptyMemberSet) {
                    setResponded = new MemberSet();
                    this.setRespondedMemberSet(setResponded);
                }
                setResponded.add(member);
            }
            if (setRemain.isEmpty()) {
                this.close();
            }
        }
    }

    public void onResponse(Message msg) {
        if (this.isClosed() ^ true) {
            this.onResponded(msg.getFromMember());
        }
    }

    private void setClosed(boolean fClosed) {
        this.__m_Closed = fClosed;
    }

    protected void setInitTimeMillis(long cMillis) {
        this.__m_InitTimeMillis = cMillis;
    }

    protected void setLeftMemberSet(MemberSet setMember) {
        this.__m_LeftMemberSet = setMember;
    }

    public void setPollId(long lMsgId) {
        this.__m_PollId = lMsgId;
    }

    protected void setRemainingMemberSet(MemberSet setMember) {
        this.__m_RemainingMemberSet = setMember;
    }

    protected void setRespondedMemberSet(MemberSet setMember) {
        this.__m_RespondedMemberSet = setMember;
    }

    public void setResult(Object oResult) {
        this.__m_Result = oResult;
    }

    public void setService(Service service) {
        Component._assert(!(service != null) ? false : this.getService() == null);
        this.__m_Service = service;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Poll").append("\n  {").append("\n  PollId=").append(this.getPollId()).append(this.isClosed() ? ", closed" : ", active").append("\n  InitTimeMillis=").append(this.getInitTimeMillis()).append("\n  Service=");
        Service service = this.getService();
        if (service == null) {
            sb.append("null");
        } else {
            sb.append(service.getServiceName()).append(" (").append(service.getServiceId()).append(')');
        }
        sb.append("\n  RespondedMemberSet=[").append(this.getRespondedMemberSet().getIdList()).append(']').append("\n  LeftMemberSet=[").append(this.getLeftMemberSet().getIdList()).append(']').append("\n  RemainingMemberSet=[").append(this.getRemainingMemberSet().getIdList()).append(']');
        String sDesc = this.getDescription();
        if (!(sDesc != null) ? false : sDesc.length() > 0) {
            sb.append('\n').append(Base.indentString((String)sDesc, (String)"  "));
        }
        sb.append("\n  }");
        return sb.toString();
    }
}

