/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.net.socket.UdpSocket;
import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WrapperDataInputStream;
import com.tangosol.net.DatagramPacketOutputStream;
import com.tangosol.util.Base;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.SocketAddress;

public class UdpPacket
extends Net {
    private byte[] __m_Buffer;
    private int __m_BufferLength;
    private DataInputStream __m_DataInputStream;
    private DataOutputStream __m_DataOutputStream;
    private DatagramPacket __m_DatagramPacket;
    private ReadBuffer.BufferInput __m_InputStream;
    private int __m_Length;
    private int __m_Offset;
    private DatagramPacketOutputStream __m_OutputStream;
    private SocketAddress __m_SocketAddress;
    private UdpSocket __m_UdpSocket;

    public UdpPacket() {
        this(null, null, true);
    }

    public UdpPacket(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public boolean append(UdpPacket packet) {
        return this.append(packet, this.getBufferLength());
    }

    public boolean append(UdpPacket packet, int cBytesMax) {
        int cbThat;
        int cbThis;
        int cbTotal;
        if (packet != null && (!((cbTotal = (cbThis = this.getLength()) + (cbThat = packet.getLength())) <= cBytesMax) ? false : this.isCommonDestination(packet))) {
            System.arraycopy(packet.getBuffer(), 0, this.getBuffer(), cbThis, cbThat);
            this.setLength(cbTotal);
            return true;
        }
        return false;
    }

    protected void appendDestination(UdpPacket packet) {
    }

    public byte[] getBuffer() {
        return this.getDatagramPacket().getData();
    }

    public int getBufferLength() {
        return this.getBuffer().length;
    }

    public int getBufferLengthDefault() {
        return 0;
    }

    public DataInputStream getDataInputStream() throws IOException {
        DataInputStream stream = this.__m_DataInputStream;
        if (stream == null) {
            stream = new DataInputStream((InputStream)new WrapperDataInputStream((DataInput)this.getInputStream()));
            this.setDataInputStream(stream);
        }
        return stream;
    }

    public DataOutputStream getDataOutputStream() {
        DataOutputStream stream = this.__m_DataOutputStream;
        if (stream == null) {
            stream = new DataOutputStream((OutputStream)this.getOutputStream());
            this.setDataOutputStream(stream);
        }
        return stream;
    }

    public DatagramPacket getDatagramPacket() {
        DatagramPacket packet = this.__m_DatagramPacket;
        if (packet == null) {
            packet = new DatagramPacket(new byte[0], 0);
            this.setDatagramPacket(packet);
        }
        return packet;
    }

    public ReadBuffer.BufferInput getInputStream() {
        ReadBuffer.BufferInput stream = this.__m_InputStream;
        if (stream == null) {
            stream = new ByteArrayReadBuffer(this.getBuffer()).getBufferInput();
            this.setInputStream(stream);
        }
        return stream;
    }

    public int getLength() {
        return this.getDatagramPacket().getLength();
    }

    public int getOffset() {
        return this.getDatagramPacket().getOffset();
    }

    public DatagramPacketOutputStream getOutputStream() {
        DatagramPacketOutputStream stream = this.__m_OutputStream;
        if (stream == null) {
            stream = new DatagramPacketOutputStream(this.getDatagramPacket());
            this.setOutputStream(stream);
        }
        return stream;
    }

    public SocketAddress getSocketAddress() {
        return this.getDatagramPacket().getSocketAddress();
    }

    public UdpSocket getUdpSocket() {
        return this.__m_UdpSocket;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/UdpPacket".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new UdpPacket();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isCommonDestination(UdpPacket packet) {
        return !(packet != null) ? false : Base.equals((Object)this.getSocketAddress(), (Object)packet.getSocketAddress());
    }

    public void onInit() {
        super.onInit();
        Component cdParent = this.get_Parent();
        if (cdParent instanceof UdpSocket) {
            this.setUdpSocket((UdpSocket)cdParent);
        }
    }

    public void receive() {
        this.getUdpSocket().receive(this);
        ReadBuffer.BufferInput streamRaw = this.getInputStream();
        ((ByteArrayReadBuffer)streamRaw.getBuffer()).resetRange(0, this.getLength());
        streamRaw.setOffset(0);
    }

    public void reset() {
        this.getOutputStream().reset();
    }

    public void send() {
        this.getUdpSocket().send(this);
    }

    protected void setBuffer(byte[] ab) {
        this.getDatagramPacket().setData(ab);
        this.setOutputStream(null);
        this.setDataInputStream(null);
        this.setDataOutputStream(null);
        this.setInputStream(null);
    }

    public void setBufferLength(int cb) {
        this.setBuffer(new byte[cb]);
    }

    protected void setDataInputStream(DataInputStream stream) {
        this.__m_DataInputStream = stream;
    }

    protected void setDataOutputStream(DataOutputStream stream) {
        this.__m_DataOutputStream = stream;
    }

    protected void setDatagramPacket(DatagramPacket packet) {
        this.__m_DatagramPacket = packet;
    }

    protected void setInputStream(ReadBuffer.BufferInput bufferInput) {
        this.__m_InputStream = bufferInput;
    }

    public void setLength(int cb) {
        Component._assert(cb <= 65535);
        this.getDatagramPacket().setLength(cb);
    }

    public void setOffset(int of) {
        this.getDatagramPacket().setData(this.getBuffer(), of, this.getLength());
    }

    protected void setOutputStream(DatagramPacketOutputStream stream) {
        this.__m_OutputStream = stream;
    }

    public void setSocketAddress(SocketAddress addr) {
        this.getDatagramPacket().setSocketAddress(addr);
    }

    public void setUdpSocket(UdpSocket socket) {
        this.__m_UdpSocket = socket;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean fVerbose) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.get_Name()).append("@").append(this.hashCode()).append(", socket=").append(this.getUdpSocket()).append(", address=").append(this.getSocketAddress());
        if (fVerbose) {
            sb.append(", buffer={").append(Base.toHexEscape((byte[])this.getBuffer(), (int)0, (int)this.getLength())).append('}');
        }
        return sb.toString();
    }
}

