/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.extend;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.comm.messageFactory.NamedCacheFactory$AggregateAllRequest;
import com.tangosol.coherence.component.comm.messageFactory.NamedCacheFactory$AggregateFilterRequest;
import com.tangosol.coherence.component.comm.messageFactory.NamedCacheFactory$ClearRequest;
import com.tangosol.coherence.component.comm.messageFactory.NamedCacheFactory$ContainsAllRequest;
import com.tangosol.coherence.component.comm.messageFactory.NamedCacheFactory$ContainsKeyRequest;
import com.tangosol.coherence.component.comm.messageFactory.NamedCacheFactory$ContainsValueRequest;
import com.tangosol.coherence.component.comm.messageFactory.NamedCacheFactory$GetAllRequest;
import com.tangosol.coherence.component.comm.messageFactory.NamedCacheFactory$GetRequest;
import com.tangosol.coherence.component.comm.messageFactory.NamedCacheFactory$IndexRequest;
import com.tangosol.coherence.component.comm.messageFactory.NamedCacheFactory$InvokeAllRequest;
import com.tangosol.coherence.component.comm.messageFactory.NamedCacheFactory$InvokeFilterRequest;
import com.tangosol.coherence.component.comm.messageFactory.NamedCacheFactory$InvokeRequest;
import com.tangosol.coherence.component.comm.messageFactory.NamedCacheFactory$ListenerFilterRequest;
import com.tangosol.coherence.component.comm.messageFactory.NamedCacheFactory$ListenerKeyRequest;
import com.tangosol.coherence.component.comm.messageFactory.NamedCacheFactory$LockRequest;
import com.tangosol.coherence.component.comm.messageFactory.NamedCacheFactory$PutAllRequest;
import com.tangosol.coherence.component.comm.messageFactory.NamedCacheFactory$PutRequest;
import com.tangosol.coherence.component.comm.messageFactory.NamedCacheFactory$QueryRequest;
import com.tangosol.coherence.component.comm.messageFactory.NamedCacheFactory$RemoveAllRequest;
import com.tangosol.coherence.component.comm.messageFactory.NamedCacheFactory$RemoveRequest;
import com.tangosol.coherence.component.comm.messageFactory.NamedCacheFactory$SizeRequest;
import com.tangosol.coherence.component.comm.messageFactory.NamedCacheFactory$UnlockRequest;
import com.tangosol.coherence.component.comm.protocol.NamedCacheProtocol;
import com.tangosol.coherence.component.net.Extend;
import com.tangosol.coherence.component.net.extend.RemoteNamedCache$EntrySet;
import com.tangosol.coherence.component.net.extend.RemoteNamedCache$KeySet;
import com.tangosol.coherence.component.net.extend.RemoteNamedCache$Values;
import com.tangosol.coherence.component.net.extend.remoteService.RemoteCacheService;
import com.tangosol.coherence.component.net.extend.remoteService.RemoteCacheService$EventDispatcher;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.net.cache.CacheStore;
import com.tangosol.net.messaging.Channel;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.net.messaging.Message;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.net.messaging.Request;
import com.tangosol.util.Base;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.LongArray;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SparseArray;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.comparator.EntryComparator;
import com.tangosol.util.comparator.SafeComparator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

public class RemoteNamedCache
extends Extend
implements NamedCache,
CacheStore,
Channel.Receiver {
    private String __m_CacheName;
    private CacheService __m_CacheService;
    private Channel __m_Channel;
    private ClassLoader __m_ClassLoader;
    private Set __m_EntrySet;
    private LongArray __m_FilterArray;
    private Set __m_KeySet;
    private MapListenerSupport __m_MapListenerSupport;
    private Collection __m_Values;

    public RemoteNamedCache() {
        this(null, null, true);
    }

    public RemoteNamedCache(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this._addChild(new RemoteNamedCache$EntrySet("EntrySet", this, true), "EntrySet");
        this._addChild(new RemoteNamedCache$KeySet("KeySet", this, true), "KeySet");
        this._addChild(new RemoteNamedCache$Values("Values", this, true), "Values");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$IndexRequest request = (NamedCacheFactory$IndexRequest)factory.createMessage(NamedCacheFactory$IndexRequest.TYPE_ID);
        request.setAdd(true);
        request.setComparator(comparator);
        request.setExtractor(extractor);
        request.setOrdered(fOrdered);
        channel.request((Request)request);
    }

    public void addMapListener(MapListener listener) {
        this.addMapListener(listener, null, false);
    }

    public void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        long lFilterId;
        boolean fWasLite;
        boolean fWasEmpty;
        MapListenerSupport support;
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        MapListenerSupport mapListenerSupport = support = this.getMapListenerSupport();
        synchronized (mapListenerSupport) {
            fWasEmpty = support.isEmpty(filter);
            fWasLite = !(fWasEmpty ^ true) ? false : support.containsStandardListeners(filter) ^ true;
            lFilterId = fWasEmpty ? this.registerFilter(filter) : this.getFilterId(filter);
            support.addListener(listener, filter, fLite);
        }
        if (fWasEmpty ? true : (!fWasLite ? false : fLite ^ true)) {
            try {
                this.addRemoteMapListener(filter, lFilterId, fLite);
            }
            catch (RuntimeException e) {
                MapListenerSupport mapListenerSupport2 = support;
                synchronized (mapListenerSupport2) {
                    if (fWasEmpty) {
                        this.getFilterArray().remove(lFilterId);
                    }
                    support.removeListener(listener, filter);
                }
                throw e;
            }
        }
    }

    public void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        boolean fWasLite;
        boolean fWasEmpty;
        MapListenerSupport support;
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        if (oKey == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        MapListenerSupport mapListenerSupport = support = this.getMapListenerSupport();
        synchronized (mapListenerSupport) {
            fWasEmpty = support.isEmpty(oKey);
            fWasLite = !(fWasEmpty ^ true) ? false : support.containsStandardListeners(oKey) ^ true;
            support.addListener(listener, oKey, fLite);
        }
        if (fWasEmpty ? true : (!fWasLite ? false : fLite ^ true)) {
            try {
                this.addRemoteMapListener(oKey, fLite);
            }
            catch (RuntimeException e) {
                support.removeListener(listener, oKey);
                throw e;
            }
        }
    }

    protected void addRemoteMapListener(Filter filter, long lFilterId, boolean fLite) {
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$ListenerFilterRequest request = (NamedCacheFactory$ListenerFilterRequest)factory.createMessage(NamedCacheFactory$ListenerFilterRequest.TYPE_ID);
        request.setAdd(true);
        request.setFilter(filter);
        request.setFilterId(lFilterId);
        request.setLite(fLite);
        channel.request((Request)request);
    }

    protected void addRemoteMapListener(Object oKey, boolean fLite) {
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$ListenerKeyRequest request = (NamedCacheFactory$ListenerKeyRequest)factory.createMessage(NamedCacheFactory$ListenerKeyRequest.TYPE_ID);
        request.setAdd(true);
        request.setKey(oKey);
        request.setLite(fLite);
        channel.request((Request)request);
    }

    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$AggregateFilterRequest request = (NamedCacheFactory$AggregateFilterRequest)factory.createMessage(NamedCacheFactory$AggregateFilterRequest.TYPE_ID);
        request.setAggregator(agent);
        request.setFilter(filter);
        return channel.request((Request)request);
    }

    public Object aggregate(Collection collKeys, InvocableMap.EntryAggregator agent) {
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$AggregateAllRequest request = (NamedCacheFactory$AggregateAllRequest)factory.createMessage(NamedCacheFactory$AggregateAllRequest.TYPE_ID);
        request.setAggregator(agent);
        request.setKeySet(collKeys);
        return channel.request((Request)request);
    }

    public void clear() {
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$ClearRequest request = (NamedCacheFactory$ClearRequest)factory.createMessage(NamedCacheFactory$ClearRequest.TYPE_ID);
        channel.request((Request)request);
    }

    public boolean containsAll(Collection colKeys) {
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$ContainsAllRequest request = (NamedCacheFactory$ContainsAllRequest)factory.createMessage(NamedCacheFactory$ContainsAllRequest.TYPE_ID);
        request.setKeySet(colKeys);
        return (Boolean)channel.request((Request)request);
    }

    public boolean containsKey(Object oKey) {
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$ContainsKeyRequest request = (NamedCacheFactory$ContainsKeyRequest)factory.createMessage(NamedCacheFactory$ContainsKeyRequest.TYPE_ID);
        request.setKey(oKey);
        return (Boolean)channel.request((Request)request);
    }

    public boolean containsValue(Object oValue) {
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$ContainsValueRequest request = (NamedCacheFactory$ContainsValueRequest)factory.createMessage(NamedCacheFactory$ContainsValueRequest.TYPE_ID);
        request.setValue(oValue);
        return (Boolean)channel.request((Request)request);
    }

    public void destroy() {
        this.getCacheService().destroyCache((NamedCache)this);
    }

    public void dispatch(int nEventId, long lFilterId, Object oKey, Object oValueOld, Object oValueNew, boolean fSynthetic) {
        Listeners listeners;
        CacheEvent evt;
        RemoteCacheService service = (RemoteCacheService)this.getCacheService();
        RemoteCacheService$EventDispatcher dispatcher = service.ensureEventDispatcher();
        MapListenerSupport support = this.getMapListenerSupport();
        if (lFilterId == 0L) {
            evt = new CacheEvent((ObservableMap)this, nEventId, oKey, oValueOld, oValueNew, fSynthetic);
            listeners = support.getListeners(oKey);
        } else {
            LongArray laFilter = this.getFilterArray();
            MapListenerSupport mapListenerSupport = support;
            synchronized (mapListenerSupport) {
                if (laFilter.exists(lFilterId)) {
                    Filter filter = (Filter)laFilter.get(lFilterId);
                    evt = new MapListenerSupport.FilterEvent((ObservableMap)this, nEventId, oKey, oValueOld, oValueNew, fSynthetic, new Filter[]{filter});
                    listeners = support.getListeners(filter);
                } else {
                    evt = null;
                    listeners = null;
                }
            }
        }
        if (listeners == null ? true : listeners.isEmpty()) {
            if (Component._isTraceEnabled(6)) {
                if (lFilterId == 0L) {
                    Component._trace(String.valueOf("Received an orphaned event; ") + MapEvent.getDescription((int)nEventId) + " key=" + oKey, 6);
                } else {
                    Filter filter = (Filter)this.getFilterArray().get(lFilterId);
                    Component._trace(String.valueOf("Received an orphaned event; ") + MapEvent.getDescription((int)nEventId) + " filter=" + filter, 6);
                }
            }
        } else {
            com.tangosol.coherence.component.util.CacheEvent.dispatchSafe((MapEvent)evt, listeners, dispatcher.getQueue());
        }
    }

    protected Channel ensureChannel() {
        Channel channel = this.getChannel();
        if (channel == null ? true : channel.isOpen() ^ true) {
            throw new ConnectionException(String.valueOf("NamedCache \"") + this.getCacheName() + "\" has been released");
        }
        return channel;
    }

    public Set entrySet() {
        return this.getEntrySet();
    }

    public Set entrySet(Filter filter) {
        if (filter == null) {
            return this.entrySet();
        }
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$QueryRequest request = (NamedCacheFactory$QueryRequest)factory.createMessage(NamedCacheFactory$QueryRequest.TYPE_ID);
        request.setFilter(filter);
        return (Set)channel.request((Request)request);
    }

    public Set entrySet(Filter filter, Comparator comparator) {
        if (comparator == null) {
            comparator = SafeComparator.INSTANCE;
        }
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$QueryRequest request = (NamedCacheFactory$QueryRequest)factory.createMessage(NamedCacheFactory$QueryRequest.TYPE_ID);
        request.setFilter(filter);
        Set set = (Set)channel.request((Request)request);
        if (set.size() <= 1) {
            return set;
        }
        Object[] aEntry = set.toArray();
        EntryComparator compEntry = new EntryComparator(comparator);
        Arrays.sort(aEntry, compEntry);
        return new ImmutableArrayList(aEntry);
    }

    public void erase(Object oKey) {
        this.remove(oKey, false);
    }

    public void eraseAll(Collection colKeys) {
        this.removeAll(colKeys);
    }

    public Object get(Object oKey) {
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$GetRequest request = (NamedCacheFactory$GetRequest)factory.createMessage(NamedCacheFactory$GetRequest.TYPE_ID);
        request.setKey(oKey);
        return channel.request((Request)request);
    }

    public Map getAll(Collection colKeys) {
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$GetAllRequest request = (NamedCacheFactory$GetAllRequest)factory.createMessage(NamedCacheFactory$GetAllRequest.TYPE_ID);
        request.setKeySet(colKeys);
        return (Map)channel.request((Request)request);
    }

    public String getCacheName() {
        return this.__m_CacheName;
    }

    public CacheService getCacheService() {
        return this.__m_CacheService;
    }

    public Channel getChannel() {
        return this.__m_Channel;
    }

    public ClassLoader getClassLoader() {
        return this.__m_ClassLoader;
    }

    protected String getDescription() {
        return String.valueOf("Name=") + this.getCacheName();
    }

    protected Set getEntrySet() {
        return this.__m_EntrySet;
    }

    protected LongArray getFilterArray() {
        return this.__m_FilterArray;
    }

    protected long getFilterId(Filter filter) {
        LongArray.Iterator iter = this.getFilterArray().iterator();
        while (iter.hasNext()) {
            Filter filterThat = (Filter)iter.next();
            if (!Base.equals((Object)filter, (Object)filterThat)) continue;
            return iter.getIndex();
        }
        return 0L;
    }

    protected Set getKeySet() {
        return this.__m_KeySet;
    }

    protected MapListenerSupport getMapListenerSupport() {
        return this.__m_MapListenerSupport;
    }

    public String getName() {
        return String.valueOf("RemoteNamedCache(Cache=") + this.getCacheName() + ")";
    }

    public Protocol getProtocol() {
        return NamedCacheProtocol.getInstance();
    }

    protected Collection getValues() {
        return this.__m_Values;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/extend/RemoteNamedCache".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new RemoteNamedCache();
    }

    private final Component get_Module() {
        return this;
    }

    public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$InvokeRequest request = (NamedCacheFactory$InvokeRequest)factory.createMessage(NamedCacheFactory$InvokeRequest.TYPE_ID);
        request.setKey(oKey);
        request.setProcessor(agent);
        return channel.request((Request)request);
    }

    public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$InvokeFilterRequest request = (NamedCacheFactory$InvokeFilterRequest)factory.createMessage(NamedCacheFactory$InvokeFilterRequest.TYPE_ID);
        request.setFilter(filter);
        request.setProcessor(agent);
        return (Map)channel.request((Request)request);
    }

    public Map invokeAll(Collection collKeys, InvocableMap.EntryProcessor agent) {
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$InvokeAllRequest request = (NamedCacheFactory$InvokeAllRequest)factory.createMessage(NamedCacheFactory$InvokeAllRequest.TYPE_ID);
        request.setKeySet(collKeys);
        request.setProcessor(agent);
        return (Map)channel.request((Request)request);
    }

    public boolean isActive() {
        Channel channel = this.getChannel();
        return channel == null ? false : channel.isOpen();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return this.getKeySet();
    }

    public Set keySet(Filter filter) {
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$QueryRequest request = (NamedCacheFactory$QueryRequest)factory.createMessage(NamedCacheFactory$QueryRequest.TYPE_ID);
        request.setFilter(filter);
        request.setKeysOnly(true);
        return (Set)channel.request((Request)request);
    }

    public Object load(Object oKey) {
        return this.get(oKey);
    }

    public Map loadAll(Collection colKeys) {
        return this.getAll(colKeys);
    }

    public boolean lock(Object oKey) {
        return this.lock(oKey, 0L);
    }

    public boolean lock(Object oKey, long cWait) {
        if (oKey == ConcurrentMap.LOCK_ALL) {
            throw new UnsupportedOperationException("RemoteNamedCache does not support LOCK_ALL");
        }
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$LockRequest request = (NamedCacheFactory$LockRequest)factory.createMessage(NamedCacheFactory$LockRequest.TYPE_ID);
        request.setKey(oKey);
        request.setTimeoutMillis(cWait);
        return (Boolean)channel.request((Request)request);
    }

    public void onInit() {
        this.setEntrySet((Set)((Object)this._findChild("EntrySet")));
        this.setFilterArray((LongArray)new SparseArray());
        this.setKeySet((Set)((Object)this._findChild("KeySet")));
        this.setMapListenerSupport(new MapListenerSupport());
        this.setValues((Collection)((Object)this._findChild("Values")));
        super.onInit();
    }

    public void process(Message message) {
        message.run();
    }

    public Object put(Object oKey, Object oValue) {
        return this.put(oKey, oValue, CacheMap.EXPIRY_DEFAULT);
    }

    public Object put(Object oKey, Object oValue, long cMillis) {
        return this.put(oKey, oValue, cMillis, true);
    }

    public Object put(Object oKey, Object oValue, long cMillis, boolean fReturn) {
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$PutRequest request = (NamedCacheFactory$PutRequest)factory.createMessage(NamedCacheFactory$PutRequest.TYPE_ID);
        request.setKey(oKey);
        request.setValue(oValue);
        request.setExpiryDelay(cMillis);
        request.setReturnRequired(fReturn);
        return channel.request((Request)request);
    }

    public void putAll(Map mapEntries) {
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$PutAllRequest request = (NamedCacheFactory$PutAllRequest)factory.createMessage(NamedCacheFactory$PutAllRequest.TYPE_ID);
        request.setMap(mapEntries);
        channel.request((Request)request);
    }

    public void registerChannel(Channel channel) {
    }

    protected long registerFilter(Filter filter) {
        LongArray laFilter = this.getFilterArray();
        if (laFilter.isEmpty()) {
            laFilter.set((long)1, (Object)filter);
            return 1L;
        }
        return laFilter.add((Object)filter);
    }

    public void release() {
        this.getCacheService().releaseCache((NamedCache)this);
    }

    public Object remove(Object oKey) {
        return this.remove(oKey, true);
    }

    public Object remove(Object oKey, boolean fReturn) {
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$RemoveRequest request = (NamedCacheFactory$RemoveRequest)factory.createMessage(NamedCacheFactory$RemoveRequest.TYPE_ID);
        request.setKey(oKey);
        request.setReturnRequired(fReturn);
        return channel.request((Request)request);
    }

    public boolean removeAll(Collection colKeys) {
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$RemoveAllRequest request = (NamedCacheFactory$RemoveAllRequest)factory.createMessage(NamedCacheFactory$RemoveAllRequest.TYPE_ID);
        request.setKeySet(colKeys);
        return (Boolean)channel.request((Request)request);
    }

    public void removeIndex(ValueExtractor extractor) {
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$IndexRequest request = (NamedCacheFactory$IndexRequest)factory.createMessage(NamedCacheFactory$IndexRequest.TYPE_ID);
        request.setExtractor(extractor);
        channel.request((Request)request);
    }

    public void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, null);
    }

    public void removeMapListener(MapListener listener, Filter filter) {
        boolean fIsEmpty;
        MapListenerSupport support;
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        long lFilterId = 0L;
        MapListenerSupport mapListenerSupport = support = this.getMapListenerSupport();
        synchronized (mapListenerSupport) {
            support.removeListener(listener, filter);
            fIsEmpty = support.isEmpty(filter);
            if (fIsEmpty) {
                lFilterId = this.getFilterId(filter);
                this.getFilterArray().remove(lFilterId);
            }
        }
        if (fIsEmpty) {
            this.removeRemoteMapListener(filter, lFilterId, listener instanceof MapListenerSupport.SynchronousListener);
        }
    }

    public void removeMapListener(MapListener listener, Object oKey) {
        boolean fIsEmpty;
        MapListenerSupport support;
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        if (oKey == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        MapListenerSupport mapListenerSupport = support = this.getMapListenerSupport();
        synchronized (mapListenerSupport) {
            support.removeListener(listener, oKey);
            fIsEmpty = support.isEmpty(oKey);
        }
        if (fIsEmpty) {
            this.removeRemoteMapListener(oKey, listener instanceof MapListenerSupport.SynchronousListener);
        }
    }

    protected void removeRemoteMapListener(Filter filter, long lFilterId, boolean fSync) {
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$ListenerFilterRequest request = (NamedCacheFactory$ListenerFilterRequest)factory.createMessage(NamedCacheFactory$ListenerFilterRequest.TYPE_ID);
        request.setFilter(filter);
        request.setFilterId(lFilterId);
        if (fSync) {
            channel.send((Request)request);
        } else {
            channel.request((Request)request);
        }
    }

    protected void removeRemoteMapListener(Object oKey, boolean fSync) {
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$ListenerKeyRequest request = (NamedCacheFactory$ListenerKeyRequest)factory.createMessage(NamedCacheFactory$ListenerKeyRequest.TYPE_ID);
        request.setKey(oKey);
        if (fSync) {
            channel.send((Request)request);
        } else {
            channel.request((Request)request);
        }
    }

    public void setCacheName(String sName) {
        this.__m_CacheName = sName;
    }

    public void setCacheService(CacheService service) {
        this.__m_CacheService = service;
    }

    public void setChannel(Channel channel) {
        this.__m_Channel = channel;
    }

    public void setClassLoader(ClassLoader loader) {
        this.__m_ClassLoader = loader;
    }

    protected void setEntrySet(Set set) {
        this.__m_EntrySet = set;
    }

    protected void setFilterArray(LongArray la) {
        this.__m_FilterArray = la;
    }

    protected void setKeySet(Set set) {
        this.__m_KeySet = set;
    }

    protected void setMapListenerSupport(MapListenerSupport support) {
        this.__m_MapListenerSupport = support;
    }

    protected void setValues(Collection col) {
        this.__m_Values = col;
    }

    public int size() {
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$SizeRequest request = (NamedCacheFactory$SizeRequest)factory.createMessage(NamedCacheFactory$SizeRequest.TYPE_ID);
        return (Integer)channel.request((Request)request);
    }

    public void store(Object oKey, Object oValue) {
        this.put(oKey, oValue, CacheMap.EXPIRY_DEFAULT, false);
    }

    public void storeAll(Map mapEntries) {
        this.putAll(mapEntries);
    }

    public boolean unlock(Object oKey) {
        if (oKey == ConcurrentMap.LOCK_ALL) {
            throw new UnsupportedOperationException("RemoteNamedCache does not support LOCK_ALL");
        }
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$UnlockRequest request = (NamedCacheFactory$UnlockRequest)factory.createMessage(NamedCacheFactory$UnlockRequest.TYPE_ID);
        request.setKey(oKey);
        return (Boolean)channel.request((Request)request);
    }

    public void unregisterChannel(Channel channel) {
    }

    public Collection values() {
        return this.getValues();
    }
}

