/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.extend;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.comm.connectionManager.Initiator;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Cluster$ClusterConfig;
import com.tangosol.coherence.component.net.ClusterConfig;
import com.tangosol.coherence.component.net.Extend;
import com.tangosol.coherence.component.util.SafeCluster;
import com.tangosol.net.Member;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceInfo;
import com.tangosol.net.messaging.Channel;
import com.tangosol.net.messaging.ConnectionEvent;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.net.messaging.ConnectionInitiator;
import com.tangosol.net.messaging.ConnectionListener;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Listeners;
import java.util.Collections;
import java.util.EventListener;
import java.util.Set;

public abstract class RemoteService
extends Extend
implements Service,
ServiceInfo,
ConnectionListener {
    private Channel __m_Channel;
    private com.tangosol.net.Cluster __m_Cluster;
    private ClusterConfig __m_ClusterConfig;
    private ClassLoader __m_ContextClassLoader;
    private volatile ConnectionInitiator __m_Initiator;
    private Listeners __m_MemberListeners;
    private String __m_ServiceName;
    private String __m_ServiceVersion;
    private Object __m_UserContext;

    public RemoteService(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void addMemberListener(MemberListener listener) {
        this.getMemberListeners().add((EventListener)listener);
    }

    public synchronized void configure(XmlElement xml) {
        Component._assert(this.isRunning() ^ true);
        this.doConfigure(xml);
    }

    public void connectionAccepted(ConnectionEvent evt) {
    }

    public void connectionClosed(ConnectionEvent evt) {
        this.dispatchMemberEvent(MemberEvent.MEMBER_LEAVING);
        this.shutdown();
        this.dispatchMemberEvent(MemberEvent.MEMBER_LEFT);
    }

    public void connectionError(ConnectionEvent evt) {
        this.dispatchMemberEvent(MemberEvent.MEMBER_LEAVING);
        this.stop();
        this.dispatchMemberEvent(MemberEvent.MEMBER_LEFT);
    }

    public void connectionInitiated(ConnectionEvent evt) {
        this.dispatchMemberEvent(MemberEvent.MEMBER_JOINED);
    }

    protected void dispatchMemberEvent(int nId) {
        Listeners listeners = this.getMemberListeners();
        if (listeners.isEmpty() ^ true) {
            new MemberEvent((Object)this, nId, this.getLocalMember()).dispatch(listeners);
        }
    }

    protected void doConfigure(XmlElement xml) {
        if (xml == null) {
            throw new IllegalArgumentException("xml configuration must not be null");
        }
        xml = Extend.findInitiatorConfig(xml);
        xml = Extend.resolveFilterConfig(xml, this.getClusterConfig());
        this.setInitiator(Extend.createInitiator(xml));
        this.getInitiator().addConnectionListener((ConnectionListener)this);
    }

    protected void doShutdown() {
        ConnectionInitiator initiator = this.getInitiator();
        Component._assert(initiator != null);
        this.setChannel(null);
        initiator.shutdown();
        initiator.setContextClassLoader(null);
        com.tangosol.net.Cluster oCluster = this.getCluster();
        if (oCluster instanceof SafeCluster) {
            ((SafeCluster)oCluster).removeLocalService(this);
        }
    }

    protected void doStart() {
        ConnectionInitiator initiator = this.getInitiator();
        Component._assert(initiator != null);
        initiator.setContextClassLoader(this.getContextClassLoader());
        initiator.start();
        this.setChannel(this.openChannel());
    }

    protected void doStop() {
        ConnectionInitiator initiator = this.getInitiator();
        Component._assert(initiator != null);
        this.setChannel(null);
        initiator.stop();
        initiator.setContextClassLoader(null);
        com.tangosol.net.Cluster oCluster = this.getCluster();
        if (oCluster instanceof SafeCluster) {
            ((SafeCluster)oCluster).removeLocalService(this);
        }
    }

    public void drainEvents() {
        ConnectionInitiator initiator = this.getInitiator();
        if (initiator instanceof Initiator) {
            ((Initiator)initiator).drainEvents();
        }
    }

    protected Channel ensureChannel() {
        Channel channel = this.getChannel();
        if (channel == null ? true : channel.isOpen() ^ true) {
            throw new ConnectionException(String.valueOf("Service \"") + this.getServiceName() + "\" has been terminated");
        }
        return channel;
    }

    protected Channel getChannel() {
        return this.__m_Channel;
    }

    public com.tangosol.net.Cluster getCluster() {
        return this.__m_Cluster;
    }

    protected ClusterConfig getClusterConfig() {
        return this.__m_ClusterConfig;
    }

    public ClassLoader getContextClassLoader() {
        return this.__m_ContextClassLoader;
    }

    protected String getDescription() {
        return String.valueOf("Name=") + this.getServiceName();
    }

    public ServiceInfo getInfo() {
        return this;
    }

    public ConnectionInitiator getInitiator() {
        return this.__m_Initiator;
    }

    protected Member getLocalMember() {
        com.tangosol.net.Cluster cluster = this.getCluster();
        return cluster == null ? null : cluster.getLocalMember();
    }

    protected Listeners getMemberListeners() {
        return this.__m_MemberListeners;
    }

    public Member getOldestMember() {
        return this.getLocalMember();
    }

    public Member getServiceMember(int nId) {
        Member member = this.getLocalMember();
        if (!(member != null) ? false : member.getId() == nId) {
            return member;
        }
        return null;
    }

    public Set getServiceMembers() {
        Member member = this.getLocalMember();
        return member == null ? Collections.EMPTY_SET : Collections.singleton(member);
    }

    public String getServiceName() {
        return this.__m_ServiceName;
    }

    public String getServiceType() {
        return null;
    }

    public String getServiceVersion() {
        return this.__m_ServiceVersion;
    }

    public String getServiceVersion(Member member) {
        return this.getServiceVersion();
    }

    public Object getUserContext() {
        return this.__m_UserContext;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/extend/RemoteService".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isRunning() {
        ConnectionInitiator initiator = this.getInitiator();
        return initiator == null ? false : initiator.isRunning();
    }

    public void onInit() {
        this.setMemberListeners(new Listeners());
        super.onInit();
    }

    protected Channel openChannel() {
        return null;
    }

    public void removeMemberListener(MemberListener listener) {
        this.getMemberListeners().remove((EventListener)listener);
    }

    protected void setChannel(Channel channel) {
        this.__m_Channel = channel;
    }

    public void setCluster(com.tangosol.net.Cluster cluster) {
        Component._assert(this.getCluster() == null);
        this.__m_Cluster = cluster;
        if (cluster instanceof SafeCluster) {
            cluster = ((SafeCluster)cluster).getCluster();
        }
        if (cluster instanceof Cluster) {
            this.setClusterConfig(((Cluster)cluster).getConfig());
        }
        if (this.getClusterConfig() == null) {
            Cluster$ClusterConfig config = new Cluster$ClusterConfig();
            config.fromXml(Coherence.getServiceConfig("Cluster"));
            this.setClusterConfig(config);
        }
    }

    protected void setClusterConfig(ClusterConfig config) {
        Component._assert(this.getClusterConfig() == null);
        this.__m_ClusterConfig = config;
    }

    public synchronized void setContextClassLoader(ClassLoader loader) {
        this.__m_ContextClassLoader = loader;
        ConnectionInitiator initiator = this.getInitiator();
        if (initiator != null) {
            initiator.setContextClassLoader(loader);
        }
    }

    protected void setInitiator(ConnectionInitiator initiator) {
        Component._assert(this.getInitiator() == null);
        this.__m_Initiator = initiator;
    }

    protected void setMemberListeners(Listeners listeners) {
        this.__m_MemberListeners = listeners;
    }

    public void setServiceName(String sName) {
        this.__m_ServiceName = sName;
    }

    protected void setServiceVersion(String sVersion) {
        this.__m_ServiceVersion = sVersion;
    }

    public void setUserContext(Object oCtx) {
        this.__m_UserContext = oCtx;
    }

    public synchronized void shutdown() {
        if (this.isRunning()) {
            this.doShutdown();
        }
    }

    public synchronized void start() {
        if (this.isRunning() ^ true) {
            try {
                this.doStart();
            }
            catch (RuntimeException e) {
                this.doStop();
                throw e;
            }
        }
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            this.doStop();
        }
    }
}

