/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.extend.proxy;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.comm.message.request.NamedCacheRequest;
import com.tangosol.coherence.component.comm.protocol.NamedCacheProtocol;
import com.tangosol.coherence.component.net.extend.Proxy;
import com.tangosol.coherence.component.net.extend.proxy.CacheServiceProxy;
import com.tangosol.net.NamedCache;
import com.tangosol.net.messaging.Channel;
import com.tangosol.net.messaging.Message;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.util.Filter;
import com.tangosol.util.MapListener;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.WrapperConcurrentMap;
import java.util.Iterator;
import java.util.Map;

public class NamedCacheProxy
extends Proxy
implements Channel.Receiver {
    public static final String ATTR_LISTENER_FILTER_MAP = "named-cache-listener-filter-map";
    public static final String ATTR_LISTENER_KEY_MAP = "named-cache-listener-key-map";
    public static final String ATTR_LOCK_MAP = "named-cache-lock-map";
    private CacheServiceProxy __m_CacheServiceProxy;
    private NamedCache __m_NamedCache;

    public NamedCacheProxy() {
        this(null, null, true);
    }

    public NamedCacheProxy(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public CacheServiceProxy getCacheServiceProxy() {
        return this.__m_CacheServiceProxy;
    }

    protected String getDescription() {
        return String.valueOf("NamedCache=") + this.getNamedCache();
    }

    public String getName() {
        return this.toString();
    }

    public NamedCache getNamedCache() {
        return this.__m_NamedCache;
    }

    public Protocol getProtocol() {
        return NamedCacheProtocol.getInstance();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/extend/proxy/NamedCacheProxy".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new NamedCacheProxy();
    }

    private final Component get_Module() {
        return this;
    }

    public void process(Message message) {
        Component._assert(message instanceof NamedCacheRequest);
        NamedCacheRequest request = (NamedCacheRequest)message;
        request.setNamedCache(this.getNamedCache());
        request.run();
    }

    public void registerChannel(Channel channel) {
        channel.setAttribute(ATTR_LISTENER_FILTER_MAP, (Object)new WrapperConcurrentMap((Map)new SafeHashMap(), false, -1L));
        channel.setAttribute(ATTR_LISTENER_KEY_MAP, (Object)new WrapperConcurrentMap((Map)new SafeHashMap(), false, -1L));
        channel.setAttribute(ATTR_LOCK_MAP, (Object)new WrapperConcurrentMap((Map)new SafeHashMap(), false, -1L));
    }

    public void release() {
        NamedCache cache = this.getNamedCache();
        Component._assert(cache != null);
        CacheServiceProxy proxy = this.getCacheServiceProxy();
        Component._assert(proxy != null);
        proxy.releaseNamedCacheProxy(cache.getCacheName());
    }

    public void setCacheServiceProxy(CacheServiceProxy proxy) {
        this.__m_CacheServiceProxy = proxy;
    }

    public void setNamedCache(NamedCache cache) {
        this.__m_NamedCache = cache;
    }

    public void unregisterChannel(Channel channel) {
        MapListener listener;
        Map.Entry entry;
        NamedCache cache = this.getNamedCache();
        Component._assert(cache != null);
        Map map = (Map)channel.getAttribute(ATTR_LISTENER_FILTER_MAP);
        Component._assert(map != null);
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            entry = (Map.Entry)iter.next();
            Filter filter = (Filter)entry.getKey();
            listener = (MapListener)entry.getValue();
            cache.removeMapListener(listener, filter);
        }
        map = (Map)channel.getAttribute(ATTR_LISTENER_KEY_MAP);
        Component._assert(map != null);
        iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            entry = (Map.Entry)iter.next();
            Object oKey = entry.getKey();
            listener = (MapListener)entry.getValue();
            cache.removeMapListener(listener, oKey);
        }
        map = (Map)channel.getAttribute(ATTR_LOCK_MAP);
        Component._assert(map != null);
        iter = map.keySet().iterator();
        while (iter.hasNext()) {
            cache.unlock(iter.next());
        }
        channel.setAttribute(ATTR_LISTENER_FILTER_MAP, null);
        channel.setAttribute(ATTR_LISTENER_KEY_MAP, null);
        channel.setAttribute(ATTR_LOCK_MAP, null);
    }
}

