/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.extend.remoteService;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.comm.messageFactory.CacheServiceFactory$CacheDestroyRequest;
import com.tangosol.coherence.component.comm.messageFactory.CacheServiceFactory$CacheEnsureRequest;
import com.tangosol.coherence.component.comm.protocol.CacheServiceProtocol;
import com.tangosol.coherence.component.comm.protocol.NamedCacheProtocol;
import com.tangosol.coherence.component.comm.util.SecurityUtil;
import com.tangosol.coherence.component.net.Extend;
import com.tangosol.coherence.component.net.extend.RemoteNamedCache;
import com.tangosol.coherence.component.net.extend.RemoteService;
import com.tangosol.coherence.component.net.extend.remoteService.RemoteCacheService$EventDispatcher;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.messaging.Channel;
import com.tangosol.net.messaging.Connection;
import com.tangosol.net.messaging.ConnectionInitiator;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.net.messaging.Request;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.IteratorEnumerator;
import com.tangosol.util.LiteMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.WrapperException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Subject;

public class RemoteCacheService
extends RemoteService
implements CacheService {
    private transient RemoteCacheService$EventDispatcher __m_EventDispatcher;
    private transient Map __m_RemoteNamedCacheMap;

    public RemoteCacheService() {
        this(null, null, true);
    }

    public RemoteCacheService(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setRemoteNamedCacheMap((Map)new SafeHashMap());
            this.setServiceVersion("3.2");
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this._addChild(new RemoteCacheService$EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public synchronized void configure(XmlElement xml) {
        super.configure(xml);
        ConnectionInitiator initiator = this.getInitiator();
        initiator.registerProtocol((Protocol)CacheServiceProtocol.getInstance());
        initiator.registerProtocol((Protocol)NamedCacheProtocol.getInstance());
    }

    protected RemoteNamedCache createRemoteNamedCache(String sName, ClassLoader loader) {
        URI uri;
        Channel channel = this.ensureChannel();
        Connection connection = channel.getConnection();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        RemoteNamedCache cache = new RemoteNamedCache();
        Subject subject = SecurityUtil.getCurrentSubject();
        CacheServiceFactory$CacheEnsureRequest request = (CacheServiceFactory$CacheEnsureRequest)factory.createMessage(CacheServiceFactory$CacheEnsureRequest.TYPE_ID);
        request.setCacheName(sName);
        try {
            uri = new URI((String)channel.request((Request)request));
        }
        catch (URISyntaxException e) {
            throw Extend.ensureRuntimeException(e, "error instantiating URI");
        }
        cache.setChannel(connection.acceptChannel(uri, loader, (Channel.Receiver)cache, subject));
        cache.setCacheName(sName);
        cache.setCacheService(this);
        cache.setClassLoader(loader);
        return cache;
    }

    public void destroyCache(NamedCache map) {
        if (map instanceof RemoteNamedCache ^ true) {
            throw new IllegalArgumentException(String.valueOf("illegal map: ") + map);
        }
        RemoteNamedCache cache = (RemoteNamedCache)map;
        String sName = cache.getCacheName();
        Map mapByName = this.getRemoteNamedCacheMap();
        Map mapByLoader = (Map)mapByName.get(sName);
        if (mapByLoader != null) {
            Map map2 = mapByLoader;
            synchronized (map2) {
                mapByLoader.remove(cache.getClassLoader());
                if (mapByLoader.isEmpty()) {
                    mapByName.remove(sName);
                }
                this.destroyRemoteNamedCache(cache);
            }
        }
    }

    protected void destroyRemoteNamedCache(RemoteNamedCache cache) {
        this.releaseRemoteNamedCache(cache);
        Channel channel = this.ensureChannel();
        Protocol.MessageFactory factory = channel.getMessageFactory();
        CacheServiceFactory$CacheDestroyRequest request = (CacheServiceFactory$CacheDestroyRequest)factory.createMessage(CacheServiceFactory$CacheDestroyRequest.TYPE_ID);
        request.setCacheName(cache.getCacheName());
        channel.request((Request)request);
    }

    protected void doShutdown() {
        super.doShutdown();
        RemoteCacheService$EventDispatcher dispatcher = this.getEventDispatcher();
        if (dispatcher != null) {
            dispatcher.stop();
            this.setEventDispatcher(null);
        }
        this.getRemoteNamedCacheMap().clear();
    }

    public NamedCache ensureCache(String sName, ClassLoader loader) {
        RemoteNamedCache cache;
        Map mapByName;
        Map mapByLoader;
        if (sName == null ? true : sName.length() == 0) {
            sName = "Default";
        }
        if (loader == null) {
            loader = this.getContextClassLoader();
            Component._assert(loader != null, "ContextClassLoader is missing");
        }
        if ((mapByLoader = (Map)(mapByName = this.getRemoteNamedCacheMap()).get(sName)) == null) {
            Map map = mapByName;
            synchronized (map) {
                mapByLoader = (Map)mapByName.get(sName);
                if (mapByLoader == null) {
                    mapByLoader = new LiteMap();
                    mapByName.put(sName, mapByLoader);
                }
            }
        }
        if ((cache = (RemoteNamedCache)mapByLoader.get(loader)) == null) {
            Map map = mapByLoader;
            synchronized (map) {
                cache = (RemoteNamedCache)mapByLoader.get(loader);
                if (cache == null) {
                    cache = this.createRemoteNamedCache(sName, loader);
                    mapByLoader.put(loader, cache);
                }
            }
        }
        return cache;
    }

    public RemoteCacheService$EventDispatcher ensureEventDispatcher() {
        RemoteCacheService$EventDispatcher dispatcher = this.getEventDispatcher();
        if (dispatcher == null) {
            dispatcher = (RemoteCacheService$EventDispatcher)this._findChild("EventDispatcher");
            this.setEventDispatcher(dispatcher);
        }
        if (dispatcher.isStarted() ^ true) {
            dispatcher.start();
        }
        return dispatcher;
    }

    public BackingMapManager getBackingMapManager() {
        return null;
    }

    public Enumeration getCacheNames() {
        Map map = this.getRemoteNamedCacheMap();
        while (true) {
            try {
                HashSet set = new HashSet(map.keySet());
                return new IteratorEnumerator(set.iterator());
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
    }

    protected RemoteCacheService$EventDispatcher getEventDispatcher() {
        return this.__m_EventDispatcher;
    }

    protected Map getRemoteNamedCacheMap() {
        return this.__m_RemoteNamedCacheMap;
    }

    public String getServiceType() {
        return CacheService.TYPE_REMOTE;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/extend/remoteService/RemoteCacheService".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new RemoteCacheService();
    }

    private final Component get_Module() {
        return this;
    }

    protected Channel openChannel() {
        Connection connection = this.getInitiator().ensureConnection();
        return connection.openChannel((Protocol)CacheServiceProtocol.getInstance(), "CacheServiceProxy", null, null, SecurityUtil.getCurrentSubject());
    }

    public void releaseCache(NamedCache map) {
        if (map instanceof RemoteNamedCache ^ true) {
            throw new IllegalArgumentException(String.valueOf("illegal map: ") + map);
        }
        RemoteNamedCache cache = (RemoteNamedCache)map;
        String sName = cache.getCacheName();
        Map mapByName = this.getRemoteNamedCacheMap();
        Map mapByLoader = (Map)mapByName.get(sName);
        if (mapByLoader != null) {
            Map map2 = mapByLoader;
            synchronized (map2) {
                mapByLoader.remove(cache.getClassLoader());
                if (mapByLoader.isEmpty()) {
                    mapByName.remove(sName);
                }
                this.releaseRemoteNamedCache(cache);
            }
        }
    }

    protected void releaseRemoteNamedCache(RemoteNamedCache cache) {
        try {
            cache.getChannel().close();
        }
        catch (RuntimeException runtimeException) {}
    }

    public void setBackingMapManager(BackingMapManager manager) {
    }

    protected void setEventDispatcher(RemoteCacheService$EventDispatcher daemon) {
        this.__m_EventDispatcher = daemon;
    }

    protected void setRemoteNamedCacheMap(Map map) {
        this.__m_RemoteNamedCacheMap = map;
    }
}

