/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Management;
import com.tangosol.coherence.component.net.management.Connector$Announce;
import com.tangosol.coherence.component.net.management.Connector$Register;
import com.tangosol.coherence.component.net.management.gateway.Local;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.coherence.component.net.management.model.RemoteModel;
import com.tangosol.net.Cluster;
import com.tangosol.net.Invocable;
import com.tangosol.net.InvocationService;
import com.tangosol.net.Member;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.util.Base;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.ListMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.WrapperException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Connector
extends Management
implements MemberListener {
    public static final int ACTION_ISREG = 1;
    public static final int ACTION_REG = 2;
    public static final int ACTION_UNREG = 3;
    private transient Local __m_LocalGateway;
    private Map __m_LocalRegistry;
    private transient Map __m_RemoteServers;
    private transient InvocationService __m_Service;
    private static ListMap __mapChildren;
    private static transient String __s_MsgLicense;

    static {
        Connector.__initStatic();
    }

    public Connector() {
        this(null, null, true);
    }

    public Connector(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setLocalRegistry((Map)new SafeHashMap());
            this.setRemoteServers((Map)new SafeHashMap());
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"Announce", (Object)Connector$Announce.get_CLASS());
        Object object2 = __mapChildren.put((Object)"Register", (Object)Connector$Register.get_CLASS());
    }

    public Local getLocalGateway() {
        return this.__m_LocalGateway;
    }

    public Map getLocalRegistry() {
        return this.__m_LocalRegistry;
    }

    private static String getMsgLicense() {
        return __s_MsgLicense;
    }

    public Map getRemoteServers() {
        return this.__m_RemoteServers;
    }

    public InvocationService getService() {
        return this.__m_Service;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/management/Connector".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new Connector();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isManagingNode() {
        return this.getLocalGateway() != null;
    }

    public boolean isStarted() {
        return this.getService() != null;
    }

    public void memberJoined(MemberEvent event) {
    }

    public void memberLeaving(MemberEvent event) {
    }

    public void memberLeft(MemberEvent event) {
        Local localGateway = this.getLocalGateway();
        if (event.isLocal()) {
            if (localGateway != null) {
                localGateway.unregisterGlobalMBeans();
            }
            this.getRemoteServers().clear();
            this.getLocalRegistry().clear();
            this.setService(null);
        } else {
            Member member = event.getMember();
            this.getRemoteServers().remove(member);
            if (localGateway != null) {
                localGateway.unregisterModelMBean(String.valueOf("nodeId=") + member.getId() + ",*");
            }
        }
    }

    public void onAnnouncement(Connector$Announce taskAnnounce) {
        if (taskAnnounce.isManagingNode()) {
            Member memberFrom = taskAnnounce.getMemberFrom();
            this.getRemoteServers().put(memberFrom, null);
            this.registerAll(memberFrom);
        }
        taskAnnounce.setResult(this.isManagingNode() ? Boolean.TRUE : Boolean.FALSE);
    }

    public void onRegisterRequest(Connector$Register taskRegister) {
        block10: {
            Local localGateway = this.getLocalGateway();
            if (!(localGateway != null)) break block10;
            int nAct = taskRegister.getAction();
            Member member = taskRegister.getOwner();
            String[] asName = taskRegister.getCanonicalName();
            LocalModel[] aModel = taskRegister.getSnapshot();
            InvocationService service = this.getService();
            try {
                int i = 0;
                int c = asName.length;
                while (i < c) {
                    String sName = asName[i];
                    switch (nAct) {
                        case 2: {
                            try {
                                RemoteModel modelRemote = new RemoteModel();
                                modelRemote.setModelName(sName);
                                modelRemote.setSnapshot(aModel[i]);
                                modelRemote.setModelOwner(member);
                                modelRemote.setService(service);
                                localGateway.registerModelMBean(sName, modelRemote);
                            }
                            catch (RuntimeException e) {
                                Component._trace(String.valueOf("Failed to register MBean: ") + sName, 1);
                                Component._trace(e);
                            }
                            break;
                        }
                        case 3: {
                            localGateway.unregisterModelMBean(sName);
                            break;
                        }
                        case 1: {
                            Component._assert(c == 1);
                            taskRegister.setResult(new Boolean(localGateway.isRegistered(sName)));
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    ++i;
                }
            }
            catch (RuntimeException e) {
                Component._trace("Ignoring RegisterRequest exception", 5);
                Component._trace(Component.getStackTrace(e), 5);
            }
        }
    }

    protected void registerAll(Member member) {
        Map mapReg;
        String[] asName = null;
        LocalModel[] aModel = null;
        Map map = mapReg = this.getLocalRegistry();
        synchronized (map) {
            int cnt = mapReg.size();
            if (cnt > 0) {
                asName = mapReg.keySet().toArray(new String[cnt]);
                aModel = mapReg.values().toArray(new LocalModel[cnt]);
            }
        }
        if (asName != null) {
            InvocationService service = this.getService();
            Connector$Register taskRegister = (Connector$Register)this._newChild("Register");
            taskRegister.setAction(ACTION_REG);
            taskRegister.setOwner(service.getCluster().getLocalMember());
            taskRegister.setCanonicalName(asName);
            taskRegister.setSnapshot(aModel);
            service.execute((Invocable)taskRegister, Collections.singleton(member), null);
        }
    }

    protected static void removeByPattern(Map mapRegistry, String sPattern) {
        ImmutableArrayList setPattern = new ImmutableArrayList((Object[])Base.parseDelimitedString((String)sPattern, (char)','));
        Iterator iter = mapRegistry.keySet().iterator();
        while (iter.hasNext()) {
            String sName = (String)iter.next();
            ImmutableArrayList setParts = new ImmutableArrayList((Object[])Base.parseDelimitedString((String)sName, (char)','));
            if (!setParts.containsAll((Collection<?>)setPattern)) continue;
            iter.remove();
        }
    }

    public boolean sendRegistration(int nAction, String sCanonicalName, LocalModel model) {
        Map mapRegistry = this.getLocalRegistry();
        switch (nAction) {
            case 2: {
                Component._assert(model.is_Snapshot() ^ true);
                mapRegistry.put(sCanonicalName, model);
                break;
            }
            case 3: {
                if (sCanonicalName.endsWith(",*")) {
                    String sPattern = sCanonicalName.substring(0, sCanonicalName.length() - 2);
                    Connector.removeByPattern(mapRegistry, sPattern);
                    break;
                }
                mapRegistry.remove(sCanonicalName);
                break;
            }
            case 1: {
                return mapRegistry.containsKey(sCanonicalName);
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        InvocationService service = this.getService();
        Set setServers = this.getRemoteServers().keySet();
        if ((service == null ? true : setServers == null) ? true : setServers.isEmpty()) {
            return false;
        }
        Connector$Register task = (Connector$Register)this._newChild("Register");
        task.setAction(nAction);
        task.setOwner(service.getCluster().getLocalMember());
        task.setCanonicalName(new String[]{sCanonicalName});
        task.setSnapshot(new LocalModel[]{model});
        service.execute((Invocable)task, setServers, null);
        return true;
    }

    public void setLocalGateway(Local pLocalGateway) {
        this.__m_LocalGateway = pLocalGateway;
    }

    protected void setLocalRegistry(Map map) {
        this.__m_LocalRegistry = map;
    }

    private static void setMsgLicense(String sMsg) {
        __s_MsgLicense = sMsg;
    }

    protected void setRemoteServers(Map setMember) {
        this.__m_RemoteServers = setMember;
    }

    protected void setService(InvocationService service) {
        this.__m_Service = service;
    }

    public void startService(Cluster cluster, String sServiceName) {
        InvocationService service;
        Connector connector = this;
        synchronized (connector) {
            if (this.isStarted() ? true : Connector.getMsgLicense() != null) {
                Object var7_4 = null;
                return;
            }
            try {
                service = (InvocationService)cluster.ensureService(sServiceName, InvocationService.TYPE_DEFAULT);
                this.setService(service);
                service.setContextClassLoader(this.getClass().getClassLoader());
                service.setUserContext((Object)this);
                service.addMemberListener((MemberListener)this);
                service.start();
            }
            catch (SecurityException e) {
                String sMsg = e.getMessage();
                Connector.setMsgLicense(sMsg);
                Component._trace(String.valueOf("Unable to initialize JMX remote management. ") + sMsg + " It will not be possible to manage this node remotely.", 2);
                Object var7_5 = null;
                return;
            }
        }
        Member memberThis = cluster.getLocalMember();
        Set setOther = service.getInfo().getServiceMembers();
        setOther.remove(memberThis);
        Connector$Announce task = (Connector$Announce)this._newChild("Announce");
        task.setMemberFrom(memberThis);
        task.setManagingNode(this.isManagingNode());
        Map mapResponse = service.query((Invocable)task, setOther);
        Iterator iter = mapResponse.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            Member member = (Member)entry.getKey();
            Boolean FServer = (Boolean)entry.getValue();
            if (!(!(FServer != null) ? false : FServer)) continue;
            this.getRemoteServers().put(member, null);
            this.registerAll(member);
        }
    }
}

