/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management.model.localModel;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Member$FlowControl;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.MasterMemberSet;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PointToPointModel
extends LocalModel {
    public static final int VIEW_WEAKEST = 0;
    private int __m_ViewedMemberId;
    private MasterMemberSet __m__MemberSet;

    public PointToPointModel() {
        this(null, null, true);
    }

    public PointToPointModel(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.set_ExpiryDelay(1000);
            this.set_SnapshotMap(new HashMap());
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public int getDeferredPackets() {
        Member$FlowControl flowcontrol = this.get_ViewedFlowControl();
        return flowcontrol == null ? -1 : flowcontrol.getDeferredPacketCount();
    }

    public long getLastIn() {
        Member member = this.get_ViewedMember();
        if (member == null) {
            return -1;
        }
        long ldtLast = member.getLastIncomingMillis();
        return ldtLast == 0L ? -1L : Base.getSafeTimeMillis() - ldtLast;
    }

    public long getLastOut() {
        Member member = this.get_ViewedMember();
        if (member == null) {
            return -1;
        }
        long ldtLast = member.getLastOutgoingMillis();
        return ldtLast == 0L ? -1L : Base.getSafeTimeMillis() - ldtLast;
    }

    public long getLastSlow() {
        Member member = this.get_ViewedMember();
        if (member == null) {
            return -1;
        }
        long ldtLast = member.getLastSlowMillis();
        return ldtLast == 0L ? -1L : Base.getSafeTimeMillis() - ldtLast;
    }

    public int getOutstandingPackets() {
        Member$FlowControl flowcontrol = this.get_ViewedFlowControl();
        return flowcontrol == null ? -1 : flowcontrol.getOutstandingPacketCount();
    }

    public float getPauseRate() {
        Member$FlowControl flowcontrol = this.get_ViewedFlowControl();
        return flowcontrol == null ? -1.0f : (float)flowcontrol.getStatsPauseRate();
    }

    public float getPublisherSuccessRate() {
        Member member = this.get_ViewedMember();
        return member == null ? -1.0f : (float)member.getStatsPublisherSuccessRate();
    }

    public float getReceiverSuccessRate() {
        Member member = this.get_ViewedMember();
        return member == null ? -1.0f : (float)member.getStatsReceiverSuccessRate();
    }

    public int getThreshold() {
        Member$FlowControl flowcontrol = this.get_ViewedFlowControl();
        return flowcontrol == null ? -1 : flowcontrol.getOutstandingPacketThreshold();
    }

    public int getViewedMemberId() {
        Member memberWorst;
        int nId = this.__m_ViewedMemberId;
        if (nId == 0 && (memberWorst = Member.findWeakestMember(this.get_MemberSet())) != null) {
            nId = memberWorst.getId();
        }
        return nId;
    }

    public String[] getViewerStatistics() {
        MasterMemberSet members = this.get_MemberSet();
        int cMembers = members.size() - 1;
        Member memberThis = members.getThisMember();
        String[] asStats = new String[cMembers];
        Iterator iter = members.iterator();
        int i = 0;
        while (!(i < cMembers) ? false : iter.hasNext()) {
            Member member = (Member)iter.next();
            if (!(!(member != memberThis) ? false : member != null)) continue;
            asStats[i++] = member.formatStats();
        }
        return asStats;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/management/model/localModel/PointToPointModel".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new PointToPointModel();
    }

    public MasterMemberSet get_MemberSet() {
        return this.__m__MemberSet;
    }

    private final Component get_Module() {
        return this;
    }

    public Member$FlowControl get_ViewedFlowControl() {
        Member member = this.get_ViewedMember();
        return member == null ? null : member.getFlowControl();
    }

    public Member get_ViewedMember() {
        return this.get_MemberSet().getMember(this.getViewedMemberId());
    }

    public boolean isDeferring() {
        Member$FlowControl flowcontrol = this.get_ViewedFlowControl();
        return flowcontrol == null ? false : flowcontrol.isDeferring();
    }

    public boolean isPaused() {
        Member$FlowControl flowcontrol = this.get_ViewedFlowControl();
        return flowcontrol == null ? false : flowcontrol.isPaused();
    }

    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        Map mapSnapshot = this.get_SnapshotMap();
        mapSnapshot.put("ViewedMemberId", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("ViewerStatistics", ExternalizableHelper.readStringArray((DataInput)in));
        mapSnapshot.put("DeferredPackets", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("Deferring", in.readBoolean());
        mapSnapshot.put("LastIn", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("LastOut", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("LastSlow", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("OutstandingPackets", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("Paused", in.readBoolean());
        mapSnapshot.put("PauseRate", new Float(in.readFloat()));
        mapSnapshot.put("PublisherSuccessRate", new Float(in.readFloat()));
        mapSnapshot.put("ReceiverSuccessRate", new Float(in.readFloat()));
        mapSnapshot.put("Threshold", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
    }

    public void resetStatistics() {
        try {
            Iterator iter = this.get_MemberSet().iterator();
            while (iter.hasNext()) {
                Member member = (Member)iter.next();
                if (!(member != null)) continue;
                member.resetStats();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {}
    }

    public void setViewedMemberId(int nMemberId) {
        if (!(nMemberId == 0 ? true : this.get_MemberSet().contains(nMemberId))) {
            throw new IllegalArgumentException(String.valueOf("There is currently no cluster member with id ") + nMemberId + ".");
        }
        this.__m_ViewedMemberId = nMemberId;
    }

    public void set_MemberSet(MasterMemberSet p_MemberSet) {
        this.__m__MemberSet = p_MemberSet;
    }

    public void specifyThreshold(int iThreshold) {
    }

    public void trackWeakest() {
        this.setViewedMemberId(VIEW_WEAKEST);
    }

    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getViewedMemberId());
        ExternalizableHelper.writeStringArray((DataOutput)out, (String[])this.getViewerStatistics());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getDeferredPackets());
        out.writeBoolean(this.isDeferring());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getLastIn());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getLastOut());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getLastSlow());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getOutstandingPackets());
        out.writeBoolean(this.isPaused());
        out.writeFloat(this.getPauseRate());
        out.writeFloat(this.getPublisherSuccessRate());
        out.writeFloat(this.getReceiverSuccessRate());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getThreshold());
    }
}

