/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.message;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Lease;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LeaseMessage
extends Message {
    private transient Lease __m_Lease;

    public LeaseMessage() {
        this(null, null, true);
    }

    public LeaseMessage(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public String getDescription() {
        Lease lease = this.getLease();
        return lease == null ? "Lease: null" : lease.toString();
    }

    public Lease getLease() {
        return this.__m_Lease;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/message/LeaseMessage".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new LeaseMessage();
    }

    private final Component get_Module() {
        return this;
    }

    public void onReceived() {
        super.onReceived();
        Member memberFrom = this.getFromMember();
        if (memberFrom == null ? true : this.getService().getServiceState() >= Service.SERVICE_STOPPING) {
            throw new EventDeathException();
        }
    }

    public void read(DataInputStream stream) throws IOException {
        Object oKey;
        super.read(stream);
        int iCache = ExternalizableHelper.readInt((DataInput)stream);
        try {
            oKey = Message.readObject(stream, this.getService().getContextClassLoader());
        }
        catch (IOException e) {
            Component._trace(String.valueOf("Failed to deserialize a key for cache ") + Lease.formatCacheName(iCache, this.getService()), 1);
            throw e;
        }
        Lease lease = Lease.instantiate(iCache, oKey, this.getService());
        lease.read(stream);
        this.setLease(lease);
    }

    public void setLease(Lease lease) {
        this.__m_Lease = (Lease)lease.clone();
    }

    public void write(DataOutputStream stream) throws IOException {
        super.write(stream);
        Lease lease = this.getLease();
        Component._assert(lease != null);
        ExternalizableHelper.writeInt((DataOutput)stream, (int)lease.getCacheIndex());
        LeaseMessage.writeObject(stream, lease.getResourceKey());
        lease.write(stream);
    }

    public static void writeObject(DataOutputStream stream, Object o) throws IOException {
        if (o instanceof Binary) {
            Binary binValue = (Binary)o;
            binValue.writeTo((OutputStream)stream);
        } else {
            Message.writeObject(stream, o);
        }
    }
}

