/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.packet;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Member$FlowControl;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.net.internal.PacketIdentifier;
import com.tangosol.util.Base;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class MessagePacket
extends Packet
implements PacketIdentifier {
    public static final int DELIVERY_CONFIRMED = 4;
    public static final int DELIVERY_DEFERRED = 2;
    public static final int DELIVERY_LOST = 3;
    public static final int DELIVERY_OUTSTANDING = 1;
    public static final int DELIVERY_UNSENT = 0;
    private byte[] __m_Body;
    private transient int __m_DeliveryState;
    private long __m_FromMessageId;
    private int __m_MessagePartCount;
    private int __m_MessagePartIndex;
    private int __m_MessageType;
    private transient boolean __m_NackInProgress;
    private transient int __m_PendingResendSkips;
    private long __m_ResendScheduled;
    private long __m_ResendTimeout;
    private int __m_ServiceId;
    private DependentMemberSet __m_ToMemberSet;

    public MessagePacket(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static int calcBodyLength(MemberSet setMember, int cbPref, int cbMax) {
        if (setMember == null) {
            return cbMax - 10;
        }
        int cMembers = setMember.size();
        if (cMembers == 1) {
            return cbPref - 23;
        }
        int cbFew = 19 + 5 * cMembers;
        int cbMany = 21 + 3 * cMembers + 4 * (setMember.getLastId() / 32 + 1);
        int cbOverhead = (!(cbFew < cbMany) ? false : cMembers <= 255) ? cbFew : cbMany;
        Component._assert(cbOverhead < cbMax, "Insufficient maximum packet size to accomodate cluster size.");
        return Math.min(Math.max(cbOverhead << 2, cbPref), cbMax) - cbOverhead;
    }

    public void clearRecipients() {
        if (this.isOutgoingMultipoint()) {
            this.getToMemberSet().clear();
        } else {
            this.setToId(0);
        }
        this.setSentMillis(Base.getSafeTimeMillis());
    }

    public boolean equals(Object obj) {
        if (obj instanceof MessagePacket) {
            MessagePacket that = (MessagePacket)obj;
            return !(!(this.getFromId() == that.getFromId()) ? false : this.getFromMessageId() == that.getFromMessageId()) ? false : this.getMessagePartIndex() == that.getMessagePartIndex();
        }
        return false;
    }

    public String formatDeliveryState(int nDeliveryState) {
        switch (nDeliveryState) {
            case 0: {
                return "unsent";
            }
            case 1: {
                return "outstanding";
            }
            case 2: {
                return "deferred";
            }
            case 3: {
                return "lost";
            }
            case 4: {
                return "confirmed";
            }
        }
        return "<unknown>";
    }

    public byte[] getBody() {
        return this.__m_Body;
    }

    public int getDeliveryState() {
        return this.__m_DeliveryState;
    }

    public long getFromMessageId() {
        return this.__m_FromMessageId;
    }

    public int getMessagePartCount() {
        return this.__m_MessagePartCount;
    }

    public int getMessagePartIndex() {
        return this.__m_MessagePartIndex;
    }

    public int getMessageType() {
        return this.__m_MessageType;
    }

    public int getPendingResendSkips() {
        return this.__m_PendingResendSkips;
    }

    public long getResendScheduled() {
        return this.__m_ResendScheduled;
    }

    public long getResendTimeout() {
        return this.__m_ResendTimeout;
    }

    public int getServiceId() {
        return this.__m_ServiceId;
    }

    public DependentMemberSet getToMemberSet() {
        return this.__m_ToMemberSet;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/packet/MessagePacket".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private final Component get_Module() {
        return this;
    }

    public int hashCode() {
        return this.getFromId() ^ (int)this.getFromMessageId() ^ this.getMessagePartIndex();
    }

    public boolean isAddressedTo(int nMemberId) {
        if (super.isAddressedTo(nMemberId)) {
            return true;
        }
        DependentMemberSet memberSet = this.getToMemberSet();
        return !(memberSet != null) ? false : ((MemberSet)memberSet).contains(nMemberId);
    }

    public boolean isNackInProgress() {
        return this.__m_NackInProgress;
    }

    public boolean isOutgoingMultipoint() {
        return this.getToMemberSet() != null;
    }

    public boolean isResendNecessary() {
        if (this.getToId() != 0) {
            return true;
        }
        DependentMemberSet set = this.getToMemberSet();
        return !(set != null) ? false : ((MemberSet)set).isEmpty() ^ true;
    }

    public void readBody(DataInputStream stream) throws IOException {
        int cb = stream.readUnsignedShort();
        byte[] ab = new byte[cb];
        stream.readFully(ab);
        this.setBody(ab);
    }

    public boolean registerAck(Member memberFrom) {
        Component._assert(this.isOutgoing());
        DependentMemberSet set = this.getToMemberSet();
        if (set == null) {
            int nToId = this.getToId();
            int nFromId = memberFrom.getId();
            if (nToId != 0) {
                Component._assert(nFromId == nToId);
                this.setToId(0);
                return true;
            }
            return false;
        }
        return set.remove(memberFrom);
    }

    public int selectType(MemberSet memberSet) {
        return 0;
    }

    public void setBody(byte[] ab) {
        this.__m_Body = ab;
    }

    protected void setDeliveryState(int nState) {
        this.__m_DeliveryState = nState;
    }

    public void setDeliveryState(int nNewState, Member member) {
        int nCurrentState = this.getDeliveryState();
        if (nNewState == nCurrentState) {
            return;
        }
        Member$FlowControl flowControl = member.getFlowControl();
        if (flowControl != null) {
            switch (nCurrentState) {
                case 1: {
                    flowControl.setOutstandingPacketCount(flowControl.getOutstandingPacketCount() - 1);
                    break;
                }
                case 2: {
                    flowControl.setDeferredPacketCount(flowControl.getDeferredPacketCount() - 1);
                    break;
                }
            }
            switch (nNewState) {
                case 1: {
                    flowControl.setOutstandingPacketCount(flowControl.getOutstandingPacketCount() + 1);
                    break;
                }
                case 2: {
                    flowControl.setDeferredPacketCount(flowControl.getDeferredPacketCount() + 1);
                    break;
                }
            }
        }
        this.setDeliveryState(nNewState);
    }

    public void setFromMessageId(long nId) {
        this.__m_FromMessageId = nId;
    }

    public void setMessagePartCount(int cParts) {
        this.__m_MessagePartCount = cParts;
    }

    public void setMessagePartIndex(int i) {
        this.__m_MessagePartIndex = i;
    }

    public void setMessageType(int nType) {
        this.__m_MessageType = nType;
    }

    public void setNackInProgress(boolean fNack) {
        this.__m_NackInProgress = fNack;
    }

    public void setPendingResendSkips(int pPendingResendSkips) {
        this.__m_PendingResendSkips = pPendingResendSkips;
    }

    public void setResendScheduled(long cMillis) {
        this.__m_ResendScheduled = cMillis;
    }

    public void setResendTimeout(long pResendTimeout) {
        this.__m_ResendTimeout = pResendTimeout;
    }

    public void setServiceId(int nId) {
        this.__m_ServiceId = nId;
    }

    public void setToMemberSet(DependentMemberSet setMember) {
        this.__m_ToMemberSet = setMember;
    }

    public static void skipBody(DataInputStream stream) throws IOException {
        long cSkip = stream.readUnsignedShort();
        long cSkipped = stream.skip(cSkip);
        Component._assert(cSkipped == cSkip);
    }

    public void writeBody(DataOutputStream stream) throws IOException {
        byte[] ab = this.getBody();
        int cb = ab.length;
        stream.writeShort(cb);
        stream.write(ab);
    }
}

