/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.packet.messagePacket;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.Time;
import java.util.Iterator;

public class Sequel
extends MessagePacket {
    public Sequel() {
        this(null, null, true);
    }

    public Sequel(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDeliveryState(0);
            this.setPacketType(232718552);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("ToMemberSet=");
        DependentMemberSet setMember = this.getToMemberSet();
        if (setMember == null) {
            sb.append("null");
        } else {
            sb.append('[');
            boolean fFirst = true;
            Iterator iter = setMember.iterator();
            while (iter.hasNext()) {
                if (fFirst) {
                    fFirst = false;
                } else {
                    sb.append(", ");
                }
                Member member = (Member)iter.next();
                int nMember = member.getId();
                sb.append(nMember);
            }
            sb.append(']');
        }
        long ldtResend = this.getResendScheduled();
        long ldtTimeout = this.getResendTimeout();
        String sResend = ldtResend <= (long)0 ? "none" : String.valueOf(new Time(ldtResend).toString()) + "." + ldtResend % (long)1000;
        String sTimeout = ldtTimeout <= (long)0 ? "none" : String.valueOf(new Time(ldtTimeout).toString()) + "." + ldtTimeout % (long)1000;
        sb.append(", ServiceId=").append(this.getServiceId()).append(", MessageType=").append(this.getMessageType()).append(", FromMessageId=").append(this.getFromMessageId()).append(", MessagePartCount=").append(this.getMessagePartCount()).append(", MessagePartIndex=").append(this.getMessagePartIndex()).append(", NackInProgress=").append(this.isNackInProgress()).append(", ResendScheduled=").append(sResend).append(", Timeout=").append(sTimeout).append(", PendingResendSkips=").append(this.getPendingResendSkips()).append(", DeliveryState=").append(this.formatDeliveryState(this.getDeliveryState())).append(", Body=");
        byte[] ab = this.getBody();
        if (ab == null) {
            sb.append("null");
        } else {
            if (ab.length > 40) {
                sb.append(Base.toHexEscape((byte[])ab, (int)0, (int)40)).append("...");
            } else {
                sb.append(Base.toHexEscape((byte[])ab));
            }
            sb.append(", Body.length=").append(ab.length);
        }
        return sb.toString();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/packet/messagePacket/Sequel".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Sequel();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isConfirmationRequired() {
        return true;
    }

    public void read(DataInputStream stream, int nMemberId) throws IOException {
        switch (this.getPacketType()) {
            case 232718553: {
                stream.readUnsignedShort();
                break;
            }
            case 232718551: {
                stream.skip(stream.readUnsignedByte() << 1);
                break;
            }
            case 232718552: {
                stream.skip(stream.readUnsignedByte() << 2);
                break;
            }
            default: {
                throw new IOException(String.valueOf("unknown packet type: ") + this.getPacketType());
            }
        }
        this.setFromId(stream.readUnsignedShort());
        this.setFromMessageId(Packet.readUnsignedTrint(stream));
        this.setMessagePartIndex(Packet.readUnsignedTrint(stream));
        this.readBody(stream);
    }

    public int selectType(MemberSet memberSet) {
        int cMembers = memberSet.size();
        switch (cMembers) {
            case 0: {
                throw new IllegalArgumentException("no members in set!");
            }
            case 1: {
                return Packet.TYPE_SEQUEL_ONE;
            }
            case 2: {
                return Packet.TYPE_SEQUEL_FEW;
            }
        }
        if (cMembers > 255) {
            return Packet.TYPE_SEQUEL_MANY;
        }
        int cbFew = 15 + 2 * cMembers;
        int cbMany = 15 + 4 * (memberSet.getLastId() / 32 + 1);
        return cbFew <= cbMany ? Packet.TYPE_SEQUEL_FEW : Packet.TYPE_SEQUEL_MANY;
    }

    public static void skip(DataInputStream stream, int nType) throws IOException {
        long cbSkip = 0L;
        switch (nType) {
            case 232718553: {
                cbSkip += 2L;
                break;
            }
            case 232718551: {
                cbSkip += (long)(stream.readUnsignedByte() << 1);
                break;
            }
            case 232718552: {
                cbSkip += (long)(stream.readUnsignedByte() << 2);
                break;
            }
            default: {
                throw new IOException(String.valueOf("unknown packet type: ") + nType);
            }
        }
        long cbSkipped = stream.skip(cbSkip += 8L);
        Component._assert(cbSkipped == cbSkip);
        MessagePacket.skipBody(stream);
    }

    public void write(DataOutputStream stream, MemberSet setTo) throws IOException {
        int nType = this.selectType(setTo);
        this.setPacketType(nType);
        stream.writeInt(nType);
        switch (nType) {
            case 232718553: {
                setTo.writeOne(stream);
                break;
            }
            case 232718551: {
                setTo.writeFew(stream);
                break;
            }
            case 232718552: {
                setTo.writeMany(stream);
                break;
            }
            default: {
                throw new IOException(String.valueOf("unknown packet type: ") + nType);
            }
        }
        stream.writeShort(this.getFromId());
        Packet.writeTrint(stream, this.getFromMessageId());
        Packet.writeTrint(stream, this.getMessagePartIndex());
        this.writeBody(stream);
    }
}

