/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.socket;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Socket;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;

public class TcpSocket
extends Socket {
    private int __m_BufferLength;
    private boolean __m_KeepAlive;
    private InetAddress __m_RemoteInetAddress;
    private int __m_RemotePort;
    private int __m_SoLinger;
    private java.net.Socket __m_Socket;
    private boolean __m_TcpNoDelay;

    public TcpSocket() {
        this(null, null, true);
    }

    public TcpSocket(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setSoLinger(-1);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void close() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getState() != Socket.STATE_CLOSED) {
                java.net.Socket socket = this.getSocket();
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setSocket(null);
                }
                this.setState(Socket.STATE_CLOSED);
            }
        }
    }

    public int getBufferLength() {
        return this.__m_BufferLength;
    }

    public String getDescription() {
        if (this.getState() == Socket.STATE_OPEN) {
            return String.valueOf("Socket=") + this.getSocket();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Remote address:port=").append(Socket.toString(this.getRemoteInetAddress())).append(':').append(this.getRemotePort());
        if (this.getInetAddress() != null) {
            sb.append(", Local address:port=").append(Socket.toString(this.getInetAddress())).append(':').append(this.getPort());
        }
        return sb.toString();
    }

    public InputStream getInputStream() {
        if (this.getState() != Socket.STATE_OPEN) {
            throw new IllegalStateException("Socket is closed");
        }
        try {
            return this.getSocket().getInputStream();
        }
        catch (IOException e) {
            throw new WrapperException((Throwable)e);
        }
    }

    public OutputStream getOutputStream() {
        if (this.getState() != Socket.STATE_OPEN) {
            throw new IllegalStateException("Socket is closed");
        }
        try {
            return this.getSocket().getOutputStream();
        }
        catch (IOException e) {
            throw new WrapperException((Throwable)e);
        }
    }

    public InetAddress getRemoteInetAddress() {
        return this.__m_RemoteInetAddress;
    }

    public int getRemotePort() {
        return this.__m_RemotePort;
    }

    public int getSoLinger() {
        return this.__m_SoLinger;
    }

    public java.net.Socket getSocket() {
        return this.__m_Socket;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/socket/TcpSocket".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new TcpSocket();
    }

    private final Component get_Module() {
        return this;
    }

    protected void initializeSocket(java.net.Socket socket) {
        try {
            int cMillis;
            int cbBuffer = this.getBufferLength();
            if (cbBuffer > 0) {
                socket.setSendBufferSize(cbBuffer);
                this.validateBufferSize("send", socket.getSendBufferSize(), cbBuffer, cbBuffer);
                socket.setReceiveBufferSize(cbBuffer);
                this.validateBufferSize("receive", socket.getReceiveBufferSize(), cbBuffer, cbBuffer);
            }
            Component._assert((cMillis = this.getSoTimeout()) >= 0, String.valueOf("TcpSocket.open: ") + "SoTimeout property must be greater than or equal to zero");
            socket.setSoTimeout(cMillis);
            this.validateSoTimeout(socket.getSoTimeout(), cMillis);
            int cLinger = this.getSoLinger();
            socket.setSoLinger(cLinger >= 0, Math.max(cLinger, 0));
            socket.setTcpNoDelay(this.isTcpNoDelay());
            try {
                socket.setKeepAlive(this.isKeepAlive());
            }
            catch (NoSuchMethodError e) {}
        }
        catch (SocketException e) {
            throw new WrapperException((Throwable)e);
        }
    }

    protected java.net.Socket instantiateSocket() throws IOException {
        InetAddress addrLocal = this.getInetAddress();
        int nPortLocal = this.getPort();
        InetAddress addrRemote = this.getRemoteInetAddress();
        int nPortRemote = this.getRemotePort();
        Component._assert(addrRemote != null, String.valueOf("TcpSocket.open: ") + "RemoteInetAddress is required");
        Component._assert(!(nPortRemote > 0) ? false : nPortRemote <= 65535, String.valueOf("TcpSocket.open: ") + "RemotePort out of range (" + nPortRemote + ")");
        java.net.Socket socket = new java.net.Socket();
        if (addrLocal != null) {
            Component._assert(!(nPortLocal > 0) ? false : nPortLocal <= 65535, String.valueOf("TcpSocket.open: ") + "Port out of range (" + nPortLocal + ")");
            int cAttempts = (!this.isPortAutoSelect() ? false : this.getState() == Socket.STATE_INITIAL) ? 256 : 1;
            int nPortOrig = nPortLocal;
            while (true) {
                try {
                    socket.bind(new InetSocketAddress(addrLocal, nPortLocal));
                    if (!(nPortLocal != nPortOrig)) break;
                    this.setPort(nPortLocal);
                }
                catch (BindException e) {
                    if (--cAttempts == 0) {
                        throw e;
                    }
                    ++nPortLocal;
                    continue;
                }
                break;
            }
        }
        socket.connect(new InetSocketAddress(addrRemote, nPortRemote), this.getSoTimeout());
        return socket;
    }

    public boolean isKeepAlive() {
        return this.__m_KeepAlive;
    }

    public boolean isTcpNoDelay() {
        return this.__m_TcpNoDelay;
    }

    public void open() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getState() != Socket.STATE_OPEN) {
                java.net.Socket socket = this.instantiateSocket();
                try {
                    this.initializeSocket(socket);
                    this.setSocket(socket);
                    this.setLastOpenMillis(Base.getSafeTimeMillis());
                }
                catch (RuntimeException e) {
                    try {
                        socket.close();
                    }
                    catch (Exception eIgnore) {
                        // empty catch block
                    }
                    this.setSocket(null);
                    throw e;
                }
                this.setState(Socket.STATE_OPEN);
            }
        }
    }

    public void setBufferLength(int cb) {
        Component._assert(cb > 0);
        Object object = this.getLock();
        synchronized (object) {
            if (this.getState() == Socket.STATE_OPEN) {
                java.net.Socket socket = this.getSocket();
                try {
                    socket.setSendBufferSize(cb);
                    this.validateBufferSize("send", socket.getSendBufferSize(), cb, cb);
                    socket.setReceiveBufferSize(cb);
                    this.validateBufferSize("receive", socket.getReceiveBufferSize(), cb, cb);
                }
                catch (SocketException e) {
                    throw new WrapperException((Throwable)e);
                }
            }
            this.__m_BufferLength = cb;
        }
    }

    public void setKeepAlive(boolean fKeepAlive) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getState() == Socket.STATE_OPEN) {
                try {
                    this.getSocket().setKeepAlive(fKeepAlive);
                }
                catch (SocketException e) {
                    throw new WrapperException((Throwable)e);
                }
                catch (NoSuchMethodError e) {
                    Object var4_5 = null;
                    return;
                }
            }
            this.__m_KeepAlive = fKeepAlive;
        }
    }

    public void setRemoteInetAddress(InetAddress addr) {
        Object object = this.getLock();
        synchronized (object) {
            Component._assert(this.getState() == Socket.STATE_INITIAL, "RemoteInetAddress cannot be modified once the socket has been opened");
            this.__m_RemoteInetAddress = addr;
        }
    }

    public void setRemotePort(int nPort) {
        Object object = this.getLock();
        synchronized (object) {
            Component._assert(this.getState() == Socket.STATE_INITIAL, "RemotePort cannot be modified once the socket has been opened");
            this.__m_RemotePort = nPort;
        }
    }

    public void setSoLinger(int cLinger) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getState() == Socket.STATE_OPEN) {
                try {
                    this.getSocket().setSoLinger(cLinger >= 0, Math.max(cLinger, 0));
                }
                catch (SocketException e) {
                    throw new WrapperException((Throwable)e);
                }
            }
            this.__m_SoLinger = cLinger;
        }
    }

    public void setSoTimeout(int cMillis) {
        Component._assert(cMillis >= 0);
        Object object = this.getLock();
        synchronized (object) {
            if (this.getState() == Socket.STATE_OPEN) {
                java.net.Socket socket = this.getSocket();
                try {
                    socket.setSoTimeout(cMillis);
                    this.validateSoTimeout(socket.getSoTimeout(), cMillis);
                }
                catch (SocketException e) {
                    throw new WrapperException((Throwable)e);
                }
            }
            super.setSoTimeout(cMillis);
        }
    }

    protected void setSocket(java.net.Socket socket) {
        this.__m_Socket = socket;
    }

    public void setTcpNoDelay(boolean fNoDelay) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getState() == Socket.STATE_OPEN) {
                try {
                    this.getSocket().setTcpNoDelay(fNoDelay);
                }
                catch (SocketException e) {
                    throw new WrapperException((Throwable)e);
                }
            }
            this.__m_TcpNoDelay = fNoDelay;
        }
    }

    public void shutdownInput() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getState() == Socket.STATE_OPEN) {
                try {
                    this.getSocket().shutdownInput();
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
        }
    }

    public void shutdownOutput() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getState() == Socket.STATE_OPEN) {
                try {
                    this.getSocket().shutdownOutput();
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
        }
    }
}

