/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.Lease;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.message.CacheMessage;
import com.tangosol.coherence.component.net.message.LeaseMessage;
import com.tangosol.coherence.component.util.CacheEvent;
import com.tangosol.coherence.component.util.CacheHandler$BackingMapListener;
import com.tangosol.coherence.component.util.CacheHandler$EntrySet;
import com.tangosol.coherence.component.util.CacheHandler$KeySet;
import com.tangosol.coherence.component.util.CacheHandler$Validator;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ReplicatedCache;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.cache.OldCache;
import com.tangosol.net.cache.OverflowMap;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlSerializable;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableHashMap;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.TransactionMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CacheHandler
extends Util
implements NamedCache,
XmlSerializable,
Converter {
    public static final int MAX_MAP_RETRIES = 32;
    private transient MapListener __m_BackingMapListener;
    private int __m_CacheIndex;
    private String __m_CacheName;
    private transient ClassLoader __m_ClassLoader;
    private transient Converter __m_ConverterFromInternal;
    private transient Converter __m_ConverterToInternal;
    private transient Object __m_IgnoreKey;
    private transient Map __m_LeaseMap;
    private transient MapListenerSupport __m_ListenerSupport;
    private transient CacheHandler __m_NextHandler;
    private transient Map __m_ResourceMap;
    private long __m_StandardLeaseMillis;
    private boolean __m_UseEventDaemon;
    private boolean __m_Valid;
    private static ListMap __mapChildren;

    static {
        CacheHandler.__initStatic();
    }

    public CacheHandler() {
        this(null, null, true);
    }

    public CacheHandler(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setCacheIndex(-1);
            this.setIgnoreKey(new Object());
            this.setStandardLeaseMillis(20000L);
            this.setUseEventDaemon(true);
            this.setValid(true);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"BackingMapListener", (Object)CacheHandler$BackingMapListener.get_CLASS());
        Object object2 = __mapChildren.put((Object)"EntrySet", (Object)CacheHandler$EntrySet.get_CLASS());
        Object object3 = __mapChildren.put((Object)"KeySet", (Object)CacheHandler$KeySet.get_CLASS());
        Object object4 = __mapChildren.put((Object)"Validator", (Object)CacheHandler$Validator.get_CLASS());
    }

    public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
    }

    public void addMapListener(MapListener listener) {
        this.addMapListener(listener, null, false);
    }

    public synchronized void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        Component._assert(listener != null);
        MapListenerSupport support = this.getListenerSupport();
        if (support == null) {
            support = new MapListenerSupport();
            this.setListenerSupport(support);
        }
        support.addListener(listener, filter, fLite);
    }

    public synchronized void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        Component._assert(listener != null);
        MapListenerSupport support = this.getListenerSupport();
        if (support == null) {
            support = new MapListenerSupport();
            this.setListenerSupport(support);
        }
        support.addListener(listener, oKey, fLite);
    }

    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
        return this.aggregate(this.keySet(filter), agent);
    }

    public Object aggregate(Collection collKeys, InvocableMap.EntryAggregator agent) {
        return agent.aggregate(InvocableMapHelper.makeEntrySet((Map)((Object)this), (Collection)collKeys, (boolean)true));
    }

    protected void checkAccess() {
        if (Thread.currentThread() != this.getService().getThread() && this.getClassLoader() == null) {
            throw new IllegalStateException(String.valueOf("Map has been invalidated:\n") + this);
        }
    }

    public void clear() {
        Enumeration enumeration = this.getResourceKeys();
        while (enumeration.hasMoreElements()) {
            Object oKey = enumeration.nextElement();
            this.remove(oKey, false);
        }
    }

    public boolean containsKey(Object oKey) {
        this.checkAccess();
        return this.getResourceMap().containsKey(oKey);
    }

    public boolean containsValue(Object oValue) {
        this.checkAccess();
        Map mapResource = this.getResourceMap();
        return mapResource.containsValue(oValue) ? true : mapResource.containsValue(ExternalizableHelper.toBinary((Object)oValue));
    }

    public Object convert(Object o) {
        return this.getCachedResource(o);
    }

    public void destroy() {
        this.getCacheService().destroyCache((NamedCache)this);
    }

    public Lease ensureLease(Object oKey) {
        Lease lease = this.getLease(oKey);
        if (lease == null) {
            Map mapLease;
            Map map = mapLease = this.getLeaseMap();
            synchronized (map) {
                lease = this.getLease(oKey);
                if (lease == null) {
                    lease = Lease.instantiate(this.getCacheIndex(), oKey, this.getService());
                    mapLease.put(oKey, lease);
                }
            }
        }
        return lease;
    }

    public Set entrySet() {
        this.checkAccess();
        CacheHandler$EntrySet set = (CacheHandler$EntrySet)this._newChild("EntrySet");
        set.setMap((Map)((Object)this));
        set.setSet(this.getResourceMap().entrySet());
        return set;
    }

    public Set entrySet(Filter filter) {
        return InvocableMapHelper.query((Map)((Object)this), (Filter)filter, (boolean)true, (boolean)false, null);
    }

    public Set entrySet(Filter filter, Comparator comparator) {
        return InvocableMapHelper.query((Map)((Object)this), (Filter)filter, (boolean)true, (boolean)true, (Comparator)comparator);
    }

    public void fromXml(XmlElement xml) {
        Component._assert(xml.getName().equals(this.get_Name()));
        this.setCacheName(xml.getElement("CacheName").getString());
        this.setCacheIndex(xml.getElement("CacheIndex").getInt());
        this.setStandardLeaseMillis(xml.getElement("StandardLeaseMillis").getLong());
    }

    public Object get(Object oKey) {
        return this.getCachedResource(oKey);
    }

    public Map getAll(Collection colKeys) {
        HashMap mapResult = new HashMap(colKeys.size());
        Iterator iter = colKeys.iterator();
        while (iter.hasNext()) {
            Object oKey = iter.next();
            Object oVal = this.get(oKey);
            if (!(oVal != null ? true : this.containsKey(oKey))) continue;
            mapResult.put(oKey, oVal);
        }
        return mapResult;
    }

    protected MapListener getBackingMapListener() {
        return this.__m_BackingMapListener;
    }

    public int getCacheIndex() {
        return this.__m_CacheIndex;
    }

    public String getCacheName() {
        return this.__m_CacheName;
    }

    public CacheService getCacheService() {
        return this.getService();
    }

    public Object getCachedResource(Object oKey) {
        ClassLoader loaderResource;
        Object oResource;
        this.checkAccess();
        boolean fNew = false;
        Map mapResource = this.getResourceMap();
        Lease lease = this.getLease(oKey);
        if (lease == null) {
            if (mapResource.containsKey(oKey) ^ true) {
                return null;
            }
            lease = this.ensureLease(oKey);
            fNew = true;
        }
        Lease lease2 = lease;
        synchronized (lease2) {
            oResource = mapResource.get(oKey);
            loaderResource = lease.getClassLoader();
            if (fNew) {
                lease.incrementResourceVersion();
            }
        }
        ClassLoader loaderCache = this.getClassLoader();
        if (!(loaderResource != null) ? false : loaderResource != loaderCache) {
            oResource = this.releaseClassLoader(lease);
        }
        if (oResource instanceof Binary) {
            Binary binValue = (Binary)oResource;
            try {
                oResource = this.getConverterFromInternal().convert((Object)binValue);
            }
            catch (WrapperException e) {
                throw new WrapperException(e.getOriginalException(), String.valueOf("CacheName=") + this.getCacheName() + ", Key=" + oKey);
            }
            Lease lease3 = lease;
            synchronized (lease3) {
                if (binValue == mapResource.get(oKey)) {
                    lease.setClassLoader(loaderCache);
                    lease.setResourceSize(binValue.length());
                    mapResource.put(oKey, oResource);
                }
            }
        }
        return oResource;
    }

    public ClassLoader getClassLoader() {
        return this.__m_ClassLoader;
    }

    protected Converter getConverterFromInternal() {
        Converter conv = this.__m_ConverterFromInternal;
        if (conv == null) {
            CacheHandler cacheHandler = this;
            synchronized (cacheHandler) {
                conv = this.__m_ConverterFromInternal;
                if (conv == null) {
                    ClassLoader loader = this.getClassLoader();
                    conv = loader == NullImplementation.getClassLoader() ? NullImplementation.getConverter() : this.getService().instantiateConverterFromInternal(loader);
                    this.setConverterFromInternal(conv);
                }
            }
        }
        return conv;
    }

    protected Converter getConverterToInternal() {
        Converter conv = this.__m_ConverterToInternal;
        if (conv == null) {
            CacheHandler cacheHandler = this;
            synchronized (cacheHandler) {
                conv = this.__m_ConverterToInternal;
                if (conv == null) {
                    ClassLoader loader = this.getClassLoader();
                    conv = loader == NullImplementation.getClassLoader() ? NullImplementation.getConverter() : this.getService().instantiateConverterToInternal();
                    this.setConverterToInternal(conv);
                }
            }
        }
        return conv;
    }

    public Object getIgnoreKey() {
        return this.__m_IgnoreKey;
    }

    public Lease getLease(Object oKey) {
        return (Lease)this.getLeaseMap().get(oKey);
    }

    public Enumeration getLeaseKeys() {
        return new SimpleEnumerator(this.getLeaseMap().keySet().toArray());
    }

    public Map getLeaseMap() {
        return this.__m_LeaseMap;
    }

    public MapListenerSupport getListenerSupport() {
        return this.__m_ListenerSupport;
    }

    public Object getLockedResource(Object oKey) {
        this.checkAccess();
        if (this.getService().lockResource(this, oKey, this.getStandardLeaseMillis(), -1)) {
            return this.getCachedResource(oKey);
        }
        throw new IllegalStateException();
    }

    public CacheHandler getNextHandler() {
        return this.__m_NextHandler;
    }

    public Enumeration getResourceKeys() {
        return new SimpleEnumerator(this.getResourceMap().keySet().toArray());
    }

    public Map getResourceMap() {
        return this.__m_ResourceMap;
    }

    public ReplicatedCache getService() {
        return (ReplicatedCache)this.get_Parent();
    }

    public long getStandardLeaseMillis() {
        return this.__m_StandardLeaseMillis;
    }

    public TransactionMap.Validator getValidator() {
        return (CacheHandler$Validator)this._newChild("Validator");
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/CacheHandler".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new CacheHandler();
    }

    private final Component get_Module() {
        return this;
    }

    private Map instantiateBackingMap(BackingMapManager manager, String sName) {
        Map map = null;
        try {
            map = manager.instantiateBackingMap(sName);
            if (map == null) {
                Component._trace(String.valueOf("BackingMapManager ") + manager.getClass().getName() + ": returned \"null\" for a cache: " + sName, 1);
            } else if (map.isEmpty() ^ true) {
                map.clear();
            }
        }
        catch (RuntimeException e) {
            Component._trace(String.valueOf("BackingMapManager ") + manager.getClass().getName() + ": failed to instantiate a cache: " + sName, 1);
            Component._trace(e);
        }
        if (map instanceof ObservableMap) {
            ((ObservableMap)map).addMapListener(this.instantiateBackingMapListener());
        }
        return map;
    }

    protected MapListener instantiateBackingMapListener() {
        CacheHandler$BackingMapListener listener = (CacheHandler$BackingMapListener)this._newChild("BackingMapListener");
        this.setBackingMapListener(listener);
        return listener;
    }

    public synchronized void invalidate() {
        String sName;
        BackingMapManager manager;
        if (this.isValid() ^ true) {
            return;
        }
        Map mapResource = this.getResourceMap();
        MapListener listener = this.getBackingMapListener();
        if (listener != null) {
            ((ObservableMap)mapResource).removeMapListener(listener);
            this.setBackingMapListener(null);
        }
        if ((manager = this.getService().getBackingMapManager()) != null && (sName = this.getCacheName()) != null) {
            try {
                manager.releaseBackingMap(sName, mapResource);
            }
            catch (RuntimeException e) {
                Component._trace(String.valueOf("BackingMapManager ") + manager.getClass().getName() + ": failed to release a cache: " + sName, 1);
                Component._trace(e);
            }
        }
        this.setClassLoader(null);
        this.setListenerSupport(null);
        this.setConverterFromInternal(null);
        this.setConverterToInternal(null);
        this.getLeaseMap().clear();
        this.setResourceMap((Map)new SafeHashMap());
        this.setValid(false);
    }

    public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
        return InvocableMapHelper.invokeLocked((ConcurrentMap)this, (InvocableMap.Entry)InvocableMapHelper.makeEntry((Map)((Object)this), (Object)oKey), (InvocableMap.EntryProcessor)agent);
    }

    public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
        return this.invokeAll(this.keySet(filter), agent);
    }

    public Map invokeAll(Collection collKeys, InvocableMap.EntryProcessor agent) {
        return InvocableMapHelper.invokeAllLocked((ConcurrentMap)this, (Set)InvocableMapHelper.makeEntrySet((Map)((Object)this), (Collection)collKeys, (boolean)false), (InvocableMap.EntryProcessor)agent);
    }

    public boolean isActive() {
        return this.getClassLoader() != null;
    }

    public boolean isEmpty() {
        this.checkAccess();
        return this.getResourceMap().isEmpty();
    }

    public boolean isUseEventDaemon() {
        return this.__m_UseEventDaemon;
    }

    public boolean isValid() {
        return this.__m_Valid;
    }

    public Set keySet() {
        this.checkAccess();
        CacheHandler$KeySet set = (CacheHandler$KeySet)this._newChild("KeySet");
        set.setMap((Map)((Object)this));
        set.setSet(this.getResourceMap().keySet());
        return set;
    }

    public Set keySet(Filter filter) {
        return InvocableMapHelper.query((Map)((Object)this), (Filter)filter, (boolean)false, (boolean)false, null);
    }

    public boolean lock(Object oKey) {
        this.checkAccess();
        return this.getService().lockResource(this, oKey, this.getStandardLeaseMillis(), 0);
    }

    public boolean lock(Object oKey, long cWait) {
        this.checkAccess();
        return this.getService().lockResource(this, oKey, this.getStandardLeaseMillis(), cWait);
    }

    public void onFarewell(Member member) {
        Enumeration enumeration = this.getLeaseKeys();
        while (enumeration.hasMoreElements()) {
            Object oKey = enumeration.nextElement();
            Lease lease = this.getLease(oKey);
            if (!(lease != null)) continue;
            this.validateLease(lease);
        }
    }

    public void onInit() {
        super.onInit();
        if (this.getLeaseMap() == null) {
            SafeHashMap mapLease;
            int nGraveyardSize = this.getService().getCacheConfig().getGraveyardSize();
            if (nGraveyardSize > 0) {
                ObservableHashMap mapFront = new ObservableHashMap();
                LocalCache mapBack = new LocalCache(nGraveyardSize, 0);
                mapBack.setEvictionType(OldCache.EVICTION_POLICY_LRU);
                mapLease = new OverflowMap((ObservableMap)mapFront, (Map)mapBack);
            } else {
                mapLease = new SafeHashMap();
            }
            this.setLeaseMap((Map)mapLease);
        }
    }

    public void onLeaseRemove(Lease lease) {
        Object oKey = lease.getResourceKey();
        Lease leaseCurrent = this.getLease(oKey);
        if (leaseCurrent == null) {
            return;
        }
        int iCompare = leaseCurrent.compareTo(lease);
        if (iCompare >= 0) {
            Component._trace(String.valueOf("Rejected remove: ") + leaseCurrent + "\n by " + lease, 4);
            throw new EventDeathException();
        }
        MapEvent event = null;
        MapListenerSupport support = this.getListenerSupport();
        Lease lease2 = leaseCurrent;
        synchronized (lease2) {
            Object oValueOld;
            boolean fNotify = !(!this.isActive() ? false : support != null) ? false : this.containsKey(oKey);
            this.setIgnoreKey(oKey);
            try {
                oValueOld = this.getResourceMap().remove(oKey);
            }
            finally {
                Object var11_10 = null;
                this.setIgnoreKey(this);
            }
            if (fNotify) {
                event = new MapEvent((ObservableMap)this, MapEvent.ENTRY_DELETED, oKey, oValueOld, null);
            }
            if (leaseCurrent.getStatus() == Lease.LEASE_AVAILABLE) {
                this.terminateLease(oKey);
            }
        }
        if (event != null) {
            event = MapListenerSupport.convertEvent((MapEvent)event, (ObservableMap)this, null, (Converter)this.getConverterFromInternal());
            if (this.isUseEventDaemon()) {
                CacheEvent.dispatchSafe(event, support.collectListeners(event), this.getService().ensureEventDispatcher().getQueue());
            } else {
                support.fireEvent(event, true);
            }
        }
    }

    public void onLeaseUpdate(Lease lease, boolean fUpdateResource, Object oValue, long cExpiryMillis) {
        Object oKey = lease.getResourceKey();
        Lease leaseCurrent = this.ensureLease(oKey);
        int iCompare = leaseCurrent.compareTo(lease);
        if (iCompare >= 0) {
            Component._trace(String.valueOf("Rejected update: ") + leaseCurrent + "\n by " + lease, 4);
            throw new EventDeathException();
        }
        MapEvent event = null;
        MapListenerSupport support = this.getListenerSupport();
        Lease lease2 = leaseCurrent;
        synchronized (lease2) {
            leaseCurrent.copyFrom(lease);
            leaseCurrent.setClassLoader(this.getClassLoader());
            Map mapResource = this.getResourceMap();
            if (fUpdateResource) {
                Object oValueOld;
                int nEventId = 0;
                if (!this.isActive() ? false : support != null) {
                    int n = nEventId = this.containsKey(oKey) ? MapEvent.ENTRY_UPDATED : MapEvent.ENTRY_INSERTED;
                }
                if (mapResource instanceof CacheMap) {
                    oValueOld = ((CacheMap)mapResource).put(oKey, oValue, cExpiryMillis);
                } else {
                    if (cExpiryMillis > (long)0) {
                        Component._trace(String.valueOf("UnsupportedOperation: ") + "class \"" + mapResource.getClass().getName() + "\" does not implement CacheMap interface", 1);
                    }
                    oValueOld = mapResource.put(oKey, oValue);
                }
                if (nEventId > 0) {
                    event = new MapEvent((ObservableMap)this, nEventId, oKey, oValueOld, oValue);
                }
            } else if (!(leaseCurrent.getStatus() == Lease.LEASE_AVAILABLE) ? false : mapResource.containsKey(oKey) ^ true) {
                this.terminateLease(oKey);
            }
        }
        if (event != null) {
            event = MapListenerSupport.convertEvent(event, (ObservableMap)this, null, (Converter)this.getConverterFromInternal());
            if (this.isUseEventDaemon()) {
                CacheEvent.dispatchSafe(event, support.collectListeners(event), this.getService().ensureEventDispatcher().getQueue());
            } else {
                support.fireEvent(event, true);
            }
        }
    }

    public void populateCache(CacheMessage msg) {
        ReplicatedCache service = this.getService();
        int iCache = this.getCacheIndex();
        Map mapResource = this.getResourceMap();
        int cLease = msg.getLeaseCount();
        ByteArrayInputStream streamBytes = new ByteArrayInputStream(msg.getCacheData());
        DataInputStream streamData = new DataInputStream(streamBytes);
        int i = 0;
        while (i < cLease) {
            try {
                Object oKey = Message.readObject(streamData, service.getContextClassLoader());
                Lease lease = Lease.instantiate(iCache, oKey, service);
                lease.read(streamData);
                int cbResource = streamData.readInt();
                if (cbResource == -1) {
                    this.onLeaseUpdate(lease, false, null, 0L);
                } else {
                    byte[] abResource = new byte[cbResource];
                    Base.read((InputStream)streamData, (byte[])abResource);
                    lease.setResourceSize(cbResource);
                    this.onLeaseUpdate(lease, true, new Binary(abResource), 0L);
                }
            }
            catch (EventDeathException e) {
            }
            catch (IOException e) {
                Component._trace(String.valueOf("An exception (") + e + ") occurred while populating cache: " + this, 1);
                Component._trace(e);
                break;
            }
            ++i;
        }
    }

    public Enumeration populateUpdateMessage(CacheMessage msg, int cbSize, Enumeration enumeration) {
        ReplicatedCache service = this.getService();
        int nThisId = service.getThisMember().getId();
        int nOldestId = service.getServiceOldestMember().getId();
        Map mapResource = this.getResourceMap();
        ByteArrayOutputStream streamBytes = new ByteArrayOutputStream(1024);
        DataOutputStream streamData = new DataOutputStream(streamBytes);
        int cLease = 0;
        if (enumeration == null) {
            enumeration = this.getLeaseKeys();
        }
        while (enumeration.hasMoreElements()) {
            byte[] abLease;
            byte[] abResource;
            block13: {
                Object oKey = enumeration.nextElement();
                Lease lease = this.getLease(oKey);
                if (lease == null) continue;
                lease.validate();
                boolean fInclude = false;
                switch (lease.getStatus()) {
                    case 1: {
                        lease.setIssuerId(nOldestId);
                    }
                    case 2: {
                        fInclude = lease.getIssuerId() == nThisId;
                        break;
                    }
                    case 3: 
                    case 4: {
                        fInclude = lease.getHolderId() == nThisId;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                if (!fInclude) continue;
                abResource = null;
                try {
                    ByteArrayOutputStream resBytes = new ByteArrayOutputStream();
                    DataOutputStream resData = new DataOutputStream(resBytes);
                    LeaseMessage.writeObject(resData, oKey);
                    lease.write(resData);
                    abLease = resBytes.toByteArray();
                    if (!mapResource.containsKey(oKey)) break block13;
                    int cb = lease.getResourceSize();
                    ByteArrayOutputStream resBytes2 = new ByteArrayOutputStream(cb <= 0 ? 256 : cb);
                    DataOutputStream resData2 = new DataOutputStream(resBytes2);
                    LeaseMessage.writeObject(resData2, mapResource.get(oKey));
                    abResource = resBytes2.toByteArray();
                }
                catch (IOException e) {
                    Component._trace(String.valueOf("An exception (") + e + ") occurred while serializing " + lease + " for " + this, 1);
                    Component._trace(e);
                    continue;
                }
            }
            try {
                streamData.write(abLease);
                if (abResource == null) {
                    streamData.writeInt(-1);
                } else {
                    streamData.writeInt(abResource.length);
                    streamData.write(abResource);
                }
            }
            catch (IOException e) {
                Component._trace(String.valueOf("An exception (") + e + ") occurred while streaming the message " + msg + " for " + this, 1);
                Component._trace(e);
                msg.setLeaseCount(0);
                msg.setCacheData(new byte[0]);
                return null;
            }
            ++cLease;
            if (streamData.size() > cbSize) break;
        }
        msg.setLeaseCount(cLease);
        msg.setCacheData(streamBytes.toByteArray());
        return enumeration.hasMoreElements() ? enumeration : null;
    }

    public Object put(Object oKey, Object oValue) {
        return this.put(oKey, oValue, 0L, true);
    }

    public Object put(Object oKey, Object oValue, long cMillis) {
        return this.put(oKey, oValue, cMillis, true);
    }

    public Object put(Object oKey, Object oValue, long cMillis, boolean fReturn) {
        this.checkAccess();
        ConcurrentModificationException cme = null;
        int i = 1;
        int c = MAX_MAP_RETRIES;
        while (i <= c) {
            try {
                return this.getService().updateResource(this, oKey, oValue, cMillis, false, fReturn);
            }
            catch (ConcurrentModificationException e) {
                cme = e;
                try {
                    Thread.sleep(i << 4);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    break;
                }
                ++i;
            }
        }
        throw cme;
    }

    public void putAll(Map map) {
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            this.put(entry.getKey(), entry.getValue(), 0L, false);
        }
    }

    public Object putFinal(Object oKey, Object oValue, boolean fReturn) throws ConcurrentModificationException {
        this.checkAccess();
        return this.getService().updateResource(this, oKey, oValue, 0L, true, fReturn);
    }

    public void release() {
        this.getCacheService().releaseCache((NamedCache)this);
    }

    public void releaseClassLoader() {
        ClassLoader loader = this.getClassLoader();
        if (loader != null) {
            this.setClassLoader(null);
            ReplicatedCache service = this.getService();
            Enumeration enumeration = this.getLeaseKeys();
            while (enumeration.hasMoreElements()) {
                Object oKey = enumeration.nextElement();
                Lease lease = this.getLease(oKey);
                if (!(lease != null)) continue;
                if (service.getThreadStatus(lease) == Lease.LEASE_LOCKED) {
                    service.unlockResource(this, oKey);
                }
                if (!(lease.getClassLoader() == loader)) continue;
                this.releaseClassLoader(lease);
            }
        }
    }

    protected Object releaseClassLoader(Lease lease) {
        Lease lease2 = lease;
        synchronized (lease2) {
            Object oKey = lease.getResourceKey();
            Object oValue = this.getResourceMap().get(oKey);
            lease.setClassLoader(null);
            try {
                Object oInternal = this.getConverterToInternal().convert(oValue);
                if (oInternal != oValue) {
                    oValue = oInternal;
                    this.getResourceMap().put(oKey, oValue);
                }
            }
            catch (WrapperException e) {
                throw new WrapperException(e.getOriginalException(), String.valueOf("CacheName=") + this.getCacheName() + ", Key=" + oKey);
            }
            Object v = oValue;
            Object var6_7 = null;
            return v;
        }
    }

    public Object remove(Object oKey) {
        return this.remove(oKey, true);
    }

    public Object remove(Object oKey, boolean fReturn) {
        this.checkAccess();
        ConcurrentModificationException cme = null;
        int i = 1;
        int c = MAX_MAP_RETRIES;
        while (i <= c) {
            try {
                return this.getService().removeResource(this, oKey, fReturn);
            }
            catch (ConcurrentModificationException e) {
                cme = e;
                try {
                    Thread.sleep(i << 4);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    break;
                }
                ++i;
            }
        }
        throw cme;
    }

    public void removeIndex(ValueExtractor extractor) {
    }

    public void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, null);
    }

    public synchronized void removeMapListener(MapListener listener, Filter filter) {
        Component._assert(listener != null);
        MapListenerSupport support = this.getListenerSupport();
        if (support != null) {
            support.removeListener(listener, filter);
            if (support.isEmpty()) {
                this.setListenerSupport(null);
            }
        }
    }

    public synchronized void removeMapListener(MapListener listener, Object oKey) {
        Component._assert(listener != null);
        MapListenerSupport support = this.getListenerSupport();
        if (support != null) {
            support.removeListener(listener, oKey);
            if (support.isEmpty()) {
                this.setListenerSupport(null);
            }
        }
    }

    protected void setBackingMapListener(MapListener listener) {
        this.__m_BackingMapListener = listener;
    }

    public void setCacheIndex(int index) {
        int indexOld;
        if (this.is_Constructed() && (!((indexOld = this.getCacheIndex()) != -1) ? false : index != indexOld)) {
            throw new IllegalStateException(String.valueOf("Attempt to modify the CacheIndex: ") + this + " to " + index);
        }
        this.__m_CacheIndex = index;
    }

    public void setCacheName(String sName) {
        if (this.is_Constructed()) {
            Map mapActual;
            boolean fClone;
            String sNameOld = this.getCacheName();
            if (!(sNameOld != null) ? false : sNameOld.equals(sName) ^ true) {
                throw new IllegalStateException(String.valueOf("Attempt to modify the CacheName: ") + this + " to " + sName);
            }
            BackingMapManager manager = this.getService().getBackingMapManager();
            Map map = this.getResourceMap();
            boolean bl = fClone = this.getNextHandler() != null;
            if (fClone) {
                Component._assert(map != null, "Resource map must be copied");
            } else if (map == null) {
                if (manager != null) {
                    if (sName == null) {
                        Component._trace(String.valueOf("Creating a temporary map: ") + this.getCacheIndex(), 5);
                    } else {
                        map = this.instantiateBackingMap(manager, sName);
                    }
                }
                this.setResourceMap((Map)(map == null ? new SafeHashMap() : map));
            } else if ((!(!(sName != null) ? false : sNameOld == null) ? false : manager != null) && (mapActual = this.instantiateBackingMap(manager, sName)) != null) {
                if (map.isEmpty() ^ true) {
                    Component._trace(String.valueOf("Transferring ") + map.size() + " to: " + sName, 5);
                    mapActual.putAll(map);
                }
                this.setResourceMap(mapActual);
            }
        }
        this.__m_CacheName = sName;
    }

    public synchronized void setClassLoader(ClassLoader loader) {
        this.__m_ClassLoader = loader;
        this.setConverterFromInternal(null);
    }

    protected void setConverterFromInternal(Converter conv) {
        this.__m_ConverterFromInternal = conv;
    }

    protected void setConverterToInternal(Converter pConverterToInternal) {
        this.__m_ConverterToInternal = pConverterToInternal;
    }

    protected void setIgnoreKey(Object oKey) {
        this.__m_IgnoreKey = oKey;
    }

    public void setLeaseMap(Map map) {
        this.__m_LeaseMap = map;
    }

    protected void setListenerSupport(MapListenerSupport support) {
        this.__m_ListenerSupport = support;
    }

    public void setNextHandler(CacheHandler handler) {
        this.__m_NextHandler = handler;
    }

    public void setResourceMap(Map map) {
        this.__m_ResourceMap = map;
    }

    public void setStandardLeaseMillis(long lMillis) {
        this.__m_StandardLeaseMillis = Math.max(0L, lMillis);
    }

    public void setUseEventDaemon(boolean pUseEventDaemon) {
        this.__m_UseEventDaemon = pUseEventDaemon;
    }

    protected void setValid(boolean fValid) {
        this.__m_Valid = fValid;
    }

    public int size() {
        this.checkAccess();
        return this.getResourceMap().size();
    }

    public void terminateLease(Object oKey) {
        Map mapLease = this.getLeaseMap();
        if (mapLease instanceof OverflowMap) {
            ObservableMap mapFront = ((OverflowMap)mapLease).getFrontMap();
            mapFront.remove(oKey);
        } else {
            mapLease.remove(oKey);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.get_Name()).append("{Name=").append(this.getCacheName()).append(", Index=").append(this.getCacheIndex()).append(", ServiceName=").append(this.getService().getServiceName());
        if (this.isValid()) {
            sb.append(", ClassLoader=").append(this.getClassLoader());
        } else {
            sb.append(", INVALID");
        }
        sb.append('}');
        return sb.toString();
    }

    public XmlElement toXml() {
        SimpleElement xml = new SimpleElement(this.get_Name());
        xml.addElement("CacheName").setString(this.getCacheName());
        xml.addElement("CacheIndex").setInt(this.getCacheIndex());
        xml.addElement("StandardLeaseMillis").setLong(this.getStandardLeaseMillis());
        return xml;
    }

    public boolean unlock(Object oKey) {
        this.checkAccess();
        return this.getService().unlockResource(this, oKey);
    }

    protected void validateLease(Lease lease) {
        ReplicatedCache service = this.getService();
        int nThisId = service.getThisMember().getId();
        lease.validate();
        switch (lease.getStatus()) {
            case 1: {
                lease.setIssuerId(service.getServiceOldestMember().getId());
            }
            case 2: {
                Object oKey = lease.getResourceKey();
                if (!(this.getResourceMap().containsKey(oKey) ^ true)) break;
                this.terminateLease(oKey);
                break;
            }
            case 3: 
            case 4: {
                if (!(lease.getIssuerId() == 0)) break;
                lease.setIssuerId(lease.getHolderId());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public Collection values() {
        this.checkAccess();
        return ConverterCollections.getCollection(this.getResourceMap().keySet(), (Converter)this, (Converter)NullImplementation.getConverter());
    }
}

