/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Application;
import com.tangosol.coherence.component.Util;
import com.tangosol.util.WrapperException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class Config
extends Util {
    public static final String CONFIG_DIRECTORY = "/META-INF";
    public static final String CONFIG_EXTENSION = ".properties";
    private char __m_ArrayDelimiter;
    private Properties __m__Properties;

    public Config() {
        this(null, null, true);
    }

    public Config(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setArrayDelimiter(':');
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m__Properties = new Properties();
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
    }

    public void clear() {
        ((Hashtable)this.get_Properties()).clear();
    }

    public boolean containsKey(String sKey) {
        return ((Hashtable)this.get_Properties()).containsKey(sKey);
    }

    public static String decodePath(String sPath) {
        int ofEnd;
        int ofStart;
        while ((ofStart = sPath.indexOf(123)) >= 0 && (ofEnd = sPath.indexOf(125, ofStart)) > ofStart) {
            String sProp = sPath.substring(ofStart + 1, ofEnd);
            String sVal = System.getProperty(sProp, "");
            sPath = String.valueOf(sPath.substring(0, ofStart)) + sVal + sPath.substring(ofEnd + 1);
        }
        return sPath;
    }

    public static String encodePath(String sPath, String[] asEnv) {
        int i = 0;
        int c = asEnv.length;
        while (i < c) {
            String sEnv = asEnv[i];
            String sVal = System.getProperty(sEnv);
            int of = (sVal == null ? true : sVal.length() == 0) ? -1 : sPath.indexOf(sVal);
            if (of != -1) {
                sPath = String.valueOf(sPath.substring(0, of)) + '{' + sEnv + '}' + sPath.substring(of + sVal.length() + 1);
            }
            ++i;
        }
        return sPath;
    }

    public char getArrayDelimiter() {
        return this.__m_ArrayDelimiter;
    }

    public boolean getBoolean(String sKey) {
        return this.getBoolean(sKey, false);
    }

    public boolean getBoolean(String sKey, boolean fDefaultValue) {
        String sValue = this.get_Properties().getProperty(sKey);
        return sValue != null ? Boolean.valueOf(sValue) : fDefaultValue;
    }

    public Config getConfig(String sKey) {
        Config config = new Config();
        Properties propThis = this.get_Properties();
        Properties propThat = config.get_Properties();
        Enumeration enumeration = ((Hashtable)propThis).keys();
        while (enumeration.hasMoreElements()) {
            String sKeyThis = (String)enumeration.nextElement();
            if (!sKeyThis.startsWith(sKey)) continue;
            String sKeyThat = sKeyThis.substring(sKey.length());
            propThat.setProperty(sKeyThat, propThis.getProperty(sKeyThis));
        }
        return config;
    }

    public int getInt(String sKey) {
        return this.getInt(sKey, 0);
    }

    public int getInt(String sKey, int iDefaultValue) {
        String sValue = this.get_Properties().getProperty(sKey);
        if (sValue != null) {
            try {
                return Integer.parseInt(sValue);
            }
            catch (NumberFormatException e) {
            }
        }
        return iDefaultValue;
    }

    public int[] getIntArray(String sKey) {
        String sValue = this.get_Properties().getProperty(sKey);
        if (!(sValue != null) ? false : sValue.length() > 0) {
            char cDelim = this.getArrayDelimiter();
            char[] ach = sValue.toCharArray();
            int cnt = 1;
            int of = 0;
            while (of < ach.length) {
                if (ach[of] == cDelim) {
                    ++cnt;
                }
                ++of;
            }
            int[] aInt = new int[cnt];
            try {
                int ix = 0;
                int ofStart = 0;
                int of2 = 0;
                while (of2 < ach.length) {
                    if (ach[of2] == cDelim) {
                        aInt[ix++] = Integer.parseInt(new String(ach, ofStart, of2 - ofStart));
                        ofStart = of2 + 1;
                    }
                    ++of2;
                }
                aInt[ix] = Integer.parseInt(new String(ach, ofStart, ach.length - ofStart));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            return aInt;
        }
        return new int[0];
    }

    public String getString(String sKey) {
        return this.get_Properties().getProperty(sKey);
    }

    public String getString(String sKey, String sDefaultValue) {
        return this.get_Properties().getProperty(sKey, sDefaultValue);
    }

    public String[] getStringArray(String sKey) {
        String sValue = this.get_Properties().getProperty(sKey);
        if (!(sValue != null) ? false : sValue.length() > 0) {
            char cDelim = this.getArrayDelimiter();
            char[] ach = sValue.toCharArray();
            int cnt = 1;
            int of = 0;
            while (of < ach.length) {
                if (ach[of] == cDelim) {
                    ++cnt;
                }
                ++of;
            }
            String[] aString = new String[cnt];
            int ix = 0;
            int ofStart = 0;
            int of2 = 0;
            while (of2 < ach.length) {
                if (ach[of2] == cDelim) {
                    aString[ix++] = new String(ach, ofStart, of2 - ofStart);
                    ofStart = of2 + 1;
                }
                ++of2;
            }
            aString[ix] = new String(ach, ofStart, ach.length - ofStart);
            return aString;
        }
        return new String[0];
    }

    public String[] getStringArray(String sKey, char cDelim) {
        char cDelimOrig = this.getArrayDelimiter();
        this.setArrayDelimiter(cDelim);
        String[] asResult = this.getStringArray(sKey);
        this.setArrayDelimiter(cDelimOrig);
        return asResult;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/Config".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Config();
    }

    private final Component get_Module() {
        return this;
    }

    private Properties get_Properties() {
        return this.__m__Properties;
    }

    public boolean isEmpty() {
        return ((Hashtable)this.get_Properties()).isEmpty();
    }

    public Enumeration keys() {
        return ((Hashtable)this.get_Properties()).keys();
    }

    public void list() {
        this.list(new PrintWriter(System.out));
    }

    public void list(PrintWriter writer) {
        this.get_Properties().list(writer);
        writer.flush();
    }

    public void load(InputStream inStream) throws IOException {
        this.get_Properties().load(inStream);
    }

    public void load(String sName) {
        block16: {
            InputStream in;
            block14: {
                String sFile;
                String sPath;
                in = null;
                Application app = (Application)Application.get_Instance();
                if (!(sName.startsWith("/") ^ true && (in = app.getResourceAsStream(sPath = Config.resolvePath(sName))) != null || (in = app.getResourceAsStream(sFile = Config.resolveName(sName))) != null)) {
                    block15: {
                        File file;
                        String sDir;
                        block13: {
                            try {
                                sDir = app.getProperty("user.home");
                                if (!(!(sDir != null) ? false : sDir.length() > 0) || !(!(!(file = new File(sDir, sFile)).isFile() ? false : file.exists()) ? false : file.canRead())) break block13;
                                in = new FileInputStream(file);
                                break block14;
                            }
                            catch (SecurityException e) {
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        try {
                            sDir = app.getProperty("user.dir");
                            if (!(!(sDir != null) ? false : sDir.length() > 0) || !(!(!(file = new File(sDir, sFile)).isFile() ? false : file.exists()) ? false : file.canRead())) break block15;
                            in = new FileInputStream(file);
                            break block14;
                        }
                        catch (SecurityException e) {
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    try {
                        File file = new File("", sFile);
                        if (!(!file.isFile() ? false : file.exists()) ? false : file.canRead()) {
                            in = new FileInputStream(file);
                        }
                    }
                    catch (SecurityException e) {
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
            if (!(in != null)) break block16;
            try {
                this.load(in);
            }
            catch (IOException e) {
                Component._trace(String.valueOf("Exception loading configuration: ") + sName);
                Component._trace(e);
            }
        }
    }

    public void putBoolean(String sKey, boolean fValue) {
        this.get_Properties().setProperty(sKey, String.valueOf(fValue));
    }

    public void putConfig(String sKey, Config config) {
        this.remove(sKey);
        String sPrefix = String.valueOf(sKey) + '.';
        Iterator iter = ((Hashtable)this.get_Properties()).keySet().iterator();
        while (iter.hasNext()) {
            String sEachKey = (String)iter.next();
            if (!sEachKey.startsWith(sPrefix)) continue;
            iter.remove();
        }
        if (!(config != null) ? false : config.isEmpty() ^ true) {
            Properties propThis = this.get_Properties();
            Properties propThat = config.get_Properties();
            Enumeration enumeration = ((Hashtable)propThat).keys();
            while (enumeration.hasMoreElements()) {
                String sKeyThat = (String)enumeration.nextElement();
                propThis.setProperty(String.valueOf(sKey) + sKeyThat, propThat.getProperty(sKeyThat));
            }
        }
    }

    public void putInt(String sKey, int iValue) {
        this.get_Properties().setProperty(sKey, String.valueOf(iValue));
    }

    public void putIntArray(String sKey, int[] aiValue) {
        if (aiValue == null) {
            this.remove(sKey);
        } else {
            char cDelim = this.getArrayDelimiter();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < aiValue.length) {
                if (i > 0) {
                    sb.append(cDelim);
                }
                sb.append(String.valueOf(aiValue[i]));
                ++i;
            }
            this.get_Properties().setProperty(sKey, sb.toString());
        }
    }

    public void putString(String sKey, String sValue) {
        if (sValue == null) {
            this.remove(sKey);
        } else {
            this.get_Properties().setProperty(sKey, sValue);
        }
    }

    public void putStringArray(String sKey, String[] asValue) {
        if (asValue == null) {
            this.remove(sKey);
        } else {
            char cDelim = this.getArrayDelimiter();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < asValue.length) {
                if (i > 0) {
                    sb.append(cDelim);
                }
                sb.append(asValue[i]);
                ++i;
            }
            this.get_Properties().setProperty(sKey, sb.toString());
        }
    }

    public void putStringArray(String sKey, String[] asValue, char cDelim) {
        char cDelimOrig = this.getArrayDelimiter();
        this.setArrayDelimiter(cDelim);
        this.putStringArray(sKey, asValue);
        this.setArrayDelimiter(cDelimOrig);
    }

    public void remove(String sName) {
        ((Hashtable)this.get_Properties()).remove(sName);
    }

    public static String resolveName(String sName) {
        return sName.startsWith("/") ? sName : String.valueOf("/") + sName + CONFIG_EXTENSION;
    }

    public static String resolvePath(String sName) {
        return sName.startsWith("/") ? sName : String.valueOf(CONFIG_DIRECTORY) + Config.resolveName(sName);
    }

    public void setArrayDelimiter(char pArrayDelimiter) {
        this.__m_ArrayDelimiter = pArrayDelimiter;
    }

    private void set_Properties(Properties p_Properties) {
        this.__m__Properties = p_Properties;
    }

    public void store(OutputStream outStream, String sHeader) throws IOException {
        this.get_Properties().store(outStream, sHeader);
    }

    public String toString() {
        return ((Hashtable)this.get_Properties()).toString();
    }
}

