/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;

public class Daemon
extends Util
implements Runnable {
    public static final int DAEMON_EXITED = 4;
    public static final int DAEMON_EXITING = 3;
    public static final int DAEMON_INITIAL = 0;
    public static final int DAEMON_RUNNING = 2;
    public static final int DAEMON_STARTING = 1;
    private boolean __m_AutoStart;
    private transient int __m_DaemonState;
    private transient boolean __m_Exiting;
    private transient Object __m_Lock;
    private transient boolean __m_Notification;
    private int __m_Priority;
    private transient Throwable __m_StartException;
    private transient long __m_StartTimestamp;
    private transient Thread __m_Thread;
    private transient ThreadGroup __m_ThreadGroup;
    private String __m_ThreadName;
    private long __m_WaitMillis;
    private static transient long __s_ClockResolutionMillis;

    static {
        Daemon._initStatic();
    }

    public Daemon() {
        this(null, null, true);
    }

    public Daemon(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        try {
            Daemon.setClockResolutionMillis(1L);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
    }

    private static void _initStatic$Default() {
        Daemon.__initStatic();
    }

    protected static void _initStatic() {
        block7: {
            Daemon._initStatic$Default();
            try {
                String sMillis = System.getProperty("tangosol.coherence.clock_resolution");
                if (sMillis == null) {
                    String sOS = System.getProperty("os.name", "");
                    if (sOS.indexOf("Windows") != -1) {
                        if (Runtime.getRuntime().availableProcessors() > 1) {
                            Daemon.setClockResolutionMillis(16);
                        } else {
                            Daemon.setClockResolutionMillis(10);
                        }
                    } else {
                        Daemon.setClockResolutionMillis(20);
                    }
                    break block7;
                }
                Daemon.setClockResolutionMillis(Integer.parseInt(sMillis));
            }
            catch (Exception exception) {}
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }

    public static long getClockResolutionMillis() {
        return __s_ClockResolutionMillis;
    }

    public int getDaemonState() {
        return this.__m_DaemonState;
    }

    public Object getLock() {
        Object oLock = this.__m_Lock;
        return oLock == null ? this : oLock;
    }

    public int getPriority() {
        return this.__m_Priority;
    }

    public Throwable getStartException() {
        return this.__m_StartException;
    }

    public long getStartTimestamp() {
        return this.__m_StartTimestamp;
    }

    public Thread getThread() {
        return this.__m_Thread;
    }

    public ThreadGroup getThreadGroup() {
        return this.__m_ThreadGroup;
    }

    public String getThreadName() {
        String sName = this.__m_ThreadName;
        return sName == null ? this.get_Name() : sName;
    }

    public long getWaitMillis() {
        return this.__m_WaitMillis;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/Daemon".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Daemon();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isAutoStart() {
        return this.__m_AutoStart;
    }

    public boolean isExiting() {
        return this.getDaemonState() == DAEMON_EXITING;
    }

    public boolean isNotification() {
        return this.__m_Notification;
    }

    public boolean isStarted() {
        int nState = this.getDaemonState();
        return !(nState > DAEMON_INITIAL) ? false : nState < DAEMON_EXITED;
    }

    protected void onEnter() {
        this.setStartTimestamp(Base.getSafeTimeMillis());
    }

    protected void onException(Throwable e) {
        if (this.isExiting()) {
            Component._trace(String.valueOf(this.get_Name()) + " caught an unhandled exception (" + e.getClass().getName() + ": " + e.getMessage() + ") while exiting.", 4);
        } else {
            Component._trace(String.valueOf("Terminating ") + this.get_Name() + " due to unhandled exception: " + e.getClass().getName(), 1);
            Component._trace(e);
            this.stop();
        }
    }

    protected void onExit() {
    }

    public void onInit() {
        super.onInit();
        if (this.isAutoStart()) {
            this.start();
        }
    }

    protected void onInterrupt(InterruptedException e) {
        if (this.isExiting() ^ true) {
            Component._trace(String.valueOf("Interrupted ") + this.get_Name() + ", " + Thread.currentThread());
        }
    }

    protected void onNotify() {
    }

    protected void onWait() throws InterruptedException {
        if (this.isNotification() ^ true) {
            Object o;
            Object object = o = this.getLock();
            synchronized (object) {
                long cWait;
                if (this.isNotification() ^ true && (cWait = this.getWaitMillis()) >= (long)0) {
                    o.wait(cWait);
                }
                this.setNotification(false);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        Component._assert(this.getThread() == Thread.currentThread(), String.valueOf("run() invoked on a different thread: ") + Thread.currentThread());
        try {
            try {
                this.onEnter();
            }
            catch (Throwable e) {
                this.setStartException(e);
                this.onException(e);
            }
            e = this;
            synchronized (e) {
                this.setDaemonState(Daemon.DAEMON_RUNNING);
                this.notifyAll();
                // MONITOREXIT @DISABLED, blocks:[0, 2, 7] lbl14 : MonitorExitStatement: MONITOREXIT : e
                if (true) ** GOTO lbl31
            }
            do {
                try {
                    this.onWait();
                    if (!(this.isExiting() ^ true)) continue;
                    this.onNotify();
                }
                catch (EventDeathException e) {
                }
                catch (InterruptedException e) {
                    this.onInterrupt(e);
                }
                catch (Throwable e) {
                    this.onException(e);
                }
lbl31:
                // 6 sources

            } while (this.isExiting() ^ true);
        }
        catch (Throwable var1_6) {
            var2_8 = null;
            var3_10 = this;
            synchronized (var3_10) {
                try {
                    try {
                        this.onExit();
                    }
                    catch (Throwable e) {
                        this.onException(e);
                    }
                }
                finally {
                    v1 = null;
                }
            }
        }
        var2_7 = null;
        var3_9 = this;
        synchronized (var3_9) {
            try {
                try {
                    this.onExit();
                }
                catch (Throwable e) {
                    this.onException(e);
                }
            }
            finally {
                v3 = null;
            }
        }
    }

    public void setAutoStart(boolean fAutoStart) {
        this.__m_AutoStart = fAutoStart;
    }

    protected static void setClockResolutionMillis(long cMillis) {
        __s_ClockResolutionMillis = Math.max((long)1, cMillis);
    }

    protected void setDaemonState(int nState) {
        if (nState > this.getDaemonState()) {
            this.__m_DaemonState = nState;
        }
    }

    protected void setExiting(boolean fExiting) {
        this.setDaemonState(DAEMON_EXITING);
    }

    public void setLock(Object oLock) {
        this.__m_Lock = oLock;
    }

    public void setNotification(boolean fNotify) {
        if (this.is_Constructed()) {
            Object oLock;
            Object object = oLock = this.getLock();
            synchronized (object) {
                Thread thread;
                this.__m_Notification = fNotify;
                if (fNotify && (!((thread = this.getThread()) != null) ? false : thread != Thread.currentThread())) {
                    oLock.notifyAll();
                }
            }
        } else {
            this.__m_Notification = fNotify;
        }
    }

    public void setPriority(int nPriority) {
        this.__m_Priority = nPriority;
    }

    public void setStartException(Throwable e) {
        this.__m_StartException = e;
    }

    protected void setStartTimestamp(long lMillis) {
        this.__m_StartTimestamp = lMillis;
    }

    protected void setThread(Thread thread) {
        this.__m_Thread = thread;
    }

    public void setThreadGroup(ThreadGroup group) {
        this.__m_ThreadGroup = group;
    }

    public void setThreadName(String sName) {
        this.__m_ThreadName = sName;
    }

    public void setWaitMillis(long cMillis) {
        this.__m_WaitMillis = cMillis;
    }

    public static boolean sleep(long lMillis) {
        try {
            if (lMillis == (long)0) {
                Thread.yield();
            } else {
                Thread.sleep(lMillis);
            }
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public synchronized void start() {
        if (this.isStarted()) {
            return;
        }
        Thread thread = Base.makeThread((ThreadGroup)this.getThreadGroup(), (Runnable)this, (String)this.getThreadName());
        thread.setDaemon(true);
        int nPriority = this.getPriority();
        if (nPriority != 0) {
            thread.setPriority(nPriority);
        }
        this.setThread(thread);
        this.setStartException(null);
        this.setDaemonState(DAEMON_STARTING);
        thread.start();
        try {
            while (this.getDaemonState() < DAEMON_RUNNING) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new WrapperException((Throwable)e);
        }
        Throwable e = this.getStartException();
        if (e != null) {
            this.setStartException(null);
            throw new WrapperException(e);
        }
    }

    public synchronized void stop() {
        block3: {
            if (!this.isStarted()) break block3;
            this.setExiting(true);
            Thread thread = this.getThread();
            if (!(thread != null) ? false : thread != Thread.currentThread()) {
                try {
                    thread.interrupt();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

