/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.util.DaemonPool$Daemon;
import com.tangosol.coherence.component.util.DaemonPool$Queue;
import com.tangosol.coherence.component.util.DaemonPool$StopTask;
import com.tangosol.coherence.component.util.DaemonPool$WrapperTask;
import com.tangosol.net.PriorityTask;
import com.tangosol.util.AtomicCounter;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.SafeLinkedList;
import com.tangosol.util.WrapperException;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DaemonPool
extends Util {
    private int __m_AbandonThreshold;
    private boolean __m_AutoStart;
    private int __m_DaemonCount;
    private transient List __m_Daemons;
    private long __m_HungThreshold;
    private volatile transient AtomicCounter __m_NextCheckHolder;
    private DaemonPool$Queue __m_Queue;
    private transient boolean __m_Started;
    private transient int __m_StatsAbandonedCount;
    private transient long __m_StatsActiveMillis;
    private transient int __m_StatsHungCount;
    private transient long __m_StatsHungDuration;
    private transient String __m_StatsHungTaskId;
    private transient int __m_StatsMaxBacklog;
    private transient long __m_StatsTaskCount;
    private transient int __m_StatsTimeoutCount;
    private long __m_TaskTimeout;
    private transient ThreadGroup __m_ThreadGroup;
    private static ListMap __mapChildren;

    static {
        DaemonPool.__initStatic();
    }

    public DaemonPool() {
        this(null, null, true);
    }

    public DaemonPool(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setAbandonThreshold(8);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this._addChild(new DaemonPool$Queue("Queue", this, true), "Queue");
        this._addChild(new DaemonPool$StopTask("StopTask", this, true), "StopTask");
        this._addChild(new DaemonPool$WrapperTask("WrapperTask", this, true), "WrapperTask");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"Daemon", (Object)DaemonPool$Daemon.get_CLASS());
    }

    public void add(Runnable task) {
        this.add(task, false);
    }

    public void add(Runnable task, boolean fAggressiveTimeout) {
        if (task != null) {
            int cMaxBacklog;
            int cCurBacklog;
            DaemonPool$Queue queue = this.getQueue();
            DaemonPool$WrapperTask taskWrapper = this.instantiateWrapperTask(task, fAggressiveTimeout);
            long ldtStop = taskWrapper.getStopTime();
            queue.add(taskWrapper);
            if (ldtStop > (long)0) {
                this.ensureNextCheck(0L, ldtStop);
            }
            if ((cCurBacklog = queue.size()) > (cMaxBacklog = this.getStatsMaxBacklog())) {
                this.setStatsMaxBacklog(cCurBacklog);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkTimeouts() {
        long ldtNow = Base.getSafeTimeMillis();
        long cHungMillis = this.getHungThreshold();
        int cHung = 0;
        long cLongest = -1L;
        DaemonPool$WrapperTask taskLongest = null;
        long cNextCheck = Long.MAX_VALUE;
        List listDaemons = this.getDaemons();
        Object[] aDaemon = listDaemons.toArray();
        int i = 0;
        int cDaemons = aDaemon.length;
        while (i < cDaemons) {
            block20: {
                long cOverrun;
                block21: {
                    long ldtTimeout;
                    DaemonPool$Daemon daemon = (DaemonPool$Daemon)aDaemon[i];
                    DaemonPool$WrapperTask wrapper = daemon == null ? null : daemon.getWrapperTask();
                    if (wrapper == null) break block20;
                    long ldtStart = wrapper.getStartTime();
                    if (!(ldtStart > (long)0) ? false : cHungMillis > (long)0) {
                        long cOverrun2 = ldtNow - (ldtStart + cHungMillis);
                        if (cOverrun2 >= (long)0) {
                            long cDuration = ldtNow - ldtStart;
                            if (cDuration > cLongest) {
                                cLongest = cDuration;
                                taskLongest = wrapper;
                            }
                            ++cHung;
                            cNextCheck = Math.min(cNextCheck, 1000L);
                        } else {
                            cNextCheck = Math.min(cNextCheck, -cOverrun2);
                        }
                    }
                    if (!((ldtTimeout = wrapper.getStopTime()) > (long)0)) break block20;
                    cOverrun = ldtNow - ldtTimeout;
                    if (!(cOverrun >= (long)0)) break block21;
                    cNextCheck = 50L;
                    int cInterrupts = daemon.getInterruptCount();
                    if (cInterrupts < Math.abs(this.getAbandonThreshold())) {
                        daemon.interrupt();
                        if (cInterrupts == 0) {
                            this.setStatsTimeoutCount(this.getStatsTimeoutCount() + 1);
                        }
                        break block20;
                    } else {
                        daemon.abandon();
                        this.setStatsAbandonedCount(this.getStatsAbandonedCount() + 1);
                        DaemonPool$Daemon daemonNew = this.instantiateDaemon(0);
                        daemonNew.setThreadName(daemon.getThreadName());
                        List list = listDaemons;
                        synchronized (list) {
                            int ix = listDaemons.indexOf(daemon);
                            if (ix >= 0) {
                                listDaemons.set(ix, daemonNew);
                            } else {
                                listDaemons.add(daemonNew);
                            }
                        }
                        daemonNew.start();
                        break;
                    }
                }
                cNextCheck = Math.min(cNextCheck, -cOverrun);
            }
            ++i;
        }
        if (cHung == 0) {
            this.setStatsHungCount(0);
            this.setStatsHungDuration(0L);
            this.setStatsHungTaskId("");
        } else {
            this.setStatsHungCount(cHung);
            this.setStatsHungDuration(cLongest);
            this.setStatsHungTaskId(taskLongest.getTaskId());
        }
        while (true) {
            try {
                Iterator iter = this.getQueue().iterator();
                while (iter.hasNext()) {
                    DaemonPool$WrapperTask wrapper;
                    long ldtTimeout;
                    Object oTask = iter.next();
                    if (!(oTask instanceof DaemonPool$WrapperTask) || !((ldtTimeout = (wrapper = (DaemonPool$WrapperTask)oTask).getStopTime()) > (long)0)) continue;
                    long cOverrun = ldtNow - ldtTimeout;
                    if (cOverrun >= (long)0) {
                        this.setStatsTimeoutCount(this.getStatsTimeoutCount() + 1);
                        wrapper.cancel(ldtNow);
                        continue;
                    }
                    cNextCheck = Math.min(cNextCheck, -cOverrun);
                }
            }
            catch (ConcurrentModificationException e) {
                continue;
            }
            break;
        }
        this.ensureNextCheck(ldtNow, cNextCheck == Long.MAX_VALUE ? cNextCheck : ldtNow + cNextCheck);
    }

    public boolean ensureNextCheck(long ldtLast, long ldtNext) {
        if (ldtNext > ldtLast) {
            AtomicCounter holder = this.getNextCheckHolder();
            long ldtCurrent = holder.getCount();
            while (!(!(ldtLast < ldtCurrent) ? false : ldtCurrent <= ldtNext)) {
                if (holder.setCount(ldtCurrent, ldtNext)) {
                    return ldtNext < ldtCurrent;
                }
                ldtCurrent = holder.getCount();
            }
        }
        return false;
    }

    public int getAbandonThreshold() {
        return this.__m_AbandonThreshold;
    }

    public int getActiveDaemonCount() {
        if (this.getQueue().size() > 0) {
            return this.getDaemonCount();
        }
        Object[] aDaemon = this.getDaemons().toArray();
        int cActive = 0;
        int i = 0;
        int cDaemons = aDaemon.length;
        while (i < cDaemons) {
            DaemonPool$Daemon daemon = (DaemonPool$Daemon)aDaemon[i];
            if (!(daemon != null) ? false : daemon.getWrapperTask() != null) {
                ++cActive;
            }
            ++i;
        }
        return cActive;
    }

    public int getDaemonCount() {
        return this.__m_DaemonCount;
    }

    public List getDaemons() {
        return this.__m_Daemons;
    }

    public long getHungThreshold() {
        return this.__m_HungThreshold;
    }

    protected AtomicCounter getNextCheckHolder() {
        return this.__m_NextCheckHolder;
    }

    public long getNextCheckMillis() {
        AtomicCounter holder = this.getNextCheckHolder();
        return holder == null ? 0L : holder.getCount();
    }

    public DaemonPool$Queue getQueue() {
        return this.__m_Queue;
    }

    public int getStatsAbandonedCount() {
        return this.__m_StatsAbandonedCount;
    }

    public long getStatsActiveMillis() {
        return this.__m_StatsActiveMillis;
    }

    public int getStatsHungCount() {
        return this.__m_StatsHungCount;
    }

    public long getStatsHungDuration() {
        return this.__m_StatsHungDuration;
    }

    public String getStatsHungTaskId() {
        return this.__m_StatsHungTaskId;
    }

    public int getStatsMaxBacklog() {
        return this.__m_StatsMaxBacklog;
    }

    public long getStatsTaskCount() {
        return this.__m_StatsTaskCount;
    }

    public int getStatsTimeoutCount() {
        return this.__m_StatsTimeoutCount;
    }

    public long getTaskTimeout() {
        return this.__m_TaskTimeout;
    }

    public ThreadGroup getThreadGroup() {
        return this.__m_ThreadGroup;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/DaemonPool".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new DaemonPool();
    }

    private final Component get_Module() {
        return this;
    }

    public DaemonPool$Daemon instantiateDaemon(int i) {
        DaemonPool$Daemon daemon = (DaemonPool$Daemon)this._newChild("Daemon");
        String sName = daemon.getThreadName();
        daemon.setThreadName(String.valueOf(sName) + ":" + i);
        daemon.setThreadGroup(this.getThreadGroup());
        this.getDaemons().add(daemon);
        return daemon;
    }

    protected DaemonPool$WrapperTask instantiateWrapperTask(Runnable task, boolean fAggressiveTimeout) {
        DaemonPool$WrapperTask wrapper = new DaemonPool$WrapperTask();
        wrapper.setTask(task);
        if (task instanceof PriorityTask) {
            PriorityTask ptask = (PriorityTask)task;
            int iPriority = ptask.getSchedulingPriority();
            if (iPriority < PriorityTask.SCHEDULE_STANDARD ? true : iPriority > PriorityTask.SCHEDULE_IMMEDIATE) {
                Component._trace(String.valueOf("Invalid scheduling priority value: ") + iPriority + " for " + task.getClass().getName() + "; changing to SCHEDULE_STANDARD", 2);
                iPriority = PriorityTask.SCHEDULE_STANDARD;
            }
            wrapper.setPriority(iPriority);
            long cTimeout = ptask.getExecutionTimeoutMillis();
            if (cTimeout == PriorityTask.TIMEOUT_DEFAULT) {
                cTimeout = this.getTaskTimeout();
            }
            if (cTimeout > (long)0) {
                long ldtNow = Base.getSafeTimeMillis();
                wrapper.setPostTime(ldtNow);
                wrapper.setTimeoutMillis(cTimeout);
                if (fAggressiveTimeout) {
                    wrapper.setStopTime(ldtNow + cTimeout);
                }
            }
        }
        return wrapper;
    }

    protected boolean isAutoStart() {
        return this.__m_AutoStart;
    }

    public boolean isStarted() {
        return this.__m_Started;
    }

    public void onInit() {
        String sCount = System.getProperty("tangosol.coherence.pool.interruptcount");
        if (sCount != null) {
            this.setAbandonThreshold(Integer.parseInt(sCount));
        }
        this.setQueue((DaemonPool$Queue)this._findChild("Queue"));
        super.onInit();
        if (this.isAutoStart()) {
            this.start();
        }
    }

    public void resetStats() {
        this.setStatsActiveMillis(0L);
        this.setStatsMaxBacklog(0);
        this.setStatsTaskCount(0L);
        this.setStatsTimeoutCount(0);
    }

    public void runCanceled(PriorityTask task, boolean fAbandoned) {
        try {
            task.runCanceled(fAbandoned);
        }
        catch (RuntimeException runtimeException) {}
    }

    public void setAbandonThreshold(int c) {
        this.__m_AbandonThreshold = c;
    }

    protected void setAutoStart(boolean fAutoStart) {
        Component._assert(this.is_Constructed() ^ true);
        this.__m_AutoStart = fAutoStart;
    }

    public synchronized void setDaemonCount(int cThreads) {
        int cOrig = this.getDaemonCount();
        if (cThreads != cOrig) {
            if (cThreads < 0) {
                throw new IllegalArgumentException(String.valueOf("Requested number of threads (") + cThreads + ") is negative");
            }
            if (this.isStarted()) {
                if (cThreads > cOrig) {
                    int i = cOrig;
                    while (i < cThreads) {
                        DaemonPool$Daemon daemon = this.instantiateDaemon(i);
                        daemon.start();
                        ++i;
                    }
                } else {
                    int i = cThreads;
                    while (i < cOrig) {
                        this.add((DaemonPool$StopTask)this._findChild("StopTask"));
                        ++i;
                    }
                }
            }
            this.__m_DaemonCount = cThreads;
        }
    }

    protected void setDaemons(List list) {
        this.__m_Daemons = list;
    }

    public void setHungThreshold(long cMillis) {
        this.__m_HungThreshold = cMillis;
    }

    protected void setNextCheckHolder(AtomicCounter counter) {
        this.__m_NextCheckHolder = counter;
    }

    protected void setQueue(DaemonPool$Queue queue) {
        this.__m_Queue = queue;
    }

    protected void setStarted(boolean fStarted) {
        Component._assert(fStarted ^ true ? true : this.is_Constructed());
        this.__m_Started = fStarted;
    }

    protected void setStatsAbandonedCount(int cThreads) {
        this.__m_StatsAbandonedCount = cThreads;
    }

    protected void setStatsActiveMillis(long cMillis) {
        this.__m_StatsActiveMillis = cMillis;
    }

    protected void setStatsHungCount(int cHung) {
        this.__m_StatsHungCount = cHung;
    }

    protected void setStatsHungDuration(long cDuration) {
        this.__m_StatsHungDuration = cDuration;
    }

    protected void setStatsHungTaskId(String sTaskId) {
        this.__m_StatsHungTaskId = sTaskId;
    }

    protected void setStatsMaxBacklog(int cTasks) {
        this.__m_StatsMaxBacklog = cTasks;
    }

    protected void setStatsTaskCount(long cTasks) {
        this.__m_StatsTaskCount = cTasks;
    }

    protected void setStatsTimeoutCount(int cTasks) {
        this.__m_StatsTimeoutCount = cTasks;
    }

    public void setTaskTimeout(long cMillis) {
        this.__m_TaskTimeout = cMillis;
    }

    public void setThreadGroup(ThreadGroup group) {
        this.__m_ThreadGroup = group;
    }

    public synchronized void start() {
        Component._assert(this.is_Constructed());
        if (this.isStarted() ^ true) {
            this.setNextCheckHolder(AtomicCounter.newAtomicCounter());
            this.setDaemons((List)new SafeLinkedList());
            int i = 0;
            int cThreads = this.getDaemonCount();
            while (i < cThreads) {
                DaemonPool$Daemon daemon = this.instantiateDaemon(i);
                daemon.start();
                ++i;
            }
            this.setStarted(true);
        }
    }

    public synchronized void stop() {
        Component._assert(this.is_Constructed());
        if (this.isStarted()) {
            List listDaemons = this.getDaemons();
            this.setDaemons(null);
            this.setStarted(false);
            Iterator iter = listDaemons.iterator();
            while (iter.hasNext()) {
                DaemonPool$Daemon daemon = (DaemonPool$Daemon)iter.next();
                daemon.stop();
            }
        }
    }

    public synchronized long updateStats(int cTasks, long ldtStart) {
        long ldtNow = Base.getSafeTimeMillis();
        if (cTasks > 0) {
            this.setStatsTaskCount(this.getStatsTaskCount() + (long)cTasks);
            this.setStatsActiveMillis(this.getStatsActiveMillis() + ldtNow - ldtStart);
        }
        return ldtNow;
    }
}

