/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.net.extend.RemoteService;
import com.tangosol.coherence.component.net.extend.remoteService.RemoteCacheService;
import com.tangosol.coherence.component.net.extend.remoteService.RemoteInvocationService;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.util.LocalCache;
import com.tangosol.coherence.component.util.SafeCluster$ShutdownHook;
import com.tangosol.coherence.component.util.SafeService;
import com.tangosol.coherence.component.util.safeService.SafeCacheService;
import com.tangosol.coherence.component.util.safeService.SafeInvocationService;
import com.tangosol.coherence.component.util.safeService.safeCacheService.SafeDistributedCacheService;
import com.tangosol.net.CacheService;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.InvocationService;
import com.tangosol.net.Member;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceInfo;
import com.tangosol.net.management.Registry;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.LiteSet;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.WrapperException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SafeCluster
extends Util
implements com.tangosol.net.Cluster {
    private transient com.tangosol.net.Cluster __m_Cluster;
    private XmlElement __m_Config;
    private ClassLoader __m_ContextClassLoader;
    private Set __m_LocalServices;
    private transient Registry __m_Management;
    private boolean __m_Restart;
    private Map __m_ServiceMap;
    private Thread __m_ShutdownHook;
    private static ListMap __mapChildren;

    static {
        SafeCluster.__initStatic();
    }

    public SafeCluster() {
        this(null, null, true);
    }

    public SafeCluster(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setLocalServices((Set)new LiteSet());
            this.setServiceMap((Map)new SafeHashMap());
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"ShutdownHook", (Object)SafeCluster$ShutdownHook.get_CLASS());
    }

    protected void cleanup() {
        this.setCluster(null);
        this.getServiceMap().clear();
        this.getLocalServices().clear();
    }

    public void configure(XmlElement xmlConfig) {
        this.setConfig(xmlConfig);
    }

    public Service ensureLocalService(String sName, String sType) {
        Component serviceLocal;
        Component service;
        if (sType.equals(CacheService.TYPE_LOCAL)) {
            service = new LocalCache();
            ((LocalCache)service).setServiceName(sName);
            ((LocalCache)service).setCluster(this);
            serviceLocal = service;
        } else if (sType.equals(CacheService.TYPE_REMOTE)) {
            service = new RemoteCacheService();
            ((RemoteService)service).setServiceName(sName);
            ((RemoteService)service).setCluster(this);
            serviceLocal = service;
        } else if (sType.equals(InvocationService.TYPE_REMOTE)) {
            service = new RemoteInvocationService();
            ((RemoteService)service).setServiceName(sName);
            ((RemoteService)service).setCluster(this);
            serviceLocal = service;
        } else {
            throw new IllegalArgumentException(String.valueOf("illegal local service type: ") + sType);
        }
        Set setLocal = this.getLocalServices();
        if (!setLocal.isEmpty() ? false : this.getShutdownHook() == null) {
            Set set = setLocal;
            synchronized (set) {
                if (!setLocal.isEmpty() ? false : this.getShutdownHook() == null) {
                    try {
                        Thread thread = Base.makeThread(null, (Runnable)((SafeCluster$ShutdownHook)this._newChild("ShutdownHook")), null);
                        Runtime.getRuntime().addShutdownHook(thread);
                        this.setShutdownHook(thread);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
        }
        setLocal.add(serviceLocal);
        return serviceLocal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public com.tangosol.net.Cluster ensureRunningCluster() {
        Registry registry;
        Cluster cluster = (Cluster)this.getCluster();
        if (!(cluster == null ? true : cluster.isRunning() ^ true)) return cluster;
        boolean fRegister = true;
        SafeCluster safeCluster = this;
        synchronized (safeCluster) {
            cluster = (Cluster)this.getCluster();
            if (cluster == null ? true : cluster.isRunning() ^ true) {
                if (!this.isRestart()) throw new IllegalStateException("SafeCluster has been explicitly stopped or has not been started");
                if (cluster != null) {
                    cluster.ensureStopped();
                    cluster = null;
                    this.setCluster(null);
                    Component._trace("Restarting cluster", 3);
                }
                cluster = this.restartCluster();
                this.setCluster(cluster);
            } else {
                fRegister = false;
            }
        }
        if (!fRegister || !((registry = this.getManagement()) != null)) return cluster;
        Member member = this.getLocalMember();
        String sNodeName = registry.ensureGlobalName(Registry.NODE_TYPE);
        registry.register(sNodeName, (Object)member);
        MasterMemberSet setMembers = cluster.getPublisher().getMemberSet();
        String sP2PName = registry.ensureGlobalName(Registry.POINT_TO_POINT_TYPE);
        registry.register(sP2PName, (Object)setMembers);
        return cluster;
    }

    protected SafeService ensureSafeService(String sName, String sType) {
        Map mapService = this.getServiceMap();
        SafeService serviceSafe = (SafeService)mapService.get(sName);
        if (serviceSafe == null) {
            SafeCluster safeCluster = this;
            synchronized (safeCluster) {
                serviceSafe = (SafeService)mapService.get(sName);
                if (serviceSafe == null) {
                    Service service = SafeCluster.isLocalService(sType) ? this.ensureLocalService(sName, sType) : this.getRunningCluster().ensureService(sName, sType);
                    serviceSafe = this.instantiateSafeService(service);
                    serviceSafe.setSafeCluster(this);
                    serviceSafe.setServiceName(sName);
                    serviceSafe.setServiceType(sType);
                    serviceSafe.setService(service);
                    serviceSafe.setContextClassLoader(this.getContextClassLoader());
                    mapService.put(sName, serviceSafe);
                }
            }
        }
        return serviceSafe;
    }

    public Service ensureService(String sName, String sType) {
        String sCacheName = InvocationService.TYPE_DEFAULT.equals(sType) ? null : "*";
        Security.checkPermission(this.getCluster(), sName, sCacheName, "join");
        SafeService serviceSafe = (SafeService)this.getServiceMap().get(sName);
        if (serviceSafe == null) {
            serviceSafe = this.ensureSafeService(sName, sType);
        }
        if (serviceSafe.getServiceType().equals(sType) ^ true) {
            throw new IllegalArgumentException(String.valueOf("Requested service type \"") + sType + "\", but the existing service has type \"" + serviceSafe.getServiceType() + '\"');
        }
        return serviceSafe;
    }

    public com.tangosol.net.Cluster getCluster() {
        return this.__m_Cluster;
    }

    public String getClusterName() {
        return this.getRunningCluster().getClusterName();
    }

    public XmlElement getConfig() {
        return this.__m_Config;
    }

    public ClassLoader getContextClassLoader() {
        ClassLoader loader = this.__m_ContextClassLoader;
        if (loader == null) {
            loader = Base.getContextClassLoader((Object)this);
        }
        return loader;
    }

    public Member getLocalMember() {
        try {
            return this.getCluster().getLocalMember();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    protected Set getLocalServices() {
        return this.__m_LocalServices;
    }

    public Registry getManagement() {
        return this.__m_Management;
    }

    public Set getMemberSet() {
        return this.getRunningCluster().getMemberSet();
    }

    public Member getOldestMember() {
        return this.getRunningCluster().getOldestMember();
    }

    protected com.tangosol.net.Cluster getRunningCluster() {
        return this.ensureRunningCluster();
    }

    public Service getService(String sName) {
        Security.checkPermission(this.getCluster(), sName, null, "join");
        Map mapService = this.getServiceMap();
        SafeService serviceSafe = (SafeService)mapService.get(sName);
        if (serviceSafe == null) {
            SafeCluster safeCluster = this;
            synchronized (safeCluster) {
                Service service;
                serviceSafe = (SafeService)mapService.get(sName);
                if (serviceSafe == null && (service = this.getRunningCluster().getService(sName)) != null) {
                    serviceSafe = this.instantiateSafeService(service);
                    serviceSafe.setSafeCluster(this);
                    serviceSafe.setServiceName(sName);
                    serviceSafe.setServiceType(service.getInfo().getServiceType());
                    serviceSafe.setService(service);
                    serviceSafe.setContextClassLoader(this.getContextClassLoader());
                    mapService.put(sName, serviceSafe);
                }
            }
        }
        return serviceSafe;
    }

    public ServiceInfo getServiceInfo(String sName) {
        return this.getRunningCluster().getServiceInfo(sName);
    }

    protected Map getServiceMap() {
        return this.__m_ServiceMap;
    }

    public Enumeration getServiceNames() {
        return this.getRunningCluster().getServiceNames();
    }

    public Thread getShutdownHook() {
        return this.__m_ShutdownHook;
    }

    public long getTimeMillis() {
        try {
            return this.getCluster().getTimeMillis();
        }
        catch (NullPointerException e) {
            return 0L;
        }
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/SafeCluster".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new SafeCluster();
    }

    private final Component get_Module() {
        return this;
    }

    protected SafeService instantiateSafeService(Service service) {
        return service instanceof CacheService ? (service instanceof DistributedCacheService ? new SafeDistributedCacheService() : new SafeCacheService()) : (service instanceof InvocationService ? new SafeInvocationService() : new SafeService());
    }

    public static boolean isLocalService(String sType) {
        return (sType.equals(CacheService.TYPE_LOCAL) ? true : sType.equals(CacheService.TYPE_REMOTE)) ? true : sType.equals(InvocationService.TYPE_REMOTE);
    }

    public boolean isRestart() {
        return this.__m_Restart;
    }

    public boolean isRunning() {
        com.tangosol.net.Cluster cluster = this.getCluster();
        return !(!(cluster != null) ? false : this.isRestart()) ? false : cluster.isRunning();
    }

    public void removeLocalService(Service service) {
        Component._assert(SafeCluster.isLocalService(service.getInfo().getServiceType()));
        this.getLocalServices().remove(service);
    }

    protected Cluster restartCluster() {
        Cluster cluster = new Cluster();
        this.startCluster(cluster);
        return cluster;
    }

    protected void setCluster(com.tangosol.net.Cluster cluster) {
        this.__m_Cluster = cluster;
    }

    public void setConfig(XmlElement xmlConfig) {
        this.__m_Config = xmlConfig;
    }

    public void setContextClassLoader(ClassLoader loader) {
        this.__m_ContextClassLoader = loader;
    }

    protected void setLocalServices(Set set) {
        this.__m_LocalServices = set;
    }

    public void setManagement(Registry registry) {
        this.__m_Management = registry;
    }

    public void setRestart(boolean fRestart) {
        this.__m_Restart = fRestart;
    }

    protected void setServiceMap(Map map) {
        this.__m_ServiceMap = map;
    }

    protected void setShutdownHook(Thread thread) {
        this.__m_ShutdownHook = thread;
    }

    public synchronized void shutdown() {
        this.setRestart(false);
        com.tangosol.net.Cluster cluster = this.getCluster();
        if (cluster != null) {
            com.tangosol.net.Cluster cluster2 = cluster;
            synchronized (cluster2) {
                if (cluster.isRunning()) {
                    cluster.shutdown();
                }
            }
        }
        this.shutdownLocalServices();
        this.cleanup();
    }

    public void shutdownLocalServices() {
        try {
            Iterator iter = this.getLocalServices().iterator();
            while (iter.hasNext()) {
                Service service = (Service)iter.next();
                iter.remove();
                service.shutdown();
            }
        }
        catch (Throwable throwable) {}
    }

    public synchronized void start() {
        this.setRestart(true);
        this.ensureRunningCluster();
    }

    protected void startCluster(com.tangosol.net.Cluster cluster) {
        cluster.configure(this.getConfig());
        cluster.setManagement(this.getManagement());
        cluster.start();
    }

    public synchronized void stop() {
        this.setRestart(false);
        com.tangosol.net.Cluster cluster = this.getCluster();
        if (cluster != null) {
            com.tangosol.net.Cluster cluster2 = cluster;
            synchronized (cluster2) {
                if (cluster.isRunning()) {
                    cluster.stop();
                }
            }
        }
        this.shutdownLocalServices();
        this.cleanup();
    }

    public String toString() {
        return String.valueOf(this.get_Name()) + ": " + this.getCluster();
    }
}

