/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.daemon.QueueProcessor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$EventDispatcher$Queue;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.util.Map;

public class Service$EventDispatcher
extends QueueProcessor {
    private int __m_CloggedCount;
    private int __m_CloggedDelay;
    private volatile boolean __m_Dispatching;
    private static ListMap __mapChildren;

    static {
        Service$EventDispatcher.__initStatic();
    }

    public Service$EventDispatcher() {
        this(null, null, true);
    }

    public Service$EventDispatcher(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setCloggedCount(1024);
            this.setCloggedDelay(32);
            this.setDaemonState(0);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"Queue", (Object)Service$EventDispatcher$Queue.get_CLASS());
    }

    public void drainOverflow() {
        Service service = this.getService();
        if ((service.isServiceThread(false) ? true : service.isClusterThread(true)) ^ true) {
            int cMaxEvents = this.getCloggedCount();
            int cPauseMillis = this.getCloggedDelay();
            while (this.isStarted()) {
                int cEvents = this.getQueue().size();
                if ((cEvents < cMaxEvents ? true : cMaxEvents <= 0) ? true : Daemon.sleep(cPauseMillis) ^ true) break;
            }
        }
    }

    public void drainQueue() {
        if (this.getService().isServiceThread(false) ^ true) {
            Queue queue = this.getQueue();
            while (queue.size() > 0 ? true : this.isDispatching()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Base.ensureRuntimeException((Throwable)e);
                }
            }
        }
    }

    public int getCloggedCount() {
        return this.__m_CloggedCount;
    }

    public int getCloggedDelay() {
        return this.__m_CloggedDelay;
    }

    public Service getService() {
        return (Service)this.get_Module();
    }

    public String getThreadName() {
        return String.valueOf(this.getService().getThreadName()) + ':' + super.getThreadName();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/Service$EventDispatcher".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new Service$EventDispatcher();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public boolean isDispatching() {
        return this.__m_Dispatching;
    }

    protected void onException(Throwable e) {
        if (this.isExiting() ^ true) {
            Component._trace("The following exception was caught by the event dispatcher:", 1);
            Component._trace(e);
            Component._trace("(The service event thread has logged the exception and is continuing.)", 1);
        }
    }

    protected void onExit() {
        this.onNotify();
        super.onExit();
    }

    public void onInit() {
        try {
            String sMaxEvents = System.getProperty("tangosol.coherence.events.limit");
            String sDelay = System.getProperty("tangosol.coherence.events.delay");
            if (sMaxEvents != null) {
                this.setCloggedCount(Integer.parseInt(sMaxEvents));
            }
            if (sDelay != null) {
                this.setCloggedDelay(Integer.parseInt(sDelay));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.onInit();
    }

    protected void onNotify() {
        Queue queue = this.getQueue();
        Runnable task = null;
        this.setDispatching(true);
        try {
            block5: {
                try {
                    while (!((task = (Runnable)queue.removeNoWait()) == null)) {
                        task.run();
                    }
                }
                catch (Throwable e) {
                    if (!this.getService().isRunning()) break block5;
                    Component._trace(String.valueOf("An exception occurred while dispatching the following event:\n") + String.valueOf(task), 1);
                    this.onException(e);
                }
            }
            Object var4_5 = null;
            this.setDispatching(false);
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.setDispatching(false);
            throw throwable;
        }
    }

    public void setCloggedCount(int cMaxEvents) {
        this.__m_CloggedCount = cMaxEvents;
    }

    public void setCloggedDelay(int cMillis) {
        this.__m_CloggedDelay = Math.max(1, cMillis);
    }

    protected void setDispatching(boolean fDispatching) {
        this.__m_Dispatching = fDispatching;
    }
}

