/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Cluster$ClusterService;
import com.tangosol.coherence.component.net.Cluster$PacketPublisher;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.WindowedArray;
import com.tangosol.coherence.component.util.daemon.QueueProcessor;
import com.tangosol.coherence.component.util.daemon.QueueProcessor$Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$DispatchMemberEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$EventDispatcher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$MemberConfigRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$MemberConfigResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$MemberConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyMemberJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyMemberLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyMemberLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyMessageReceipt;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyPollClosed;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyServiceAnnounced;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyServiceJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyServiceLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyServiceLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyShutdown;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyStartup;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$PollArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$ProtocolContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$ServiceConfigMap;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$ServiceConfigRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$ServiceConfigResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$ServiceConfigSync;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$ServiceConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService;
import com.tangosol.coherence.component.util.queue.concurrentQueue.DualQueue;
import com.tangosol.io.MultiByteArrayInputStream;
import com.tangosol.io.WrapperStreamFactory;
import com.tangosol.license.LicenseException;
import com.tangosol.license.LicensedObject;
import com.tangosol.net.Member;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.PriorityTask;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.ServiceInfo;
import com.tangosol.net.internal.ProtocolAwareStream;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.AtomicCounter;
import com.tangosol.util.Base;
import com.tangosol.util.HashHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.LongArray;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.WrapperException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Service
extends QueueProcessor
implements com.tangosol.net.Service {
    public static final int MESSAGE_OFFSET = 32;
    public static final int SERVICE_INITIAL = 0;
    public static final int SERVICE_STARTED = 2;
    public static final int SERVICE_STARTING = 1;
    public static final int SERVICE_STOPPED = 4;
    public static final int SERVICE_STOPPING = 3;
    public static final long TIME_CLUSTER = -3L;
    public static final long TIME_SAFE = -2L;
    public static final long TIME_SYSTEM = -1L;
    private boolean __m_AcceptingClients;
    private boolean __m_AcceptingOthers;
    private transient com.tangosol.net.Cluster __m_Cluster;
    private MasterMemberSet __m_ClusterMemberSet;
    private ClassLoader __m_ContextClassLoader;
    private transient DaemonPool __m_DaemonPool;
    private transient Service$EventDispatcher __m_EventDispatcher;
    private Listeners __m_MemberListeners;
    private Class[] __m_MessageClass;
    private transient LongArray __m_PendingRequestInfo;
    private WindowedArray __m_PollArray;
    private Queue __m_QueueDeferred;
    private long __m_RequestTimeout;
    private transient AtomicCounter __m_SUIDCounter;
    private Queue __m_SendQueue;
    private XmlElement __m_ServiceConfig;
    private ObservableMap __m_ServiceConfigMap;
    private int __m_ServiceId;
    private ServiceMemberSet __m_ServiceMemberSet;
    private String __m_ServiceName;
    private int __m_ServiceState;
    private transient long __m_StatsCpu;
    private transient long __m_StatsPollCount;
    private transient long __m_StatsPollDuration;
    private transient long __m_StatsPollMaxDuration;
    private transient long __m_StatsReceived;
    private transient long __m_StatsReset;
    private volatile long __m_StatsTimeoutCount;
    private Object __m_UserContext;
    private List __m_WrapperStreamFactoryList;
    private static ListMap __mapChildren;

    static {
        Service.__initStatic();
    }

    public Service(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_MemberListeners = new Listeners();
            this.__m_QueueDeferred = new Queue();
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"DispatchMemberEvent", (Object)Service$DispatchMemberEvent.get_CLASS());
        Object object2 = __mapChildren.put((Object)"MemberConfigRequest", (Object)Service$MemberConfigRequest.get_CLASS());
        Object object3 = __mapChildren.put((Object)"MemberConfigResponse", (Object)Service$MemberConfigResponse.get_CLASS());
        Object object4 = __mapChildren.put((Object)"MemberConfigUpdate", (Object)Service$MemberConfigUpdate.get_CLASS());
        Object object5 = __mapChildren.put((Object)"NotifyMemberJoined", (Object)Service$NotifyMemberJoined.get_CLASS());
        Object object6 = __mapChildren.put((Object)"NotifyMemberLeaving", (Object)Service$NotifyMemberLeaving.get_CLASS());
        Object object7 = __mapChildren.put((Object)"NotifyMemberLeft", (Object)Service$NotifyMemberLeft.get_CLASS());
        Object object8 = __mapChildren.put((Object)"NotifyMessageReceipt", (Object)Service$NotifyMessageReceipt.get_CLASS());
        Object object9 = __mapChildren.put((Object)"NotifyPollClosed", (Object)Service$NotifyPollClosed.get_CLASS());
        Object object10 = __mapChildren.put((Object)"NotifyServiceAnnounced", (Object)Service$NotifyServiceAnnounced.get_CLASS());
        Object object11 = __mapChildren.put((Object)"NotifyServiceJoined", (Object)Service$NotifyServiceJoined.get_CLASS());
        Object object12 = __mapChildren.put((Object)"NotifyServiceLeaving", (Object)Service$NotifyServiceLeaving.get_CLASS());
        Object object13 = __mapChildren.put((Object)"NotifyServiceLeft", (Object)Service$NotifyServiceLeft.get_CLASS());
        Object object14 = __mapChildren.put((Object)"NotifyShutdown", (Object)Service$NotifyShutdown.get_CLASS());
        Object object15 = __mapChildren.put((Object)"NotifyStartup", (Object)Service$NotifyStartup.get_CLASS());
        Object object16 = __mapChildren.put((Object)"ProtocolContext", (Object)Service$ProtocolContext.get_CLASS());
        Object object17 = __mapChildren.put((Object)"Queue", (Object)QueueProcessor$Queue.get_CLASS());
        Object object18 = __mapChildren.put((Object)"ServiceConfigRequest", (Object)Service$ServiceConfigRequest.get_CLASS());
        Object object19 = __mapChildren.put((Object)"ServiceConfigResponse", (Object)Service$ServiceConfigResponse.get_CLASS());
        Object object20 = __mapChildren.put((Object)"ServiceConfigSync", (Object)Service$ServiceConfigSync.get_CLASS());
        Object object21 = __mapChildren.put((Object)"ServiceConfigUpdate", (Object)Service$ServiceConfigUpdate.get_CLASS());
    }

    public void addMemberListener(MemberListener l) {
        this.ensureEventDispatcher();
        this.getMemberListeners().add((EventListener)l);
    }

    public static long adjustTimeout(long lDefaultTimeout, long lContextTimeout) {
        long TIMEOUT_DEFAULT = 0L;
        long TIMEOUT_NONE = -1L;
        return lContextTimeout == TIMEOUT_DEFAULT ? lDefaultTimeout : (lContextTimeout == TIMEOUT_NONE ? 0L : lContextTimeout);
    }

    public long adjustWaitTime(long cWaitMillis, long cAdjustMillis) {
        if (cWaitMillis < 0L) {
            return Long.MAX_VALUE;
        }
        if (cAdjustMillis < 0L) {
            if (cAdjustMillis == TIME_CLUSTER) {
                cAdjustMillis = this.getClusterTime();
            } else if (cAdjustMillis == TIME_SAFE) {
                cAdjustMillis = Base.getSafeTimeMillis();
            } else if (cAdjustMillis == TIME_SYSTEM) {
                cAdjustMillis = System.currentTimeMillis();
            } else {
                throw new IllegalArgumentException(String.valueOf("Invalid adjustment: ") + cAdjustMillis);
            }
        }
        return (cWaitMillis += cAdjustMillis) < 0L ? Long.MAX_VALUE : cWaitMillis;
    }

    public static long calculateOldestSUID(LongArray array, int nMember) {
        long lSUID;
        long lBase = Service.getBaseSUID(nMember);
        LongArray longArray = array;
        synchronized (longArray) {
            LongArray.Iterator iter = array.iterator(lBase);
            if (!iter.hasNext()) {
                long l = -1L;
                Object var10_7 = null;
                return l;
            }
            iter.next();
            lSUID = iter.getIndex();
        }
        return Service.getMemberId(lSUID) == nMember ? lSUID : -1L;
    }

    public long checkRequestTimeout(long ldtStart, long cTimeout) {
        long cElapsed = System.currentTimeMillis() - ldtStart;
        if (cElapsed >= cTimeout) {
            this.setStatsTimeoutCount(this.getStatsTimeoutCount() + 1L);
            throw new RequestTimeoutException(String.valueOf("Request timed out after ") + cElapsed + " millis");
        }
        return cTimeout - Math.max(0L, cElapsed);
    }

    protected void closePolls() {
        Service$ServiceConfigMap config = (Service$ServiceConfigMap)this.getServiceConfigMap();
        config.getPendingPolls().clear();
        WindowedArray waPoll = this.getPollArray();
        long l = waPoll.getFirstIndex();
        while (l <= waPoll.getLastIndex()) {
            Poll poll = (Poll)waPoll.get(l);
            if (poll != null) {
                poll.close();
            }
            ++l;
        }
    }

    public void closePolls(com.tangosol.coherence.component.net.Member member) {
        long lLast;
        long lFirst;
        WindowedArray waPoll;
        Component._assert(Thread.currentThread() == this.getThread());
        WindowedArray windowedArray = waPoll = this.getPollArray();
        synchronized (windowedArray) {
            lFirst = waPoll.getFirstIndex();
            lLast = waPoll.getLastIndex();
        }
        long l = lFirst;
        while (l <= lLast) {
            Poll poll = (Poll)waPoll.get(l);
            if (poll != null) {
                poll.onLeft(member);
            }
            ++l;
        }
    }

    public int compareImportance(com.tangosol.coherence.component.net.Member memberThat) {
        return 0;
    }

    public void configure(XmlElement xml) {
        this.setServiceConfig(xml);
        if (xml != null) {
            String sRequestTimeout;
            int cThreads = xml.getSafeElement("thread-count").getInt();
            if (cThreads > 0) {
                String sTaskTimeout;
                DaemonPool pool = this.getDaemonPool();
                pool.setDaemonCount(cThreads);
                String sHungMillis = xml.getSafeElement("task-hung-threshold").getString();
                if (sHungMillis.length() > 0) {
                    pool.setHungThreshold(Base.parseTime((String)sHungMillis));
                }
                if ((sTaskTimeout = xml.getSafeElement("task-timeout").getString()).length() > 0) {
                    pool.setTaskTimeout(Base.parseTime((String)sTaskTimeout));
                }
            }
            if ((sRequestTimeout = xml.getSafeElement("request-timeout").getString()).length() > 0) {
                this.setRequestTimeout(Base.parseTime((String)sRequestTimeout));
            }
        }
    }

    public void dispatchMemberEvent(com.tangosol.coherence.component.net.Member member, int nEvent) {
        Listeners listeners = this.getMemberListeners();
        if (listeners.isEmpty() ^ true) {
            Service$DispatchMemberEvent task = (Service$DispatchMemberEvent)this._newChild("DispatchMemberEvent");
            task.setMemberEvent(new MemberEvent((Object)this, nEvent, (Member)member));
            task.setListeners(listeners);
            this.ensureEventDispatcher().getQueue().add(task);
        }
    }

    protected boolean dispatchMessage(Message msg) {
        com.tangosol.coherence.component.net.Member memberFrom = msg.getFromMember();
        if (memberFrom == null && (memberFrom = this.getThisMember()) != null) {
            msg.setFromMember(memberFrom);
        }
        MemberSet setMemberTo = msg.getToMemberSet();
        int LOCAL = 1;
        int REMOTE = 2;
        int nDestination = setMemberTo == null ? (msg.getMessageType() < 0 ? LOCAL : REMOTE) : ((!(memberFrom != null) ? false : setMemberTo.contains(memberFrom)) ? (setMemberTo.size() == 1 ? LOCAL : LOCAL | REMOTE) : REMOTE);
        boolean fSent = false;
        if ((nDestination & LOCAL) != 0) {
            fSent = this.getQueue().add(msg);
        }
        if (!((nDestination & REMOTE) != 0) ? false : this.getSendQueue().add(msg)) {
            return true;
        }
        if (msg.isNotifySent()) {
            this.onMessageReceipt(msg);
        }
        return fSent;
    }

    public void drainEvents() {
        Service$EventDispatcher daemon = this.getEventDispatcher();
        if (daemon != null) {
            daemon.drainQueue();
        }
    }

    public Service$EventDispatcher ensureEventDispatcher() {
        Service$EventDispatcher dispatcher = this.getEventDispatcher();
        if (dispatcher == null) {
            dispatcher = (Service$EventDispatcher)this._findChild("EventDispatcher");
            if (this.isExiting() ^ true) {
                dispatcher.setThreadGroup(this.getThreadGroup());
                dispatcher.start();
            }
            this.setEventDispatcher(dispatcher);
        }
        return dispatcher;
    }

    public void flushSend() {
        this.getSendQueue().flush();
        if (this.getThread() != Thread.currentThread()) {
            this.getQueue().flush();
        }
    }

    public static String formatServiceStateName(int nState) {
        switch (nState) {
            case 0: {
                return "SERVICE_INITIAL";
            }
            case 1: {
                return "SERVICE_STARTING";
            }
            case 2: {
                return "SERVICE_STARTED";
            }
            case 3: {
                return "SERVICE_STOPPING";
            }
            case 4: {
                return "SERVICE_STOPPED";
            }
        }
        return "<unknown>";
    }

    public String formatStats() {
        long cCpu = this.getStatsCpu();
        long cTotal = Base.getSafeTimeMillis() - this.getStatsReset();
        long cMsgs = this.getStatsReceived();
        double dCpu = cTotal == 0L ? 0.0 : (double)cCpu / (double)cTotal;
        double dThru = cCpu == 0L ? 0.0 : (double)cMsgs * (double)1000 / (double)cCpu;
        dCpu = (double)((int)(dCpu * (double)1000)) / 10.0;
        StringBuffer sb = new StringBuffer();
        sb.append("Cpu=").append(cCpu).append("ms (").append(dCpu).append("%), Messages=").append(cMsgs).append(", Throughput=").append((float)dThru).append("msg/sec");
        DaemonPool pool = this.getDaemonPool();
        if (pool.isStarted()) {
            long cPoolTotal = pool.getStatsActiveMillis();
            long cTasks = pool.getStatsTaskCount();
            long cHung = pool.getStatsHungCount();
            float flAvgThread = cTotal == 0L ? 0.0f : (float)((double)cPoolTotal / (double)cTotal);
            float flAvgTask = cTasks == 0L ? 0.0f : (float)((double)cPoolTotal / (double)cTasks);
            sb.append(", AverageActiveThreadCount=").append(flAvgThread).append(", Tasks=").append(cTasks).append(", AverageTaskDuration=").append(flAvgTask).append("ms, MaximumBacklog=").append(pool.getStatsMaxBacklog());
            if (cHung > (long)0) {
                sb.append(", HungTaskCount=").append(cHung).append(", HungMaxDuration=").append(pool.getStatsHungDuration()).append(", HungMaxId=").append(pool.getStatsHungTaskId());
            }
        }
        return sb.toString();
    }

    public static long getBaseSUID(int nMember) {
        return (long)nMember << 48;
    }

    public static long getBaseSUID(long lSUID) {
        return lSUID & 0xFF000000000000L;
    }

    public com.tangosol.net.Cluster getCluster() {
        return this.__m_Cluster;
    }

    public MasterMemberSet getClusterMemberSet() {
        return this.__m_ClusterMemberSet;
    }

    public com.tangosol.coherence.component.net.Member getClusterOldestMember() {
        return this.getClusterMemberSet().getOldestMember();
    }

    public long getClusterTime() {
        return this.getCluster().getTimeMillis();
    }

    public int getClusterTimeVariance() {
        return ((Cluster)this.getCluster()).getClusterService().getTimestampMaxVariance();
    }

    public ClassLoader getContextClassLoader() {
        return this.__m_ContextClassLoader;
    }

    public DaemonPool getDaemonPool() {
        DaemonPool pool = this.__m_DaemonPool;
        if (pool == null) {
            pool = (DaemonPool)this._findChild("DaemonPool");
            this.setDaemonPool(pool);
        }
        return pool;
    }

    public String getDescription() {
        return null;
    }

    public Service$EventDispatcher getEventDispatcher() {
        return this.__m_EventDispatcher;
    }

    public ServiceInfo getInfo() {
        return this.getCluster().getServiceInfo(this.getServiceName());
    }

    public static int getMemberId(long lSUID) {
        return (int)(lSUID >>> 48);
    }

    public Listeners getMemberListeners() {
        return this.__m_MemberListeners;
    }

    private Class[] getMessageClass() {
        return this.__m_MessageClass;
    }

    public Class getMessageClass(int i) {
        Class[] aClass = this.getMessageClass();
        return (!(aClass != null) ? false : (i += MESSAGE_OFFSET) < aClass.length) ? aClass[i] : null;
    }

    public long getOldestPendingRequestSUID() {
        return Service.calculateOldestSUID(this.getPendingRequestInfo(), this.getThisMember().getId());
    }

    public MemberSet getOthersMemberSet() {
        MemberSet set = new MemberSet();
        set.addAll((Collection)this.getServiceMemberSet());
        set.remove(this.getThisMember());
        return set;
    }

    public int getPendingConfigRequestCount() {
        return ((Service$ServiceConfigMap)this.getServiceConfigMap()).getPendingPolls().size();
    }

    public LongArray getPendingRequestInfo() {
        return this.__m_PendingRequestInfo;
    }

    public WindowedArray getPollArray() {
        return this.__m_PollArray;
    }

    public ProtocolAwareStream.ProtocolContext getProtocolContext(Message msg) {
        Service$ProtocolContext context = new Service$ProtocolContext();
        context.setMessage(msg);
        return context;
    }

    protected Queue getQueueDeferred() {
        return this.__m_QueueDeferred;
    }

    public long getRequestTimeout() {
        return this.__m_RequestTimeout;
    }

    public long getSUID() {
        return this.getSUIDCounter().increment(1L);
    }

    protected AtomicCounter getSUIDCounter() {
        return this.__m_SUIDCounter;
    }

    public Queue getSendQueue() {
        return this.__m_SendQueue;
    }

    public XmlElement getServiceConfig() {
        return this.__m_ServiceConfig;
    }

    public ObservableMap getServiceConfigMap() {
        ObservableMap map = this.__m_ServiceConfigMap;
        if (map == null) {
            map = (Service$ServiceConfigMap)this._findChild("ServiceConfigMap");
            this.setServiceConfigMap(map);
        }
        return map;
    }

    public int getServiceId() {
        return this.__m_ServiceId;
    }

    public long getServiceJoined() {
        return this.getServiceMemberSet().getServiceJoined(this.getThisMember().getId());
    }

    public ServiceMemberSet getServiceMemberSet() {
        return this.__m_ServiceMemberSet;
    }

    public String getServiceName() {
        String sName = this.__m_ServiceName;
        return sName == null ? this.get_Name() : sName;
    }

    public com.tangosol.coherence.component.net.Member getServiceOldestMember() {
        return this.getServiceMemberSet().getOldestMember();
    }

    public int getServiceState() {
        return this.__m_ServiceState;
    }

    public String getServiceStateName() {
        return Service.formatServiceStateName(this.getServiceState());
    }

    public String getServiceType() {
        return null;
    }

    public String getServiceVersion() {
        return null;
    }

    public long getStatsCpu() {
        return this.__m_StatsCpu;
    }

    public long getStatsPollCount() {
        return this.__m_StatsPollCount;
    }

    public long getStatsPollDuration() {
        return this.__m_StatsPollDuration;
    }

    public long getStatsPollMaxDuration() {
        return this.__m_StatsPollMaxDuration;
    }

    public long getStatsReceived() {
        return this.__m_StatsReceived;
    }

    public long getStatsReset() {
        return this.__m_StatsReset;
    }

    public long getStatsTimeoutCount() {
        return this.__m_StatsTimeoutCount;
    }

    public com.tangosol.coherence.component.net.Member getThisMember() {
        MasterMemberSet setMembers = this.getClusterMemberSet();
        return setMembers == null ? null : setMembers.getThisMember();
    }

    public ObservableMap getThisMemberConfigMap() {
        com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
        return memberThis == null ? null : this.getServiceMemberSet().ensureMemberConfigMap(memberThis.getId());
    }

    public String getThreadName() {
        String sServiceType = this.getServiceType();
        String sServiceName = this.getServiceName();
        return sServiceName.equals(sServiceType) ? sServiceName : String.valueOf(sServiceType) + ':' + sServiceName;
    }

    public Object getUserContext() {
        return this.__m_UserContext;
    }

    public long getWaitMillis() {
        DaemonPool pool = this.getDaemonPool();
        long cWait1 = super.getWaitMillis();
        long cWait2 = pool.isStarted() ? Math.max(1L, pool.getNextCheckMillis() - Base.getSafeTimeMillis()) : 0L;
        return cWait1 <= 0L ? cWait2 : Math.min(cWait1, cWait2);
    }

    public List getWrapperStreamFactoryList() {
        return this.__m_WrapperStreamFactoryList;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/Service".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public final Object get_Feed() {
        try {
            LicensedObject.LicenseData[] aLic = LicensedObject.getLicenseData();
            ArrayList<LicensedObject.LicenseData> list = new ArrayList<LicensedObject.LicenseData>();
            int nMaxType = -1;
            int i = 0;
            int c = aLic.length;
            while (i < c) {
                int nType;
                LicensedObject.LicenseData lic = aLic[i];
                if (LicensedObject.getLicenseFailure((LicensedObject.LicenseData)lic) == null && (nType = lic.nLicenseType) >= nMaxType) {
                    nMaxType = nType;
                    list.add(lic);
                }
                ++i;
            }
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                LicensedObject.LicenseData lic = (LicensedObject.LicenseData)iter.next();
                if (!(lic.nLicenseType < nMaxType)) continue;
                iter.remove();
            }
            return list.toArray(new LicensedObject.LicenseData[list.size()]);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException((Throwable)e);
        }
    }

    private final Component get_Module() {
        return this;
    }

    protected void initializeSUID() {
        int nMember = this.getThisMember().getId();
        long lMillis = this.getClusterTime();
        long lFirst = (long)nMember << 48 | lMillis & 0xFFFFFFFFFFFFL;
        AtomicCounter counter = AtomicCounter.newAtomicCounter();
        counter.increment(lFirst);
        this.setSUIDCounter(counter);
    }

    /*
     * WARNING - void declaration
     */
    public Message instantiateMessage(int nMsgType) {
        Class clz = this.getMessageClass(nMsgType);
        if (clz == null) {
            int nConvertedType = -(65535 - nMsgType + 1);
            clz = this.getMessageClass(nConvertedType);
            if (clz == null) {
                throw new RuntimeException(String.valueOf("Service ") + this.getServiceName() + " was unable to instantiate MessageType=" + nMsgType);
            }
            Component._trace(String.valueOf("Compensated for JIT compilation error (optimized out I2S); ") + "Expected: " + nConvertedType + ", received: " + nMsgType, 2);
        }
        try {
            void e;
            Message msg = (Message)clz.newInstance();
            msg.setService(this);
            return e;
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Message instantiateMessage(String sMsgName) {
        Class clz = (Class)((Component)this).get_ChildClasses().get(sMsgName);
        if (clz == null) {
            throw new IllegalArgumentException(String.valueOf("Unable to instantiate Message \"") + sMsgName + '\"');
        }
        try {
            void e;
            Message msg = (Message)clz.newInstance();
            msg.setService(this);
            return e;
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException((Throwable)e);
        }
    }

    protected Queue instantiateQueue() {
        DualQueue queue = new DualQueue();
        queue.setBatchSize(Integer.parseInt(System.getProperty("tangosol.coherence.service.batch", "4")));
        return queue;
    }

    public boolean isAcceptingClients() {
        return this.__m_AcceptingClients;
    }

    public boolean isAcceptingOthers() {
        return this.__m_AcceptingOthers;
    }

    public boolean isClusterThread(boolean fStrict) {
        ThreadGroup groupCluster = this.getThread().getThreadGroup();
        ThreadGroup groupThis = Thread.currentThread().getThreadGroup();
        return fStrict ? groupCluster == groupThis : groupCluster.parentOf(groupThis);
    }

    public boolean isRunning() {
        return !(this.getServiceState() == SERVICE_STARTED) ? false : this.isExiting() ^ true;
    }

    public boolean isServiceThread(boolean fStrict) {
        Thread thread = Thread.currentThread();
        Service$EventDispatcher dispatcher = this.getEventDispatcher();
        if (thread == this.getThread() ? true : (!(dispatcher != null) ? false : thread == dispatcher.getThread())) {
            return true;
        }
        if (fStrict ^ true) {
            DaemonPool pool = this.getDaemonPool();
            return !(pool != null) ? false : pool.getThreadGroup() == thread.getThreadGroup();
        }
        return false;
    }

    protected void onEnter() {
        super.onEnter();
        this.resetStats();
        if (this instanceof ClusterService ^ true) {
            this.initializeSUID();
        }
        this.setServiceState(SERVICE_STARTING);
        this.send(this.instantiateMessage("NotifyStartup"));
    }

    public void onException(Throwable e) {
        if (this.getServiceState() < SERVICE_STARTED ? true : (!(this.getServiceState() == SERVICE_STARTED) ? false : this.isAcceptingClients() ^ true)) {
            this.setStartException(e);
        }
        super.onException(e);
    }

    protected void onExit() {
        Security security;
        DaemonPool pool;
        try {
            this.setServiceState(SERVICE_STOPPED);
        }
        catch (Throwable e) {
            Component._trace(String.valueOf("Exception occured during exiting:\n ") + Component.getStackTrace(e), 4);
        }
        super.onExit();
        Service$EventDispatcher daemonDispatcher = this.getEventDispatcher();
        if (daemonDispatcher != null) {
            daemonDispatcher.stop();
        }
        if ((pool = this.getDaemonPool()).isStarted()) {
            pool.stop();
        }
        if ((security = Security.getInstance()) != null) {
            security.releaseSecureContext(this.getServiceName());
        }
    }

    public void onInit() {
        super.onInit();
        Map map = ((Component)this).get_ChildClasses();
        Class clzMessage = Message.get_CLASS();
        Iterator iter = map.values().iterator();
        while (iter.hasNext()) {
            Class clz = (Class)iter.next();
            if (!clzMessage.isAssignableFrom(clz)) continue;
            try {
                Message msg = (Message)clz.newInstance();
                int nType = msg.getMessageType();
                if (this.getMessageClass(nType) != null) {
                    throw new IllegalStateException(String.valueOf(clz) + " - duplicate MessageType: " + nType + " " + this.getMessageClass(nType));
                }
                this.setMessageClass(nType, clz);
            }
            catch (Exception e) {
                Component._trace(String.valueOf("Service.onInit: Unable to instantiate ") + clz, 1);
                Component._trace(e);
            }
        }
        WindowedArray waPoll = (WindowedArray)this._findChild("PollArray");
        this.setPollArray(waPoll);
        waPoll.remove(waPoll.add(null));
    }

    public void onMessage(Message msg) {
        if (msg != null) {
            block4: {
                try {
                    msg.onReceived();
                }
                catch (EventDeathException e) {
                    if (!(msg instanceof RequestMessage)) break block4;
                    Component._trace(String.valueOf("Processing for RequestMessage has been interrupted:\n") + msg, 2);
                    Component._trace(Component.getStackTrace(e), 4);
                }
            }
            Poll poll = msg.getPoll();
            if (poll != null) {
                poll.onResponse(msg);
            }
        }
    }

    protected boolean onMessageReadException(Throwable e, Message msg) {
        if (e instanceof SecurityException) {
            Component._trace(String.valueOf("SecurityException received while reading ") + msg + "\n" + Component.getStackTrace(e), 1);
        } else {
            Component._trace(String.valueOf("An exception (") + e.getClass().getName() + ") occurred reading Message " + msg.get_Name() + " Type=" + msg.getMessageType() + " for Service=" + this, 1);
            this.onException(e);
        }
        return false;
    }

    public void onMessageReceipt(Message msg) {
        if (msg != null) {
            Service$NotifyMessageReceipt msgRecpt = (Service$NotifyMessageReceipt)this.instantiateMessage("NotifyMessageReceipt");
            msgRecpt.setNotifyMessage(msg);
            this.send(msgRecpt);
        }
    }

    protected void onNotify() {
        long lStart = Base.getSafeTimeMillis();
        long cMsgs = this.getStatsReceived();
        while (this.isExiting() ^ true) {
            if (cMsgs % 1024L == 0L) {
                ((Service$PollArray)this.getPollArray()).validate();
            }
            Message msg = null;
            boolean fAccept = this.isAcceptingOthers();
            if (!fAccept ? false : this.getQueueDeferred().isEmpty() ^ true) {
                msg = (Message)this.getQueueDeferred().remove();
            } else {
                msg = (Message)this.getQueue().removeNoWait();
                if (msg == null) break;
                if (!(!(fAccept ^ true) ? false : msg.isIncoming()) ? false : msg.getMessageType() >= 0) {
                    this.getQueueDeferred().add(msg);
                    continue;
                }
            }
            ++cMsgs;
            if (msg.isIncoming()) {
                int cPackets = msg.getMessagePartCount();
                Object stream = null;
                if (cPackets == 1) {
                    byte[] ab = msg.getPacket(0).getBody();
                    if (!(ab != null) ? false : ab.length > 0) {
                        stream = new ByteArrayInputStream(ab);
                    }
                } else {
                    byte[][] aab = new byte[cPackets][];
                    int i = 0;
                    while (i < cPackets) {
                        aab[i] = msg.getPacket(i).getBody();
                        ++i;
                    }
                    stream = new MultiByteArrayInputStream(aab);
                }
                try {
                    List listSvc;
                    Cluster$PacketPublisher publisher = ((Cluster)this.getCluster()).getPublisher();
                    List listAll = publisher.getWrapperStreamFactoryList();
                    if (listAll != null) {
                        int i = listAll.size() - 1;
                        while (i >= 0) {
                            stream = ((WrapperStreamFactory)listAll.get(i)).getInputStream((InputStream)stream);
                            if (stream instanceof ProtocolAwareStream) {
                                ((ProtocolAwareStream)stream).setProtocolContext(this.getProtocolContext(msg));
                            }
                            --i;
                        }
                    }
                    if ((listSvc = this.getWrapperStreamFactoryList()) != null) {
                        int i = listSvc.size() - 1;
                        while (i >= 0) {
                            stream = ((WrapperStreamFactory)listSvc.get(i)).getInputStream((InputStream)stream);
                            if (stream instanceof ProtocolAwareStream) {
                                ((ProtocolAwareStream)stream).setProtocolContext(this.getProtocolContext(msg));
                            }
                            --i;
                        }
                    }
                    DataInputStream streamData = new DataInputStream((InputStream)stream);
                    msg.readInternal(streamData);
                    msg.read(streamData);
                    ((InputStream)stream).close();
                }
                catch (Throwable e) {
                    if (this.onMessageReadException(e, msg) ^ true) continue;
                }
            }
            this.onMessage(msg);
        }
        long ldtNow = Base.getSafeTimeMillis();
        this.setStatsReceived(cMsgs);
        this.setStatsCpu(this.getStatsCpu() + (ldtNow - lStart));
        DaemonPool pool = this.getDaemonPool();
        if (!pool.isStarted() ? false : ldtNow >= pool.getNextCheckMillis()) {
            pool.checkTimeouts();
        }
    }

    public void onPollClosed(Poll poll) {
        this.unregisterPoll(poll);
    }

    public void onServiceStarted() {
        this.setAcceptingOthers(true);
        this.setAcceptingClients(true);
    }

    protected void onServiceStopped() {
        this.setAcceptingClients(false);
    }

    protected void onServiceStopping() {
        this.setAcceptingClients(false);
    }

    protected void onWait() throws InterruptedException {
        this.flushSend();
        super.onWait();
    }

    public Object poll(RequestMessage msg) {
        long lTimeout = this.getRequestTimeout();
        if (msg instanceof PriorityTask) {
            lTimeout = Service.adjustTimeout(lTimeout, ((PriorityTask)msg).getRequestTimeoutMillis());
        }
        return this.poll(msg, lTimeout);
    }

    public Object poll(RequestMessage msg, long lMillis) {
        Component._assert(this.getThread() != Thread.currentThread(), "poll() is a blocking call and cannot be called on the Service thread");
        this.waitAcceptingClients();
        Poll poll = msg.ensureRequestPoll();
        this.send(msg);
        Poll poll2 = poll;
        synchronized (poll2) {
            if (poll.getRemainingMemberSet().isEmpty()) {
                poll.close();
            }
            if (poll.isClosed() ^ true) {
                boolean fClosed = false;
                try {
                    block15: {
                        try {
                            if (lMillis == 0L) {
                                do {
                                    poll.wait();
                                } while ((fClosed = poll.isClosed()) ^ true);
                                break block15;
                            }
                            long cWait = lMillis;
                            while (true) {
                                long ldtStart = System.currentTimeMillis();
                                poll.wait(cWait);
                                fClosed = poll.isClosed();
                                if (!fClosed) {
                                    cWait = this.checkRequestTimeout(ldtStart, lMillis);
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new WrapperException((Throwable)e);
                        }
                    }
                    Object var8_10 = null;
                    if (fClosed ^ true) {
                        poll.close();
                    }
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    if (fClosed ^ true) {
                        poll.close();
                    }
                    throw throwable;
                }
            }
        }
        return poll.getResult();
    }

    public void post(Message msg) {
        if (msg.getService() == null) {
            msg.setService(this);
        }
        ((Cluster)this.getCluster()).getPublisher().drainOverflow(msg);
        Service$EventDispatcher dispatcher = this.getEventDispatcher();
        if (dispatcher != null) {
            dispatcher.drainOverflow();
        }
        if (msg instanceof RequestMessage) {
            RequestMessage req = (RequestMessage)msg;
            Poll poll = req.ensureRequestPoll();
            boolean fSuccess = false;
            try {
                long lId = poll.getPollId();
                if (lId == 0L) {
                    poll.configureFrom(req);
                    lId = this.registerPoll(poll);
                }
                req.setFromPollId(lId);
                fSuccess = this.dispatchMessage(msg);
            }
            finally {
                Object var7_8 = null;
                if (fSuccess ^ true) {
                    Service$NotifyPollClosed msgRTS = (Service$NotifyPollClosed)this.instantiateMessage("NotifyPollClosed");
                    msgRTS.setNotifyMessage(req);
                    this.getQueue().add(msgRTS);
                }
            }
        } else {
            this.dispatchMessage(msg);
        }
    }

    protected long registerPoll(Poll poll) {
        Component._assert(!(!(poll.getService() == null) ? false : poll.getPollId() == 0L) ? false : poll.isClosed() ^ true);
        poll.setService(this);
        long lId = this.getPollArray().add(poll);
        poll.setPollId(lId);
        ServiceMemberSet setService = this.getServiceMemberSet();
        MemberSet setPoll = poll.getRemainingMemberSet();
        if (setService.containsAll((Collection)setPoll) ^ true) {
            MasterMemberSet setMaster = this.getClusterMemberSet();
            int i = setPoll.getFirstId();
            int iLast = setPoll.getLastId();
            while (i <= iLast) {
                if (!setPoll.contains(i) ? false : setService.contains(i) ^ true) {
                    com.tangosol.coherence.component.net.Member member = setMaster.getMember(i);
                    if (member == null) {
                        member = setMaster.getRecycleSet().getMember(i);
                        Component._assert(member != null);
                    }
                    poll.onLeft(member);
                }
                ++i;
            }
        }
        if (setPoll.isEmpty() ? true : this.getServiceState() == SERVICE_STOPPED) {
            poll.close();
        }
        return lId;
    }

    public Object registerRequestInfo(long lId, Object oValue) {
        LongArray laPending;
        LongArray longArray = laPending = this.getPendingRequestInfo();
        synchronized (longArray) {
            Object object = laPending.set(lId, oValue);
            Object var7_6 = null;
            return object;
        }
    }

    public void removeMemberListener(MemberListener l) {
        this.getMemberListeners().remove((EventListener)l);
    }

    public void resetStats() {
        this.getDaemonPool().resetStats();
        this.setStatsCpu(0L);
        this.setStatsReceived(0L);
        this.setStatsPollCount(0L);
        this.setStatsPollDuration(0L);
        this.setStatsPollMaxDuration(0L);
        this.setStatsTimeoutCount(0L);
        this.setStatsReset(Base.getSafeTimeMillis());
    }

    public void send(Message msg) {
        this.post(msg);
        this.flushSend();
    }

    public synchronized void setAcceptingClients(boolean fAccepting) {
        this.__m_AcceptingClients = fAccepting;
        this.notifyAll();
    }

    public void setAcceptingOthers(boolean fAccepting) {
        Object oLock;
        this.__m_AcceptingOthers = fAccepting;
        Object object = oLock = this.getLock();
        synchronized (object) {
            oLock.notify();
        }
    }

    public void setCluster(com.tangosol.net.Cluster cluster) {
        Component._assert(this.getCluster() == null);
        this.__m_Cluster = cluster;
    }

    public void setClusterMemberSet(MasterMemberSet setMember) {
        Component._assert(this.isStarted() ^ true);
        this.__m_ClusterMemberSet = setMember;
    }

    public void setContextClassLoader(ClassLoader loader) {
        this.__m_ContextClassLoader = loader;
    }

    protected void setDaemonPool(DaemonPool pool) {
        this.__m_DaemonPool = pool;
    }

    private void setEventDispatcher(Service$EventDispatcher daemon) {
        this.__m_EventDispatcher = daemon;
    }

    private void setMemberListeners(Listeners listeners) {
        this.__m_MemberListeners = listeners;
    }

    protected void setMessageClass(int i, Class clz) {
        boolean fBeyondBounds;
        Class[] aClass = this.getMessageClass();
        boolean bl = aClass == null ? true : (fBeyondBounds = (i += MESSAGE_OFFSET) >= aClass.length);
        if (!fBeyondBounds ? false : clz != null) {
            int cNew = Math.max(i + (i >>> 1), i + 4);
            Class[] aClassNew = new Class[cNew];
            if (aClass != null) {
                System.arraycopy(aClass, 0, aClassNew, 0, aClass.length);
            }
            aClass = aClassNew;
            this.setMessageClass(aClassNew);
            fBeyondBounds = false;
        }
        if (fBeyondBounds ^ true) {
            aClass[i] = clz;
        }
    }

    private void setMessageClass(Class[] aclz) {
        this.__m_MessageClass = aclz;
    }

    protected void setPendingRequestInfo(LongArray array) {
        this.__m_PendingRequestInfo = array;
    }

    protected void setPollArray(WindowedArray waPoll) {
        this.__m_PollArray = waPoll;
    }

    private void setQueueDeferred(Queue queue) {
        this.__m_QueueDeferred = queue;
    }

    public void setRequestTimeout(long cMillis) {
        this.__m_RequestTimeout = Math.max(0L, cMillis);
    }

    protected void setSUIDCounter(AtomicCounter counter) {
        this.__m_SUIDCounter = counter;
    }

    public void setSendQueue(Queue queue) {
        Component._assert(this.isStarted() ^ true);
        this.__m_SendQueue = queue;
    }

    public void setServiceConfig(XmlElement xml) {
        if (this.getServiceState() != SERVICE_INITIAL) {
            throw new IllegalStateException(String.valueOf("Configuration cannot be specified once the service has been started: ") + this);
        }
        this.__m_ServiceConfig = xml;
    }

    protected void setServiceConfigMap(ObservableMap map) {
        this.__m_ServiceConfigMap = map;
    }

    public void setServiceId(int nId) {
        Component._assert(this.isStarted() ^ true);
        this.__m_ServiceId = nId;
    }

    public void setServiceMemberSet(ServiceMemberSet setMember) {
        Component._assert(this.isStarted() ^ true);
        this.__m_ServiceMemberSet = setMember;
    }

    public void setServiceName(String sName) {
        Component._assert(this.isStarted() ^ true);
        this.__m_ServiceName = sName;
    }

    public synchronized void setServiceState(int nState) {
        int nPrevState = this.getServiceState();
        if (nState > nPrevState) {
            com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
            switch (nState) {
                case 2: {
                    this.dispatchMemberEvent(memberThis, MemberEvent.MEMBER_JOINED);
                    break;
                }
                case 3: {
                    this.dispatchMemberEvent(memberThis, MemberEvent.MEMBER_LEAVING);
                    break;
                }
                case 4: {
                    this.dispatchMemberEvent(memberThis, MemberEvent.MEMBER_LEFT);
                    break;
                }
            }
            this.__m_ServiceState = nState;
            Cluster$ClusterService clusterservice = ((Cluster)this.getCluster()).getClusterService();
            switch (nState) {
                case 2: {
                    clusterservice.doServiceJoined(this);
                    com.tangosol.coherence.component.net.Member memberSenior = this.getServiceOldestMember();
                    Component._trace(String.valueOf("Service ") + this.getServiceName() + " joined the cluster with senior service member " + (memberSenior == null ? "n/a" : String.valueOf(memberSenior.getId())), 5);
                    if (this == clusterservice ? true : memberThis == memberSenior) {
                        this.onServiceStarted();
                        break;
                    }
                    Service$MemberConfigRequest msg = (Service$MemberConfigRequest)this.instantiateMessage("MemberConfigRequest");
                    msg.setToMemberSet(this.getOthersMemberSet());
                    this.send(msg);
                    break;
                }
                case 3: {
                    this.onServiceStopping();
                    clusterservice.doServiceLeaving(this);
                    break;
                }
                case 4: {
                    this.onServiceStopped();
                    this.closePolls();
                    clusterservice.doServiceLeft(this);
                    Component._trace(String.valueOf("Service ") + this.getServiceName() + " left the cluster", 5);
                    break;
                }
            }
        } else {
            Component._assert(nState == nPrevState);
        }
        this.notifyAll();
    }

    protected void setStatsCpu(long cMillis) {
        this.__m_StatsCpu = cMillis;
    }

    protected void setStatsPollCount(long cPolls) {
        this.__m_StatsPollCount = cPolls;
    }

    protected void setStatsPollDuration(long cMillis) {
        this.__m_StatsPollDuration = cMillis;
    }

    protected void setStatsPollMaxDuration(long cMillis) {
        this.__m_StatsPollMaxDuration = cMillis;
    }

    protected void setStatsReceived(long cMsgs) {
        this.__m_StatsReceived = cMsgs;
    }

    protected void setStatsReset(long lMillis) {
        this.__m_StatsReset = lMillis;
    }

    protected void setStatsTimeoutCount(long cRequests) {
        this.__m_StatsTimeoutCount = cRequests;
    }

    public void setUserContext(Object oCtx) {
        this.__m_UserContext = oCtx;
    }

    public void setWrapperStreamFactoryList(List list) {
        Component._assert(this.isStarted() ^ true);
        this.__m_WrapperStreamFactoryList = list;
    }

    public synchronized void shutdown() {
        Thread thread;
        if (this.isStarted() && this.getServiceState() < SERVICE_STOPPING) {
            this.send(this.instantiateMessage("NotifyShutdown"));
        }
        if ((thread = this.getThread()) != Thread.currentThread()) {
            while (!this.isStarted() ? false : this.getServiceState() < SERVICE_STOPPED) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new WrapperException((Throwable)e);
                }
            }
            if (this.getServiceState() != SERVICE_STOPPED) {
                this.stop();
            }
        }
    }

    public synchronized void start() {
        Cluster cluster = (Cluster)this.getCluster();
        String sName = this.getServiceName();
        String sType = this.getServiceType();
        Component._assert(cluster != null, "Cluster is not configured!");
        Component._assert(this.getServiceState() <= SERVICE_STARTED, String.valueOf("Service restart is illegal (ServiceName=") + sName + ')');
        if (this.getServiceState() == SERVICE_INITIAL) {
            this.setSendQueue(cluster.getPublisher().getQueue());
            if (this instanceof ClusterService ^ true) {
                Cluster$ClusterService clusterservice = cluster.getClusterService();
                int nId = clusterservice.ensureService(sName, sType);
                this.setServiceId(nId);
                com.tangosol.coherence.component.net.ServiceInfo info = clusterservice.getServiceInfo(nId);
                MasterMemberSet setClusterMember = clusterservice.getClusterMemberSet();
                ServiceMemberSet setServiceMember = info.getMemberSet();
                this.setClusterMemberSet(setClusterMember);
                this.setServiceMemberSet(setServiceMember);
            }
        }
        super.start();
        while (!(!this.isStarted() ? false : this.getServiceState() <= SERVICE_STARTED) ? false : this.isAcceptingClients() ^ true) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WrapperException((Throwable)e);
            }
        }
        if (this.getServiceState() != SERVICE_STARTED) {
            Throwable e = this.getStartException();
            String s = String.valueOf("Failed to start Service \"") + sName + "\" (ServiceState=" + this.getServiceStateName() + ')';
            throw e == null ? new RuntimeException(s) : new WrapperException(e, s);
        }
        Coherence.prepareDtd(this);
    }

    public synchronized void stop() {
        if (this.isStarted()) {
            super.stop();
            if (this.getThread() == Thread.currentThread()) {
                this.setServiceState(SERVICE_STOPPED);
            }
        } else {
            this.setServiceState(SERVICE_STOPPED);
        }
    }

    public RuntimeException tagException(Throwable e) {
        if (e instanceof LicenseException) {
            return (RuntimeException)e;
        }
        String sMsg = null;
        try {
            StackTraceElement[] atrace;
            sMsg = String.valueOf("Failed request execution for ") + this.getServiceName() + " service on " + this.getThisMember();
            if (e instanceof WrapperException) {
                WrapperException we = (WrapperException)e;
                e = we.getOriginalException();
                sMsg = String.valueOf(sMsg) + (String.valueOf(' ') + we.getMessage());
            }
            if (e instanceof OutOfMemoryError && ((atrace = e.getStackTrace()) == null ? true : atrace.length == 0)) {
                e = new OutOfMemoryError();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new WrapperException(e, sMsg);
    }

    public String toString() {
        String sDesc;
        StringBuffer sb = new StringBuffer();
        sb.append(this.get_Name()).append("{Name=").append(this.getServiceName()).append(", State=").append("(").append(this.getServiceStateName()).append("), Id=").append(this.getServiceId()).append(", Version=").append(this.getServiceVersion());
        if (!this.isRunning() ? false : this.getServiceOldestMember() != null) {
            sb.append(", OldestMemberId=").append(this.getServiceOldestMember().getId());
        }
        if ((sDesc = this.getDescription()) != null) {
            sb.append(", ").append(sDesc);
        }
        sb.append('}');
        return sb.toString();
    }

    public String toString(String s) {
        return HashHelper.hash((String)s);
    }

    protected void unregisterPoll(Poll poll) {
        Component._assert(!(poll != null) ? false : poll.getService() == this);
        this.getPollArray().remove(poll.getPollId());
        long cMillis = Base.getSafeTimeMillis() - poll.getInitTimeMillis();
        this.setStatsPollCount(this.getStatsPollCount() + 1L);
        this.setStatsPollDuration(this.getStatsPollDuration() + cMillis);
        if (cMillis > this.getStatsPollMaxDuration()) {
            this.setStatsPollMaxDuration(cMillis);
        }
    }

    public Object unregisterRequestInfo(long lId) {
        LongArray laPending;
        LongArray longArray = laPending = this.getPendingRequestInfo();
        synchronized (longArray) {
            Object object = laPending.remove(lId);
            Object var6_5 = null;
            return object;
        }
    }

    public void unregisterRequestInfoRange(long lFrom, long lTo) {
        LongArray laPending;
        if (lFrom == -1L) {
            lFrom = Service.getBaseSUID(lTo);
        }
        LongArray longArray = laPending = this.getPendingRequestInfo();
        synchronized (longArray) {
            LongArray.Iterator iter = laPending.iterator(lFrom);
            while (iter.hasNext()) {
                iter.next();
                if (!(iter.getIndex() < lTo)) continue;
                iter.remove();
            }
        }
    }

    public void updateServiceConfigMap(Object oKey, Object oValue, boolean fRemove) {
        Map mapConfig;
        Map map = mapConfig = ((Service$ServiceConfigMap)this.getServiceConfigMap()).getMap();
        synchronized (map) {
            if (fRemove) {
                if (mapConfig.containsKey(oKey)) {
                    mapConfig.remove(oKey);
                }
            } else if (mapConfig.containsKey(oKey) ^ true ? true : Base.equals((Object)oValue, mapConfig.get(oKey)) ^ true) {
                mapConfig.put(oKey, oValue);
            }
        }
    }

    protected void waitAcceptingClients() {
        while (this.isAcceptingClients() ^ true) {
            Service service = this;
            synchronized (service) {
                if (this.getServiceState() != SERVICE_STARTED) {
                    Throwable e = this.getStartException();
                    String s = String.valueOf("Failed to start Service \"") + this.getServiceName() + "\" (ServiceState=" + this.getServiceStateName() + ')';
                    throw e == null ? new RuntimeException(s) : new WrapperException(e, s);
                }
                if (this.isAcceptingClients() ^ true) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new WrapperException((Throwable)e);
                    }
                }
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new UnsupportedOperationException(String.valueOf("Service is not serializable: ") + this);
    }
}

