/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.UdpPacket;
import com.tangosol.coherence.component.net.socket.UdpSocket;
import com.tangosol.coherence.component.util.Pool;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.daemon.QueueProcessor$Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.PacketProcessor;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.util.Map;

public class PacketListener
extends PacketProcessor {
    private Queue __m_ReceiveQueue;
    private transient long __m_StatsCpu;
    private transient long __m_StatsReset;
    private transient Pool __m_UdpPacketPool;
    private UdpSocket __m_UdpSocket;
    private static ListMap __mapChildren;

    static {
        PacketListener.__initStatic();
    }

    public PacketListener() {
        this(null, null, true);
    }

    public PacketListener(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"Queue", (Object)QueueProcessor$Queue.get_CLASS());
    }

    public String formatStats() {
        long cCpu = this.getStatsCpu();
        long cTotal = Base.getSafeTimeMillis() - this.getStartTimestamp();
        double dCpu = cTotal == 0L ? 0.0 : (double)cCpu / (double)cTotal;
        return String.valueOf("Cpu=") + cCpu + "ms (" + (float)dCpu + "%)";
    }

    public Queue getReceiveQueue() {
        return this.__m_ReceiveQueue;
    }

    public long getStatsCpu() {
        return this.__m_StatsCpu;
    }

    public long getStatsReset() {
        return this.__m_StatsReset;
    }

    public Pool getUdpPacketPool() {
        return this.__m_UdpPacketPool;
    }

    public UdpSocket getUdpSocket() {
        return this.__m_UdpSocket;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/packetProcessor/PacketListener".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new PacketListener();
    }

    private final Component get_Module() {
        return this;
    }

    protected void onEnter() {
        super.onEnter();
        this.resetStats();
    }

    protected void onNotify() {
        Queue queue = this.getReceiveQueue();
        Pool packetPool = this.getUdpPacketPool();
        while (this.isExiting() ^ true) {
            Object var5_4;
            UdpPacket udpPacket = null;
            try {
                udpPacket = (UdpPacket)packetPool.acquire();
                udpPacket.setUdpSocket(this.getUdpSocket());
                udpPacket.receive();
                queue.add(udpPacket);
                udpPacket = null;
            }
            catch (Throwable throwable) {
                var5_4 = null;
                if (udpPacket != null) {
                    packetPool.release(udpPacket);
                }
                throw throwable;
            }
            var5_4 = null;
            if (!(udpPacket != null)) continue;
            packetPool.release(udpPacket);
        }
    }

    public void onReceiveException(Exception e) {
        throw new EventDeathException(e.toString());
    }

    protected void onWait() throws InterruptedException {
    }

    public void resetStats() {
        this.setStatsCpu(0L);
        this.setStatsReset(Base.getSafeTimeMillis());
    }

    public void setReceiveQueue(Queue queue) {
        Component._assert(queue != null);
        Component._assert(this.getReceiveQueue() == null);
        this.__m_ReceiveQueue = queue;
    }

    protected void setStatsCpu(long cMillis) {
        this.__m_StatsCpu = cMillis;
    }

    protected void setStatsReset(long lMillis) {
        this.__m_StatsReset = lMillis;
    }

    public void setUdpPacketPool(Pool pool) {
        this.__m_UdpPacketPool = pool;
    }

    public void setUdpSocket(UdpSocket socket) {
        Component._assert(this.getUdpSocket() == null);
        UdpPacket packet = null;
        if (socket != null) {
            packet = new UdpPacket();
            packet.setBufferLength(socket.getPacketLength());
            packet.setUdpSocket(socket);
        }
        this.__m_UdpSocket = socket;
    }

    public synchronized void start() {
        if (this.getUdpSocket() == null) {
            throw new IllegalStateException("DatagramSocket is required!");
        }
        if (this.getReceiveQueue() == null) {
            throw new IllegalStateException("ReceiveQueue is required!");
        }
        super.start();
    }

    public synchronized void stop() {
        super.stop();
        try {
            this.getUdpSocket().close();
        }
        catch (Throwable throwable) {}
    }

    public String toString() {
        return String.valueOf(this.get_Name()) + ':' + this.formatStats();
    }
}

