/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Member$FlowControl;
import com.tangosol.coherence.component.net.Member$SentQueue;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.coherence.component.net.memberSet.SingleMemberSet;
import com.tangosol.coherence.component.net.message.DiscoveryMessage;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.coherence.component.net.packet.messagePacket.Broadcast;
import com.tangosol.coherence.component.net.packet.messagePacket.Directed;
import com.tangosol.coherence.component.net.packet.messagePacket.Sequel;
import com.tangosol.coherence.component.net.packet.notifyPacket.Ack;
import com.tangosol.coherence.component.net.socket.udpSocket.MulticastUdpSocket;
import com.tangosol.coherence.component.net.socket.udpSocket.UnicastUdpSocket;
import com.tangosol.coherence.component.net.udpPacket.OutgoingUdpPacket;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.WindowedArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.PacketProcessor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher$AckQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher$ConfirmationQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher$InQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher$MemberSet;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher$OutgoingMessageArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher$ResendQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher$UdpPacketPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketSpeaker$BundlingQueue;
import com.tangosol.coherence.component.util.queue.ConcurrentQueue;
import com.tangosol.io.MultiByteArrayOutputStream;
import com.tangosol.io.WrapperStreamFactory;
import com.tangosol.net.internal.PacketComparator;
import com.tangosol.net.internal.PacketIdentifier;
import com.tangosol.net.internal.ProtocolAwareStream;
import com.tangosol.util.Base;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.RecyclingLinkedList;
import com.tangosol.util.WrapperException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PacketPublisher
extends PacketProcessor {
    private int __m_AckDelay;
    private PacketPublisher$AckQueue __m_AckQueue;
    private transient List __m_AckdPacketListTemp;
    private List __m_BroadcastAddressList;
    private int __m_CloggedCount;
    private int __m_CloggedDelay;
    private PacketPublisher$ConfirmationQueue __m_ConfirmationQueue;
    private Queue __m_DeferredReadyQueue;
    private transient Queue[] __m_IncommingPacketQueues;
    private volatile long __m_LastTrafficJamWarningTimeMillis;
    private transient List __m_LostPacketListTemp;
    private int __m_MaximumPacketLength;
    private PacketPublisher$MemberSet __m_MemberSetTemp;
    private WindowedArray __m_MessageOutgoing;
    private transient Message[] __m_MsgArrayTemp;
    private transient long[] __m_MsgIdArrayTemp;
    private boolean __m_MulticastEnabled;
    private double __m_MulticastThreshold;
    private transient long __m_NackDelayMillis;
    private transient boolean __m_NackEnabled;
    private transient Queue __m_PacketAdapterQueue;
    private int __m_PreferredPacketLength;
    private int __m_ResendDelay;
    private PacketPublisher$ResendQueue __m_ResendQueue;
    private int __m_ResendTimeout;
    private transient OutgoingUdpPacket __m_ReuseableUdpPacket;
    private transient Queue __m_SendQueue;
    private transient SingleMemberSet __m_SingleMemberSetTemp;
    private transient long __m_StatsCpu;
    private transient long __m_StatsNacksSent;
    private transient long __m_StatsResent;
    private transient long __m_StatsResentEarly;
    private transient long __m_StatsResentExcess;
    private transient long __m_StatsReset;
    private transient long __m_StatsSent;
    private transient PacketPublisher$UdpPacketPool __m_UdpPacketPool;
    private MulticastUdpSocket __m_UdpSocketMulticast;
    private UnicastUdpSocket __m_UdpSocketUnicast;
    private List __m_WellKnownAddressList;
    private List __m_WrapperStreamFactoryList;

    public PacketPublisher() {
        this(null, null, true);
    }

    public PacketPublisher(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setAckdPacketListTemp((List)new RecyclingLinkedList());
            this.setCloggedCount(1024);
            this.setCloggedDelay(32);
            this.setDaemonState(0);
            this.setLostPacketListTemp((List)new RecyclingLinkedList());
            this.setMulticastEnabled(true);
            this.setMulticastThreshold(0.25);
            this.setSingleMemberSetTemp(new SingleMemberSet());
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this._addChild(new PacketPublisher$AckQueue("AckQueue", this, true), "AckQueue");
        this._addChild(new PacketPublisher$ConfirmationQueue("ConfirmationQueue", this, true), "ConfirmationQueue");
        this._addChild(new PacketPublisher$InQueue("InQueue", this, true), "InQueue");
        this._addChild(new PacketPublisher$MemberSet("MemberSet", this, true), "MemberSet");
        this._addChild(new PacketPublisher$OutgoingMessageArray("OutgoingMessageArray", this, true), "OutgoingMessageArray");
        this._addChild(new PacketPublisher$ResendQueue("ResendQueue", this, true), "ResendQueue");
        this._addChild(new PacketPublisher$UdpPacketPool("UdpPacketPool", this, true), "UdpPacketPool");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    protected void addressBroadcastPacket(OutgoingUdpPacket packet, InetSocketAddress address) {
        packet.setUdpSocket(this.getUdpSocketUnicast());
        if (address == null) {
            List listBroadcast;
            List list = listBroadcast = this.getBroadcastAddressList();
            synchronized (list) {
                packet.ensureAddressCapacity(listBroadcast.size());
                Iterator iter = listBroadcast.iterator();
                while (iter.hasNext()) {
                    packet.addAddress((InetSocketAddress)iter.next());
                }
            }
        } else {
            packet.addAddress(address);
        }
    }

    protected void addressMulticastPacket(OutgoingUdpPacket packet) {
        MulticastUdpSocket socket = this.getUdpSocketMulticast();
        packet.setUdpSocket(socket);
        packet.addAddress(socket.getAddress());
    }

    protected void addressMultipointPacket(OutgoingUdpPacket packet, PacketPublisher$MemberSet setTo) {
        int[] anToId = setTo.toIdArray();
        int cAddrs = anToId.length;
        packet.setUdpSocket(this.getUdpSocketUnicast());
        packet.ensureAddressCapacity(cAddrs);
        int i = 0;
        while (i < cAddrs) {
            Member member = this.getMember(anToId[i]);
            if (member != null) {
                packet.addAddress(member.getSocketAddress());
            }
            ++i;
        }
    }

    public void assignMessageIds(Message msg) {
        MessagePacket packetFirst = msg.getPacket(0);
        if (packetFirst instanceof Directed) {
            Directed packetHead = (Directed)packetFirst;
            DependentMemberSet setTo = packetHead.getToMemberSet();
            if (setTo == null) {
                Member memberTo = this.getMember(packetHead.getToId());
                if (memberTo != null) {
                    packetHead.setToMessageId(memberTo.getNextDestinationMessageId());
                }
            } else {
                Object[] aMember = setTo.toArray();
                int i = aMember.length - 1;
                while (i >= 0) {
                    Member memberTo = (Member)aMember[i];
                    setTo.setDestinationMessageId(memberTo.getId(), memberTo.getNextDestinationMessageId());
                    --i;
                }
            }
            long lFromMsgId = this.getMessageOutgoing().add(msg);
            long lSetId = msg.getFromMessageId();
            if (lSetId != lFromMsgId) {
                throw new IllegalStateException(String.valueOf("Set MsgFromId ") + lSetId + " != expected " + lFromMsgId);
            }
            int i = 0;
            int c = msg.getMessagePartCount();
            while (i < c) {
                msg.getPacket(i).setFromMessageId(lFromMsgId);
                ++i;
            }
        } else {
            WindowedArray wa = this.getMessageOutgoing();
            wa.remove(wa.add(msg));
        }
    }

    public boolean deferPacket(Member member, MessagePacket packet) {
        boolean fResult = false;
        Member$FlowControl flowControl = member.getFlowControl();
        if (flowControl != null) {
            if (packet.getDeliveryState() == MessagePacket.DELIVERY_CONFIRMED) {
                return false;
            }
            int cThreshold = flowControl.isPaused() ? 1 : flowControl.getOutstandingPacketThreshold();
            int cOutstanding = flowControl.getOutstandingPacketCount();
            boolean fOverLimit = cOutstanding > cThreshold;
            boolean fDeferring = flowControl.isDeferring();
            int nState = packet.getDeliveryState();
            if (nState == MessagePacket.DELIVERY_CONFIRMED) {
                fResult = false;
            } else if (fOverLimit) {
                Member$FlowControl member$FlowControl = flowControl;
                synchronized (member$FlowControl) {
                    flowControl.getDeferredQueue().add(packet);
                }
                packet.setDeliveryState(MessagePacket.DELIVERY_DEFERRED, member);
                fResult = true;
            } else if (!fDeferring ? false : nState != MessagePacket.DELIVERY_DEFERRED) {
                Member$FlowControl member$FlowControl = flowControl;
                synchronized (member$FlowControl) {
                    Queue deferredQueue = flowControl.getDeferredQueue();
                    if (deferredQueue.isEmpty()) {
                        this.getDeferredReadyQueue().add(packet);
                    } else {
                        deferredQueue.add(packet);
                    }
                }
                packet.setDeliveryState(MessagePacket.DELIVERY_DEFERRED, member);
                fResult = true;
            }
        }
        return fResult;
    }

    protected void doEarlyLossDetection(Member member, MessagePacket packetNewestTo, PacketIdentifier ptidNewestFrom) {
        MessagePacket packet;
        if (PacketComparator.compare((PacketIdentifier)ptidNewestFrom, (PacketIdentifier)member.getContiguousFromPacketId()) > 0) {
            this.scheduleNack(member);
        }
        Member$SentQueue queueRecent = member.getRecentPacketQueue();
        int nMemberId = member.getId();
        if (packetNewestTo == null) {
            MessagePacket packet2;
            do {
                if (!((packet2 = (MessagePacket)((Queue)queueRecent).peekNoWait()) == null ? true : packet2.isAddressedTo(nMemberId))) continue;
                return;
            } while (!(packet2 != ((Queue)queueRecent).removeNoWait()));
            throw new IllegalStateException();
        }
        PacketIdentifier ptidContTo = member.getContiguousToPacketId();
        long ldtNow = Base.getSafeTimeMillis();
        List listLost = this.getLostPacketListTemp();
        List listAckd = this.getAckdPacketListTemp();
        boolean fAdded = false;
        do {
            if ((packet = (MessagePacket)((Queue)queueRecent).removeNoWait()) == null) {
                fAdded = false;
                break;
            }
            if (!(!packet.isAddressedTo(nMemberId) ? false : packet.getResendScheduled() > ldtNow)) continue;
            if (PacketComparator.compare((PacketIdentifier)ptidContTo, (PacketIdentifier)packet) >= 0) {
                if (!packet.registerAck(member)) continue;
                listAckd.add(packet);
                continue;
            }
            listLost.add(packet);
            fAdded = true;
        } while (packet != packetNewestTo);
        if (listAckd.isEmpty() ^ true) {
            this.onAcknowledgedPacket(member, listAckd);
        }
        if (fAdded) {
            this.getResendQueue().addAllHead(listLost, true);
        }
    }

    public void drainDeferredPackets(Member member) {
        int cThreshold;
        int cSpots;
        Member$FlowControl flowControl = member.getFlowControl();
        if (flowControl != null && (cSpots = (cThreshold = flowControl.isPaused() ? 1 : flowControl.getOutstandingPacketThreshold()) - flowControl.getOutstandingPacketCount()) > 0) {
            Packet packet;
            Queue queueDeferred = flowControl.getDeferredQueue();
            Queue queueReady = this.getDeferredReadyQueue();
            while (!((packet = (Packet)queueDeferred.removeNoWait()) == null)) {
                queueReady.add(packet);
                if (packet.getToId() != 0) {
                    --cSpots;
                }
                if (cSpots > 0) continue;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void drainOverflow(Message msg) {
        int cMaxPackets = this.getCloggedCount();
        if (cMaxPackets <= 0) return;
        boolean bl = false;
        if (bl) {
            return;
        }
        if (Thread.currentThread().getThreadGroup() == this.getThreadGroup()) return;
        boolean bl2 = false;
        if (bl2) {
            return;
        }
        if (msg == null) return;
        boolean bl3 = false;
        if (bl3) {
            return;
        }
        Queue queueIn = this.getPacketAdapterQueue();
        Queue queueReady = this.getDeferredReadyQueue();
        PacketPublisher$ResendQueue queueResend = this.getResendQueue();
        boolean fFlowcontrol = Member$FlowControl.isEnabled();
        Member memberThis = this.getThisMember();
        MemberSet setMembers = msg.getToMemberSet();
        int[] anToId = null;
        long ldtStart = 0L;
        long ldtAlarmNext = 0L;
        int cIters = 0;
        while (this.isStarted()) {
            block22: {
                Member memberJammed;
                int cPacketsPending;
                int cPacketsMp;
                int cPacketsReady;
                int cPacketsResend;
                int cPacketsIn;
                int cPackets;
                block17: {
                    block18: {
                        block20: {
                            Member$FlowControl flowControl;
                            Member member;
                            block21: {
                                block19: {
                                    cPacketsIn = cPackets = queueIn.size();
                                    cPacketsResend = -1;
                                    cPacketsReady = -1;
                                    cPacketsMp = -1;
                                    cPacketsPending = -1;
                                    memberJammed = null;
                                    if (!fFlowcontrol) break block18;
                                    cPacketsMp = queueResend.getMultipointPacketCount();
                                    cPackets += cPacketsMp;
                                    cPacketsReady = queueReady.size();
                                    cPackets += cPacketsReady;
                                    if (!(setMembers == null)) break block19;
                                    cPacketsResend = queueResend.size();
                                    cPackets += cPacketsResend;
                                    break block17;
                                }
                                if (!(setMembers.size() == 1)) break block20;
                                member = this.getMember(setMembers.getFirstId());
                                if (!(member == memberThis)) break block21;
                                setMembers = this.getMemberSet();
                                if (!(setMembers.size() > 1)) break block17;
                                --cIters;
                                break block22;
                            }
                            if (member != null && (flowControl = member.getFlowControl()) != null) {
                                memberJammed = member;
                                cPacketsPending = flowControl.getPendingPacketCount();
                                cPackets += cPacketsPending;
                            }
                            break block17;
                        }
                        if (anToId == null) {
                            PacketPublisher$MemberSet setTo = new PacketPublisher$MemberSet();
                            setTo.addAll((Collection)setMembers);
                            anToId = setTo.toIdArray();
                        }
                        int i = 0;
                        int c = anToId.length;
                        while (i < c) {
                            int cPending;
                            Member$FlowControl flowControl;
                            Member member = this.getMember(anToId[i]);
                            if (member != null && (flowControl = member.getFlowControl()) != null && cPackets + (cPending = flowControl.getPendingPacketCount()) > cMaxPackets) {
                                memberJammed = member;
                                cPacketsPending = cPending;
                                cPackets += cPacketsPending;
                                break block17;
                            }
                            ++i;
                        }
                        break block17;
                    }
                    cPacketsResend = queueResend.size();
                    cPackets += cPacketsResend;
                }
                if (cPackets > cMaxPackets) {
                    long ldtNow = Base.getSafeTimeMillis();
                    if (ldtNow > ldtAlarmNext) {
                        if (ldtStart == 0L) {
                            ldtStart = ldtNow;
                        } else {
                            Component._trace(String.valueOf("Overloaded packet queue; ") + cPackets + "/" + cMaxPackets + " packet limit" + ", Duration=" + (ldtNow - ldtStart) / (long)1000 + "s" + ", InQueue=" + cPacketsIn + ", ResendQueue=" + cPacketsResend + ", MultiPoint=" + cPacketsMp + ", Pending=" + cPacketsPending + ", Ready=" + cPacketsReady + ", " + memberJammed + ", FlowControl(" + (memberJammed == null ? null : memberJammed.getFlowControl()) + ")", 2);
                        }
                        ldtAlarmNext = ldtNow + (long)(this.getResendTimeout() / 4);
                    }
                    this.getQueue().flush();
                    if (!Daemon.sleep(this.getCloggedDelay())) return;
                    setMembers = msg.getToMemberSet();
                } else {
                    if (cPackets != 0) {
                        return;
                    }
                    boolean bl4 = true;
                    if (!bl4) {
                        return;
                    }
                    if (cIters <= 1) {
                        return;
                    }
                    boolean bl5 = true;
                    if (!bl5) return;
                    long ldtNow = Base.getSafeTimeMillis();
                    if (ldtNow <= this.getLastTrafficJamWarningTimeMillis() + 60000L) {
                        return;
                    }
                    boolean bl6 = true;
                    if (!bl6) return;
                    Component._trace(String.valueOf("The \"traffic-jam\" settings may be overly cautious; consider ") + "increasing the \"maximum-packets\", or decreasing " + "\"pause-milliseconds\"", 5);
                    this.setLastTrafficJamWarningTimeMillis(ldtNow);
                    return;
                }
            }
            ++cIters;
        }
    }

    protected Message[] ensureMsgArrayTemp(int cMinSize) {
        Message[] aMsgTemp = this.getMsgArrayTemp();
        if (aMsgTemp == null ? true : aMsgTemp.length < cMinSize) {
            aMsgTemp = new Message[cMinSize];
            this.setMsgArrayTemp(aMsgTemp);
        }
        return aMsgTemp;
    }

    protected long[] ensureMsgIdArrayTemp(int cMinSize) {
        long[] alTemp = this.getMsgIdArrayTemp();
        if (alTemp == null ? true : alTemp.length < cMinSize) {
            alTemp = new long[cMinSize];
            this.setMsgIdArrayTemp(alTemp);
        }
        return alTemp;
    }

    protected MemberSet ensureSingleMemberSetTemp(Member member) {
        SingleMemberSet setMember = this.getSingleMemberSetTemp();
        setMember.setTheMember(member);
        return setMember;
    }

    public void flushSend() {
        this.getSendQueue().flush();
    }

    public String formatStats() {
        long cCpu = this.getStatsCpu();
        long cMillis = Base.getSafeTimeMillis() - this.getStartTimestamp();
        long lSent = this.getStatsSent();
        long lResent = this.getStatsResent();
        double dCpu = cMillis == 0L ? 0.0 : (double)cCpu / (double)cMillis;
        double dThru = cCpu == 0L ? 0.0 : (double)lSent * (double)1000 / (double)cCpu;
        double dSuccess = lSent == 0L ? 1.0 : 1.0 - (double)lResent / (double)lSent;
        dCpu = (double)((int)(dCpu * 1000.0)) / 10.0;
        dSuccess = (double)((int)(dSuccess * 10000.0)) / 10000.0;
        return String.valueOf("Cpu=") + cCpu + "ms (" + dCpu + "%)" + ", PacketsSent=" + lSent + ", PacketsResent=" + lResent + ", SuccessRate=" + dSuccess + ", Throughput=" + (int)dThru + "pkt/sec";
    }

    public int getAckDelay() {
        return this.getAckQueue().getDelayMillis();
    }

    public PacketPublisher$AckQueue getAckQueue() {
        return this.__m_AckQueue;
    }

    protected List getAckdPacketListTemp() {
        List list = this.__m_AckdPacketListTemp;
        list.clear();
        return list;
    }

    public List getBroadcastAddressList() {
        return this.__m_BroadcastAddressList;
    }

    public int getCloggedCount() {
        return this.__m_CloggedCount;
    }

    public int getCloggedDelay() {
        return this.__m_CloggedDelay;
    }

    public PacketPublisher$ConfirmationQueue getConfirmationQueue() {
        return this.__m_ConfirmationQueue;
    }

    public Queue getDeferredReadyQueue() {
        return this.__m_DeferredReadyQueue;
    }

    protected Queue[] getIncommingPacketQueues() {
        return this.__m_IncommingPacketQueues;
    }

    public long getLastTrafficJamWarningTimeMillis() {
        return this.__m_LastTrafficJamWarningTimeMillis;
    }

    protected List getLostPacketListTemp() {
        List list = this.__m_LostPacketListTemp;
        list.clear();
        return list;
    }

    public int getMaximumPacketLength() {
        return this.__m_MaximumPacketLength;
    }

    public PacketPublisher$MemberSet getMemberSetTemp() {
        PacketPublisher$MemberSet set = this.__m_MemberSetTemp;
        if (set == null) {
            set = (PacketPublisher$MemberSet)this._findChild("MemberSet");
            this.setMemberSetTemp(set);
        } else {
            set.clear();
        }
        return set;
    }

    public WindowedArray getMessageOutgoing() {
        return this.__m_MessageOutgoing;
    }

    public Message[] getMsgArrayTemp() {
        return this.__m_MsgArrayTemp;
    }

    public long[] getMsgIdArrayTemp() {
        return this.__m_MsgIdArrayTemp;
    }

    public double getMulticastThreshold() {
        return this.__m_MulticastThreshold;
    }

    public long getNackDelayMillis() {
        return this.__m_NackDelayMillis;
    }

    public Queue getPacketAdapterQueue() {
        return this.__m_PacketAdapterQueue;
    }

    public int getPreferredPacketLength() {
        return this.__m_PreferredPacketLength;
    }

    public int getResendDelay() {
        return this.getResendQueue().getResendMillis();
    }

    public PacketPublisher$ResendQueue getResendQueue() {
        return this.__m_ResendQueue;
    }

    public int getResendTimeout() {
        return this.getResendQueue().getTimeoutMillis();
    }

    protected OutgoingUdpPacket getReuseableUdpPacket() {
        return this.__m_ReuseableUdpPacket;
    }

    public Queue getSendQueue() {
        return this.__m_SendQueue;
    }

    protected SingleMemberSet getSingleMemberSetTemp() {
        return this.__m_SingleMemberSetTemp;
    }

    public long getStatsCpu() {
        return this.__m_StatsCpu;
    }

    public long getStatsNacksSent() {
        return this.__m_StatsNacksSent;
    }

    public long getStatsResent() {
        return this.__m_StatsResent;
    }

    public long getStatsResentEarly() {
        return this.__m_StatsResentEarly;
    }

    public long getStatsResentExcess() {
        return this.__m_StatsResentExcess;
    }

    public long getStatsReset() {
        return this.__m_StatsReset;
    }

    public long getStatsSent() {
        return this.__m_StatsSent;
    }

    public PacketPublisher$UdpPacketPool getUdpPacketPool() {
        return this.__m_UdpPacketPool;
    }

    public MulticastUdpSocket getUdpSocketMulticast() {
        return this.__m_UdpSocketMulticast;
    }

    public UnicastUdpSocket getUdpSocketUnicast() {
        return this.__m_UdpSocketUnicast;
    }

    public long getWaitMillis() {
        long lWaitResend = this.getResendQueue().getWaitMillis();
        long lWaitAck = this.getAckQueue().getWaitMillis();
        if (!(lWaitResend == 0L) ? false : lWaitAck == 0L) {
            return 0L;
        }
        if (lWaitResend == 0L) {
            lWaitResend = 60000L;
        }
        if (lWaitAck == 0L) {
            lWaitAck = 60000L;
        }
        return Math.min(lWaitResend, lWaitAck);
    }

    public List getWellKnownAddressList() {
        return this.__m_WellKnownAddressList;
    }

    public List getWrapperStreamFactoryList() {
        return this.__m_WrapperStreamFactoryList;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/packetProcessor/PacketPublisher".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new PacketPublisher();
    }

    private final Component get_Module() {
        return this;
    }

    protected Queue instantiateQueue() {
        return (Queue)this._findChild("InQueue");
    }

    protected boolean isMulticast(Packet packet, MemberSet setTo) {
        int cToMembers = setTo.size();
        if (cToMembers <= 1) {
            return false;
        }
        int cOtherMembers = this.getMemberSet().size() - 1;
        double dflMulticastThreshold = this.getMulticastThreshold();
        return cToMembers > (int)(dflMulticastThreshold * (double)cOtherMembers);
    }

    public boolean isMulticastEnabled() {
        return this.__m_MulticastEnabled;
    }

    public boolean isNackEnabled() {
        return this.__m_NackEnabled;
    }

    public boolean isNotification() {
        Queue queueIn = this.getPacketAdapterQueue();
        PacketPublisher$ConfirmationQueue queueConfirmation = this.getConfirmationQueue();
        Queue queueDeferredReady = this.getDeferredReadyQueue();
        return (queueIn.isEmpty() ^ true ? true : ((Queue)queueConfirmation).isEmpty() ^ true) ? true : (!(queueDeferredReady != null) ? false : queueDeferredReady.isEmpty() ^ true);
    }

    protected void onAcknowledgedPacket(Member member, Collection collAcknowledged) {
        Member$FlowControl flowControl = member.getFlowControl();
        if (flowControl != null) {
            int cNewAcks = 0;
            Iterator iter = collAcknowledged.iterator();
            while (iter.hasNext()) {
                MessagePacket packet = (MessagePacket)iter.next();
                if (!packet.isDeferrable()) continue;
                ++cNewAcks;
                packet.setDeliveryState(MessagePacket.DELIVERY_CONFIRMED, member);
            }
            int cSeqAcks = flowControl.getSequentialConfirmedCount();
            int cSeqLost = flowControl.getSequentialLostCount();
            if (cSeqLost > 0) {
                flowControl.setPaused(false);
                flowControl.setSequentialLostCount(0);
                flowControl.setSequentialConfirmedCount(cNewAcks);
            } else {
                flowControl.setSequentialConfirmedCount(cSeqAcks + cNewAcks);
            }
            if (flowControl.isAdjustable()) {
                int cThreshold = flowControl.getOutstandingPacketThreshold();
                int cEffectiveAcks = cSeqLost == 0 ? cSeqAcks : cSeqAcks / cSeqLost;
                int iGoalDelta = cEffectiveAcks - Member$FlowControl.getSuccessGoal();
                boolean fNearCap = flowControl.getOutstandingPacketHighMark() > cThreshold - (cThreshold >>> 2);
                if (!(iGoalDelta < 0) ? false : cSeqLost > 0) {
                    cThreshold -= Math.max(1, cThreshold / Member$FlowControl.getAggressionFactor());
                    flowControl.setOutstandingPacketThreshold(cThreshold);
                } else if (!(iGoalDelta > 0) ? false : fNearCap) {
                    flowControl.setOutstandingPacketHighMark(flowControl.getOutstandingPacketCount());
                    cThreshold += Math.max(1, cThreshold / Member$FlowControl.getAggressionFactor());
                    flowControl.setOutstandingPacketThreshold(cThreshold);
                }
            }
            this.drainDeferredPackets(member);
        }
    }

    protected void onConfirmation(Ack packetAck) {
        Member memberThis;
        Object[] aMsgAck;
        long[] alMsgId;
        int nFromId = packetAck.getFromId();
        Member member = this.getMember(nFromId);
        if (member == null) {
            return;
        }
        WindowedArray waMsg = this.getMessageOutgoing();
        long lMsgFirst = waMsg.getFirstIndex();
        long lMsgId = 0L;
        int cUniqueMsgs = 0;
        try {
            int cNotify = packetAck.getNotifyCount();
            alMsgId = this.ensureMsgIdArrayTemp(cNotify + 1);
            int iNotify = 0;
            int iLastTrint = -1;
            while (iNotify < cNotify) {
                int iMsgIdTrint = packetAck.getMessageId(iNotify);
                if (iMsgIdTrint != iLastTrint) {
                    lMsgId = Packet.translateTrint(iMsgIdTrint, lMsgFirst);
                    iLastTrint = iMsgIdTrint;
                    alMsgId[cUniqueMsgs++] = lMsgId;
                }
                ++iNotify;
            }
        }
        catch (Exception e) {
            Component._trace(String.valueOf("Exception while translating Trints from Ack ") + packetAck + " front of outgoing message array is " + waMsg.get(lMsgFirst) + " array window size is " + waMsg.getWindowSize(), 1);
            throw Base.ensureRuntimeException((Throwable)e);
        }
        boolean fUseNacks = this.isNackEnabled();
        PacketIdentifier ptidNewestTo = packetAck.getNewestFromPacketId(lMsgFirst);
        MessagePacket packetNewestTo = null;
        if (!fUseNacks ? false : ptidNewestTo != null) {
            long lNewestMsgId = ptidNewestTo.getFromMessageId();
            if (lNewestMsgId != lMsgId) {
                alMsgId[cUniqueMsgs++] = lNewestMsgId;
            }
            aMsgAck = this.ensureMsgArrayTemp(cUniqueMsgs);
            waMsg.getAll(alMsgId, cUniqueMsgs, aMsgAck);
            Object msgNewest = aMsgAck[cUniqueMsgs - 1];
            int iPacket = ptidNewestTo.getMessagePartIndex();
            if ((!(msgNewest != null) ? false : iPacket < ((Message)msgNewest).getMessagePartCount()) && (!((packetNewestTo = ((Message)msgNewest).getPacket(iPacket)) != null) ? false : packetNewestTo.isAddressedTo(nFromId) ^ true)) {
                packetNewestTo = null;
            }
        } else {
            aMsgAck = this.ensureMsgArrayTemp(cUniqueMsgs);
            waMsg.getAll(alMsgId, cUniqueMsgs, aMsgAck);
        }
        MessagePacket packetLast = this.registerAcks(packetAck, member, (Message[])aMsgAck);
        PacketIdentifier ptidCont = packetAck.getContiguousFromPacketId(lMsgFirst);
        if (PacketComparator.compare((PacketIdentifier)ptidCont, (PacketIdentifier)member.getContiguousToPacketId()) > 0) {
            member.setContiguousToPacketId(ptidCont);
        }
        PacketIdentifier ptidNewestFrom = packetAck.getNewestToPacketId(member.getLastIncomingMessageId());
        member.setNewestFromPacketId(ptidNewestFrom);
        if (fUseNacks) {
            this.doEarlyLossDetection(member, (packetNewestTo == null ? true : packetNewestTo.isOutgoingMultipoint()) ? packetLast : packetNewestTo, ptidNewestFrom);
        }
        if ((memberThis = this.getThisMember()) != null) {
            long lRecvTime = packetAck.getReceivedMillis();
            memberThis.setLastIncomingMillis(lRecvTime);
            if (member != memberThis) {
                member.setLastIncomingMillis(lRecvTime);
            }
        }
    }

    protected void onEnter() {
        super.onEnter();
        this.resetStats();
    }

    public void onException(Throwable e) {
        super.onException(e);
    }

    public void onInit() {
        this.setMessageOutgoing((PacketPublisher$OutgoingMessageArray)this._findChild("OutgoingMessageArray"));
        this.setAckQueue((PacketPublisher$AckQueue)this._findChild("AckQueue"));
        this.setResendQueue((PacketPublisher$ResendQueue)this._findChild("ResendQueue"));
        this.setConfirmationQueue((PacketPublisher$ConfirmationQueue)this._findChild("ConfirmationQueue"));
        this.setUdpPacketPool((PacketPublisher$UdpPacketPool)this._findChild("UdpPacketPool"));
        super.onInit();
    }

    public void onMemberLeft(Member member) {
        Queue queueReady;
        Queue queueDeferred;
        Member$FlowControl flowControl = member.getFlowControl();
        if (flowControl != null && (queueDeferred = flowControl.getDeferredQueue()) != (queueReady = this.getDeferredReadyQueue())) {
            Member$FlowControl member$FlowControl = flowControl;
            synchronized (member$FlowControl) {
                flowControl.setDeferredQueue(this.getDeferredReadyQueue());
            }
            Object o = queueDeferred.removeNoWait();
            while (o != null) {
                queueReady.add(o);
                o = queueDeferred.removeNoWait();
            }
        }
    }

    protected void onNoRecipientPacket(Packet packet) {
        if (packet.isConfirmationRequired()) {
            ((MessagePacket)packet).clearRecipients();
            this.getResendQueue().addHead(packet);
        }
    }

    protected void onNotify() {
        try {
            long lStartTime = System.currentTimeMillis();
            Queue[] aQueue = this.getIncommingPacketQueues();
            Queue queueReady = this.getDeferredReadyQueue();
            PacketPublisher$ConfirmationQueue queueConfirm = this.getConfirmationQueue();
            Queue queueIn = this.getPacketAdapterQueue();
            int cQueues = aQueue.length;
            int cPacketsStart = queueIn.size();
            int cSentPackets = 0;
            int cResentPackets = 0;
            int cEarlyPackets = 0;
            while (true) {
                Ack ack;
                if (!((ack = (Ack)((Queue)queueConfirm).removeNoWait()) == null)) {
                    this.onConfirmation(ack);
                    continue;
                }
                boolean fMore = false;
                int iQueue = 0;
                int cDeferred = 0;
                while (iQueue < cQueues) {
                    Queue queue = aQueue[iQueue];
                    Packet packet = (Packet)queue.removeNoWait();
                    if (packet != null) {
                        boolean fResend = packet.getSentMillis() != 0L;
                        int cSent = this.onPacket(packet);
                        fMore = true;
                        cSentPackets += cSent;
                        if (fResend) {
                            cResentPackets += cSent;
                            if (((MessagePacket)packet).getPendingResendSkips() > 0) {
                                cEarlyPackets += cSent;
                            }
                        }
                        if (queue == queueReady) {
                            if (cDeferred-- > 0) {
                                continue;
                            }
                        } else if (!(cSent == 0) ? false : packet.isDeferrable()) {
                            ++cDeferred;
                        }
                    }
                    ++iQueue;
                }
                if (!(!fMore ? false : cSentPackets < 30000)) break;
            }
            if (cSentPackets > 0 ? true : cResentPackets > 0) {
                ((PacketSpeaker$BundlingQueue)this.getSendQueue()).tuneVolumeThreshold(queueIn.size() - cPacketsStart);
                this.setStatsSent(this.getStatsSent() + (long)cSentPackets);
                this.setStatsResent(this.getStatsResent() + (long)cResentPackets);
                this.setStatsResentEarly(this.getStatsResentEarly() + (long)cEarlyPackets);
                this.setStatsCpu(this.getStatsCpu() + System.currentTimeMillis() - lStartTime);
            }
        }
        catch (Exception e) {
            if (this.isExiting()) {
                return;
            }
            throw Base.ensureRuntimeException((Throwable)e);
        }
    }

    protected int onPacket(Packet packetData) {
        if (!(packetData.getSentMillis() > 0L) ? false : this.verifyResendNecessary((MessagePacket)packetData) ^ true) {
            this.onNoRecipientPacket(packetData);
            return 0;
        }
        Member memberSingle = this.getMember(packetData.getToId());
        if (!(!(memberSingle != null) ? false : packetData.isDeferrable()) ? false : this.deferPacket(memberSingle, (MessagePacket)packetData)) {
            return 0;
        }
        OutgoingUdpPacket packet = this.getReuseableUdpPacket();
        MemberSet setTo = null;
        int cAddresses = 0;
        try {
            try {
                if (packet == null) {
                    packet = (OutgoingUdpPacket)this.getUdpPacketPool().acquire();
                } else {
                    packet.reset();
                }
                if (memberSingle == null) {
                    boolean fMulticast;
                    setTo = this.getMemberSetTemp();
                    if (packetData.isOutgoingMultipoint()) {
                        setTo.addAll((Collection)((MessagePacket)packetData).getToMemberSet());
                    }
                    boolean fBroadcast = packetData.isOutgoingBroadcast();
                    boolean bl = !this.isMulticastEnabled() ? false : (fBroadcast ? ((Broadcast)packetData).getToAddress() == null : (fMulticast = this.isMulticast(packetData, setTo)));
                    if (fMulticast) {
                        this.addressMulticastPacket(packet);
                    } else if (fBroadcast) {
                        this.addressBroadcastPacket(packet, ((Broadcast)packetData).getToAddress());
                    } else {
                        this.addressMultipointPacket(packet, (PacketPublisher$MemberSet)setTo);
                    }
                    cAddresses = packet.getAddressCount();
                    if (cAddresses == 0) {
                        this.onNoRecipientPacket(packetData);
                        int n = 0;
                        Object var9_12 = null;
                        this.setReuseableUdpPacket(packet);
                        return n;
                    }
                } else {
                    setTo = this.ensureSingleMemberSetTemp(memberSingle);
                    packet.setUdpSocket(this.getUdpSocketUnicast());
                    packet.addAddress(memberSingle.getSocketAddress());
                    cAddresses = 1;
                }
                packetData.write(packet.getDataOutputStream(), setTo);
                packet.getOutputStream().flush();
                this.onSendPacket(packetData);
                if (this.getSendQueue().add(packet)) {
                    packet = null;
                }
            }
            catch (IOException e) {
                throw new WrapperException((Throwable)e);
            }
        }
        catch (Throwable e) {
            Object var9_14 = null;
            this.setReuseableUdpPacket(packet);
            throw e;
        }
        Object var9_13 = null;
        this.setReuseableUdpPacket(packet);
        long cMillis = Base.getSafeTimeMillis();
        packetData.setSentMillis(cMillis);
        packetData.setSentCount(packetData.getSentCount() + 1);
        if (packetData.isConfirmationRequired()) {
            if (memberSingle == null) {
                ((PacketPublisher$MemberSet)setTo).updateStats(cMillis);
            } else {
                memberSingle.setLastOutgoingMillis(cMillis);
            }
            this.getResendQueue().add(packetData);
        }
        return cAddresses;
    }

    protected void onSendPacket(Member member, Packet packet) {
        MessagePacket msgPacket;
        Member$FlowControl flowControl = member.getFlowControl();
        if ((!(flowControl != null) ? false : packet.isDeferrable()) && (msgPacket = (MessagePacket)packet).getDeliveryState() != MessagePacket.DELIVERY_CONFIRMED) {
            msgPacket.setDeliveryState(MessagePacket.DELIVERY_OUTSTANDING, member);
        }
        if (!(!this.isNackEnabled() ? false : packet.isConfirmationRequired()) ? false : packet.isOutgoingMultipoint() ^ true) {
            if (packet.getSentMillis() == 0L) {
                member.setNewestToPacketId((MessagePacket)packet);
            }
            member.getRecentPacketQueue().add(packet);
        }
        member.setStatsSent(member.getStatsSent() + (long)1);
        if (packet.getSentMillis() > (long)0) {
            member.setStatsResent(member.getStatsResent() + (long)1);
        }
    }

    protected void onSendPacket(Packet packet) {
        if (packet.isOutgoingMultipoint()) {
            PacketPublisher$MemberSet setTo = this.getMemberSetTemp();
            setTo.addAll((Collection)((MessagePacket)packet).getToMemberSet());
            int[] anToId = setTo.toIdArray();
            int i = 0;
            int c = anToId.length;
            while (i < c) {
                Member member = this.getMember(anToId[i]);
                if (member != null) {
                    this.onSendPacket(member, packet);
                }
                ++i;
            }
        } else {
            Member member = this.getMember(packet.getToId());
            if (member != null) {
                this.onSendPacket(member, packet);
            }
        }
    }

    public void onSlowPacket(MessagePacket packet) {
    }

    public void onUndeliverablePacket(MessagePacket packet) {
        DependentMemberSet setMemberTo;
        int nMemberTo = packet.getToId();
        if (nMemberTo != 0) {
            Member member = this.getMember(nMemberTo);
            if (member != null) {
                this.getMemberSet().remove(member);
            }
            packet.setToId(0);
        }
        if ((setMemberTo = packet.getToMemberSet()) != null) {
            this.getMemberSet().removeAll((Collection)setMemberTo);
            setMemberTo.clear();
        }
    }

    protected void onWait() throws InterruptedException {
        this.flushSend();
        super.onWait();
    }

    public boolean packetizeMessage(Message msg) {
        List listAll;
        Object stream;
        Service service = msg.getService();
        if (service == null) {
            throw new IllegalStateException(String.valueOf("Orphaned message: ") + msg);
        }
        boolean fBroadcast = true;
        Member memberFrom = msg.getFromMember();
        int nMemberFrom = memberFrom.getId();
        MemberSet setMemberTo = msg.getToMemberSet();
        int cMembers = 0;
        int nMemberTo = 0;
        if (setMemberTo != null) {
            fBroadcast = false;
            if (setMemberTo.contains(memberFrom)) {
                MemberSet setMemberNew = new MemberSet();
                setMemberNew.addAll((Collection)setMemberTo);
                setMemberNew.remove(memberFrom);
                setMemberTo = setMemberNew;
            }
            if ((cMembers = setMemberTo.size()) == 0) {
                return false;
            }
            if (cMembers == 1 && (nMemberTo = setMemberTo.getFirstId()) == 0) {
                return false;
            }
        }
        int cbBody = MessagePacket.calcBodyLength(setMemberTo, this.getPreferredPacketLength(), this.getMaximumPacketLength());
        if (fBroadcast) {
            if (msg instanceof DiscoveryMessage ^ true) {
                throw new IllegalStateException(String.valueOf("Invalid Broadcast Message: ") + msg);
            }
            if (service.getServiceId() != 0) {
                throw new IllegalStateException(String.valueOf("Broadcast Message sent from invalid") + " service (Message=" + msg + ")");
            }
            stream = new ByteArrayOutputStream();
        } else {
            if (nMemberFrom == 0) {
                Component._trace(String.valueOf("Publisher: Directed Message sent before Member ID") + " obtained (Message=" + msg + ")", 1);
                return false;
            }
            stream = new MultiByteArrayOutputStream(cbBody);
        }
        MultiByteArrayOutputStream streamOrig = stream;
        List listSvc = service.getWrapperStreamFactoryList();
        if (listSvc != null) {
            int i = 0;
            int c = listSvc.size();
            while (i < c) {
                stream = ((WrapperStreamFactory)listSvc.get(i)).getOutputStream((OutputStream)stream);
                if (stream instanceof ProtocolAwareStream) {
                    ((ProtocolAwareStream)stream).setProtocolContext(service.getProtocolContext(msg));
                }
                ++i;
            }
        }
        if ((listAll = this.getWrapperStreamFactoryList()) != null) {
            int i = 0;
            int c = listAll.size();
            while (i < c) {
                stream = ((WrapperStreamFactory)listAll.get(i)).getOutputStream((OutputStream)stream);
                if (stream instanceof ProtocolAwareStream) {
                    ((ProtocolAwareStream)stream).setProtocolContext(service.getProtocolContext(msg));
                }
                ++i;
            }
        }
        try {
            DataOutputStream streamData = new DataOutputStream((OutputStream)stream);
            msg.writeInternal(streamData);
            msg.write(streamData);
            ((OutputStream)stream).close();
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException((Throwable)e);
        }
        if (fBroadcast) {
            byte[] ab = ((ByteArrayOutputStream)streamOrig).toByteArray();
            Component._assert(ab.length <= cbBody, String.valueOf("Dispatcher: Broadcast Message is") + " too large (max=" + this.getMaximumPacketLength() + ", actual=" + ab.length);
            Broadcast packet = new Broadcast();
            packet.setFromId(nMemberFrom);
            packet.setMessageType(msg.getMessageType());
            packet.setBody(ab);
            Member memberTo = ((DiscoveryMessage)msg).getToMember();
            if (memberTo != null) {
                packet.setToAddress(memberTo.getSocketAddress());
            }
            msg.setMessagePartCount(1);
            msg.setPacket(0, packet);
        } else {
            MultiByteArrayOutputStream streamMulti = streamOrig;
            int cPackets = streamMulti.getBlockCount();
            msg.setMessagePartCount(cPackets);
            Directed packetHead = new Directed();
            DependentMemberSet setTo = null;
            if (cMembers == 1) {
                packetHead.setToId(nMemberTo);
            } else {
                setTo = new DependentMemberSet();
                setTo.setBaseSet(this.getMemberSet());
                setTo.addAll((Collection)setMemberTo);
                packetHead.setToMemberSet(setTo);
            }
            packetHead.setFromId(nMemberFrom);
            packetHead.setServiceId(service.getServiceId());
            packetHead.setMessageType(msg.getMessageType());
            packetHead.setMessagePartCount(cPackets);
            packetHead.setBody(streamMulti.getBlock(0));
            msg.setPacket(0, packetHead);
            int i = 1;
            while (i < cPackets) {
                Sequel packet = new Sequel();
                if (setTo == null) {
                    packet.setToId(nMemberTo);
                } else {
                    packet.setToMemberSet((DependentMemberSet)setTo.clone());
                }
                packet.setFromId(nMemberFrom);
                packet.setServiceId(service.getServiceId());
                packet.setMessageType(msg.getMessageType());
                packet.setMessagePartCount(cPackets);
                packet.setMessagePartIndex(i);
                packet.setBody(streamMulti.getBlock(i));
                msg.setPacket(i, packet);
                ++i;
            }
        }
        return true;
    }

    protected MessagePacket registerAcks(Ack packetAck, Member member, Message[] aMsgAck) {
        Message msgLast = null;
        MessagePacket packetLast = null;
        List listAckd = this.getAckdPacketListTemp();
        int cNotify = packetAck.getNotifyCount();
        int cNewAck = 0;
        int i = 0;
        int iLastTrint = -1;
        int iMsg = 0;
        while (i < cNotify) {
            MessagePacket packetMsg;
            int iMsgIdTrint = packetAck.getMessageId(i);
            if (iMsgIdTrint != iLastTrint) {
                msgLast = aMsgAck[iMsg++];
                iLastTrint = iMsgIdTrint;
            }
            if (msgLast != null && (!((packetMsg = msgLast.getPacket(packetAck.getMessagePartIndex(i))) != null) ? false : packetMsg.registerAck(member))) {
                listAckd.add(packetMsg);
                if (packetMsg.isOutgoingMultipoint() ^ true) {
                    packetLast = packetMsg;
                }
                ++cNewAck;
            }
            ++i;
        }
        if (cNewAck < cNotify) {
            this.setStatsResentExcess(Math.min(this.getStatsResent(), this.getStatsResentExcess() + (long)(cNotify - cNewAck)));
        }
        this.onAcknowledgedPacket(member, listAckd);
        return packetLast;
    }

    public void resetStats() {
        this.setStatsSent(0L);
        this.setStatsResent(0L);
        this.setStatsResentEarly(0L);
        this.setStatsResentExcess(0L);
        this.setStatsNacksSent(0L);
        this.setStatsCpu(0L);
        this.setStatsReset(Base.getSafeTimeMillis());
    }

    public void scheduleNack(Member member) {
        Ack packetAck = member.getPacketAck();
        long ldtSend = Base.getSafeTimeMillis() + this.getNackDelayMillis();
        if (!(packetAck != null) ? false : packetAck.getScheduledMillis() <= ldtSend) {
            if (packetAck.isFlushed() ^ true) {
                return;
            }
            packetAck = null;
        }
        if (packetAck == null) {
            packetAck = new Ack();
            packetAck.setFromId(this.getMemberId());
            packetAck.setToId(member.getId());
        }
        packetAck.setScheduledMillis(ldtSend);
        this.setStatsNacksSent(this.getStatsNacksSent() + 1L);
        this.getAckQueue().addHead(packetAck);
    }

    public void setAckDelay(int cMillis) {
        this.getAckQueue().setDelayMillis(cMillis);
    }

    protected void setAckQueue(PacketPublisher$AckQueue queue) {
        this.__m_AckQueue = queue;
    }

    protected void setAckdPacketListTemp(List listPacket) {
        this.__m_AckdPacketListTemp = listPacket;
    }

    protected void setBroadcastAddressList(List list) {
        this.__m_BroadcastAddressList = list;
    }

    public void setCloggedCount(int cMaxPackets) {
        this.__m_CloggedCount = cMaxPackets;
    }

    public void setCloggedDelay(int cMillis) {
        this.__m_CloggedDelay = Math.max(1, cMillis);
    }

    protected void setConfirmationQueue(PacketPublisher$ConfirmationQueue queue) {
        this.__m_ConfirmationQueue = queue;
    }

    public void setDeferredReadyQueue(Queue queue) {
        this.__m_DeferredReadyQueue = queue;
    }

    protected void setIncommingPacketQueues(Queue[] aQueue) {
        this.__m_IncommingPacketQueues = aQueue;
    }

    protected void setLastTrafficJamWarningTimeMillis(long cMillis) {
        this.__m_LastTrafficJamWarningTimeMillis = cMillis;
    }

    protected void setLostPacketListTemp(List listPacket) {
        this.__m_LostPacketListTemp = listPacket;
    }

    public void setMaximumPacketLength(int cbMax) {
        Component._assert(this.getMaximumPacketLength() == 0, "MaximumPacketLength is not resettable");
        this.__m_MaximumPacketLength = cbMax;
    }

    protected void setMemberSetTemp(PacketPublisher$MemberSet set) {
        this.__m_MemberSetTemp = set;
    }

    protected void setMessageOutgoing(WindowedArray waMsg) {
        this.__m_MessageOutgoing = waMsg;
    }

    protected void setMsgArrayTemp(Message[] aMsg) {
        this.__m_MsgArrayTemp = aMsg;
    }

    protected void setMsgIdArrayTemp(long[] alMsgId) {
        this.__m_MsgIdArrayTemp = alMsgId;
    }

    public void setMulticastEnabled(boolean dflThresholdPercent) {
        this.__m_MulticastEnabled = dflThresholdPercent;
    }

    public void setMulticastThreshold(double dflThresholdPercent) {
        this.__m_MulticastThreshold = dflThresholdPercent;
    }

    public void setNackDelayMillis(long cDelayMillis) {
        this.__m_NackDelayMillis = cDelayMillis;
    }

    public void setNackEnabled(boolean fEnabled) {
        this.__m_NackEnabled = fEnabled;
    }

    protected void setPacketAdapterQueue(Queue queue) {
        this.__m_PacketAdapterQueue = queue;
    }

    public void setPreferredPacketLength(int pPreferredPacketLength) {
        this.__m_PreferredPacketLength = pPreferredPacketLength;
    }

    public void setResendDelay(int cMillis) {
        PacketPublisher$ResendQueue queue = this.getResendQueue();
        if (queue != null) {
            queue.setResendMillis(cMillis);
        }
    }

    protected void setResendQueue(PacketPublisher$ResendQueue queue) {
        this.__m_ResendQueue = queue;
    }

    public void setResendTimeout(int cMillis) {
        PacketPublisher$ResendQueue queue = this.getResendQueue();
        if (queue != null) {
            queue.setTimeoutMillis(cMillis);
        }
    }

    protected void setReuseableUdpPacket(OutgoingUdpPacket packet) {
        this.__m_ReuseableUdpPacket = packet;
    }

    public void setSendQueue(Queue queue) {
        this.__m_SendQueue = queue;
        PacketPublisher$UdpPacketPool pool = this.getUdpPacketPool();
        int cBatch = ((ConcurrentQueue)queue).getBatchSize();
        ((ConcurrentQueue)pool.getStorage()).setBatchSize(cBatch);
    }

    protected void setSingleMemberSetTemp(SingleMemberSet set) {
        this.__m_SingleMemberSetTemp = set;
    }

    protected void setStatsCpu(long cMillis) {
        this.__m_StatsCpu = cMillis;
    }

    protected void setStatsNacksSent(long cPackets) {
        this.__m_StatsNacksSent = cPackets;
    }

    protected void setStatsResent(long cPackets) {
        this.__m_StatsResent = cPackets;
    }

    protected void setStatsResentEarly(long cPackets) {
        this.__m_StatsResentEarly = cPackets;
    }

    protected void setStatsResentExcess(long cPackets) {
        this.__m_StatsResentExcess = cPackets;
    }

    protected void setStatsReset(long lMillis) {
        this.__m_StatsReset = lMillis;
    }

    protected void setStatsSent(long cPackets) {
        this.__m_StatsSent = cPackets;
    }

    protected void setUdpPacketPool(PacketPublisher$UdpPacketPool pool) {
        this.__m_UdpPacketPool = pool;
    }

    public void setUdpSocketMulticast(MulticastUdpSocket socket) {
        Component._assert(this.getUdpSocketMulticast() == null);
        this.__m_UdpSocketMulticast = socket;
    }

    public void setUdpSocketUnicast(UnicastUdpSocket socket) {
        Component._assert(this.getUdpSocketUnicast() == null);
        this.__m_UdpSocketUnicast = socket;
    }

    public void setWellKnownAddressList(List list) {
        Component._assert(this.getWellKnownAddressList() == null);
        this.__m_WellKnownAddressList = new ImmutableArrayList((Collection)list);
        this.setBroadcastAddressList(new ArrayList(list));
        this.setMulticastEnabled(list == null ? true : list.isEmpty());
    }

    public void setWrapperStreamFactoryList(List list) {
        Component._assert(this.isStarted() ^ true);
        this.__m_WrapperStreamFactoryList = list;
    }

    public synchronized void start() {
        if (this.getSendQueue() == null) {
            throw new IllegalStateException("SendQueue is required!");
        }
        if (this.getMaximumPacketLength() == 0) {
            throw new IllegalStateException("MaximumPacketLength is required!");
        }
        if (this.getPreferredPacketLength() == 0) {
            throw new IllegalStateException("PreferredPacketLength is required!");
        }
        if (this.getUdpSocketUnicast() == null) {
            throw new IllegalStateException("UdpSocketUnicast is required!");
        }
        if (!(this.getUdpSocketMulticast() == null) ? false : this.isMulticastEnabled()) {
            throw new IllegalStateException("UdpSocketMulticast is required!");
        }
        this.setPacketAdapterQueue(((PacketPublisher$InQueue)this.getQueue()).getPacketAdapter());
        Queue queueDeferred = this.getDeferredReadyQueue();
        Queue[] aQueue = new Queue[queueDeferred == null ? 3 : 4];
        int iQueue = 0;
        aQueue[iQueue++] = this.getAckQueue();
        aQueue[iQueue++] = this.getPacketAdapterQueue();
        aQueue[iQueue++] = this.getResendQueue();
        if (queueDeferred != null) {
            aQueue[iQueue++] = queueDeferred;
        }
        this.setIncommingPacketQueues(aQueue);
        super.start();
    }

    public synchronized void stop() {
        super.stop();
        try {
            MulticastUdpSocket socket = this.getUdpSocketMulticast();
            if (socket != null) {
                socket.close();
            }
        }
        catch (Throwable throwable) {}
    }

    public String toString() {
        return String.valueOf(this.get_Name()) + ':' + this.formatStats();
    }

    public boolean verifyResendNecessary(MessagePacket packet) {
        PacketPublisher publisher = (PacketPublisher)this.get_Module();
        long lMsgId = packet.getFromMessageId();
        boolean fLiveMembers = false;
        if (packet.isOutgoingMultipoint()) {
            PacketPublisher$MemberSet setTo = publisher.getMemberSetTemp();
            setTo.addAll((Collection)packet.getToMemberSet());
            int[] anToId = setTo.toIdArray();
            int i = 0;
            int c = anToId.length;
            while (i < c) {
                Member member = publisher.getMember(anToId[i]);
                if (member != null) {
                    fLiveMembers = true;
                    if (!(PacketComparator.compare((PacketIdentifier)member.getContiguousToPacketId(), (PacketIdentifier)packet) >= 0) ? false : packet.registerAck(member)) {
                        this.onAcknowledgedPacket(member, Collections.singleton(packet));
                    }
                }
                ++i;
            }
        } else {
            Member member = publisher.getMember(packet.getToId());
            if (member != null) {
                fLiveMembers = true;
                if (!(PacketComparator.compare((PacketIdentifier)member.getContiguousToPacketId(), (PacketIdentifier)packet) >= 0) ? false : packet.registerAck(member)) {
                    this.onAcknowledgedPacket(member, Collections.singleton(packet));
                }
            }
        }
        return !fLiveMembers ? false : packet.isResendNecessary();
    }
}

