/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.UdpPacket;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.coherence.component.net.packet.NotifyPacket;
import com.tangosol.coherence.component.net.packet.messagePacket.Broadcast;
import com.tangosol.coherence.component.net.packet.messagePacket.Directed;
import com.tangosol.coherence.component.net.packet.messagePacket.Sequel;
import com.tangosol.coherence.component.net.packet.notifyPacket.Ack;
import com.tangosol.coherence.component.net.packet.notifyPacket.Request;
import com.tangosol.coherence.component.util.Pool;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.WindowedArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.PacketProcessor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketReceiver$InQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketReceiver$ThisMemberSet;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketReceiver$UdpPacketPool;
import com.tangosol.net.internal.PacketComparator;
import com.tangosol.net.internal.PacketIdentifier;
import com.tangosol.util.Base;
import com.tangosol.util.LongArray;
import com.tangosol.util.SimpleLongArray;
import com.tangosol.util.SparseArray;
import com.tangosol.util.WrapperException;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;

public class PacketReceiver
extends PacketProcessor {
    private transient Queue __m_AckSendQueue;
    private transient Queue __m_ConfirmationQueue;
    private transient Service __m_FlushPendingService;
    private transient int __m_MaxAckNotifyCount;
    private int __m_MaximumPacketLength;
    private transient boolean __m_NackEnabled;
    private int __m_PreferredPacketLength;
    private transient PacketPublisher __m_Publisher;
    private Service[] __m_Service;
    private transient long __m_StatsReceived;
    private transient long __m_StatsRepeated;
    private transient long __m_StatsReset;
    private PacketReceiver$ThisMemberSet __m_ThisMemberSet;
    private transient PacketReceiver$UdpPacketPool __m_UdpPacketPool;

    public PacketReceiver() {
        this(null, null, true);
    }

    public PacketReceiver(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this._addChild(new PacketReceiver$InQueue("InQueue", this, true), "InQueue");
        this._addChild(new PacketReceiver$ThisMemberSet("ThisMemberSet", this, true), "ThisMemberSet");
        this._addChild(new PacketReceiver$UdpPacketPool("UdpPacketPool", this, true), "UdpPacketPool");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    protected void checkReadyMessages(Member member) {
        long lMsgId;
        WindowedArray waMsg = member.getMessageIncoming();
        Message msg = (Message)waMsg.get(lMsgId = waMsg.getFirstIndex());
        if (msg == null) {
            return;
        }
        SparseArray laPile = member.getMessagePile();
        while (msg.getNullPacketCount() == 0) {
            waMsg.remove(lMsgId);
            long lFromMsgId = msg.getFromMessageId();
            if (msg.getMessagePartCount() > 1) {
                laPile.remove(lFromMsgId);
            }
            member.setLastIncomingMessageId(lFromMsgId);
            this.onMessage(msg);
            Object oMsgNext = waMsg.get(++lMsgId);
            if (oMsgNext == null) break;
            msg = (Message)oMsgNext;
        }
        if (msg.getNullPacketCount() == 0) {
            member.setContiguousFromPacketId(msg.getPacket(msg.getMessagePartCount() - 1));
        } else {
            int i = 1;
            int c = msg.getMessagePartCount();
            while (i < c) {
                if (msg.getPacket(i) == null) {
                    member.setContiguousFromPacketId(msg.getPacket(i - 1));
                    break;
                }
                ++i;
            }
        }
    }

    protected void confirm(Member member, MessagePacket packet) {
        boolean fNewAck;
        Packet packetAck;
        PacketIdentifier packetNewestFromId;
        if (this.isNackEnabled() && PacketComparator.compare((PacketIdentifier)packet, (PacketIdentifier)(packetNewestFromId = member.getNewestFromPacketId())) > 0) {
            member.setNewestFromPacketId(packet);
            packetAck = packet;
        }
        boolean bl = fNewAck = (packetAck = member.getPacketAck()) == null;
        if (fNewAck ^ true) {
            int cSlots = Math.min(this.getMaxAckNotifyCount(), member.getPreferredAckSize()) - ((NotifyPacket)packetAck).getNotifyCount();
            if (cSlots > 0) {
                ((Ack)packetAck).addPacket(packet);
                boolean bl2 = fNewAck = member.getPacketAck() != packetAck;
                if (!(fNewAck ^ true) ? false : cSlots == 1) {
                    ((Ack)packetAck).flush(member);
                    long ldtNow = Base.getSafeTimeMillis();
                    if (((NotifyPacket)packetAck).getScheduledMillis() > ldtNow) {
                        ((NotifyPacket)packetAck).setScheduledMillis(ldtNow);
                        this.getAckSendQueue().addHead(packetAck);
                    }
                }
            } else {
                fNewAck = true;
            }
        }
        if (fNewAck) {
            Queue queueAck = this.getAckSendQueue();
            packetAck = new Ack();
            packetAck.setFromId(this.getMemberId());
            packetAck.setToId(packet.getFromId());
            ((Ack)packetAck).addPacket(packet);
            queueAck.add(packetAck);
        }
    }

    protected void flushSend() {
        Service service = this.getFlushPendingService();
        if (service != null) {
            service.getQueue().flush();
            this.setFlushPendingService(null);
        }
    }

    public String formatStats() {
        long cTotal = Base.getSafeTimeMillis() - this.getStartTimestamp();
        long lReceived = this.getStatsReceived();
        long lRepeated = this.getStatsRepeated();
        double dSuccess = lReceived == 0L ? 1.0 : 1.0 - (double)lRepeated / (double)lReceived;
        dSuccess = (double)((int)(dSuccess * (double)10000)) / 10000.0;
        return String.valueOf("PacketsReceived=") + lReceived + ", PacketsRepeated=" + lRepeated + ", SuccessRate=" + dSuccess;
    }

    public Queue getAckSendQueue() {
        return this.__m_AckSendQueue;
    }

    public Queue getConfirmationQueue() {
        return this.__m_ConfirmationQueue;
    }

    public Service getFlushPendingService() {
        return this.__m_FlushPendingService;
    }

    public int getMaxAckNotifyCount() {
        return this.__m_MaxAckNotifyCount;
    }

    public int getMaximumPacketLength() {
        return this.__m_MaximumPacketLength;
    }

    public Queue getMessageQueue(int i) {
        Service service = this.getService(i);
        return service == null ? null : service.getQueue();
    }

    public int getPreferredPacketLength() {
        return this.__m_PreferredPacketLength;
    }

    public PacketPublisher getPublisher() {
        return this.__m_Publisher;
    }

    protected Service[] getService() {
        return this.__m_Service;
    }

    public Service getService(int i) {
        Service[] aService = this.getService();
        return (!(aService != null) ? false : i < aService.length) ? aService[i] : null;
    }

    public long getStatsReceived() {
        return this.__m_StatsReceived;
    }

    public long getStatsRepeated() {
        return this.__m_StatsRepeated;
    }

    public long getStatsReset() {
        return this.__m_StatsReset;
    }

    public PacketReceiver$ThisMemberSet getThisMemberSet() {
        return this.__m_ThisMemberSet;
    }

    public PacketReceiver$UdpPacketPool getUdpPacketPool() {
        return this.__m_UdpPacketPool;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/packetProcessor/PacketReceiver".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new PacketReceiver();
    }

    private final Component get_Module() {
        return this;
    }

    protected Message instantiateMessage(Member member, MessagePacket packet) {
        Message msg;
        int nType = packet.getMessageType();
        Service service = this.getService(packet.getServiceId());
        if (service == null) {
            msg = new Message();
        } else {
            msg = service.instantiateMessage(nType);
            if (msg == null) {
                throw new IllegalStateException(String.valueOf("Failed to instantiate Message Type=") + nType + " for Service=" + service.getServiceName());
            }
        }
        msg.setIncoming(true);
        msg.setMessageType(nType);
        msg.setFromMember(member);
        msg.setToMemberSet(this.getThisMemberSet());
        msg.setMessagePartCount(packet.getMessagePartCount());
        msg.setPacket(0, packet);
        return msg;
    }

    protected Queue instantiateQueue() {
        return (Queue)this._findChild("InQueue");
    }

    public boolean isNackEnabled() {
        return this.__m_NackEnabled;
    }

    protected void onEnter() {
        super.onEnter();
        this.resetStats();
    }

    public void onInit() {
        this.setUdpPacketPool((PacketReceiver$UdpPacketPool)this._findChild("UdpPacketPool"));
        super.onInit();
    }

    public void onJoined() {
        PacketReceiver$ThisMemberSet setMember = this.getThisMemberSet();
        if (setMember == null) {
            setMember = (PacketReceiver$ThisMemberSet)this._findName("ThisMemberSet");
            Component._assert(setMember != null);
            Member member = this.getThisMember();
            Component._assert(member != null);
            Component._assert(member.getId() != 0);
            setMember.add(member);
            this.setThisMemberSet(setMember);
        }
    }

    public void onMessage(Message msg) {
        Service service = msg.getService();
        if (service != null) {
            service.getQueue().add(msg);
            Service servicePending = this.getFlushPendingService();
            if (servicePending != service) {
                if (servicePending != null) {
                    servicePending.getQueue().flush();
                }
                this.setFlushPendingService(service);
            }
        }
    }

    protected void onNotify() {
        Queue queue = this.getQueue();
        PacketReceiver$UdpPacketPool packetPool = this.getUdpPacketPool();
        try {
            Object oPacket;
            while (!((oPacket = queue.removeNoWait()) == null)) {
                try {
                    this.onUdpPacket((UdpPacket)oPacket);
                }
                finally {
                    Object var5_5 = null;
                    ((Pool)packetPool).release(oPacket);
                }
            }
        }
        catch (RuntimeException e) {
            if (this.isExiting()) {
                return;
            }
            throw e;
        }
    }

    protected void onPacket(Packet packet) {
        int nFromId = packet.getFromId();
        Member member = this.getMember(nFromId);
        if (member == null) {
            if (!(nFromId != 0) ? false : packet.getToId() != 0) {
                return;
            }
        } else if (packet.isConfirmationRequired()) {
            MessagePacket msgPacket = (MessagePacket)packet;
            msgPacket.setFromMessageId(Packet.translateTrint((int)msgPacket.getFromMessageId(), member.getLastIncomingMessageId()));
            this.confirm(member, msgPacket);
        }
        int nType = packet.getPacketType();
        switch (nType) {
            case 232718546: {
                this.onPacketBroadcast(member, (Broadcast)packet);
                break;
            }
            case 232718547: 
            case 232718548: 
            case 232718549: {
                this.onPacketDirected(member, (Directed)packet);
                break;
            }
            case 232718551: 
            case 232718552: 
            case 232718553: {
                this.onPacketSequel(member, (Sequel)packet);
                break;
            }
            case 232718550: {
                this.onPacketRequest(member, (Request)packet);
                break;
            }
            case 232718545: {
                this.onPacketAck(member, (Ack)packet);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf("unknown packet type: ") + nType);
            }
        }
        if (member != null) {
            member.setStatsReceived(member.getStatsReceived() + (long)1);
        }
    }

    protected void onPacketAck(Member member, Ack packetAck) {
        if (member != null) {
            member.setPreferredAckSize(packetAck.getPreferredAckSize());
            this.getConfirmationQueue().add(packetAck);
        }
    }

    protected void onPacketBroadcast(Member member, Broadcast packet) {
        this.onMessage(this.instantiateMessage(member, packet));
    }

    protected void onPacketDirected(Member member, Directed packet) {
        if (member == null) {
            return;
        }
        WindowedArray waMsg = member.getMessageIncoming();
        long lMsgFirst = waMsg.getFirstIndex();
        long lToMsgId = Packet.translateTrint(packet.getToMessageId(), lMsgFirst);
        if (!(lToMsgId >= lMsgFirst) ? false : waMsg.get(lToMsgId) == null) {
            Message msg = this.instantiateMessage(member, packet);
            waMsg.set(lToMsgId, msg);
            long lFromMsgId = packet.getFromMessageId();
            msg.setFromMessageId(lFromMsgId);
            if (msg.getMessagePartCount() > 1) {
                LongArray laSequel;
                SparseArray laPile = member.getMessagePile();
                if (laPile.isEmpty() ^ true && (laSequel = (LongArray)laPile.get(lFromMsgId)) != null) {
                    LongArray.Iterator iter = laSequel.iterator();
                    while (iter.hasNext()) {
                        Sequel packetSequel = (Sequel)iter.next();
                        msg.setPacket(packetSequel.getMessagePartIndex(), packetSequel);
                    }
                }
                laPile.set(lFromMsgId, (Object)msg);
            }
            if (lToMsgId == lMsgFirst) {
                this.checkReadyMessages(member);
            } else if (this.isNackEnabled()) {
                this.getPublisher().scheduleNack(member);
            }
        } else {
            this.setStatsRepeated(this.getStatsRepeated() + (long)1);
            member.setStatsRepeated(member.getStatsRepeated() + (long)1);
        }
    }

    protected void onPacketRequest(Member member, Request packet) {
        throw new UnsupportedOperationException();
    }

    protected void onPacketSequel(Member member, Sequel packet) {
        if (member == null) {
            return;
        }
        SparseArray laPile = member.getMessagePile();
        long lLastMsgId = member.getLastIncomingMessageId();
        long lFromMsgId = packet.getFromMessageId();
        boolean fRepeated = false;
        if (lFromMsgId > lLastMsgId) {
            int iPart = packet.getMessagePartIndex();
            Object oVal = laPile.get(lFromMsgId);
            if (oVal instanceof Message) {
                Message msg = (Message)oVal;
                if (msg.getPacket(iPart) == null) {
                    msg.setPacket(iPart, packet);
                    WindowedArray waMsg = member.getMessageIncoming();
                    if (msg == waMsg.get(waMsg.getFirstIndex())) {
                        this.checkReadyMessages(member);
                    } else if (this.isNackEnabled()) {
                        this.getPublisher().scheduleNack(member);
                    }
                } else {
                    fRepeated = true;
                }
            } else {
                LongArray laSequel = (LongArray)oVal;
                if (laSequel == null) {
                    laSequel = new SimpleLongArray();
                    laPile.set(lFromMsgId, (Object)laSequel);
                } else {
                    boolean bl = fRepeated = laSequel.get((long)iPart) != null;
                }
                if (fRepeated ^ true) {
                    laSequel.set((long)iPart, (Object)packet);
                    if (this.isNackEnabled()) {
                        this.getPublisher().scheduleNack(member);
                    }
                }
            }
        } else {
            fRepeated = true;
        }
        if (fRepeated) {
            this.setStatsRepeated(this.getStatsRepeated() + (long)1);
            member.setStatsRepeated(member.getStatsRepeated() + (long)1);
        }
    }

    protected void onUdpPacket(UdpPacket udppacket) {
        block6: {
            int cPackets = 0;
            int cSkips = 0;
            try {
                DataInputStream stream = udppacket.getDataInputStream();
                InetSocketAddress addr = (InetSocketAddress)udppacket.getSocketAddress();
                int nMemberId = this.getMemberId();
                do {
                    stream.mark(3840);
                    boolean fForThisMember = Packet.isForMember(stream, nMemberId);
                    stream.reset();
                    if (fForThisMember) {
                        Packet packet = Packet.instantiate(stream, nMemberId);
                        packet.setFromAddress(addr.getAddress());
                        packet.setFromPort(addr.getPort());
                        this.onPacket(packet);
                        ++cPackets;
                        continue;
                    }
                    if (!(nMemberId == 0) ? false : (nMemberId = this.getMemberId()) != 0) continue;
                    Packet.skip(stream);
                    ++cSkips;
                } while (stream.available() > 0);
                this.setStatsReceived(this.getStatsReceived() + (long)cPackets);
            }
            catch (IOException e) {
                if (!(this.isExiting() ^ true)) break block6;
                try {
                    Component._trace(String.valueOf("An exception occurred while processing packet ") + cPackets + ':' + cSkips + " of DatagramPacket{" + udppacket.toString(true) + "}:\n" + Component.getStackTrace(e) + "\nException will be ignored.", 2);
                }
                catch (Throwable x) {}
            }
        }
    }

    protected void onWait() throws InterruptedException {
        this.flushSend();
        super.onWait();
    }

    public void resetStats() {
        this.setStatsReceived(0L);
        this.setStatsRepeated(0L);
        this.setStatsReset(Base.getSafeTimeMillis());
    }

    public void setAckSendQueue(Queue queue) {
        Component._assert(queue != null);
        Component._assert(this.getAckSendQueue() == null);
        this.__m_AckSendQueue = queue;
    }

    public void setConfirmationQueue(Queue queue) {
        Component._assert(queue != null);
        Component._assert(this.getConfirmationQueue() == null);
        this.__m_ConfirmationQueue = queue;
    }

    protected void setFlushPendingService(Service service) {
        this.__m_FlushPendingService = service;
    }

    protected void setMaxAckNotifyCount(int nCount) {
        this.__m_MaxAckNotifyCount = nCount;
    }

    public void setMaximumPacketLength(int cbMax) {
        Component._assert(this.getMaximumPacketLength() == 0, "MaximumPacketLength is not resettable");
        this.__m_MaximumPacketLength = cbMax;
    }

    public void setNackEnabled(boolean fUseRequestPackets) {
        this.__m_NackEnabled = fUseRequestPackets;
    }

    public void setPreferredPacketLength(int cBytes) {
        Component._assert(this.getPreferredPacketLength() == 0, "PreferredPacketLength is not resettable");
        this.__m_PreferredPacketLength = cBytes;
        this.setMaxAckNotifyCount((cBytes - Ack.LENGTH_FIXED) / Ack.LENGTH_VARIABLE);
    }

    public void setPublisher(PacketPublisher publisher) {
        this.__m_Publisher = publisher;
    }

    public void setService(int i, Service service) {
        Service[] aService = this.getService();
        if (aService == null ? true : i >= aService.length) {
            int cNew = Math.max(i + (i >>> 1), i + 4);
            Service[] aServiceNew = new Service[cNew];
            if (aService != null) {
                System.arraycopy(aService, 0, aServiceNew, 0, aService.length);
            }
            aService = aServiceNew;
            this.setService(aServiceNew);
        }
        aService[i] = service;
    }

    protected void setService(Service[] aService) {
        this.__m_Service = aService;
    }

    protected void setStatsReceived(long cPackets) {
        this.__m_StatsReceived = cPackets;
    }

    protected void setStatsRepeated(long cPackets) {
        this.__m_StatsRepeated = cPackets;
    }

    protected void setStatsReset(long lMillis) {
        this.__m_StatsReset = lMillis;
    }

    protected void setThisMemberSet(PacketReceiver$ThisMemberSet setMember) {
        this.__m_ThisMemberSet = setMember;
    }

    protected void setUdpPacketPool(PacketReceiver$UdpPacketPool pool) {
        this.__m_UdpPacketPool = pool;
    }

    public String toString() {
        return String.valueOf(this.get_Name()) + ':' + this.formatStats();
    }
}

