/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Socket;
import com.tangosol.coherence.component.net.udpPacket.OutgoingUdpPacket;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.Pool;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.PacketProcessor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketSpeaker$BundlingQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketSpeaker$InQueue;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.util.Map;

public class PacketSpeaker
extends PacketProcessor {
    private int __m_BurstCount;
    private int __m_BurstDelay;
    private int __m_MaximumPacketLength;
    private int __m_PreferredPacketLength;
    private transient long __m_StatsBurst;
    private transient long __m_StatsCpu;
    private transient long __m_StatsReset;
    private transient long __m_StatsSent;
    private transient Pool __m_UdpPacketPool;
    private static ListMap __mapChildren;

    static {
        PacketSpeaker.__initStatic();
    }

    public PacketSpeaker() {
        this(null, null, true);
    }

    public PacketSpeaker(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"BundlingQueue", (Object)PacketSpeaker$BundlingQueue.get_CLASS());
        Object object2 = __mapChildren.put((Object)"InQueue", (Object)PacketSpeaker$InQueue.get_CLASS());
    }

    public String formatStats() {
        long ldtNow = Base.getSafeTimeMillis();
        long cCpu = this.getStatsCpu();
        long cTotal = ldtNow - this.getStartTimestamp();
        long lSent = this.getStatsSent();
        long lBurst = this.getStatsBurst();
        double dCpu = cTotal == 0L ? 0.0 : (double)cCpu / (double)cTotal;
        double dThru = cCpu == 0L ? 0.0 : (double)lSent * (double)1000 / (double)cCpu;
        dCpu = (double)((int)(dCpu * (double)1000)) / 10.0;
        return String.valueOf("Cpu=") + cCpu + "ms (" + dCpu + "%)" + ", PacketsSent=" + lSent + ", Bursts=" + lBurst + ", Throughput=" + (int)dThru + "pkt/sec" + ", Queued=" + this.getQueue().size();
    }

    public int getBurstCount() {
        return this.__m_BurstCount;
    }

    public int getBurstDelay() {
        return this.__m_BurstDelay;
    }

    public int getMaximumPacketLength() {
        return this.__m_MaximumPacketLength;
    }

    public int getPreferredPacketLength() {
        return this.__m_PreferredPacketLength;
    }

    public long getStatsBurst() {
        return this.__m_StatsBurst;
    }

    public long getStatsCpu() {
        return this.__m_StatsCpu;
    }

    public long getStatsReset() {
        return this.__m_StatsReset;
    }

    public long getStatsSent() {
        return this.__m_StatsSent;
    }

    public Pool getUdpPacketPool() {
        return this.__m_UdpPacketPool;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/packetProcessor/PacketSpeaker".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new PacketSpeaker();
    }

    private final Component get_Module() {
        return this;
    }

    protected Queue instantiateQueue() {
        return (Queue)this._newChild("BundlingQueue");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onNotify() {
        Object var11_13;
        int cPackets;
        long lStartTime;
        block22: {
            boolean bl;
            block21: {
                Queue queue = this.getQueue();
                lStartTime = System.currentTimeMillis();
                int cBurst = this.getBurstCount();
                int cBurstMillis = this.getBurstDelay();
                cPackets = 0;
                int cUpdateInterval = cBurst > 0 ? cBurst : 30000;
                OutgoingUdpPacket packet = null;
                Pool pool = this.getUdpPacketPool();
                try {
                    try {
                        while (this.isExiting() ^ true) {
                            block20: {
                                boolean bl2;
                                block19: {
                                    try {
                                        packet = (OutgoingUdpPacket)queue.removeNoWait();
                                        if (cPackets > cUpdateInterval ? true : packet == null) {
                                            if (cPackets > 0) {
                                                long lDelta = System.currentTimeMillis() - lStartTime;
                                                if (lDelta > (long)0) {
                                                    this.setStatsCpu(this.getStatsCpu() + lDelta);
                                                }
                                                this.setStatsSent(this.getStatsSent() + (long)cPackets);
                                            }
                                            this.setStatsBurst(this.getStatsBurst() + (long)1);
                                            if ((!(cBurst > 0) ? false : cPackets > cBurst >>> 1) && Daemon.sleep(cBurstMillis) ^ true) {
                                                var11_13 = null;
                                                bl2 = packet != null;
                                                break block19;
                                            }
                                            cPackets = 0;
                                            cBurst = this.getBurstCount();
                                            cBurstMillis = this.getBurstDelay();
                                            cUpdateInterval = cBurst > 0 ? cBurst : 30000;
                                            if (packet == null) {
                                                packet = (OutgoingUdpPacket)queue.remove();
                                            }
                                            lStartTime = System.currentTimeMillis();
                                        }
                                        packet.send();
                                        cPackets += packet.getAddressCount();
                                        break block20;
                                    }
                                    catch (Throwable lDelta) {
                                        var11_13 = null;
                                        if (!(packet != null)) throw lDelta;
                                        pool.release(packet);
                                        throw lDelta;
                                    }
                                }
                                if (bl2) {
                                    pool.release(packet);
                                }
                                var11_13 = null;
                                bl = cPackets > 0;
                                break block21;
                            }
                            var11_13 = null;
                            if (!(packet != null)) continue;
                            pool.release(packet);
                        }
                        break block22;
                    }
                    catch (Exception e) {
                        if (this.isExiting()) {
                            Object var11_14 = null;
                            if (!(cPackets > 0)) return;
                            long lDelta = System.currentTimeMillis() - lStartTime;
                            if (lDelta > (long)0) {
                                this.setStatsCpu(this.getStatsCpu() + lDelta);
                            }
                            this.setStatsSent(this.getStatsSent() + (long)cPackets);
                            return;
                        }
                        if (!(packet != null) ? false : packet.getUdpSocket().getState() != Socket.STATE_CLOSED) {
                            throw Base.ensureRuntimeException((Throwable)e);
                        }
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_15 = null;
                    if (!(cPackets > 0)) throw throwable;
                    long lDelta = System.currentTimeMillis() - lStartTime;
                    if (lDelta > (long)0) {
                        this.setStatsCpu(this.getStatsCpu() + lDelta);
                    }
                    this.setStatsSent(this.getStatsSent() + (long)cPackets);
                    throw throwable;
                }
            }
            if (!bl) return;
            long lDelta = System.currentTimeMillis() - lStartTime;
            if (lDelta > (long)0) {
                this.setStatsCpu(this.getStatsCpu() + lDelta);
            }
            this.setStatsSent(this.getStatsSent() + (long)cPackets);
            return;
        }
        var11_13 = null;
        if (!(cPackets > 0)) return;
        long lDelta = System.currentTimeMillis() - lStartTime;
        if (lDelta > (long)0) {
            this.setStatsCpu(this.getStatsCpu() + lDelta);
        }
        this.setStatsSent(this.getStatsSent() + (long)cPackets);
    }

    protected void onWait() throws InterruptedException {
    }

    public void resetStats() {
        this.setStatsSent(0L);
        this.setStatsCpu(0L);
        this.setStatsBurst(0L);
        this.setStatsReset(Base.getSafeTimeMillis());
        ((PacketSpeaker$BundlingQueue)this.getQueue()).resetStats();
    }

    public void setBurstCount(int cPackets) {
        this.__m_BurstCount = cPackets;
    }

    public void setBurstDelay(int cMillis) {
        this.__m_BurstDelay = Math.max(0, cMillis);
    }

    public void setMaximumPacketLength(int cb) {
        this.__m_MaximumPacketLength = cb;
    }

    public void setPreferredPacketLength(int cBytes) {
        this.__m_PreferredPacketLength = cBytes;
    }

    protected void setStatsBurst(long cBurst) {
        this.__m_StatsBurst = cBurst;
    }

    protected void setStatsCpu(long lMillis) {
        this.__m_StatsCpu = lMillis;
    }

    protected void setStatsReset(long lMillis) {
        this.__m_StatsReset = lMillis;
    }

    protected void setStatsSent(long cPackets) {
        this.__m_StatsSent = cPackets;
    }

    public void setUdpPacketPool(Pool pool) {
        this.__m_UdpPacketPool = pool;
    }

    public String toString() {
        return String.valueOf(this.get_Name()) + ':' + this.formatStats();
    }
}

