/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.net.message.DiscoveryMessage;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$NewMemberAnnounceReply;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$NewMemberAnnounceWait;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;

public class ClusterService$NewMemberAnnounce
extends DiscoveryMessage {
    private int __m_AttemptCounter;
    private int __m_AttemptLimit;
    private long __m_ThisSentTimestamp;

    public ClusterService$NewMemberAnnounce() {
        this(null, null, true);
    }

    public ClusterService$NewMemberAnnounce(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setMessageType(7);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public int getAttemptCounter() {
        return this.__m_AttemptCounter;
    }

    public int getAttemptLimit() {
        return this.__m_AttemptLimit;
    }

    public String getDescription() {
        long lThisSentTimestamp = this.getThisSentTimestamp();
        long lThisRecvTimestamp = this.getThisRecvTimestamp();
        String sThisSentTimestamp = lThisSentTimestamp == 0L ? "none" : new Date(lThisSentTimestamp).toString();
        String sThisRecvTimestamp = lThisRecvTimestamp == 0L ? "none" : new Date(lThisRecvTimestamp).toString();
        return String.valueOf("AttemptCounter=") + this.getAttemptCounter() + "\nAttemptLimit=" + this.getAttemptLimit() + "\nThisSentTimestamp=" + sThisSentTimestamp + "\nThisRecvTimestamp=" + sThisRecvTimestamp;
    }

    public long getThisRecvTimestamp() {
        MessagePacket packet;
        MessagePacket[] aPacket = this.getPacket();
        if ((!(aPacket != null) ? false : aPacket.length > 0) && (packet = aPacket[0]) != null) {
            ClusterService service = (ClusterService)this.getService();
            return service.calcTimestamp(packet.getReceivedMillis());
        }
        return 0L;
    }

    public long getThisSentTimestamp() {
        return this.__m_ThisSentTimestamp;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/ClusterService$NewMemberAnnounce".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new ClusterService$NewMemberAnnounce();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    public void onReceived() {
        super.onReceived();
        ClusterService service = (ClusterService)this.getService();
        Member memberNew = this.getFromMember();
        switch (service.getState()) {
            case 0: {
                if (this.isReadError()) {
                    service.onMemberRejected(-2, memberNew);
                    throw new EventDeathException("Version mismatch");
                }
                Member memberTemp = service.getAnnounceMember();
                if (!(memberNew.equals(memberTemp) ^ true) || !(memberTemp.compareTo(memberNew) > 0)) break;
                service.resetBroadcastCounter("an older member announcing", this);
                break;
            }
            case 2: {
                int cMembers;
                Member memberSenior;
                if (this.isReadError()) {
                    throw new EventDeathException("Version mismatch");
                }
                MasterMemberSet setMember = service.getClusterMemberSet();
                Member memberThis = setMember.getThisMember();
                if (!(memberThis == (memberSenior = setMember.getOldestMember())) ? false : service.isMembershipSuspended() ^ true) {
                    ClusterService$NewMemberAnnounceReply msg = (ClusterService$NewMemberAnnounceReply)service.instantiateMessage("NewMemberAnnounceReply");
                    msg.setToMember(memberNew);
                    msg.setPrevSentTimestamp(this.getThisSentTimestamp());
                    msg.setPrevRecvTimestamp(this.getThisRecvTimestamp());
                    service.send(msg);
                    break;
                }
                if (!(this.getAttemptCounter() > this.getAttemptLimit() >>> 2) || !((cMembers = setMember.size()) < 8 ? true : Base.getRandom().nextInt(cMembers) < (int)Math.log(cMembers) + 1)) break;
                ClusterService$NewMemberAnnounceWait msg = (ClusterService$NewMemberAnnounceWait)service.instantiateMessage("NewMemberAnnounceWait");
                msg.setToMember(memberNew);
                msg.setSeniorMember(memberSenior);
                service.send(msg);
                break;
            }
        }
    }

    public void read(DataInputStream stream) throws IOException {
        super.read(stream);
        this.setAttemptCounter(stream.readInt());
        this.setAttemptLimit(stream.readInt());
        this.setThisSentTimestamp(stream.readLong());
        this.ensureEOS(stream);
    }

    public void setAttemptCounter(int n) {
        this.__m_AttemptCounter = n;
    }

    public void setAttemptLimit(int c) {
        this.__m_AttemptLimit = c;
    }

    public void setThisSentTimestamp(long cMillis) {
        this.__m_ThisSentTimestamp = cMillis;
    }

    public void write(DataOutputStream stream) throws IOException {
        super.write(stream);
        long lMillis = Base.getSafeTimeMillis();
        this.setThisSentTimestamp(lMillis);
        stream.writeInt(this.getAttemptCounter());
        stream.writeInt(this.getAttemptLimit());
        stream.writeLong(this.getThisSentTimestamp());
    }
}

