/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.memberSet.ActualMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.message.DiscoveryMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$MemberJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$NewMemberRequestIdReject;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$NewMemberRequestIdReply;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$NewMemberRequestIdWait;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.UUID;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;

public class ClusterService$NewMemberRequestId
extends DiscoveryMessage {
    private int __m_AttemptCounter;
    private int __m_AttemptLimit;
    private transient int __m_Count;
    private int __m_MaxPacketSize;
    private String __m_ServiceVersion;
    private boolean __m_WkaEnabled;

    public ClusterService$NewMemberRequestId() {
        this(null, null, true);
    }

    public ClusterService$NewMemberRequestId(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setMessageType(10);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void ensureEOS(DataInputStream stream) throws IOException {
        ((ClusterService)this.getService()).resetBroadcastCounter(stream, false);
        super.ensureEOS(stream);
    }

    public int getAttemptCounter() {
        return this.__m_AttemptCounter;
    }

    public int getAttemptLimit() {
        return this.__m_AttemptLimit;
    }

    public int getCount() {
        return this.__m_Count;
    }

    public String getDescription() {
        return String.valueOf("AttemptCounter=") + this.getAttemptCounter() + "\nAttemptLimit=" + this.getAttemptLimit() + "\nServiceVersion=" + this.getServiceVersion();
    }

    public int getMaxPacketSize() {
        return this.__m_MaxPacketSize;
    }

    public String getServiceVersion() {
        return this.__m_ServiceVersion;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/ClusterService$NewMemberRequestId".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new ClusterService$NewMemberRequestId();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    public boolean isWkaEnabled() {
        return this.__m_WkaEnabled;
    }

    public void onReceived() {
        super.onReceived();
        ClusterService service = (ClusterService)this.getService();
        Member memberFrom = this.getFromMember();
        switch (service.getState()) {
            case 0: {
                if (this.isReadError()) {
                    service.onMemberRejected(-2, null);
                    throw new EventDeathException("Version mismatch");
                }
                service.resetBroadcastCounter("the presence of an existing cluster", this);
                break;
            }
            case 1: {
                if (this.isReadError()) {
                    service.onMemberRejected(-2, null);
                    throw new EventDeathException("Version mismatch");
                }
                Member memberThis = service.getRequestMember();
                if (!(memberFrom.equals(memberThis) ^ true) || !(memberThis.compareTo(memberFrom) > 0)) break;
                service.resetBroadcastCounter("an older member joining", this);
                break;
            }
            case 2: {
                int cMembers;
                MasterMemberSet setMember = service.getClusterMemberSet();
                Member memberThis = setMember.getThisMember();
                if (!(memberThis == setMember.getOldestMember()) ? false : service.isMembershipSuspended() ^ true) {
                    int cbPacketNew = this.getMaxPacketSize();
                    int cbPacketThis = service.getReceiverMaxPacketSize();
                    String sVersionNew = this.getServiceVersion();
                    String sVersionThis = service.getServiceVersion();
                    boolean fWkaEnabledNew = this.isWkaEnabled();
                    boolean fWkaEnabledThis = service.isWkaEnabled();
                    String sClusterNameNew = memberFrom.getClusterName();
                    String sClusterNameThis = service.getClusterName();
                    int nEditionNew = memberFrom.getEdition();
                    int nEditionThis = memberThis.getEdition();
                    int nModeNew = memberFrom.getMode();
                    int nModeThis = memberThis.getMode();
                    service.validateNewMember(memberFrom);
                    boolean fBrandNew = false;
                    UUID uidNew = memberFrom.getUid32();
                    Member memberNew = setMember.getMember(uidNew);
                    if (memberNew == null) {
                        int nRejectReason = MasterMemberSet.MAX_MEMBERS;
                        if ((Base.equals((Object)sVersionNew, (Object)sVersionThis) ^ true ? true : cbPacketNew == 0) ? true : this.isReadError()) {
                            nRejectReason += 2;
                        } else if (Base.equals((Object)sClusterNameNew, (Object)sClusterNameThis) ^ true) {
                            nRejectReason += 7;
                        } else if (cbPacketNew != cbPacketThis) {
                            nRejectReason += 3;
                        } else if (fWkaEnabledNew ^ fWkaEnabledThis) {
                            nRejectReason += 6;
                        } else if (nModeNew != nModeThis) {
                            nRejectReason += 9;
                        } else if (((nEditionNew == nEditionThis ? true : (!(nEditionNew == 1) ? false : nEditionThis == 5)) ? true : (!(nEditionNew == 5) ? false : nEditionThis == 1)) ^ true) {
                            nRejectReason += 8;
                        } else {
                            memberNew = service.instantiateMember();
                            memberNew.configure(memberFrom, 0L);
                            nRejectReason = setMember.induct(memberNew, service);
                        }
                        if (nRejectReason <= 0) {
                            fBrandNew = true;
                            ServiceMemberSet setServiceMembers = service.getServiceMemberSet();
                            setServiceMembers.add(memberNew);
                            setServiceMembers.setServiceVersion(memberNew.getId(), sVersionNew);
                            setServiceMembers.setServiceJoined(memberNew.getId(), memberNew.getUid32().getTimestamp());
                        } else {
                            ClusterService$NewMemberRequestIdReject msg = (ClusterService$NewMemberRequestIdReject)service.instantiateMessage("NewMemberRequestIdReject");
                            msg.setToMember(memberFrom);
                            msg.setReason(nRejectReason);
                            service.send(msg);
                            break;
                        }
                    }
                    ClusterService$NewMemberRequestIdReply msg = (ClusterService$NewMemberRequestIdReply)service.instantiateMessage("NewMemberRequestIdReply");
                    msg.setToMember(memberNew);
                    msg.setServiceVersion(sVersionThis);
                    msg.setMulticastTimeToLive(service.getMulticastTimeToLive());
                    msg.setWkaListHashCode(service.getWkaListHashCode());
                    service.send(msg);
                    if (!fBrandNew) break;
                    service.onMemberJoined(memberNew);
                    ActualMemberSet setOthers = new ActualMemberSet();
                    ((MemberSet)setOthers).addAll((Collection)setMember);
                    setOthers.remove(memberThis);
                    setOthers.remove(memberNew);
                    if (!(((MemberSet)setOthers).isEmpty() ^ true)) break;
                    ClusterService$MemberJoined msg2 = (ClusterService$MemberJoined)service.instantiateMessage("MemberJoined");
                    msg2.setToMemberSet(setOthers);
                    msg2.setMember(memberNew);
                    msg2.setServiceVersion(sVersionNew);
                    service.send(msg2);
                    break;
                }
                if (!(this.getAttemptCounter() > this.getAttemptLimit() >>> 2) || !((cMembers = setMember.size()) < 8 ? true : Base.getRandom().nextInt(cMembers) < (int)Math.log(cMembers) + 1)) break;
                ClusterService$NewMemberRequestIdWait msg = (ClusterService$NewMemberRequestIdWait)service.instantiateMessage("NewMemberRequestIdWait");
                msg.setToMember(memberFrom);
                service.send(msg);
                break;
            }
        }
    }

    public void read(DataInputStream stream) throws IOException {
        super.read(stream);
        this.setAttemptCounter(ExternalizableHelper.readInt((DataInput)stream));
        this.setAttemptLimit(ExternalizableHelper.readInt((DataInput)stream));
        this.setServiceVersion(ExternalizableHelper.readUTF((DataInput)stream));
        this.setMaxPacketSize(ExternalizableHelper.readInt((DataInput)stream));
        this.setWkaEnabled(stream.readBoolean());
        this.setCount(stream.readInt());
        this.ensureEOS(stream);
    }

    public void setAttemptCounter(int n) {
        this.__m_AttemptCounter = n;
    }

    public void setAttemptLimit(int c) {
        this.__m_AttemptLimit = c;
    }

    public void setCount(int pCount) {
        this.__m_Count = pCount;
    }

    public void setMaxPacketSize(int cb) {
        this.__m_MaxPacketSize = cb;
    }

    public void setServiceVersion(String sVersion) {
        this.__m_ServiceVersion = sVersion;
    }

    public void setWkaEnabled(boolean fEnabled) {
        this.__m_WkaEnabled = fEnabled;
    }

    public void write(DataOutputStream stream) throws IOException {
        super.write(stream);
        ExternalizableHelper.writeInt((DataOutput)stream, (int)this.getAttemptCounter());
        ExternalizableHelper.writeInt((DataOutput)stream, (int)this.getAttemptLimit());
        ExternalizableHelper.writeUTF((DataOutput)stream, (String)this.getServiceVersion());
        ExternalizableHelper.writeInt((DataOutput)stream, (int)this.getMaxPacketSize());
        stream.writeBoolean(this.isWkaEnabled());
        ((ClusterService)this.getService()).getBroadcastTimestamp().writeExternal((DataOutput)stream);
    }
}

